/*
 * Decompiled with CFR 0.152.
 */
package coins.snapshot;

import coins.PassException;
import coins.aflow.BBlock;
import coins.backend.ana.Dominators;
import coins.backend.ana.Postdominators;
import coins.backend.cfg.BasicBlk;
import coins.backend.util.BiList;
import coins.mdf.MacroTask;
import coins.snapshot.DisplayNames;
import coins.snapshot.InfoTag;
import coins.snapshot.LabelType;
import coins.snapshot.StatementTag;
import java.util.Iterator;
import java.util.List;

class NodeTag {
    private final LabelType id;
    private final LabelType next;
    private final LabelType prev;
    private final StatementTag statement;
    private final InfoTag info;

    NodeTag(String dName, BasicBlk blk) {
        BiList tmp = new BiList();
        tmp.add(blk);
        this.id = new LabelType(blk.label().name(), tmp);
        if (dName.equals(DisplayNames.CFG)) {
            this.next = blk.succList().length() > 0 ? new LabelType(DisplayNames.SUCC, blk.succList()) : null;
            this.prev = blk.predList().length() > 0 ? new LabelType(DisplayNames.PRED, blk.predList()) : null;
        } else if (dName.equals(DisplayNames.DOMTREE)) {
            Dominators dom = (Dominators)blk.flowGraph.function.require(Dominators.analyzer);
            this.next = dom.kids[blk.id] != null && dom.kids[blk.id].length() > 0 ? new LabelType(DisplayNames.DCHILD, dom.kids[blk.id]) : null;
            if (dom.idom[blk.id] != null) {
                BiList tmp1 = new BiList();
                tmp1.add(dom.idom[blk.id]);
                this.prev = new LabelType(DisplayNames.DOM, tmp1);
            } else {
                this.prev = null;
            }
        } else if (dName.equals(DisplayNames.PDOMTREE)) {
            Postdominators pdom = (Postdominators)blk.flowGraph.function.require(Postdominators.analyzer);
            this.next = pdom.kids[blk.id] != null && pdom.kids[blk.id].length() > 0 ? new LabelType(DisplayNames.PDCHILD, pdom.kids[blk.id]) : null;
            if (pdom.idom[blk.id] != null) {
                BiList tmp1 = new BiList();
                tmp1.add(pdom.idom[blk.id]);
                this.prev = new LabelType(DisplayNames.PDOM, tmp1);
            } else {
                this.prev = null;
            }
        } else {
            this.next = null;
            this.prev = null;
        }
        this.statement = new StatementTag(blk.instrList());
        this.info = new InfoTag(blk);
    }

    NodeTag(String dName, BBlock blk) {
        BiList tmp = new BiList();
        tmp.add(blk);
        this.id = new LabelType(blk.getLabel().getName(), tmp);
        if (dName.equals(DisplayNames.CFG)) {
            Iterator ite;
            if (blk.getSuccList().size() > 0) {
                tmp = new BiList();
                ite = blk.getSuccList().iterator();
                while (ite.hasNext()) {
                    tmp.add((BBlock)ite.next());
                }
                this.next = new LabelType(DisplayNames.SUCC, tmp);
            } else {
                this.next = null;
            }
            if (blk.getPredList().size() > 0) {
                tmp = new BiList();
                ite = blk.getPredList().iterator();
                while (ite.hasNext()) {
                    tmp.add((BBlock)ite.next());
                }
                this.prev = new LabelType(DisplayNames.PRED, tmp);
            } else {
                this.prev = null;
            }
        } else if (dName.equals(DisplayNames.DOMTREE)) {
            List dchild = blk.getDominatedChildrenForSubpFlow();
            if (dchild != null && dchild.size() > 0) {
                BiList tmp1 = new BiList();
                Iterator ite = dchild.iterator();
                while (ite.hasNext()) {
                    tmp1.add(ite.next());
                }
                this.next = new LabelType(DisplayNames.DCHILD, tmp1);
            } else {
                this.next = null;
            }
            BBlock dom = blk.getImmediateDominatorForSubpFlow();
            if (dom != null) {
                BiList tmp1 = new BiList();
                tmp1.add(dom);
                this.prev = new LabelType(DisplayNames.DOM, tmp1);
            } else {
                this.prev = null;
            }
        } else if (dName.equals(DisplayNames.PDOMTREE)) {
            List pdchild = blk.getPostdominatedChildrenForSubpFlow();
            if (pdchild != null && pdchild.size() > 0) {
                BiList tmp1 = new BiList();
                Iterator ite = pdchild.iterator();
                while (ite.hasNext()) {
                    tmp1.add(ite.next());
                }
                this.next = new LabelType(DisplayNames.PDCHILD, tmp1);
            } else {
                this.next = null;
            }
            BBlock pdom = blk.getImmediatePostdominatorForSubpFlow();
            if (pdom != null) {
                BiList tmp1 = new BiList();
                tmp1.add(pdom);
                this.prev = new LabelType(DisplayNames.PDOM, tmp1);
            } else {
                this.prev = null;
            }
        } else {
            this.next = null;
            this.prev = null;
        }
        this.statement = new StatementTag(blk.bblockSubtreeIterator());
        this.info = new InfoTag(blk);
    }

    NodeTag(String dName, MacroTask mt) throws PassException {
        BiList tmp = new BiList();
        tmp.add(mt);
        this.id = new LabelType(mt.label.getName(), tmp);
        if (dName.equals(DisplayNames.MFG)) {
            Iterator ite;
            if (mt.succList.size() > 0) {
                tmp = new BiList();
                ite = mt.succList.iterator();
                while (ite.hasNext()) {
                    tmp.add((MacroTask)ite.next());
                }
                this.next = new LabelType(DisplayNames.SUCC, tmp);
            } else {
                this.next = null;
            }
            if (mt.predList.size() > 0) {
                tmp = new BiList();
                ite = mt.predList.iterator();
                while (ite.hasNext()) {
                    tmp.add((MacroTask)ite.next());
                }
                this.prev = new LabelType(DisplayNames.PRED, tmp);
            } else {
                this.prev = null;
            }
        } else {
            this.next = null;
            this.prev = null;
        }
        this.statement = new StatementTag(mt.blks());
        this.info = new InfoTag(mt);
    }

    public String toString(int space) {
        String ws1 = "";
        for (int i = 0; i < space; ++i) {
            ws1 = ws1 + "  ";
        }
        String ws = "";
        for (int i = 0; i < space + 1; ++i) {
            ws = ws + "  ";
        }
        String str = "";
        str = str + ws1 + "<" + "node" + ">\n";
        str = str + ws + "<" + "id" + " " + "displayName" + "=" + this.id.displayName() + ">\n";
        str = str + this.id.toString(space + 2);
        str = str + ws + "</" + "id" + ">\n";
        if (this.next != null) {
            str = str + ws + "<" + "next";
            str = str + " displayName=" + this.next.displayName() + ">\n";
            str = str + this.next.toString(space + 2);
            str = str + ws + "</" + "next" + ">\n";
        }
        if (this.prev != null) {
            str = str + ws + "<" + "prev";
            str = str + " displayName=" + this.prev.displayName() + ">\n";
            str = str + this.prev.toString(space + 2);
            str = str + ws + "</" + "prev" + ">\n";
        }
        str = str + ws + "<" + "statement" + ">\n";
        str = str + this.statement.toString(space + 2);
        str = str + ws + "</" + "statement" + ">\n";
        str = str + this.info.toString(space + 1);
        str = str + ws1 + "</" + "node" + ">\n";
        return str;
    }

    public String toString() {
        return this.toString(0);
    }
}

