/*
 * Decompiled with CFR 0.152.
 */
package coins.snapshot;

import coins.HirRoot;
import coins.PassException;
import coins.backend.Function;
import coins.backend.Module;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.ir.IrList;
import coins.ir.hir.Program;
import coins.ir.hir.SubpDefinition;
import coins.mdf.MacroFlowGraph;
import coins.mdf.MdfModule;
import coins.snapshot.FunctionTag;
import java.util.ListIterator;

class ModuleTag {
    private BiList functions;
    private final String moduleName;
    private final String filepath;

    ModuleTag(Module m, String fName, String fPath) {
        this.moduleName = fName;
        this.filepath = fPath;
        this.functions = new BiList();
        BiLink p = m.elements.first();
        while (!p.atEnd()) {
            if (p.elem() instanceof Function) {
                FunctionTag fTag = new FunctionTag((Function)p.elem());
                this.functions.add(fTag);
            }
            p = p.next();
        }
    }

    ModuleTag(HirRoot hirRoot, String fName, String fPath) {
        this.moduleName = fName;
        this.filepath = fPath;
        this.functions = new BiList();
        IrList subpDefList = ((Program)hirRoot.programRoot).getSubpDefinitionList();
        ListIterator subpDefIterator = subpDefList.iterator();
        while (subpDefIterator.hasNext()) {
            SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
            FunctionTag fTag = new FunctionTag(hirRoot, subpDef);
            this.functions.add(fTag);
        }
    }

    ModuleTag(MdfModule m, String fName, String fPath) throws PassException {
        this.moduleName = fName;
        this.filepath = fPath;
        this.functions = new BiList();
        for (MacroFlowGraph mfg : m.flowGraph) {
            FunctionTag fTag = new FunctionTag(mfg);
            this.functions.add(fTag);
        }
    }

    private String moduleName() {
        return "\"" + this.moduleName + "\"";
    }

    private String filepath() {
        return "\"" + this.filepath + "\"";
    }

    public String toString(int space) {
        String ws = "";
        for (int i = 0; i < space; ++i) {
            ws = ws + "  ";
        }
        String str = "";
        str = str + ws + "<" + "module" + " " + "name" + "=" + this.moduleName();
        str = str + " src=" + this.filepath() + ">\n";
        BiLink p = this.functions.first();
        while (!p.atEnd()) {
            FunctionTag fTag = (FunctionTag)p.elem();
            str = str + fTag.toString(space + 1);
            p = p.next();
        }
        str = str + ws + "</" + "module" + ">\n";
        return str;
    }

    public String toString() {
        return this.toString(0);
    }
}

