/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.simd.SimdOptException;
import java.util.Vector;

public class Util {
    Util() {
    }

    BiList findTargetLir(LirNode root, int opCode, BiList l) {
        if (root != null) {
            if (root.opCode == opCode) {
                l.add(root);
            }
            for (int i = 0; i < root.nKids(); ++i) {
                this.findTargetLir(root.kid(i), opCode, l);
            }
        }
        return l;
    }

    public static void assert2(boolean p, String s, int lineno) throws SimdOptException {
        if (!p) {
            throw new SimdOptException("Assertion failed: " + s + ", line " + lineno);
        }
    }

    public static void assert2(boolean p, String s) throws SimdOptException {
        if (!p) {
            throw new SimdOptException("Assertion failed: " + s);
        }
    }

    public static void abort(String s) throws SimdOptException {
        throw new SimdOptException("Abort: " + s);
    }

    public static void sorry(boolean p, String s) throws SimdOptException {
        if (p) {
            throw new SimdOptException("Sorry not implemented: " + s);
        }
    }

    public static void warn(String s) {
        System.err.println("Warning: " + s);
    }

    public static void printBlk(BasicBlk blk) {
        BiLink lir = blk.instrList().first();
        while (!lir.atEnd()) {
            LirNode ins = (LirNode)lir.elem();
            System.out.println(ins.toString());
            lir = lir.next();
        }
    }

    public static Vector blkToVecs(BasicBlk blk) {
        Vector out = new Vector();
        Vector<LirNode> tmp = new Vector<LirNode>();
        boolean setflag = true;
        BiLink lir = blk.instrList().first();
        while (!lir.atEnd()) {
            LirNode ins = (LirNode)lir.elem();
            if (ins.opCode == 48) {
                if (!setflag) {
                    setflag = true;
                    out.addElement(tmp);
                    tmp = new Vector();
                }
                tmp.addElement(ins);
            } else {
                setflag = false;
                out.addElement(tmp);
                tmp = new Vector();
                tmp.addElement(ins);
            }
            lir = lir.next();
        }
        if (tmp.size() != 0) {
            out.addElement(tmp);
        }
        return out;
    }

    public static void vecsToBlk(BasicBlk blk, Vector vs) {
        BiList instlist = blk.instrList();
        instlist.clear();
        for (int i = 0; i < vs.size(); ++i) {
            if (!(vs.elementAt(i) instanceof Vector)) continue;
            Vector v = (Vector)vs.elementAt(i);
            for (int j = 0; j < v.size(); ++j) {
                instlist.add(v.elementAt(j));
            }
        }
    }

    public static void revV(Vector v) {
        int n = v.size() / 2;
        for (int i = 0; i < n; ++i) {
            Object o1 = v.elementAt(i);
            v.setElementAt(v.elementAt(v.size() - i), i);
            v.setElementAt(o1, v.size() - i);
        }
    }
}

