/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.lir.PickUpVariable;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.simd.SimdOptException;
import java.util.Vector;

public class SimdEstimation {
    private Function func;

    public SimdEstimation(Function func) {
        this.func = func;
    }

    public void doIt() throws SimdOptException {
        if (!this.estimateDefUse()) {
            throw new SimdOptException("SimdEstimation found unused simd regs.");
        }
    }

    private boolean estimateDefUse() {
        BiLink bp = this.func.flowGraph().basicBlkList.first();
        while (!bp.atEnd()) {
            BasicBlk blk = (BasicBlk)bp.elem();
            BiList instrList = blk.instrList();
            Object[] instrs = instrList.toArray();
            for (int i = 0; i < instrs.length; ++i) {
                LirNode ins = (LirNode)instrs[i];
                if (ins.opCode != 56 || ins.kid((int)0).opCode != 48 || ins.kid((int)0).kid((int)0).opCode != 7) continue;
                LirNode reg = ins.kid(0).kid(0).kid(0);
                if (reg.opCode != 6) continue;
                boolean score = false;
                for (int j = i + 1; j < instrs.length; ++j) {
                    if (this.used(reg, (LirNode)instrs[j])) {
                        score = true;
                        break;
                    }
                    if (this.defined(reg, (LirNode)instrs[j])) break;
                }
                if (score) continue;
                return false;
            }
            bp = bp.next();
        }
        return true;
    }

    private boolean used(LirNode reg, LirNode ins) {
        if (reg.opCode != 6) {
            return false;
        }
        if (ins.opCode != 56) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < ins.nKids(); ++i) {
            if (ins.kid((int)i).opCode != 48) {
                return false;
            }
            result |= this.isContained(reg, ins.kid(i).kid(1));
        }
        return result;
    }

    private boolean defined(LirNode reg, LirNode ins) {
        if (reg.opCode != 6) {
            return false;
        }
        if (ins.opCode != 56) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < ins.nKids(); ++i) {
            if (ins.kid((int)i).opCode != 48) {
                return false;
            }
            result |= this.isContained(reg, ins.kid(i).kid(0));
        }
        return result;
    }

    private boolean isContained(LirNode reg, LirNode nd) {
        RegCollector rc = new RegCollector();
        nd.pickUpUses(rc);
        rc.subregFilter();
        return rc.contains(reg);
    }

    class RegCollector
    implements PickUpVariable {
        private Vector reglist = new Vector();

        RegCollector() {
        }

        public void meetVar(LirNode node) {
            if (!this.reglist.contains(node)) {
                this.reglist.addElement(node);
            }
        }

        void subregFilter() {
            for (int i = 0; i < this.reglist.size(); ++i) {
                LirNode nd = (LirNode)this.reglist.elementAt(i);
                if (nd.opCode != 7) continue;
                this.reglist.setElementAt(nd.kid(0), i);
            }
        }

        boolean contains(LirNode node) {
            return this.reglist.contains(node);
        }

        Vector reglist() {
            return this.reglist;
        }

        void printIt() {
            System.out.println("RegCollector:");
            for (int i = 0; i < this.reglist.size(); ++i) {
                System.out.println("  " + ((LirNode)this.reglist.elementAt(i)).toString());
            }
        }
    }
}

