/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Module;
import coins.backend.lir.LirFactory;
import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.Trace;
import java.io.PrintWriter;

class SimdEnvironment {
    public static final int MsgThr = 100;
    public static final int MinThr = 1000;
    public static final int SimdThr = 1500;
    public static final int OptThr = 2000;
    public static final int AllThr = 10000;
    public final PrintWriter output;
    public final CompileSpecification spec;
    public final CoinsOptions opt;
    public final Trace trace;
    public final String MODULENAME = "SIMD";
    public final Module module;
    public final LirFactory lir;

    SimdEnvironment(Module m, CompileSpecification coinsSpec, PrintWriter writer) {
        this.module = m;
        this.lir = m.newLir;
        this.output = writer;
        this.spec = coinsSpec;
        this.opt = this.spec.getCoinsOptions();
        this.trace = this.spec.getTrace();
    }

    boolean shouldDo(int threshold) {
        return this.trace.shouldTrace("SIMD", threshold);
    }

    void println(String str, int threshold) {
        if (this.shouldDo(threshold)) {
            this.output.println(str);
        }
    }

    void print(String str, int threshold) {
        if (this.shouldDo(threshold)) {
            this.output.print(str);
        }
    }
}

