/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import java.util.HashMap;
import java.util.Vector;

public class RegGroups {
    private HashMap regRefs = new HashMap();

    RegGroups(BasicBlk blk) {
        BiLink lir = blk.instrList().first();
        while (!lir.atEnd()) {
            LirNode ins = (LirNode)lir.elem();
            if (ins.opCode == 48) {
                this.addRegGroup(ins);
            } else if (ins.opCode == 56) {
                for (int i = 0; i < ins.nKids(); ++i) {
                    this.addRegGroup(ins.kid(i));
                }
            }
            lir = lir.next();
        }
    }

    RegGroups(Vector is) {
        for (int n = 0; n < is.size(); ++n) {
            LirNode ins = (LirNode)is.elementAt(n);
            if (ins.opCode == 48) {
                this.addRegGroup(ins);
                continue;
            }
            if (ins.opCode != 56) continue;
            for (int i = 0; i < ins.nKids(); ++i) {
                this.addRegGroup(ins.kid(i));
            }
        }
    }

    private void addRegGroup(LirNode ins) {
        if (ins.kid((int)0).opCode == 6) {
            LirNode lnode = this.pickupBasicNode(ins.kid(0));
            LirNode rnode = this.pickupBasicNode(ins.kid(1));
            if (lnode != null) {
                this.regRefs.put(lnode, rnode);
            }
        }
    }

    private LirNode pickupBasicNode(LirNode lexp) {
        switch (lexp.opCode) {
            case 5: 
            case 6: {
                return lexp;
            }
            case 47: {
                LirNode res = this.pickupBasicNode(lexp.kid(0));
                if (res == null) {
                    return lexp;
                }
                if (res.opCode == 6) {
                    return lexp;
                }
                return res;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: {
                if (lexp.kid((int)1).opCode == 2) {
                    return this.pickupBasicNode(lexp.kid(0));
                }
                return null;
            }
        }
        return null;
    }

    public boolean isEquivalent(LirNode reg1, LirNode reg2) {
        if (reg1.opCode != reg2.opCode) {
            return false;
        }
        if (reg1.type != reg2.type) {
            return false;
        }
        if (reg1.opCode == 2 || reg1.opCode == 3) {
            return true;
        }
        LirNode rn1 = this.rootNode(this.pickupBasicNode(reg1));
        LirNode rn2 = this.rootNode(this.pickupBasicNode(reg2));
        if (rn1 == null || rn2 == null) {
            return true;
        }
        return rn1.equals(rn2);
    }

    private LirNode rootNode(LirNode regnode) {
        if (regnode == null) {
            return null;
        }
        LirNode rn = regnode;
        LirNode parent = regnode;
        while (parent != null) {
            rn = parent;
            parent = (LirNode)this.regRefs.get(rn);
        }
        if (rn.opCode == 47) {
            return this.pickupBasicNode(rn.kid(0));
        }
        if (rn.opCode == 6) {
            return null;
        }
        return rn;
    }
}

