/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.Type;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.simd.BoundanalysisDwForLir;
import coins.simd.BoundanalysisUwForLir;
import coins.simd.SizeConv;

public class BoundanalysisForLir {
    public BoundanalysisUwForLir bauw;
    private Function func;
    public BoundanalysisDwForLir badw;

    BoundanalysisForLir(Function f) {
        this.func = f;
        this.bauw = new BoundanalysisUwForLir(f);
        this.badw = new BoundanalysisDwForLir(f);
    }

    public void boundanalysis(LirNode ins) {
        this.bauw.boundanalysisUw(ins);
        this.badw.boundanalysisDw(ins, this.bauw);
    }

    public void invoke(BasicBlk blk) {
        if (!blk.instrList().isEmpty()) {
            BiLink lir = blk.instrList().first();
            while (!lir.atEnd()) {
                LirNode ins = (LirNode)lir.elem();
                if (ins.opCode == 48 && Type.tag(ins.type) == 2) {
                    this.boundanalysis(ins);
                    SizeConv sc = new SizeConv(this.func, this.badw);
                    LirNode insNew = sc.convert(ins);
                    if (insNew != ins) {
                        lir.setElem(insNew);
                    }
                }
                lir = lir.next();
            }
        }
    }
}

