/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.aflow.FlowResults;
import coins.aflow.InitiateFlowHir;
import coins.aflow.RegisterFlowAnalClasses;
import coins.aflow.SubpFlow;
import coins.alias.AliasAnal;
import coins.alias.alias2.AliasAnalHir2;
import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.Trace;
import coins.flow.ControlFlow;
import coins.flow.ControlFlowImpl;
import coins.flow.DataFlow;
import coins.flow.Flow;
import coins.flow.FlowImpl;
import coins.flow.HirSubpFlowImpl;
import coins.flow.ShowDataFlow;
import coins.flow.SubpFlowImpl;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.InfStmt;
import coins.ir.hir.Program;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.opt.CommonSubexpElimHirE;
import coins.opt.ConstFoldingHir;
import coins.opt.ConstPropagationAndFoldingHir;
import coins.opt.ConstPropagationAndFoldingHirOld;
import coins.opt.DeadCodeElim;
import coins.opt.GlobalReform;
import coins.opt.GlobalVariableTemporalize;
import coins.opt.Inline;
import coins.opt.LoopUnrolling;
import coins.opt.LoopUnswitching;
import coins.opt.PRE;
import coins.sym.Label;
import coins.sym.Subp;
import coins.sym.SubpImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Opt {
    public final FlowRoot flowRoot;
    public final IoRoot ioRoot;
    public final SymRoot symRoot;
    public final HirRoot hirRoot;
    public final Flow flow;
    protected coins.flow.SubpFlow fSubpFlow;
    public final AliasAnal fAlias;
    public final Map fOptionMap;
    public final CoinsOptions fOptions;
    public final String fHirOpt;
    public final List fKeyList;
    public final int fDbgLevel;
    protected List fInlineSubps;
    protected List fReformPatternList = null;

    public Opt(FlowRoot pFlowRoot) {
        this.flowRoot = pFlowRoot;
        this.flow = pFlowRoot.flow;
        this.ioRoot = this.flowRoot.ioRoot;
        this.symRoot = this.flowRoot.symRoot;
        this.hirRoot = this.flowRoot.hirRoot;
        this.fDbgLevel = this.ioRoot.dbgOpt1.getLevel();
        this.fAlias = new AliasAnalHir2(this.hirRoot);
        this.fOptions = this.ioRoot.getCompileSpecification().getCoinsOptions();
        this.fHirOpt = this.fOptions.getArg("hirOpt");
        if (this.fHirOpt != null) {
            this.fOptionMap = this.fOptions.parseArgument(this.fHirOpt, '/', '.');
            this.fKeyList = (List)this.fOptionMap.get("item_key_list");
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgOpt1.print(1, "\n Opt start", "Option map " + this.fOptionMap + " key list " + this.fKeyList);
            }
        } else {
            this.fOptionMap = new HashMap();
            this.fKeyList = new ArrayList();
        }
    }

    void dbg(int level, String pHeader, Object pObject) {
        this.ioRoot.dbgOpt1.printObject(level, pHeader, pObject);
        this.ioRoot.dbgOpt1.println(level);
    }

    boolean shouldTrace(int level) {
        return level <= this.fDbgLevel;
    }

    public boolean doHir(List pOpts) {
        return this.doHir();
    }

    public boolean doHir() {
        boolean lOptimized = false;
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgOpt1.print(1, "\ndoHir options:" + this.fHirOpt);
        }
        FlowResults.putRegClasses(new RegisterFlowAnalClasses());
        CompileSpecification lSpec = this.ioRoot.getCompileSpecification();
        this.fReformPatternList = new ArrayList();
        if (this.fKeyList.contains("globalReform")) {
            GlobalReform lReform = new GlobalReform(this.hirRoot);
            lOptimized = lReform.doReform(this.fReformPatternList);
        }
        this.fInlineSubps = new ArrayList();
        ArrayList<Subp> lSubprograms = new ArrayList<Subp>();
        Program lProgram = (Program)this.hirRoot.programRoot;
        IrList subpDefList = lProgram.getSubpDefinitionList();
        ListIterator lIt = subpDefList.iterator();
        while (lIt.hasNext()) {
            SubpDefinition lSubpDef = (SubpDefinition)lIt.next();
            lSubprograms.add(lSubpDef.getSubpSym());
        }
        this.ioRoot.dbgOpt1.print(2, "Subprograms defined", lSubprograms + "\n");
        HIR lProgInitPart = (HIR)lProgram.getInitiationPart();
        if (lProgInitPart instanceof BlockStmt) {
            for (Stmt lStmt = ((BlockStmt)lProgInitPart).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                if (!(lStmt instanceof InfStmt) || ((InfStmt)lStmt).getInfKind() != "optControl") continue;
                this.ioRoot.dbgOpt1.print(3, lStmt.toString() + "\n");
                IrList lOptionList = ((InfStmt)lStmt).getInfList("optControl");
                String lSubkind = ((InfStmt)lStmt).getInfSubkindOf("optControl");
                if (lSubkind == null || lSubkind != "inline") continue;
                ListIterator lIt2 = lOptionList.iterator();
                while (lIt2.hasNext()) {
                    Object lSubp = lIt2.next();
                    this.ioRoot.dbgOpt1.print(4, " " + lSubp + " " + lSubp.getClass() + "\n");
                    if (!(lSubp instanceof Subp)) continue;
                    this.fInlineSubps.add(lSubp);
                }
            }
        }
        this.ioRoot.dbgOpt1.print(2, "Subprograms specified in #pragma inline", this.fInlineSubps.toString());
        if (!this.fOptions.isSet("hirOpt") && this.fInlineSubps.isEmpty()) {
            this.ioRoot.dbgOpt1.print(1, "\nNeither hirOpt nore #pragma inline is specified.\n");
            return false;
        }
        Trace lTrace = lSpec.getTrace();
        if (this.fKeyList.contains("inline") || !this.fInlineSubps.isEmpty()) {
            this.symRoot.symTableRoot.setUniqueNameToAllSym();
        }
        ListIterator subpDefIterator = subpDefList.iterator();
        while (subpDefIterator.hasNext()) {
            SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
            this.symRoot.subpCurrent = subpDef.getSubpSym();
            this.flowRoot.subpUnderAnalysis = subpDef.getSubpSym();
            if (this.fDbgLevel > 0 || this.ioRoot.dbgControl.getLevel() > 0) {
                String lFileName = this.symRoot.subpCurrent.getDefinedFile();
                System.out.print("\nhirOpt " + lFileName + " " + this.symRoot.subpCurrent.getName());
            }
            if (this.fReformPatternList.contains(this.symRoot.subpCurrent)) {
                this.ioRoot.dbgOpt1.print(2, "\n Skip global reform pattern " + this.symRoot.subpCurrent.getName());
                continue;
            }
            Object lRecordAlias = null;
            if (subpDef.getIndex() == 0 && subpDef.getChild1().getIndex() == 0) {
                subpDef.setIndexNumberToAllNodes(0, true);
            }
            FlowResults results = new FlowResults(this.flowRoot);
            SubpFlow lSubpFlowA = this.flowRoot.aflow.subpFlow(subpDef, results);
            this.flowRoot.aflow.setSubpFlow(lSubpFlowA);
            HirSubpFlowImpl lSubpFlow = new HirSubpFlowImpl(this.flowRoot, subpDef);
            this.fSubpFlow = lSubpFlow;
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgOpt1.print(2, "\n  optimize " + subpDef.getSubpSym().toString());
                if (this.fDbgLevel >= 4) {
                    this.ioRoot.dbgOpt1.print(3, "\nHIR before optimization");
                    if (this.fOptions.isSet("hirOpt") || this.fInlineSubps.contains(subpDef.getSubpSym())) {
                        subpDef.print(1, true);
                    }
                }
            }
            for (String lOpt : this.fKeyList) {
                DataFlow lDataFlow;
                ControlFlow controlFlow;
                if (this.fDbgLevel > 2) {
                    this.ioRoot.dbgOpt1.print(3, "\noptimize " + subpDef.getSubpSym().toString() + " by " + lOpt);
                }
                boolean llOptimized = false;
                boolean lHirPrinted = false;
                ShowDataFlow lShowDataFlow = null;
                int lThreshold = this.flowRoot.hirRoot.machineParam.costOfInstruction(1);
                lThreshold += 3;
                if (this.fDbgLevel > 2) {
                    this.ioRoot.dbgOpt1.print(3, "\n lOpt " + lOpt + "\n");
                }
                if (lOpt.equals("pre")) {
                    if (llOptimized) {
                        lSubpFlow.resetFlowSymLinkForRecordedSym();
                    }
                    PRE lPre = this.fKeyList.contains("subsptr") ? new PRE(this.fSubpFlow, subpDef, true, lThreshold) : new PRE(this.fSubpFlow, subpDef, false, lThreshold);
                    llOptimized = lPre.doPRE();
                    lHirPrinted = true;
                } else if (lOpt.equals("cse")) {
                    if (!this.fKeyList.contains("pre")) {
                        ((SubpFlowImpl)lSubpFlow).fHirAnalExtended = true;
                        if (!lSubpFlow.isComputed(4)) {
                            if (llOptimized) {
                                lSubpFlow.resetFlowSymLinkForRecordedSym();
                            }
                            controlFlow = new ControlFlowImpl(this.flowRoot, lSubpFlow, subpDef);
                        }
                        if (lSubpFlow.isFailed()) {
                            this.ioRoot.msgRecovered.put(5011, "Skip optimization " + lOpt);
                            continue;
                        }
                        CommonSubexpElimHirE cse = new CommonSubexpElimHirE(this.flowRoot, lThreshold);
                        cse.estimateExpCost(subpDef);
                        llOptimized = cse.doBBlockLocal(lSubpFlow);
                        lOptimized |= llOptimized;
                        lHirPrinted = true;
                    } else if (this.fDbgLevel >= 0) {
                        this.ioRoot.dbgOpt1.print(2, "\nSkip cse optimization because pre does cse.\n");
                    }
                } else if (lOpt.equals("cpf")) {
                    if (!lSubpFlow.isComputed(4)) {
                        controlFlow = this.flow.controlFlowAnal(this.fSubpFlow);
                    }
                    if (lSubpFlow.isFailed()) {
                        this.ioRoot.msgRecovered.put(5011, "Skip optimization " + lOpt);
                        continue;
                    }
                    if (!lSubpFlow.isComputed(23)) {
                        lDataFlow = this.flow.dataFlowAnal(subpDef);
                        lShowDataFlow = new ShowDataFlow(lDataFlow);
                    }
                    ConstPropagationAndFoldingHir cpaf = new ConstPropagationAndFoldingHir(results);
                    llOptimized = cpaf.doSubp(lSubpFlow);
                    lOptimized |= llOptimized;
                } else if (lOpt.equals("cpfold")) {
                    lSubpFlowA.controlFlowAnal();
                    if (lSubpFlow.isFailed()) {
                        this.ioRoot.msgRecovered.put(5011, "Skip optimization " + lOpt);
                        continue;
                    }
                    InitiateFlowHir lInitiateFlow = new InitiateFlowHir(results);
                    results.find("Initiate", lSubpFlowA);
                    ConstPropagationAndFoldingHirOld cpaf = new ConstPropagationAndFoldingHirOld(results);
                    llOptimized = cpaf.doSubp(lSubpFlowA);
                    lOptimized |= llOptimized;
                }
                if (lOpt.equals("globalReform")) {
                    if (this.fDbgLevel >= 0) {
                        this.ioRoot.dbgOpt1.print(2, "\nglobalReform is already processed.\n");
                    }
                } else {
                    if (!lSubpFlow.isComputed(4)) {
                        if (llOptimized) {
                            lSubpFlow.resetFlowSymLinkForRecordedSym();
                        }
                        controlFlow = this.flow.controlFlowAnal(this.fSubpFlow);
                    }
                    if (lSubpFlow.isFailed()) {
                        this.ioRoot.msgRecovered.put(5011, "Skip optimization " + lOpt);
                        continue;
                    }
                    if (lOpt.equals("dce")) {
                        if (!lSubpFlow.isComputed(23)) {
                            lDataFlow = this.flow.dataFlowAnal(subpDef);
                            if (lSubpFlow.isFailed()) {
                                this.ioRoot.msgRecovered.put(5011, "Skip optimization " + lOpt);
                                continue;
                            }
                            lShowDataFlow = new ShowDataFlow(lDataFlow);
                        }
                    }
                    if (lOpt.equals("cf")) {
                        ConstFoldingHir cf = new ConstFoldingHir(results);
                        llOptimized = cf.doSubp(lSubpFlow);
                        lOptimized |= llOptimized;
                    }
                    if (lOpt.equals("dce")) {
                        DeadCodeElim dce = new DeadCodeElim(results, this);
                        llOptimized = dce.doSubp(lSubpFlow);
                        lOptimized |= llOptimized;
                    }
                    if (lOpt.equals("gt")) {
                        boolean lisOptimizedGt;
                        GlobalVariableTemporalize lGt = new GlobalVariableTemporalize(subpDef, lSubpFlow, this.fAlias);
                        llOptimized = lisOptimizedGt = lGt.doSubprogram();
                        lOptimized |= llOptimized;
                    }
                    if (lOpt.equals("loopif")) {
                        LoopUnswitching lLoopUnswitching = new LoopUnswitching(this.hirRoot);
                        llOptimized = lLoopUnswitching.doSubprogram(subpDef);
                        lOptimized |= llOptimized;
                    }
                    if (lOpt.equals("loopexp")) {
                        LoopUnrolling lLoopUnrolling = new LoopUnrolling(this.hirRoot);
                        llOptimized = lLoopUnrolling.doSubprogram(subpDef);
                        lOptimized |= llOptimized;
                    }
                    if (lOpt.equals("inline")) {
                        String lOptionValue = (String)this.fOptionMap.get("inline");
                        String lInlineDepth = "1";
                        if (this.fOptionMap.containsKey("inlinedepth")) {
                            lInlineDepth = (String)this.fOptionMap.get("inlinedepth");
                        }
                        Inline inline = new Inline(this.hirRoot, this.symRoot, this.ioRoot, lOptionValue, this.fInlineSubps, true, lInlineDepth);
                        llOptimized = inline.changeSubp(subpDef);
                        lOptimized |= llOptimized;
                    }
                }
                if (llOptimized) {
                    if (!lHirPrinted) {
                        if (this.fDbgLevel >= 2) {
                            this.ioRoot.dbgOpt1.print(2, "\nHIR of " + subpDef.getSubpSym().toString() + " after " + lOpt + " optimization");
                            subpDef.print(1, true);
                        }
                        subpDef.finishHir();
                        this.fSubpFlow.setComputedFlag(2);
                    }
                    this.fSubpFlow.resetComputedFlag(4);
                    this.fSubpFlow.setFlowAnalStateLevel(1);
                }
                if (llOptimized) {
                    if (this.fDbgLevel <= 0) continue;
                    this.ioRoot.dbgOpt1.print(1, "\nHIR of " + subpDef.getSubpSym().toString() + " is changed by " + lOpt + " optimization\n");
                    continue;
                }
                if (this.fDbgLevel <= 0) continue;
                this.ioRoot.dbgOpt1.print(1, "\nHIR of " + subpDef.getSubpSym().toString() + " is not changed by " + lOpt + " optimization\n");
            }
            if (this.fKeyList.isEmpty() && !this.fInlineSubps.isEmpty()) {
                if (this.fDbgLevel > 0) {
                    this.ioRoot.dbgOpt1.print(2, "Trial of inline expansion", "by #pragma ");
                }
                String lInlineDepth2 = "1";
                if (this.fOptionMap.containsKey("inlinedepth")) {
                    lInlineDepth2 = (String)this.fOptionMap.get("inlinedepth");
                }
                Inline inline = new Inline(this.hirRoot, this.symRoot, this.ioRoot, "", this.fInlineSubps, false, lInlineDepth2);
                lOptimized |= inline.changeSubp(subpDef);
            }
            this.releaseFlowInf(subpDef);
        }
        if (lOptimized) {
            ((HIR)this.hirRoot.programRoot).finishHir();
        }
        return lOptimized;
    }

    public void releaseFlowInf(SubpDefinition pSubpDef) {
        Subp lSubp = pSubpDef.getSubpSym();
        this.ioRoot.dbgOpt1.print(2, "releaseFlowInf", pSubpDef.getSubpSym().getName());
        IrList lLabelList = ((SubpImpl)lSubp).getLabelDefList();
        if (lLabelList != null && ((FlowImpl)this.flowRoot.flow).fSubpFlowCurrent instanceof SubpFlow) {
            this.ioRoot.dbgOpt1.print(2, " reset flow Inf of labels");
            ListIterator lItL = lLabelList.iterator();
            while (lItL.hasNext()) {
                Label lLabel = (Label)lItL.next();
                lLabel.setBBlock(null);
            }
        }
        this.flowRoot.flow.resetAllFlowInf(lSubp);
        this.symRoot.symTableFlow = null;
        this.flowRoot.fSubpFlow = null;
        this.flowRoot.subpFlow = null;
    }
}

