/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.HirRoot;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ForStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.IfStmt;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubscriptedExp;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.VarNode;
import coins.opt.LoopExpansion;
import coins.sym.Const;
import coins.sym.IntConst;
import coins.sym.SymIterator;
import coins.sym.Type;
import coins.sym.Var;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class LoopUnrolling
extends LoopExpansion {
    private Var fLoopVar;
    private int fChildNumofLoopVarinCond;
    private Set fBadVarSet = new HashSet();
    private Set fBadMergeableVarSet = new HashSet();
    private Set fUsedVarSet = new HashSet();
    private Set fIncrementalVarSet = new HashSet();
    private Set fNotIncrementalVarSet = new HashSet();
    protected int fExpRate = 4;
    protected int fUpperLimitOfExpansionFactor;
    protected int fNodeCountMultipliedByExpFactor;
    private boolean fIsSIMD = false;

    public boolean isSIMD() {
        return this.fIsSIMD;
    }

    public void setSIMD_Environment(boolean isSIMD) {
        this.fIsSIMD = isSIMD;
    }

    public int getExpRate() {
        return this.fExpRate;
    }

    public void setExpRate(int pRate) {
        if (pRate >= 2) {
            this.fExpRate = pRate;
        }
    }

    public LoopUnrolling(HirRoot phirRoot) {
        super(phirRoot);
        int lExpansionFactor;
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgOpt1.print(1, "\nLoopUnrolling ");
        }
        if (this.fNumberOfGeneralRegisters <= 8) {
            lExpansionFactor = 2;
            this.fUpperLimitOfExpansionFactor = 4;
            this.fMaxAllowableNodesInLoopBody = 50;
            this.fNodeCountMultipliedByExpFactor = 100;
        } else if (this.fNumberOfGeneralRegisters <= 16) {
            lExpansionFactor = 2;
            this.fUpperLimitOfExpansionFactor = 4;
            this.fMaxAllowableNodesInLoopBody = 60;
            this.fNodeCountMultipliedByExpFactor = 120;
        } else if (this.fNumberOfGeneralRegisters <= 32) {
            lExpansionFactor = 2;
            this.fUpperLimitOfExpansionFactor = 4;
            this.fMaxAllowableNodesInLoopBody = 100;
            this.fNodeCountMultipliedByExpFactor = 200;
        } else {
            lExpansionFactor = 4;
            this.fUpperLimitOfExpansionFactor = 8;
            this.fMaxAllowableNodesInLoopBody = 200;
            this.fNodeCountMultipliedByExpFactor = 400;
        }
        String lOptionValue = (String)this.fOptionMap.get("loopexp");
        if (lOptionValue != "" && Character.isDigit(lOptionValue.charAt(0))) {
            lOptionValue = lOptionValue.length() >= 2 && Character.isDigit(lOptionValue.charAt(1)) ? lOptionValue.substring(0, 2) : lOptionValue.substring(0, 1);
            Integer lValue = Integer.valueOf(lOptionValue);
            this.fUpperLimitOfExpansionFactor = lExpansionFactor = lValue.intValue();
        }
        this.setExpRate(lExpansionFactor);
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgOpt1.print(2, " upper limit of expansion factor " + this.fUpperLimitOfExpansionFactor);
        }
        if (this.fOptions.isSet("simd")) {
            this.setSIMD_Environment(true);
        } else {
            this.setSIMD_Environment(false);
        }
    }

    public LoopUnrolling(HirRoot pHirRoot, int pExpansionFactor, int pMaxAllowableNodesInLoopBody, int pNodeCountMultipliedByExpFactor) {
        this(pHirRoot);
        this.fUpperLimitOfExpansionFactor = pExpansionFactor;
        this.fMaxAllowableNodesInLoopBody = pMaxAllowableNodesInLoopBody;
        this.fNodeCountMultipliedByExpFactor = pNodeCountMultipliedByExpFactor;
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgOpt1.print(2, " UpperLimitOfExpansionFactor=" + this.fUpperLimitOfExpansionFactor + " MAxAllowableNodesInLoopBody=" + this.fMaxAllowableNodesInLoopBody + " NodeCountMultipliedByExpFactor=" + this.fNodeCountMultipliedByExpFactor);
        }
    }

    public boolean doSubprogram(SubpDefinition pSubpDef) {
        String lMethodName = "doHir";
        this.getDebug().print(2, "doHir", "Start process");
        this.flowRoot.subpUnderAnalysis = pSubpDef.getSubpSym();
        this.symRoot.symTableCurrentSubp = this.symRoot.symTableCurrent = pSubpDef.getSymTable();
        boolean lChanged = false;
        HirIterator lHirIterator = this.hirRoot.hir.hirIterator(pSubpDef.getHirBody());
        while (lHirIterator.hasNextStmt()) {
            Stmt lStmt = lHirIterator.getNextStmt();
            if (lStmt == null || lStmt.getOperator() != 25) continue;
            int lExpansionFactor = this.computeExpansionFactor((ForStmt)lStmt);
            this.getDebug().print(2, "doHir", "Loop is found. ExpansionFactor " + lExpansionFactor + " Line " + lStmt.getLineNumber());
            if (lExpansionFactor <= 1) continue;
            this.setExpRate(lExpansionFactor);
            if (!this.isExpansible((ForStmt)lStmt)) continue;
            this.expandLoop((ForStmt)lStmt);
            lChanged = true;
        }
        if (lChanged) {
            // empty if block
        }
        return lChanged;
    }

    protected void pickUpVariables(ForStmt pForStmt) {
        Exp lExp;
        Var lVar;
        SymIterator lSymIterator;
        HIR lnode;
        Stmt lStmtNext;
        String lMethodName = "pickUpVariables";
        HashSet<Var> lAssignedVarSet = new HashSet<Var>();
        this.getDebug().print(3, "pickUpVariables", "Start process");
        this.fBadVarSet.clear();
        this.fBadMergeableVarSet.clear();
        this.fUsedVarSet.clear();
        this.fIncrementalVarSet.clear();
        this.fNotIncrementalVarSet.clear();
        BlockStmt lBlock = this.hirRoot.hir.blockStmt(null);
        Stmt lLoopBodyPart = pForStmt.getLoopBodyPart();
        if (lLoopBodyPart instanceof LabeledStmt) {
            lLoopBodyPart = ((LabeledStmt)lLoopBodyPart).getStmt();
        }
        Stmt lStmt = lLoopBodyPart instanceof BlockStmt ? ((BlockStmt)lLoopBodyPart).getFirstStmt() : lLoopBodyPart;
        lStmt = (Stmt)lStmt.copyWithOperandsChangingLabels(null);
        while (lStmt != null) {
            lStmtNext = lStmt.getNextStmt();
            if (!(lStmt instanceof LabeledStmt) || ((LabeledStmt)lStmt).getLabel() != null) {
                lBlock.addLastStmt(lStmt);
            }
            lStmt = lStmtNext;
        }
        if (pForStmt.getLoopStepPart() != null && (lStmt = (Stmt)pForStmt.getLoopStepPart().copyWithOperandsChangingLabels(null)) instanceof BlockStmt) {
            lStmt = ((BlockStmt)lStmt).getFirstStmt();
        }
        while (lStmt != null) {
            lStmtNext = lStmt.getNextStmt();
            if (!(lStmt instanceof LabeledStmt) || ((LabeledStmt)lStmt).getLabel() != null) {
                lBlock.addLastStmt(lStmt);
            }
            lStmt = lStmtNext;
        }
        boolean lHasFunction = false;
        HirIterator lHirIterator = this.hirRoot.hir.hirIterator(lBlock);
        while (!lHasFunction && lHirIterator.hasNext()) {
            lnode = lHirIterator.next();
            if (lnode == null || lnode.getOperator() != 33) continue;
            lHasFunction = true;
        }
        if (lHasFunction) {
            lSymIterator = this.hirRoot.symRoot.symTableRoot.getSymIterator();
            while ((lVar = lSymIterator.nextVar()) != null) {
                this.fBadVarSet.add(lVar);
            }
        }
        lSymIterator = this.hirRoot.symRoot.symTableCurrentSubp.getSymIterator();
        while ((lVar = lSymIterator.nextVar()) != null) {
            if (lVar.getSymType().getTypeKind() != 22 && !lVar.getFlag(6)) continue;
            this.fBadVarSet.add(lVar);
        }
        lHirIterator = this.hirRoot.hir.hirIterator(lBlock);
        while (lHirIterator.hasNext()) {
            lnode = lHirIterator.next();
            if (!(lnode instanceof VarNode)) continue;
            boolean lusedVar = true;
            for (HIR lnode2 = lnode; lnode2 != lBlock && lnode2.getOperator() != 18 && lusedVar; lnode2 = (HIR)lnode2.getParent()) {
                if (!(lnode2.getParent() instanceof AssignStmt)) continue;
                if (lnode2.getChildNumber() == 1) {
                    lusedVar = false;
                    continue;
                }
                lExp = ((AssignStmt)lnode2.getParent()).getLeftSide();
                if (this.getSimpleExp(lExp).getVar() != ((VarNode)lnode).getVar()) continue;
                lusedVar = false;
            }
            if (!lusedVar) continue;
            this.fUsedVarSet.add(((VarNode)lnode).getVar());
        }
        lHirIterator = this.hirRoot.hir.hirIterator(lBlock);
        while (lHirIterator.hasNextStmt()) {
            lStmt = lHirIterator.getNextStmt();
            if (!(lStmt instanceof AssignStmt) || (lVar = (lExp = this.getSimpleExp(((AssignStmt)lStmt).getLeftSide())).getOperator() == 17 || lExp.getOperator() == 19 ? lExp.getExp1().getVar() : lExp.getVar()) == null || this.fBadVarSet.contains(lVar)) continue;
            lAssignedVarSet.add(lVar);
            if (lVar.getSymType().getTypeKind() == 23 || lVar.getSymType().getTypeKind() == 24 || lVar.getSymType().getTypeKind() == 25) {
                this.fBadVarSet.add(lVar);
                continue;
            }
            for (lnode = (HIR)lStmt.getParent(); lnode != lBlock; lnode = (HIR)lnode.getParent()) {
                if (!(lnode instanceof IfStmt) && !(lnode instanceof SwitchStmt)) continue;
                this.fBadVarSet.add(lVar);
            }
        }
        lHirIterator = this.hirRoot.hir.hirIterator(lBlock);
        block9: while (lHirIterator.hasNext()) {
            Var lArrayVar;
            lnode = lHirIterator.next();
            if (!(lnode instanceof SubscriptedExp) || (lArrayVar = this.getArrayVar((SubscriptedExp)lnode)) == null) continue;
            Set lVarSet = this.getSubscriptVar((SubscriptedExp)lnode);
            for (Var var : lVarSet) {
                if (!lAssignedVarSet.contains(var) && !this.fBadVarSet.contains(var)) continue;
                this.fBadVarSet.add(lArrayVar);
                continue block9;
            }
        }
        lHirIterator = this.hirRoot.hir.hirIterator(lBlock);
        while (lHirIterator.hasNextStmt()) {
            Var lAssignedVar;
            lStmt = lHirIterator.getNextStmt();
            if (!(lStmt instanceof AssignStmt) || (lAssignedVar = this.getSimpleExp(((AssignStmt)lStmt).getLeftSide()).getVar()) == null) continue;
            boolean lIncremental = false;
            HirIterator lHirIterator2 = this.hirRoot.hir.hirIterator(((AssignStmt)lStmt).getRightSide());
            while (lHirIterator2.hasNext()) {
                HIR lRSideNode = lHirIterator2.next();
                if (lRSideNode instanceof Exp) {
                    Exp lRSideExp = this.getSimpleExp((Exp)lRSideNode);
                    if (lRSideExp.getVar() == null) continue;
                    if (lRSideExp.getVar() == lAssignedVar) {
                        lIncremental = true;
                        while (lRSideExp.getParent() != lStmt && !this.fBadMergeableVarSet.contains(lAssignedVar)) {
                            if (lRSideExp.getParent().getOperator() != 65 && lRSideExp.getParent().getOperator() != 38 && lRSideExp.getParent().getOperator() != 39 || lRSideExp.getParent().getOperator() == 39 && lRSideExp.getChildNumber() != 1) {
                                this.fBadMergeableVarSet.add(lAssignedVar);
                            }
                            lRSideExp = (Exp)lRSideExp.getParent();
                        }
                        continue;
                    }
                    if (this.fBadVarSet.contains(lRSideExp.getVar()) || this.fBadMergeableVarSet.contains(lRSideExp.getVar())) {
                        this.fBadVarSet.add(lAssignedVar);
                        continue;
                    }
                    if (!lAssignedVarSet.contains(lRSideExp.getVar())) continue;
                    this.fBadMergeableVarSet.add(lAssignedVar);
                    continue;
                }
                this.fBadVarSet.add(lAssignedVar);
            }
            if (lIncremental) {
                this.fIncrementalVarSet.add(lAssignedVar);
                continue;
            }
            this.fNotIncrementalVarSet.add(lAssignedVar);
        }
        if (this.fDbgLevel >= 3) {
            this.getDebug().print(4, "pickUpVariables", "Variables are picked up");
            this.getDebug().print(4, "pickUpVariables", "fBadVarSet:" + this.fBadVarSet);
            this.getDebug().print(4, "pickUpVariables", "fBadMergeableVarSet:" + this.fBadMergeableVarSet);
            this.getDebug().print(4, "pickUpVariables", "fUsedVarSet:" + this.fUsedVarSet);
            this.getDebug().print(4, "pickUpVariables", "fIncrementalVarSet:" + this.fIncrementalVarSet);
            this.getDebug().print(4, "pickUpVariables", "fNotIncrementalVarSet:" + this.fNotIncrementalVarSet);
        }
    }

    protected boolean isExpansible(ForStmt pForStmt) {
        HIR lnode;
        String lMethodName = "isExpansible";
        if (this.fDbgLevel > 0) {
            this.getDebug().print(3, "isExpansible", "Start process:" + pForStmt.toStringDetail());
        }
        if (this.hasBadElement(pForStmt)) {
            this.getDebug().print(3, "isExpansible", "Bad element is found.");
            return false;
        }
        Stmt lLoopBodyPart = pForStmt.getLoopBodyPart();
        if (lLoopBodyPart instanceof LabeledStmt) {
            lLoopBodyPart = ((LabeledStmt)lLoopBodyPart).getStmt();
        }
        HirIterator lHirIterator = this.hirRoot.hir.hirIterator(lLoopBodyPart);
        while (lHirIterator.hasNextStmt()) {
            lnode = lHirIterator.getNextStmt();
            if (!(lnode instanceof ForStmt)) continue;
            this.getDebug().print(4, "isExpansible", "Not innermost loop");
            return false;
        }
        this.getDebug().print(4, "isExpansible", "Innermost loop");
        int cntStmtInBody = this.calcStatementCount(pForStmt.getLoopBodyPart());
        this.getDebug().print(4, "isExpansible", "statement count in body is " + cntStmtInBody);
        if (pForStmt.getLoopStartCondition() == null) {
            return false;
        }
        this.getDebug().print(4, "isExpansible", "Single start condition");
        int lCondOP = pForStmt.getLoopStartCondition().getOperator();
        if (lCondOP != 53 && lCondOP != 54 && lCondOP != 55 && lCondOP != 56) {
            return false;
        }
        this.getDebug().print(4, "isExpansible", "Compare GT|GE|LT|LE");
        this.pickUpVariables(pForStmt);
        this.fLoopVar = null;
        for (int i = 1; i <= 2; ++i) {
            lHirIterator = this.hirRoot.hir.hirIterator(pForStmt.getLoopStartCondition().getChild(i));
            while (lHirIterator.hasNext()) {
                lnode = lHirIterator.next();
                if (!(lnode instanceof VarNode)) continue;
                if (this.fBadVarSet.contains(((VarNode)lnode).getVar()) || this.fBadMergeableVarSet.contains(((VarNode)lnode).getVar()) || this.fNotIncrementalVarSet.contains(((VarNode)lnode).getVar())) {
                    this.getDebug().print(4, "isExpansible", "Condpart maybe changed.");
                    return false;
                }
                if (!this.fIncrementalVarSet.contains(((VarNode)lnode).getVar())) continue;
                if (this.fLoopVar == null) {
                    this.fLoopVar = ((VarNode)lnode).getVar();
                    this.fChildNumofLoopVarinCond = i;
                    continue;
                }
                this.getDebug().print(4, "isExpansible", "Loop has control variables multiply " + this.fLoopVar);
                return false;
            }
        }
        if (this.fLoopVar == null) {
            this.getDebug().print(4, "isExpansible", "This loop doesn't have LoopVar");
            return false;
        }
        this.getDebug().print(2, "isExpansible", "This loop is expansible");
        return true;
    }

    protected void expandLoop(ForStmt pForStmt) {
        Const lConst;
        Exp lExp;
        Stmt lBodyCopy;
        HirIterator lHirIterator;
        String lMethodName = "expandLoop";
        HIR lnode = null;
        Stmt lStmt = null;
        Stmt lStmt2 = null;
        Stmt lStepPart = null;
        Const lStepConst = null;
        this.getDebug().print(3, "expandLoop", "Start process " + pForStmt.toStringShort());
        Stmt lBodyPart = (Stmt)pForStmt.getLoopBodyPart().copyWithOperandsChangingLabels(null);
        if (pForStmt.getLoopStepPart() != null) {
            lStepPart = (Stmt)pForStmt.getLoopStepPart().copyWithOperandsChangingLabels(null);
            lStmt = lStepPart instanceof BlockStmt ? ((BlockStmt)lStepPart).getFirstStmt() : lStepPart;
            while (lStmt != null) {
                if (lStmt instanceof AssignStmt && this.getSimpleExp(((AssignStmt)lStmt).getLeftSide()).getVar() != this.fLoopVar) {
                    lHirIterator = this.hirRoot.hir.hirIterator(((AssignStmt)lStmt).getRightSide());
                    while (lHirIterator.hasNext()) {
                        lnode = lHirIterator.next();
                        if (!(lnode instanceof VarNode) || ((VarNode)lnode).getVar() != this.fLoopVar) continue;
                        lStmt2 = ((LabeledStmt)lBodyPart).getStmt();
                        for (lStmt = ((BlockStmt)lStepPart).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                            ((BlockStmt)lStmt2).addLastStmt((Stmt)lStmt.copyWithOperands());
                        }
                        lStepPart = null;
                        break;
                    }
                }
                if (lStmt == null) continue;
                lStmt = lStmt.getNextStmt();
            }
        }
        if (lStepPart != null) {
            lStmt = lStepPart instanceof BlockStmt ? ((BlockStmt)lStepPart).getFirstStmt() : lStepPart;
            lStmt2 = ((LabeledStmt)lBodyPart).getStmt();
            while (lStmt != null) {
                if (!(lStmt instanceof AssignStmt) || this.getSimpleExp(((AssignStmt)lStmt).getLeftSide()).getVar() != this.fLoopVar) {
                    ((BlockStmt)lStmt2).addLastStmt((Stmt)lStmt.copyWithOperands());
                    lStmt = lStmt.deleteThisStmt();
                    continue;
                }
                lStmt = lStmt.getNextStmt();
            }
        }
        this.getDebug().print(4, "expandLoop", "Step part is converted " + lStmt);
        if (this.fDbgLevel > 0 && lStmt != null) {
            this.getDebug().print(4, "expandLoop", "step part " + lStmt.toStringWithChildren());
        }
        Exp lStepExpInStep = null;
        Exp lStepExpInBody = null;
        boolean lStepWithVar = false;
        if (lStepPart != null) {
            lStepExpInStep = this.getStepExp(lStepPart);
        }
        if (lStepExpInStep != null) {
            lHirIterator = this.hirRoot.hir.hirIterator(lStepExpInStep);
            while (lHirIterator.hasNext()) {
                lnode = lHirIterator.next();
                if (!(lnode instanceof VarNode)) continue;
                lStepWithVar = true;
            }
        }
        if (lStepExpInStep != null && !lStepWithVar) {
            lStepConst = lStepExpInStep.evaluate();
            lStepExpInStep = this.hirRoot.hir.constNode(lStepConst);
        }
        if ((lStepExpInBody = this.getStepExp(((LabeledStmt)lBodyPart).getStmt())) != null) {
            lHirIterator = this.hirRoot.hir.hirIterator(lStepExpInBody);
            while (lHirIterator.hasNext()) {
                lnode = lHirIterator.next();
                if (!(lnode instanceof VarNode)) continue;
                lStepWithVar = true;
            }
        }
        this.getDebug().print(4, "expandLoop", "StepExp is generated " + lnode);
        BlockStmt lNewBody = this.hirRoot.hir.blockStmt(null);
        if (lStepExpInBody != null || lStepWithVar) {
            Type lAddExpType = this.typeForArithmeticExp(this.fLoopVar.getSymType());
            for (int i = 0; i < this.getExpRate(); ++i) {
                lBodyCopy = (Stmt)lBodyPart.copyWithOperandsChangingLabels(null);
                for (lStmt = ((BlockStmt)((LabeledStmt)lBodyCopy).getStmt()).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                    Stmt lStmtNext = lStmt.getNextStmt();
                    if (lStmt instanceof LabeledStmt && ((LabeledStmt)lStmt).getStmt() == null) continue;
                    lNewBody.addLastStmt(lStmt);
                }
                if (lStepExpInStep == null) continue;
                lExp = this.integralPromotion(38, this.hirRoot.hir.varNode(this.fLoopVar), (Exp)lStepExpInStep.copyWithOperands());
                lStmt = this.makeAssignStmt(this.fLoopVar, (Exp)lExp.copyWithOperands());
                lNewBody.addLastStmt(lStmt);
                if (this.fDbgLevel <= 0) continue;
                this.getDebug().print(4, "expandLoop", "Add step stmt " + lStmt.toStringWithChildren() + " to loop body");
            }
        } else {
            BlockStmt lMerged = this.hirRoot.hir.blockStmt(null);
            boolean lmergeable = true;
            Stmt lLoopBodyPart2 = pForStmt.getLoopBodyPart();
            if (lLoopBodyPart2 instanceof LabeledStmt) {
                lLoopBodyPart2 = ((LabeledStmt)lLoopBodyPart2).getStmt();
            }
            lHirIterator = this.hirRoot.hir.hirIterator(lLoopBodyPart2);
            while (lHirIterator.hasNextStmt()) {
                lnode = lHirIterator.getNextStmt();
                if (!lmergeable || !(lnode instanceof JumpStmt)) continue;
                lmergeable = false;
            }
            if (lmergeable) {
                this.pickUpVariables(this.hirRoot.hir.forStmt(null, pForStmt.getLoopStartCondition(), lBodyPart, lStepPart));
                HashSet lMergeableVarSet = new HashSet(this.fIncrementalVarSet);
                lMergeableVarSet.removeAll(this.fNotIncrementalVarSet);
                lMergeableVarSet.removeAll(this.fBadVarSet);
                lMergeableVarSet.removeAll(this.fUsedVarSet);
                lHirIterator = this.hirRoot.hir.hirIterator(((LabeledStmt)lBodyPart).getStmt());
                block9: while (lHirIterator.hasNextStmt()) {
                    Var lAssignedVar;
                    lStmt = lHirIterator.getNextStmt();
                    if (!(lStmt instanceof AssignStmt) || !lMergeableVarSet.contains(lAssignedVar = this.getSimpleExp(((AssignStmt)lStmt).getLeftSide()).getVar())) continue;
                    HirIterator lHirIterator2 = this.hirRoot.hir.hirIterator(((AssignStmt)lStmt).getRightSide());
                    while (lHirIterator2.hasNext()) {
                        lnode = lHirIterator2.next();
                        if (!(lnode instanceof VarNode) || ((VarNode)lnode).getVar() == lAssignedVar || ((VarNode)lnode).getVar() == this.fLoopVar || !this.fIncrementalVarSet.contains(((VarNode)lnode).getVar()) && !this.fNotIncrementalVarSet.contains(((VarNode)lnode).getVar())) continue;
                        lMergeableVarSet.remove(lAssignedVar);
                        continue block9;
                    }
                }
                if (this.fDbgLevel > 0) {
                    this.getDebug().print(4, "expandLoop", "Mergeable variables are picked up " + lMergeableVarSet);
                }
                lHirIterator = this.hirRoot.hir.hirIterator(((LabeledStmt)lBodyPart).getStmt());
                while (lHirIterator.hasNextStmt()) {
                    lStmt = lHirIterator.getNextStmt();
                    if (!(lStmt instanceof AssignStmt) || !lMergeableVarSet.contains((lExp = this.getSimpleExp(((AssignStmt)lStmt).getLeftSide())).getVar())) continue;
                    lStmt2 = this.mergeAssignStmt(lStmt, lStepConst);
                    lMerged.addLastStmt((Stmt)lStmt2.copyWithOperandsChangingLabels(null));
                    lStmt.deleteThisStmt();
                }
            }
            for (int i = 0; i < this.getExpRate(); ++i) {
                if (this.fDbgLevel > 0) {
                    this.getDebug().print(4, "expandLoop", "Expand loop body (" + i + "-th)");
                }
                lBodyCopy = (Stmt)lBodyPart.copyWithOperandsChangingLabels(null);
                if (i != 0) {
                    lHirIterator = this.hirRoot.hir.hirIterator(((LabeledStmt)lBodyCopy).getStmt());
                    while (lHirIterator.hasNext()) {
                        lnode = lHirIterator.next();
                        if (!(lnode instanceof VarNode) || ((VarNode)lnode).getVar() != this.fLoopVar) continue;
                        lConst = lStepConst.getSymType().isInteger() ? this.symRoot.sym.intConst(lStepConst.intValue() * i, this.typeForArithmeticExp(lStepConst.getSymType())) : this.symRoot.sym.floatConst(lStepConst.doubleValue() * (double)i, this.symRoot.typeDouble);
                        lExp = this.hirRoot.hir.constNode(lConst);
                        lExp = this.integralPromotion(38, this.hirRoot.hir.varNode(this.fLoopVar), lExp);
                        this.replaceExpAdjustingType((Exp)lnode, lExp);
                        if (this.fDbgLevel <= 0) continue;
                        this.getDebug().print(4, "expandLoop", "Loop var is replaced by " + lExp.toStringWithChildren());
                    }
                }
                for (lStmt = ((BlockStmt)((LabeledStmt)lBodyCopy).getStmt()).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                    if (lStmt instanceof LabeledStmt && ((LabeledStmt)lStmt).getStmt() == null) continue;
                    lNewBody.addLastStmt((Stmt)lStmt.copyWithOperandsChangingLabels(null));
                }
            }
            for (lStmt = lMerged.getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                lNewBody.addLastStmt((Stmt)lStmt.copyWithOperandsChangingLabels(null));
            }
        }
        this.getDebug().print(4, "expandLoop", "New body part is generated");
        if (!(pForStmt.getParent() instanceof BlockStmt)) {
            lStmt = this.hirRoot.hir.blockStmt((Stmt)pForStmt.copyWithOperands());
            pForStmt.replaceThisNode(lStmt);
            pForStmt = (ForStmt)((BlockStmt)lStmt).getFirstStmt();
        }
        if (pForStmt.getLoopInitPart() != null) {
            lStmt = pForStmt.getLoopInitPart();
            if (lStmt instanceof BlockStmt) {
                lStmt = ((BlockStmt)lStmt).getFirstStmt();
            }
            while (lStmt != null) {
                pForStmt.insertPreviousStmt((Stmt)lStmt.copyWithOperandsChangingLabels(null), (BlockStmt)pForStmt.getParent());
                lStmt = lStmt.getNextStmt();
            }
        }
        lExp = lStepExpInBody != null ? (lStepExpInStep != null ? this.integralPromotion(38, (Exp)lStepExpInBody.copyWithOperands(), (Exp)lStepExpInStep.copyWithOperands()) : (Exp)lStepExpInBody.copyWithOperands()) : (Exp)lStepExpInStep.copyWithOperands();
        Var lStepTimes7 = this.symRoot.symTableCurrentSubp.generateVar(lExp.getType(), this.fLoopVar.getDefinedIn());
        lConst = lExp.getType().isInteger() ? this.symRoot.sym.intConst(this.getExpRate() - 1, lExp.getType()) : this.symRoot.sym.floatConst(this.getExpRate() - 1, lExp.getType());
        lExp = this.integralPromotion(41, lExp, this.hirRoot.hir.constNode(lConst));
        lStmt = this.makeAssignStmt(lStepTimes7, lExp);
        if (this.fDbgLevel > 0) {
            this.getDebug().print(4, "expandLoop", "Insert " + lStmt.toStringWithChildren());
        }
        pForStmt.insertPreviousStmt(lStmt, (BlockStmt)pForStmt.getParent());
        Exp lStartCondcopy = (Exp)pForStmt.getLoopStartCondition().copyWithOperandsChangingLabels(null);
        lExp = (Exp)lStartCondcopy.getChild(3 - this.fChildNumofLoopVarinCond);
        VarNode lExp2 = this.hirRoot.hir.varNode(lStepTimes7);
        Type lExpType = lExp.getType();
        Exp lStartCondOperand = this.integralPromotion(39, (Exp)lExp.copyWithOperands(), lExp2);
        lnode = this.replaceExpAdjustingType(lExp, lStartCondOperand);
        this.getDebug().print(4, "expandLoop", "Start condition part is converted to " + lnode.toStringWithChildren());
        BlockStmt lNewStep = null;
        if (lStepExpInBody == null && !lStepWithVar) {
            Var lStepTimes8 = this.symRoot.symTableCurrentSubp.generateVar(lStepExpInStep.getType(), this.fLoopVar.getDefinedIn());
            lConst = lStepExpInStep.getType().isInteger() ? this.symRoot.sym.intConst(this.getExpRate(), this.typeForArithmeticExp(lStepExpInStep.getType())) : this.symRoot.sym.floatConst(this.getExpRate(), lStepExpInStep.getType());
            lExp = this.integralPromotion(41, (Exp)lStepExpInStep.copyWithOperands(), this.hirRoot.hir.constNode(lConst));
            lStmt = this.makeAssignStmt(lStepTimes8, lExp);
            pForStmt.insertPreviousStmt(lStmt, (BlockStmt)pForStmt.getParent());
            lExp = this.hirRoot.hir.varNode(lStepTimes8);
            lExp = this.integralPromotion(38, this.hirRoot.hir.varNode(this.fLoopVar), lExp);
            lStmt = this.makeAssignStmt(this.fLoopVar, lExp);
            lNewStep = this.hirRoot.hir.blockStmt(lStmt);
            if (this.fDbgLevel > 0) {
                this.getDebug().print(4, "expandLoop", "Change step part to " + lNewStep.toStringWithChildren());
            }
        }
        lStmt = this.hirRoot.hir.forStmt(null, lStartCondcopy, lNewBody, lNewStep);
        if (this.isSIMD()) {
            Var lVar;
            Vector<Var> lPointerList = new Vector<Var>();
            int lPointerCount = 0;
            lHirIterator = this.hirRoot.hir.hirIterator(((ForStmt)lStmt).getLoopBodyPart());
            while (lHirIterator.hasNext()) {
                lnode = lHirIterator.next();
                if (!(lnode instanceof VarNode) || (lVar = ((VarNode)lnode).getVar()).getSymType().getTypeKind() != 22 || lPointerList.contains(lVar)) continue;
                lPointerList.add(lVar);
                ++lPointerCount;
            }
            if (((ForStmt)lStmt).getLoopStepPart() != null) {
                lHirIterator = this.hirRoot.hir.hirIterator(((ForStmt)lStmt).getLoopStepPart());
                while (lHirIterator.hasNext()) {
                    lnode = lHirIterator.next();
                    if (!(lnode instanceof VarNode) || (lVar = ((VarNode)lnode).getVar()).getSymType().getTypeKind() != 22 || lPointerList.contains(lVar)) continue;
                    lPointerList.add(lVar);
                    ++lPointerCount;
                }
            }
            for (int i = 0; i < lPointerCount; ++i) {
                for (int j = i + 1; j < lPointerCount; ++j) {
                    lVar = (Var)lPointerList.get(i);
                    Var lVar2 = (Var)lPointerList.get(j);
                    Exp lPtrAdd = this.makePointerAddExp(lVar, this.getExpRate());
                    Exp lCmpExp = this.hirRoot.hir.exp(56, lPtrAdd, this.hirRoot.hir.varNode(lVar2));
                    lStmt = this.hirRoot.hir.ifStmt(lCmpExp, lStmt, null);
                    lPtrAdd = this.makePointerAddExp(lVar2, this.getExpRate());
                    lCmpExp = this.hirRoot.hir.exp(56, lPtrAdd, this.hirRoot.hir.varNode(lVar));
                    lStmt = this.hirRoot.hir.ifStmt(lCmpExp, lStmt, null);
                }
            }
        }
        pForStmt.insertPreviousStmt(lStmt, (BlockStmt)pForStmt.getParent());
        Stmt lStepCopy = null;
        lStartCondcopy = (Exp)pForStmt.getLoopStartCondition().copyWithOperandsChangingLabels(null);
        lBodyCopy = (Stmt)pForStmt.getLoopBodyPart().copyWithOperandsChangingLabels(null);
        if (pForStmt.getLoopStepPart() != null) {
            lStepCopy = (Stmt)pForStmt.getLoopStepPart().copyWithOperandsChangingLabels(null);
        }
        lStmt = this.hirRoot.hir.forStmt(null, lStartCondcopy, lBodyCopy, lStepCopy);
        pForStmt.replaceThisStmtWith(lStmt);
        this.getDebug().print(3, "expandLoop", "Loop is Expanded");
    }

    private Exp makePointerAddExp(Var pPtrVar, int pAddValue) {
        IntConst lRateConst = this.symRoot.sym.intConst(pAddValue, this.symRoot.typeInt);
        ConstNode lRateConstNode = this.hirRoot.hir.constNode(lRateConst);
        Exp lConvOffsetExp = this.hirRoot.hir.convExp(this.symRoot.typeOffset, lRateConstNode);
        long lSizeValue = pPtrVar.getSymType().getSizeValue();
        IntConst lOffsetConst = this.symRoot.sym.intConst(lSizeValue, this.symRoot.typeOffset);
        ConstNode lOffsetConstNode = this.hirRoot.hir.constNode(lOffsetConst);
        Exp lMultExp = this.hirRoot.hir.exp(41, lOffsetConstNode, lConvOffsetExp);
        VarNode lVarNode = this.hirRoot.hir.varNode(pPtrVar);
        return this.hirRoot.hir.exp(38, lVarNode, lMultExp);
    }

    protected Exp getStepExp(Stmt pStmt) {
        HIR lStepExp = null;
        HirIterator lHirIterator = this.hirRoot.hir.hirIterator(pStmt);
        block0: while (lHirIterator.hasNextStmt()) {
            Stmt lStmt = lHirIterator.getNextStmt();
            if (!(lStmt instanceof AssignStmt) || this.getSimpleExp(((AssignStmt)lStmt).getLeftSide()).getVar() != this.fLoopVar) continue;
            Exp lStepExpCopy = (Exp)((AssignStmt)lStmt).getRightSide().copyWithOperands();
            HirIterator lHirIterator2 = this.hirRoot.hir.hirIterator(lStepExpCopy);
            while (lHirIterator2.hasNext()) {
                HIR lnode = lHirIterator2.next();
                if (!(lnode instanceof VarNode) || ((VarNode)lnode).getVar() != this.fLoopVar) continue;
                if (lStepExp == null) {
                    while (lnode.getParent().getOperator() == 65) {
                        lnode = (HIR)lnode.getParent();
                    }
                    Exp lExp = (Exp)lnode.getParent();
                    Exp lExp2 = (Exp)((Exp)lExp.getChild(3 - lnode.getChildNumber())).copyWithOperands();
                    if (lExp.getOperator() == 39) {
                        lExp2 = this.integralPromotion(63, lExp2);
                    }
                    if (lExp.getParent() == null) {
                        lStepExpCopy = lExp2;
                    } else {
                        this.replaceExpAdjustingType(lExp, lExp2);
                    }
                } else {
                    this.replaceExpAdjustingType((Exp)lnode, (Exp)lStepExp);
                }
                lStepExp = lStepExpCopy;
                continue block0;
            }
        }
        if (this.fDbgLevel > 0 && lStepExp != null) {
            this.getDebug().print(4, "getStepExp", lStepExp.toStringWithChildren());
        }
        return lStepExp;
    }

    protected Stmt mergeAssignStmt(Stmt pStmt, Const pStepConst) {
        String lMethodName = "mergeAssignStmt";
        Stmt lStmt = (Stmt)pStmt.copyWithOperandsChangingLabels(null);
        Var lVar = this.getSimpleExp(((AssignStmt)lStmt).getLeftSide()).getVar();
        this.getDebug().print(4, "mergeAssignStmt", "Start process. Left side var " + lVar.getName());
        Type lAddExpType = this.typeForArithmeticExp(this.fLoopVar.getSymType());
        Exp lRightSide = null;
        for (int i = 0; i < this.getExpRate(); ++i) {
            Exp lRightSideCopy = (Exp)this.getSimpleExp(((AssignStmt)lStmt).getRightSide()).copyWithOperands();
            if (lRightSide != null) {
                if (this.fDbgLevel > 0) {
                    this.getDebug().print(4, "mergeAssignStmt", " right side " + lRightSide.toStringWithChildren());
                }
                ArrayList<HIR> lListOfOld = new ArrayList<HIR>();
                ArrayList<HIR> lListOfNew = new ArrayList<HIR>();
                HirIterator lHirIterator = this.hirRoot.hir.hirIterator(lRightSideCopy);
                while (lHirIterator.hasNext()) {
                    HIR lnode = lHirIterator.next();
                    if (!(lnode instanceof VarNode)) continue;
                    if (((VarNode)lnode).getVar() == lVar) {
                        while (lnode.getParent().getOperator() == 65) {
                            lnode = (HIR)lnode.getParent();
                        }
                        lListOfOld.add(lnode);
                        lListOfNew.add(lRightSide.copyWithOperands());
                        continue;
                    }
                    if (((VarNode)lnode).getVar() != this.fLoopVar) continue;
                    Const lConst = pStepConst.getSymType().isInteger() ? this.symRoot.sym.intConst(pStepConst.intValue() * i, this.typeForArithmeticExp(pStepConst.getSymType())) : this.symRoot.sym.floatConst(pStepConst.doubleValue() * (double)i, this.symRoot.typeDouble);
                    Exp lExp = this.hirRoot.hir.constNode(lConst);
                    lExp = this.integralPromotion(38, this.hirRoot.hir.varNode(this.fLoopVar), lExp);
                    if (lnode.getParent() == null) {
                        lRightSideCopy = lExp;
                        continue;
                    }
                    lListOfOld.add(lnode);
                    lListOfNew.add(lExp.copyWithOperands());
                }
                Iterator lIter1 = lListOfNew.iterator();
                for (HIR lOld : lListOfOld) {
                    Exp lNew = (Exp)lIter1.next();
                    this.replaceExpAdjustingType((Exp)lOld, lNew);
                }
            }
            lRightSide = lRightSideCopy;
        }
        lStmt = this.makeAssignStmt(lVar, lRightSide);
        if (this.fDbgLevel > 0) {
            this.getDebug().print(4, "mergeAssignStmt", "result " + lStmt.toStringWithChildren());
        }
        return lStmt;
    }

    protected boolean isBadElement(HIR hirElement) {
        String lMethodName = "isBadElement";
        if (super.isBadElement(hirElement)) {
            return true;
        }
        if (hirElement instanceof JumpStmt) {
            this.getDebug().print(3, "isBadElement", "Jump statement is found.");
            return true;
        }
        return false;
    }

    private void CheckBadSubscript(HIR pHir, Set pAssignedVarSet, Set pBadVarSet) {
        HirIterator lHirIterator = this.hirRoot.hir.hirIterator(pHir);
        while (lHirIterator.hasNext()) {
            Var lVar;
            HIR lnode = lHirIterator.next();
            if (!(lnode instanceof SubscriptedExp) || (lVar = this.getSimpleExp(((SubscriptedExp)lnode).getArrayExp()).getVar()) == null) continue;
            HirIterator lHirIterator2 = this.hirRoot.hir.hirIterator(((SubscriptedExp)lnode).getSubscriptExp());
            while (lHirIterator2.hasNext()) {
                HIR lnode2 = lHirIterator2.next();
                if (!(lnode2 instanceof VarNode) || !pAssignedVarSet.contains(((VarNode)lnode2).getVar()) && !pBadVarSet.contains(((VarNode)lnode2).getVar())) continue;
                pBadVarSet.add(lVar);
            }
        }
    }

    protected int computeExpansionFactor(LoopStmt pLoopStmt) {
        int lNextStmtIndex = 0;
        Stmt lLoopBody = pLoopStmt.getLoopBodyPart();
        if (lLoopBody == null || lLoopBody.getIndex() == 0) {
            return 0;
        }
        int lStartNodeIndex = lLoopBody.getIndex();
        Exp lEndCondition = pLoopStmt.getLoopEndCondition();
        if (lEndCondition != null && lEndCondition.getIndex() > 0) {
            lNextStmtIndex = lEndCondition.getIndex();
        } else {
            Stmt lStepPart = pLoopStmt.getLoopStepPart();
            if (lStepPart != null && lStepPart.getIndex() > 0) {
                lNextStmtIndex = lStepPart.getIndex();
            } else {
                LabeledStmt lEndPart = pLoopStmt.getLoopEndPart();
                lNextStmtIndex = lEndPart.getIndex();
            }
        }
        int lNodeCount = lNextStmtIndex - lStartNodeIndex;
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgOpt1.print(4, "computeExpansionFactor " + pLoopStmt.toStringShort() + " node count of loop body " + lNodeCount);
        }
        if (lNodeCount > this.fNodeCountMultipliedByExpFactor / 2) {
            return 0;
        }
        int lExpansionFactor = this.fNodeCountMultipliedByExpFactor / lNodeCount;
        if (lExpansionFactor > this.fUpperLimitOfExpansionFactor) {
            lExpansionFactor = this.fUpperLimitOfExpansionFactor;
        }
        if (this.isSIMD()) {
            // empty if block
        }
        return lExpansionFactor;
    }

    protected Exp integralPromotion(int pOperator, Exp pOperand1, Exp pOperand2) {
        Exp lExp2;
        Exp lExp1;
        Type lType1 = pOperand1.getType();
        Type lType2 = pOperand2.getType();
        Type lExpType = lType1;
        if (lType2.getTypeRank() > lExpType.getTypeRank()) {
            lExpType = lType2;
        }
        if (lExpType.getTypeRank() < this.symRoot.typeInt.getTypeRank()) {
            lExpType = this.symRoot.typeInt;
        }
        if ((lExp1 = pOperand1).getType() != lExpType) {
            lExp1 = this.hirRoot.hir.convExp(lExpType, (Exp)lExp1.copyWithOperands());
        }
        if ((lExp2 = pOperand2).getType() != lExpType) {
            lExp2 = this.hirRoot.hir.convExp(lExpType, (Exp)lExp2.copyWithOperands());
        }
        return this.hirRoot.hir.exp(pOperator, lExp1, lExp2);
    }

    protected Exp integralPromotion(int pOperator, Exp pOperand1) {
        Exp lExp1;
        Type lExpType = pOperand1.getType();
        if (lExpType.getTypeRank() < this.symRoot.typeInt.getTypeRank()) {
            lExpType = this.symRoot.typeInt;
        }
        if ((lExp1 = pOperand1).getType() != lExpType) {
            lExp1 = this.hirRoot.hir.convExp(lExpType, (Exp)lExp1.copyWithOperands());
        }
        return this.hirRoot.hir.exp(pOperator, lExp1);
    }

    protected AssignStmt makeAssignStmt(Var pVariable, Exp pExp) {
        Type lType = pVariable.getSymType();
        Exp lExp = pExp;
        if (pExp.getType() != lType) {
            lExp = this.hirRoot.hir.convExp(lType, lExp);
        }
        return this.hirRoot.hir.assignStmt(this.hirRoot.hir.varNode(pVariable), lExp);
    }

    protected Type typeForArithmeticExp(Type pType) {
        Type lType = pType;
        if (lType.getTypeRank() < this.symRoot.typeInt.getTypeRank()) {
            lType = this.symRoot.typeInt;
        }
        return lType;
    }

    protected HIR replaceExpAdjustingType(Exp lOld, Exp lNew) {
        Exp lExp = lNew;
        if (lOld.getType() != lNew.getType()) {
            lExp = this.hirRoot.hir.convExp(lOld.getType(), lNew);
        }
        Exp lNewExp = (Exp)lOld.replaceThisNode(lExp);
        return lNewExp;
    }
}

