/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.driver.CoinsOptions;
import coins.ir.IrList;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirList;
import coins.ir.hir.InfStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Program;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubscriptedExp;
import coins.ir.hir.SymNode;
import coins.ir.hir.VarNode;
import coins.sym.Param;
import coins.sym.PointerType;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class GlobalReform {
    protected HirRoot hirRoot;
    protected SymRoot symRoot;
    protected IoRoot ioRoot;
    protected Map fOptionMap;
    protected CoinsOptions fCoinsOptions;
    protected List fPatternList;
    protected Map fInPatternMap;
    protected Map fOutPatternMap;
    protected Map fLocalVarListMap;
    protected List fSubpToReform;
    protected Set fStmtParamSet;
    protected Set fNoFurtherChange;
    protected Subp fCurrentPatternSym = null;
    protected boolean[] fUsedAsSubroot;
    protected double[] fPatternCodeUpper;
    protected double[] fPatternCodeLower;
    static double fHirCodeLim = 100.0;
    static double fDontCareCode = 99.0;
    static double fHirCodeLim2 = fHirCodeLim * fHirCodeLim;
    static double fHirCodeLim3 = fHirCodeLim2 * fHirCodeLim;
    static double fHirCodeLim4 = fHirCodeLim3 * fHirCodeLim;
    static double fHirCodeLim5 = fHirCodeLim4 * fHirCodeLim;
    static double fHirCodeLim6 = fHirCodeLim5 * fHirCodeLim;
    protected boolean fChanged;
    protected int fDbgLevel;
    protected HIR hir;

    public GlobalReform(HirRoot pHirRoot) {
        SubpDefinition lSubpDef;
        this.hirRoot = pHirRoot;
        this.symRoot = pHirRoot.symRoot;
        this.ioRoot = pHirRoot.ioRoot;
        this.fDbgLevel = this.ioRoot.dbgOpt1.getLevel();
        this.hir = this.hirRoot.hir;
        this.fCoinsOptions = this.ioRoot.getCompileSpecification().getCoinsOptions();
        String lOptArg = this.fCoinsOptions.getArg("hirOpt");
        this.fOptionMap = this.fCoinsOptions.parseArgument(lOptArg, '/', '.');
        if (this.fDbgLevel > 0) {
            this.dbgOut(1, "\nGlobalReform\n");
            this.dbgOut(2, "\n CoinsOptions " + this.fCoinsOptions);
            this.dbgOut(2, "\n Option map " + this.fOptionMap);
        }
        if (!this.fOptionMap.containsKey("globalReform")) {
            this.dbgOut(2, "no globalReform option is given.\n");
            return;
        }
        ArrayList<Subp> lSubprograms = new ArrayList<Subp>();
        this.fPatternList = new ArrayList();
        this.fInPatternMap = new HashMap();
        this.fOutPatternMap = new HashMap();
        this.fLocalVarListMap = new HashMap();
        this.fSubpToReform = new ArrayList();
        this.fNoFurtherChange = new HashSet();
        Program lProgram = (Program)this.hirRoot.programRoot;
        IrList lSubpList = lProgram.getSubpDefinitionList();
        if (this.fDbgLevel >= 4) {
            this.dbgOut(3, "\nHIR before GlobalReform \n");
            lProgram.print(0);
        }
        ListIterator lIt = lSubpList.iterator();
        while (lIt.hasNext()) {
            lSubpDef = (SubpDefinition)lIt.next();
            lSubprograms.add(lSubpDef.getSubpSym());
        }
        this.dbgOut(3, "Subprograms defined", lSubprograms + "\n");
        HIR lProgInitPart = (HIR)lProgram.getInitiationPart();
        if (lProgInitPart instanceof BlockStmt) {
            for (Stmt lStmt = ((BlockStmt)lProgInitPart).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                Object lSubp;
                ListIterator lIt2;
                int lIndex;
                String lOptionName;
                if (!(lStmt instanceof InfStmt) || ((InfStmt)lStmt).getInfKind() != "globalReform") continue;
                if (this.fDbgLevel > 2) {
                    this.dbgOut(3, lStmt.toStringWithChildren() + "\n");
                }
                IrList lOptionList = ((InfStmt)lStmt).getInfList("globalReform");
                if (this.fDbgLevel > 2) {
                    this.dbgOut(4, " option list " + lOptionList + "\n");
                }
                if ((lOptionName = ((InfStmt)lStmt).getInfSubkindOf("globalReform")) == null) {
                    this.dbgOut(1, "\nUnknown option subkind " + ((InfStmt)lStmt).toStringWithChildren() + "\n");
                    continue;
                }
                if (lOptionName == "SIMDpattern") {
                    lIndex = 0;
                    lIt2 = lOptionList.iterator();
                    while (lIt2.hasNext()) {
                        lSubp = lIt2.next();
                        if (this.fDbgLevel > 1) {
                            this.dbgOut(4, " " + lSubp + " " + lSubp.getClass() + "\n");
                        }
                        if (lSubp instanceof Subp) {
                            this.fPatternList.add(lSubp);
                        }
                        ++lIndex;
                    }
                    continue;
                }
                if (lOptionName == "reformList") {
                    lIndex = 0;
                    lIt2 = lOptionList.iterator();
                    while (lIt2.hasNext()) {
                        lSubp = lIt2.next();
                        if (this.fDbgLevel > 1) {
                            this.dbgOut(4, " " + lSubp + " " + lSubp.getClass() + "\n");
                        }
                        if (lSubp instanceof Subp) {
                            this.fSubpToReform.add(lSubp);
                        }
                        ++lIndex;
                    }
                    continue;
                }
                if (lOptionName == "noFurtherChange") {
                    lIndex = 0;
                    lIt2 = lOptionList.iterator();
                    while (lIt2.hasNext()) {
                        lSubp = lIt2.next();
                        if (this.fDbgLevel > 1) {
                            this.dbgOut(4, " " + lSubp + " " + lSubp.getClass() + "\n");
                        }
                        if (lSubp instanceof Subp) {
                            this.fNoFurtherChange.add(lSubp);
                        }
                        ++lIndex;
                    }
                    continue;
                }
                this.dbgOut(1, "\nUnknown option " + lOptionName + "\n");
            }
        }
        this.dbgOut(1, "List of patterns", this.fPatternList.toString());
        this.dbgOut(1, "Subprograms to be reformed", this.fSubpToReform.toString());
        for (Subp lSubp : this.fPatternList) {
            this.dbgOut(2, "\n Scan pattern " + lSubp.getName());
            lSubpDef = lSubp.getSubpDefinition();
            Stmt lSubpBody = lSubpDef.getHirBody();
            if (lSubpBody instanceof LabeledStmt) {
                lSubpBody = ((LabeledStmt)lSubpBody).getStmt();
            }
            Stmt lInPattern = null;
            Stmt lOutPattern = null;
            this.dbgOut(2, "\n lSubpBody " + lSubpBody.toString());
            if (lSubpBody instanceof BlockStmt) {
                Stmt lStmt = ((BlockStmt)lSubpBody).getFirstStmt();
                while (lStmt != null) {
                    if (this.fDbgLevel > 1) {
                        this.dbgOut(3, "\n lStmt " + lStmt.toStringWithChildren());
                    }
                    if (lStmt instanceof InfStmt && ((InfStmt)lStmt).getInfKind() == "globalReform") {
                        String lOptionName;
                        if (this.fDbgLevel > 1) {
                            this.dbgOut(3, lStmt.toString() + "\n");
                        }
                        IrList lOptionList = ((InfStmt)lStmt).getInfList("globalReform");
                        if (this.fDbgLevel > 1) {
                            this.dbgOut(4, " option list " + lOptionList + "\n");
                        }
                        if ((lOptionName = ((InfStmt)lStmt).getInfSubkindOf("globalReform")) == null) {
                            this.dbgOut(1, "\nUnknown option subkind " + ((InfStmt)lStmt).toString() + "\n");
                            continue;
                        }
                        if (lOptionName == "stmtParam") {
                            int lOptIndex = 0;
                            ListIterator lOptIt = lOptionList.iterator();
                            while (lOptIt.hasNext()) {
                                Object lParam = lOptIt.next();
                                if (this.fDbgLevel > 1) {
                                    this.dbgOut(4, " " + lParam + " " + lParam.getClass() + "\n");
                                }
                                if (lParam instanceof Param) {
                                    this.fStmtParamSet.add(lParam);
                                }
                                ++lOptIndex;
                            }
                        }
                    } else if (lStmt instanceof LabeledStmt && ((LabeledStmt)lStmt).getLabel().getName() == "iPattern") {
                        lInPattern = ((LabeledStmt)lStmt).getStmt();
                        if (lInPattern == null) {
                            lInPattern = lStmt = lStmt.getNextStmt();
                        }
                    } else if (lStmt instanceof LabeledStmt && ((LabeledStmt)lStmt).getLabel().getName() == "oPattern" && (lOutPattern = ((LabeledStmt)lStmt).getStmt()) == null) {
                        lOutPattern = lStmt = lStmt.getNextStmt();
                    }
                    lStmt = lStmt.getNextStmt();
                }
                if (lInPattern == null) {
                    this.ioRoot.msgRecovered.put(5111, "iPattern is not found in " + lSubp.getName());
                }
                if (lOutPattern == null) {
                    this.ioRoot.msgRecovered.put(5111, "oPattern is not found in " + lSubp.getName());
                }
                if (lInPattern == null || lOutPattern == null) continue;
                this.fInPatternMap.put(lSubp, lInPattern);
                this.fOutPatternMap.put(lSubp, lOutPattern);
            }
            ArrayList lLocalVarList = new ArrayList();
            this.checkConsistency(lSubp, lLocalVarList, lInPattern, lOutPattern);
            this.fLocalVarListMap.put(lSubp, lLocalVarList);
        }
        this.dbgOut(2, "InPatternMap", this.fInPatternMap.toString());
        this.dbgOut(2, "OutPatternMap", this.fOutPatternMap.toString());
    }

    public boolean doReform(List pReformPatternList) {
        boolean lChanged = false;
        this.fChanged = false;
        if (this.fSubpToReform.isEmpty() || this.fPatternList.isEmpty()) {
            return lChanged;
        }
        this.dbgOut(2, "\ndoReform");
        this.computePatternCodeRange();
        for (Subp lSubp : this.fSubpToReform) {
            HIR lNewBody;
            SubpDefinition lSubpDef = lSubp.getSubpDefinition();
            if (lSubpDef == null) continue;
            this.dbgOut(2, "Reform", lSubp.getName());
            this.symRoot.subpCurrent = lSubp;
            this.symRoot.symTableCurrentSubp = lSubp.getSymTable();
            Stmt lSubpBody = lSubpDef.getHirBody();
            if (lSubpBody instanceof LabeledStmt) {
                lSubpBody = ((LabeledStmt)lSubpBody).getStmt();
            }
            if ((lNewBody = this.tryToReform(lSubpBody)) == lSubpBody) continue;
            lSubpBody.replaceThisNode(lNewBody);
            lChanged = true;
            this.fChanged = true;
            this.dbgOut(2, "Reform has changed", lSubp.getName());
            if (this.fDbgLevel < 4) continue;
            lSubpDef.printHir("Replaced result");
        }
        pReformPatternList.addAll(this.fPatternList);
        return lChanged;
    }

    protected HIR tryToReform(HIR pHir) {
        boolean lChanged = false;
        HIR lNewHir = pHir;
        if (pHir == null) {
            return null;
        }
        this.dbgOut(2, "tryToReform", pHir.toStringShort());
        int lOpCode = pHir.getOperator();
        if (this.fUsedAsSubroot[lOpCode]) {
            double lPatternCode = this.patternCode(pHir);
            this.dbgOut(2, "pattern code " + lPatternCode);
            for (int lIndex = 0; lIndex < this.fPatternList.size(); ++lIndex) {
                if (this.fDbgLevel > 1) {
                    this.dbgOut(4, " range " + this.fPatternCodeLower[lIndex] + " - " + this.fPatternCodeUpper[lIndex]);
                }
                if (!(lPatternCode >= this.fPatternCodeLower[lIndex]) || !(lPatternCode <= this.fPatternCodeUpper[lIndex])) continue;
                Subp lPatternSym = (Subp)this.fPatternList.get(lIndex);
                HIR lPattern = (HIR)this.fInPatternMap.get(lPatternSym);
                this.fCurrentPatternSym = lPatternSym;
                HashMap lParamCorresp = new HashMap();
                HashMap lArrayCorresp = new HashMap();
                if (!this.isMatchedPattern(lParamCorresp, lArrayCorresp, lPattern, pHir)) continue;
                if (this.fDbgLevel >= 3) {
                    System.out.print("\n Parameter correspondence to " + pHir.toStringShort() + " " + lParamCorresp + " arrayCorresp " + lArrayCorresp);
                }
                if ((lNewHir = this.transformByPatternSym(lParamCorresp, lArrayCorresp, lPatternSym, pHir)) != pHir) {
                    this.fChanged = true;
                }
                return lNewHir;
            }
        } else if (this.fDbgLevel >= 4) {
            this.dbgOut(4, " skip " + pHir.toStringShort());
        }
        if (lOpCode == 35) {
            for (Stmt lStmt = ((BlockStmt)pHir).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                HIR lNewHir2 = this.tryToReform(lStmt);
                if (lNewHir2 == lStmt) continue;
                if (lNewHir2 instanceof Stmt) {
                    lStmt.replaceThisStmtWith((Stmt)lNewHir2);
                    lChanged = true;
                    continue;
                }
                this.ioRoot.msgRecovered.put(5122, "type mismatch in replacing " + lStmt.toStringShort() + " with " + lNewHir2.toStringWithChildren());
            }
        } else if (lOpCode == 14) {
            ListIterator lIt3 = ((HirList)pHir).iterator();
            while (lIt3.hasNext()) {
                HIR lNewHir3;
                HIR lHir3 = (HIR)lIt3.next();
                if (lHir3 == null || (lNewHir3 = this.tryToReform(lHir3)) == lHir3) continue;
                lHir3.replaceThisNode(lNewHir3);
                lChanged = true;
            }
        } else {
            for (int lChildIndex = 1; lChildIndex <= pHir.getChildCount(); ++lChildIndex) {
                HIR lNewHir4;
                HIR lChild = (HIR)pHir.getChild(lChildIndex);
                if (lChild == null || (lNewHir4 = this.tryToReform(lChild)) == lChild) continue;
                lChild.replaceThisNode(lNewHir4);
                lChanged = true;
            }
        }
        if (lChanged) {
            this.fChanged = true;
            return pHir.copyWithOperandsChangingLabels(null);
        }
        return pHir;
    }

    protected boolean isMatchedPattern(Map pParamCorresp, Map pArrayCorresp, HIR pSubPattern, HIR pHir) {
        int lOpCodeH;
        Sym lSym;
        if (pSubPattern == null) {
            return pHir == null;
        }
        if (this.fDbgLevel > 1) {
            this.dbgOut(4, "\n isMatchedPattern " + pSubPattern.toStringShort() + " with " + pHir);
        }
        if (pSubPattern instanceof SymNode && ((lSym = ((SymNode)pSubPattern).getSymNodeSym()) instanceof Param || lSym == this.fCurrentPatternSym)) {
            Sym lParam = lSym;
            if (pParamCorresp.containsKey(lParam)) {
                HIR lHirForParam = (HIR)pParamCorresp.get(lParam);
                if (this.isSameTree(lHirForParam, pHir)) {
                    return true;
                }
                this.ioRoot.msgRecovered.put(5122, "Param " + lParam.getName() + " has different correspondence: " + lHirForParam + " and " + pHir);
                return false;
            }
            if (pHir != null) {
                Type lHirType;
                Type lParamType = lParam.getSymType();
                if (lParamType == (lHirType = pHir.getType()) || lParamType.getOrigin() == lHirType.getOrigin()) {
                    if (lParamType.isConst() && !(pHir instanceof ConstNode)) {
                        this.dbgOut(3, "Const param " + lParam.getName() + " request constant instead of " + pHir.toStringShort());
                    }
                    pParamCorresp.put(lParam, pHir);
                    return true;
                }
                this.dbgOut(2, " Param " + lParam.getName() + " may correspond to " + pHir.toStringShort() + " bat has different type.");
                return false;
            }
            this.dbgOut(3, "Param " + lParam.getName() + " correspomds to null ");
            pParamCorresp.put(lParam, pHir);
        }
        if (pHir == null) {
            return false;
        }
        int lOpCodeP = pSubPattern.getOperator();
        if (lOpCodeP != (lOpCodeH = pHir.getOperator())) {
            if (lOpCodeP == 17 || lOpCodeH == 17 || pSubPattern.getChild1() != null && ((HIR)pSubPattern.getChild1()).getType() instanceof VectorType || pHir.getChild1() != null && ((HIR)pHir.getChild1()).getType() instanceof VectorType || pSubPattern.getType() instanceof PointerType && pHir.getType() instanceof PointerType) {
                return this.isMatchedSubs(pParamCorresp, pArrayCorresp, pSubPattern, pHir);
            }
            if (lOpCodeP == 67 && pHir.getType() instanceof VectorType || lOpCodeH == 67 && pSubPattern.getType() instanceof VectorType) {
                return this.isMatchedArray(pParamCorresp, pArrayCorresp, pSubPattern, pHir);
            }
            return false;
        }
        if (pSubPattern instanceof SymNode) {
            return ((SymNode)pSubPattern).getSym() == ((SymNode)pHir).getSym();
        }
        if (pSubPattern instanceof BlockStmt) {
            Stmt lStmt1 = ((BlockStmt)pSubPattern).getFirstStmt();
            Stmt lStmt2 = ((BlockStmt)pHir).getFirstStmt();
            while (lStmt1 != null) {
                if (!this.isMatchedPattern(pParamCorresp, pArrayCorresp, lStmt1, lStmt2)) {
                    return false;
                }
                lStmt1 = lStmt1.getNextStmt();
                if (lStmt2 == null) {
                    if (this.fDbgLevel > 2) {
                        this.dbgOut(4, "\n Block " + pHir + " is short.");
                    }
                    return false;
                }
                lStmt2 = lStmt2.getNextStmt();
            }
            if (lStmt2 == null) {
                return true;
            }
            if (this.fDbgLevel > 2) {
                this.dbgOut(4, "\n There remains some statement in " + pHir);
            }
            return false;
        }
        if (pSubPattern instanceof HirList) {
            ListIterator lItP = ((HirList)pSubPattern).iterator();
            ListIterator lItH = ((HirList)pHir).iterator();
            while (lItP.hasNext()) {
                HIR lElemP = (HIR)lItP.next();
                HIR lElemH = null;
                if (lItH.hasNext()) {
                    lElemH = (HIR)lItH.next();
                }
                if (this.isMatchedPattern(pParamCorresp, pArrayCorresp, lElemP, lElemH)) continue;
                return false;
            }
            return !lItH.hasNext();
        }
        for (int lChildNum = 1; lChildNum <= pSubPattern.getChildCount(); ++lChildNum) {
            if (this.isMatchedPattern(pParamCorresp, pArrayCorresp, (HIR)pSubPattern.getChild(lChildNum), (HIR)pHir.getChild(lChildNum))) continue;
            return false;
        }
        return true;
    }

    protected boolean isMatchedSubs(Map pParamCorresp, Map pArrayCorresp, HIR pSubPattern, HIR pHir) {
        if (this.fDbgLevel > 1) {
            this.dbgOut(4, "\n  isMatchedSubs " + pSubPattern.toStringShort() + " with " + pHir);
        }
        int lOpCodeP = pSubPattern.getOperator();
        int lOpCodeH = pHir.getOperator();
        HIR lChildP1 = (HIR)pSubPattern.getChild1();
        HIR lChildH1 = (HIR)pHir.getChild1();
        if (lOpCodeP != 17 && lOpCodeH == 17) {
            return lOpCodeP == 68 && lChildP1.getOperator() == 38 && lChildP1.getChild2().getOperator() == 41 && this.isMatchedArray(pParamCorresp, pArrayCorresp, (HIR)lChildP1.getChild1(), lChildH1) && this.isMatchedPattern(pParamCorresp, pArrayCorresp, (HIR)lChildP1.getChild2().getChild2(), (HIR)pHir.getChild2());
        }
        if (lOpCodeP == 17 && lOpCodeH != 17) {
            return lOpCodeH == 68 && lChildH1.getOperator() == 38 && lChildH1.getChild2().getOperator() == 41 && this.isMatchedArray(pParamCorresp, pArrayCorresp, lChildP1, (HIR)lChildH1.getChild1()) && this.isMatchedPattern(pParamCorresp, pArrayCorresp, (HIR)pSubPattern.getChild2(), (HIR)lChildH1.getChild2().getChild2());
        }
        if (lOpCodeP == 17 && lOpCodeH == 17) {
            if (this.isMatchedArray(pParamCorresp, pArrayCorresp, lChildP1, lChildH1) && this.isMatchedPattern(pParamCorresp, pArrayCorresp, (HIR)pSubPattern.getChild2(), (HIR)lChildH1.getChild2())) {
                return true;
            }
        } else if (pSubPattern.getType() instanceof PointerType && pHir.getType() instanceof PointerType) {
            if (lOpCodeP == 66 || lOpCodeP == 64) {
                return this.isMatchedArray(pParamCorresp, pArrayCorresp, (HIR)pSubPattern.getChild1(), pHir);
            }
            if (lOpCodeH == 66 || lOpCodeH == 64) {
                return this.isMatchedArray(pParamCorresp, pArrayCorresp, pSubPattern, (HIR)pHir.getChild1());
            }
        }
        return false;
    }

    protected boolean isMatchedArray(Map pParamCorresp, Map pArrayCorresp, HIR pSubPattern, HIR pHir) {
        if (this.fDbgLevel > 1) {
            this.dbgOut(4, "\n  isMatchedArray " + pSubPattern.toStringShort() + " " + pHir.toStringShort());
        }
        int lOpCodeP = pSubPattern.getOperator();
        int lOpCodeH = pHir.getOperator();
        Type lTypeP = pSubPattern.getType();
        Type lTypeH = pHir.getType();
        if (pSubPattern instanceof SymNode && ((SymNode)pSubPattern).getSymNodeSym() instanceof Param) {
            Sym lParamSym = ((SymNode)pSubPattern).getSymNodeSym();
            if (!(lTypeP instanceof VectorType) && !(lTypeP instanceof PointerType)) {
                this.ioRoot.msgRecovered.put(5212, "Illegal array type for " + lParamSym.getName() + " in " + pSubPattern.toStringShort() + " " + lTypeP.toStringShort());
                return false;
            }
            if (pArrayCorresp.containsKey(lParamSym)) {
                HIR lPrevHir = (HIR)pArrayCorresp.get(lParamSym);
                if (this.isSameTree(lPrevHir, pHir)) {
                    return true;
                }
                this.ioRoot.msgRecovered.put(5212, "Parameter " + lParamSym.getName() + " in " + pSubPattern.toStringShort() + " has different correspondence " + lPrevHir.toStringShort() + " " + pHir.toStringWithChildren());
                return false;
            }
            pArrayCorresp.put(((SymNode)pSubPattern).getSymNodeSym(), pHir);
            return true;
        }
        if (lTypeP instanceof PointerType && lTypeH instanceof PointerType) {
            if (lOpCodeP == 66 || lOpCodeP == 64) {
                return this.isMatchedArray(pParamCorresp, pArrayCorresp, (HIR)pSubPattern.getChild1(), pHir);
            }
            if (lOpCodeH == 66 || lOpCodeH == 64) {
                return this.isMatchedArray(pParamCorresp, pArrayCorresp, pSubPattern, (HIR)pHir.getChild1());
            }
            if (((PointerType)lTypeP).getPointedType() != ((PointerType)lTypeH).getPointedType()) {
                this.dbgOut(4, "Array type mismatch " + pSubPattern.toStringShort() + " " + lTypeP.toStringShort() + pHir.toStringShort() + " " + lTypeH.toStringShort());
                return false;
            }
            return true;
        }
        if (lTypeP instanceof VectorType && lTypeH instanceof VectorType) {
            if (lOpCodeP == 67) {
                return this.isMatchedArray(pParamCorresp, pArrayCorresp, (HIR)pSubPattern.getChild1(), pHir);
            }
            if (((VectorType)lTypeP).getElemType() != ((VectorType)lTypeH).getElemType()) {
                this.dbgOut(3, "Element type mismatch " + pSubPattern.toStringShort() + " " + lTypeP.toStringShort() + pHir.toStringShort() + " " + lTypeH.toStringShort());
                return false;
            }
            return true;
        }
        if (lTypeP instanceof PointerType && lTypeH instanceof VectorType) {
            if (lOpCodeP == 66 || lOpCodeP == 64) {
                return this.isMatchedArray(pParamCorresp, pArrayCorresp, (HIR)pSubPattern.getChild1(), pHir);
            }
            if (lOpCodeH == 67) {
                return this.isMatchedArray(pParamCorresp, pArrayCorresp, pSubPattern, (HIR)pHir.getChild1());
            }
            return ((VectorType)lTypeH).getElemType() == ((PointerType)lTypeP).getPointedType();
        }
        if (lTypeP instanceof VectorType && lTypeH instanceof PointerType) {
            if (lOpCodeP == 67) {
                return this.isMatchedArray(pParamCorresp, pArrayCorresp, (HIR)pSubPattern.getChild1(), pHir);
            }
            if (lOpCodeH == 66 || lOpCodeH == 64) {
                return this.isMatchedArray(pParamCorresp, pArrayCorresp, pSubPattern, (HIR)pHir.getChild1());
            }
            return ((VectorType)lTypeP).getElemType() == ((PointerType)lTypeH).getPointedType();
        }
        for (int lChildNum = 1; lChildNum <= pSubPattern.getChildCount(); ++lChildNum) {
            if (this.isMatchedPattern(pParamCorresp, pArrayCorresp, (HIR)pSubPattern.getChild(lChildNum), (HIR)pHir.getChild(lChildNum))) continue;
            return false;
        }
        return true;
    }

    protected HIR transformByPatternSym(Map pParamCorresp, Map pArrayCorresp, Subp pPatternSym, HIR pInHir) {
        if (pPatternSym == null || pInHir == null) {
            return pInHir;
        }
        HIR lInPattern = (HIR)this.fInPatternMap.get(pPatternSym);
        if (lInPattern == null) {
            this.dbgOut(1, "Undefined pattern " + pPatternSym.getName() + " for " + pInHir.toStringShort());
            return pInHir;
        }
        if (this.fDbgLevel > 1) {
            this.dbgOut(3, "transformByPatternSym", pInHir.toStringShort() + " by " + lInPattern.toStringShort());
        }
        this.fCurrentPatternSym = pPatternSym;
        List lLocalVarList = (List)this.fLocalVarListMap.get(pPatternSym);
        for (Var lVar : lLocalVarList) {
            if (this.symRoot.symTableCurrentSubp.search(lVar.getName().intern()) != null) continue;
            Var lTempVar = this.symRoot.symTableCurrentSubp.generateVar(lVar.getSymType());
            pParamCorresp.put(lVar, lTempVar);
            if (this.fDbgLevel <= 0) continue;
            this.dbgOut(2, " map " + lVar.getName() + " to " + lTempVar.getName());
        }
        HIR lOutPattern = (HIR)this.fOutPatternMap.get(pPatternSym);
        HIR lOutHir = lOutPattern.copyWithOperands();
        lOutHir = this.transform(pParamCorresp, pArrayCorresp, lOutPattern);
        if (this.fNoFurtherChange.contains(this.fCurrentPatternSym)) {
            lOutHir.setFlag(1, true);
        }
        return lOutHir;
    }

    protected HIR transform(Map pParamCorresp, Map pArrayCorresp, HIR pOutHir) {
        if (pOutHir == null) {
            return pOutHir;
        }
        this.dbgOut(3, "transform", pOutHir.toStringWithChildren());
        HIR lOutHir = pOutHir.copyWithOperandsChangingLabels(null);
        HirIterator lHirIt = lOutHir.hirIterator(lOutHir);
        while (lHirIt.hasNext()) {
            Var lTempVar;
            HIR lNode = lHirIt.next();
            if (this.fDbgLevel > 2) {
                this.dbgOut(5, "\n  " + lNode);
            }
            if (lNode == null) continue;
            boolean lNoParent = false;
            if (lNode.getParent() == null) {
                lNoParent = true;
            }
            if (!(lNode instanceof SymNode)) continue;
            HIR lReplica = null;
            Sym lSym = ((SymNode)lNode).getSymNodeSym();
            if (lSym instanceof Param) {
                if (pParamCorresp.containsKey(lSym) && pParamCorresp.get(lSym) != null) {
                    if (this.fDbgLevel > 2) {
                        this.dbgOut(5, "\n replace by " + pParamCorresp.get(lSym));
                    }
                    if ((lReplica = ((HIR)pParamCorresp.get(lSym)).copyWithOperandsChangingLabels(null)) instanceof Stmt && this.fStmtParamSet.contains(lSym)) {
                        lReplica = ((Stmt)lNode).replaceThisStmtWith((Stmt)lReplica);
                        if (!lNoParent) continue;
                        return lReplica;
                    }
                    if (lReplica instanceof Exp) {
                        lReplica = this.replaceExpAdjustingType((Exp)lNode, (Exp)lReplica);
                        if (!lNoParent) continue;
                        return lReplica;
                    }
                    if (lReplica == null) {
                        if (lNode instanceof Stmt) {
                            ((Stmt)lNode).deleteThisStmt();
                            continue;
                        }
                        lNode.replaceThisNode(null);
                        continue;
                    }
                    this.ioRoot.msgRecovered.put(5122, "Irregal replacement of " + ((Object)lNode).toString() + " with " + lReplica.toStringWithChildren());
                    continue;
                }
                if (pArrayCorresp.containsKey(lSym) && pArrayCorresp.get(lSym) != null) {
                    if (this.fDbgLevel > 2) {
                        this.dbgOut(5, "\n replace array elem " + lSym.getName() + " " + pArrayCorresp.get(lSym));
                    }
                    HIR lParent = (HIR)lNode.getParent();
                    HIR lNewNode = (HIR)pArrayCorresp.get(lSym);
                    int lOpCodeP = lParent.getOperator();
                    int lOpCodeN = lNewNode.getOperator();
                    if (lOpCodeP == 38 && lParent.getParent() != null && lParent.getParent().getOperator() == 68 && lParent.getChild2().getOperator() == 41) {
                        HIR lSubscript;
                        if (lNewNode instanceof VarNode && (lNewNode.getParent() == null || lNewNode.getParent().getOperator() == 17) && lNewNode.getType() instanceof VectorType) {
                            lSubscript = this.transform(pParamCorresp, pArrayCorresp, (HIR)lParent.getChild2().getChild2());
                            SubscriptedExp lArrayElem = this.hir.subscriptedExp((Exp)lNewNode.copyWithOperands(), (Exp)lSubscript);
                            this.replaceExpAdjustingType((Exp)lParent.getParent(), lArrayElem);
                            continue;
                        }
                        if (lNewNode instanceof VarNode && lNewNode.getParent() != null && lNewNode.getParent().getOperator() == 38 && lNewNode.getParent().getParent() != null && lNewNode.getParent().getParent().getOperator() == 68 && lNewNode.getParent().getChild2().getOperator() == 41) {
                            lSubscript = (Exp)this.transform(pParamCorresp, pArrayCorresp, (HIR)lNewNode.getParent().getChild2().getChild2());
                            Exp lElemSize = (Exp)this.transform(pParamCorresp, pArrayCorresp, (HIR)lNewNode.getParent().getChild2().getChild1());
                            Exp lOffset = this.hir.exp(41, lElemSize, (Exp)lSubscript);
                            lReplica = this.hir.exp(68, this.hir.exp(38, (Exp)lNewNode.copyWithOperands(), lOffset));
                            this.replaceExpAdjustingType((Exp)lParent.getParent(), (Exp)lReplica);
                            continue;
                        }
                        if (!(lNewNode instanceof VarNode) || lNewNode.getParent() == null || lNewNode.getParent().getOperator() != 17) continue;
                        continue;
                    }
                    if (lOpCodeP == 67 && lParent.getParent() != null && lParent.getParent().getOperator() == 17 && lNewNode.getType() instanceof VectorType && lNewNode.getParent() != null && lNewNode.getParent().getOperator() == 17) {
                        Exp lArray = (Exp)lNewNode.copyWithOperands();
                        Exp lSubscript = (Exp)this.transform(pParamCorresp, pArrayCorresp, (Exp)lNewNode.getParent().getChild2());
                        lReplica = this.hir.subscriptedExp(lArray, lSubscript);
                        lReplica = this.replaceExpAdjustingType((Exp)lParent.getParent(), (Exp)lReplica);
                        continue;
                    }
                    if (lOpCodeP != 14) continue;
                    lReplica = this.replaceExpAdjustingType((Exp)lNode, (Exp)lNewNode.copyWithOperands());
                    continue;
                }
                this.dbgOut(2, " No corresponcdence to " + lSym.getName());
                continue;
            }
            if (lSym instanceof Var && !pParamCorresp.containsKey(lSym) && this.symRoot.symTableCurrentSubp.search(lSym.getName().intern(), lSym.getSymKind()) == null) {
                lTempVar = this.symRoot.symTableCurrentSubp.generateVar(lSym.getSymType());
                pParamCorresp.put(lSym, lTempVar);
                if (this.fDbgLevel > 0) {
                    this.dbgOut(2, " map " + lSym.getName() + " to " + lTempVar.getName());
                }
            }
            if (!pParamCorresp.containsKey(lSym)) continue;
            lTempVar = null;
            Object lObj = pParamCorresp.get(lSym);
            if (lObj instanceof Var) {
                lTempVar = (Var)lObj;
                lReplica = this.hir.varNode(lTempVar);
            } else if (lObj instanceof Exp) {
                lReplica = ((Exp)lObj).copyWithOperands();
            }
            lReplica = this.replaceExpAdjustingType((Exp)lNode, (Exp)lReplica);
            if (!lNoParent) continue;
            return lReplica;
        }
        lOutHir.setFlag(1, true);
        if (this.fDbgLevel > 3) {
            this.dbgOut(5, " return " + lOutHir.toStringWithChildren());
        }
        return lOutHir;
    }

    protected Map mismatch(Map pParamCorresp, HIR pInPattern, HIR pInHir) {
        String lMessage = "Parameter mismatch in " + pInPattern.toStringWithChildren() + " applied to " + pInHir.toStringWithChildren();
        this.putMessage(1, lMessage);
        return pParamCorresp;
    }

    public void putMessage(int pLevel, String pMessage) {
        this.ioRoot.msgRecovered.put(pMessage);
        if (this.ioRoot.dbgControl.getLevel() == 0 && this.fDbgLevel > 0) {
            this.dbgOut(pLevel, "\n" + pMessage);
        }
    }

    protected boolean checkConsistency(Subp pPattern, List pLocalVarList, HIR pInPattern, HIR pOutPattern) {
        boolean lResult = true;
        if (this.fDbgLevel > 0) {
            this.dbgOut(3, "checkConsistency", pInPattern.toStringShort() + " and " + pOutPattern.toStringShort());
        }
        SymTable lSubpSymTable = pPattern.getSymTable();
        HashSet<Sym> lInParamAppeared = new HashSet<Sym>();
        HashSet<Sym> lOutParamAppeared = new HashSet<Sym>();
        HirIterator lIt1 = pInPattern.hirIterator(pInPattern);
        while (lIt1.hasNext()) {
            HIR lHir1 = lIt1.next();
            if (!(lHir1 instanceof SymNode)) continue;
            Sym lSym1 = ((SymNode)lHir1).getSymNodeSym();
            if (lSym1 instanceof Param) {
                lInParamAppeared.add(lSym1);
                continue;
            }
            if (lSym1 != pPattern) continue;
            lInParamAppeared.add(lSym1);
        }
        HirIterator lIt2 = pOutPattern.hirIterator(pOutPattern);
        while (lIt2.hasNext()) {
            HIR lHir2 = lIt2.next();
            if (!(lHir2 instanceof SymNode)) continue;
            Sym lSym2 = ((SymNode)lHir2).getSymNodeSym();
            if (lSym2 instanceof Param) {
                lOutParamAppeared.add(lSym2);
                if (lInParamAppeared.contains(lSym2)) continue;
                this.ioRoot.msgRecovered.put(5122, "Parameter " + lSym2.getName() + " has not appeared in the input pattern of " + pPattern.getName());
                lResult = false;
                continue;
            }
            if (lSym2 instanceof Var) {
                if (lSubpSymTable.search(lSym2.getName().intern(), lSym2.getSymKind()) != null || pLocalVarList.contains(lSym2)) continue;
                pLocalVarList.add(lSym2);
                continue;
            }
            if (lSym2 != pPattern) continue;
            lOutParamAppeared.add(lSym2);
        }
        HashSet<Sym> lInParam2 = new HashSet<Sym>();
        lInParam2.addAll(lInParamAppeared);
        lInParam2.removeAll(lOutParamAppeared);
        if (!lInParam2.isEmpty()) {
            this.dbgOut(2, "Parameters " + ((Object)lInParam2).toString() + " have not appeared in the output pattern of " + pPattern.getName());
        }
        if (this.fDbgLevel > 0) {
            this.dbgOut(2, "\nVariables local to out-pattern " + pLocalVarList);
        }
        return lResult;
    }

    protected double patternCode(HIR pHir) {
        HIR lChild2;
        if (pHir == null) {
            return 0.0;
        }
        double lPatternCode = (double)pHir.getOperator() * fHirCodeLim6;
        HIR lChild1 = (HIR)pHir.getChild1();
        if (lChild1 != null) {
            HIR lChild12;
            if (this.fDbgLevel > 2) {
                this.dbgOut(5, " child1 " + lChild1.getOperator());
            }
            lPatternCode += (double)lChild1.getOperator() * fHirCodeLim5;
            HIR lChild11 = (HIR)lChild1.getChild1();
            if (lChild11 != null) {
                lPatternCode += (double)lChild11.getOperator() * fHirCodeLim3;
            }
            if ((lChild12 = (HIR)lChild1.getChild2()) != null) {
                lPatternCode += (double)lChild12.getOperator() * fHirCodeLim2;
            }
        }
        if ((lChild2 = (HIR)pHir.getChild2()) != null) {
            HIR lChild22;
            if (this.fDbgLevel > 2) {
                this.dbgOut(5, " child2 " + lChild2.getOperator());
            }
            lPatternCode += (double)lChild2.getOperator() * fHirCodeLim4;
            HIR lChild21 = (HIR)lChild2.getChild1();
            if (lChild21 != null) {
                lPatternCode += (double)lChild21.getOperator() * fHirCodeLim;
            }
            if ((lChild22 = (HIR)lChild2.getChild2()) != null) {
                lPatternCode += (double)lChild22.getOperator();
            }
        }
        return lPatternCode;
    }

    protected void computePatternCodeRange() {
        this.dbgOut(2, "\ncomputePatternCodeRange");
        this.fPatternCodeUpper = new double[this.fPatternList.size() + 1];
        this.fPatternCodeLower = new double[this.fPatternList.size() + 1];
        this.fUsedAsSubroot = new boolean[(int)fHirCodeLim];
        for (int i = 0; i < this.fUsedAsSubroot.length; ++i) {
            this.fUsedAsSubroot[i] = false;
        }
        for (int lIndex = 0; lIndex < this.fPatternList.size(); ++lIndex) {
            HIR lChild2;
            double lCode;
            double lUpperCode;
            Subp lPatternSym;
            HIR lInPattern;
            Object lObj = this.fPatternList.get(lIndex);
            if (this.fDbgLevel > 2) {
                this.dbgOut(3, "\n " + lIndex + " " + lObj + " " + lObj.getClass());
            }
            if ((lInPattern = (HIR)this.fInPatternMap.get(lPatternSym = (Subp)this.fPatternList.get(lIndex))) == null) continue;
            HIR lNode = lInPattern;
            int lOpCode = lNode.getOperator();
            this.fUsedAsSubroot[lOpCode] = true;
            double lLowerCode = lUpperCode = (double)lOpCode * fHirCodeLim6;
            HIR lChild1 = (HIR)lNode.getChild1();
            if (lChild1 != null) {
                HIR lChild12;
                if (this.fDbgLevel > 2) {
                    this.dbgOut(5, " child1 " + lChild1.getOperator());
                }
                lCode = lChild1.getOperator();
                if (lChild1 instanceof Param) {
                    lUpperCode += fDontCareCode * fHirCodeLim5;
                } else {
                    lUpperCode += lCode * fHirCodeLim5;
                    lLowerCode += lCode * fHirCodeLim5;
                }
                HIR lChild11 = (HIR)lChild1.getChild1();
                if (lChild11 != null) {
                    lCode = lChild11.getOperator();
                    if (lChild11 instanceof Param) {
                        lUpperCode += fDontCareCode * fHirCodeLim3;
                    } else {
                        lUpperCode += lCode * fHirCodeLim3;
                        lLowerCode += lCode * fHirCodeLim3;
                    }
                }
                if ((lChild12 = (HIR)lChild1.getChild2()) != null) {
                    lCode = lChild12.getOperator();
                    if (lChild11 instanceof Param) {
                        lUpperCode += fDontCareCode * fHirCodeLim2;
                    } else {
                        lUpperCode += lCode * fHirCodeLim2;
                        lLowerCode += lCode * fHirCodeLim2;
                    }
                }
            }
            if ((lChild2 = (HIR)lNode.getChild2()) != null) {
                HIR lChild22;
                if (this.fDbgLevel > 2) {
                    this.dbgOut(5, " child2 " + lChild2.getOperator());
                }
                lCode = lChild2.getOperator();
                if (lChild2 instanceof Param) {
                    lUpperCode += fDontCareCode * fHirCodeLim4;
                } else {
                    lUpperCode += lCode * fHirCodeLim4;
                    lLowerCode += lCode * fHirCodeLim4;
                }
                HIR lChild21 = (HIR)lChild2.getChild1();
                if (lChild21 != null) {
                    lCode = lChild21.getOperator();
                    if (lChild21 instanceof Param) {
                        lUpperCode += fDontCareCode * fHirCodeLim;
                    } else {
                        lUpperCode += lCode * fHirCodeLim;
                        lLowerCode += lCode * fHirCodeLim;
                    }
                }
                if ((lChild22 = (HIR)lChild2.getChild2()) != null) {
                    lCode = lChild22.getOperator();
                    if (lChild22 instanceof Param) {
                        lUpperCode += fDontCareCode;
                    } else {
                        lUpperCode += lCode;
                        lLowerCode += lCode;
                    }
                }
            }
            this.fPatternCodeUpper[lIndex] = lUpperCode * 1.001;
            this.fPatternCodeLower[lIndex] = lLowerCode * 0.999;
            if (this.fDbgLevel < 2) continue;
            System.out.print("\n pattern code " + lIndex + "[" + this.fPatternCodeUpper[lIndex] + " - " + this.fPatternCodeLower[lIndex] + "]");
            if (this.fDbgLevel < 3) continue;
            System.out.print("\n pattern " + lInPattern.toStringWithChildren());
        }
        if (this.fDbgLevel >= 4) {
            System.out.print("\n fUsedAsSubroot ");
            for (int li = 1; li < this.fUsedAsSubroot.length; ++li) {
                if (!this.fUsedAsSubroot[li]) continue;
                System.out.print(" " + li);
            }
        }
    }

    protected Exp integralPromotion(int pOperator, Exp pOperand1, Exp pOperand2) {
        Exp lExp2;
        Exp lExp1;
        Type lType1 = pOperand1.getType();
        Type lType2 = pOperand2.getType();
        Type lExpType = lType1;
        if (lType2.getTypeRank() > lExpType.getTypeRank()) {
            lExpType = lType2;
        }
        if (lExpType.getTypeRank() < this.symRoot.typeInt.getTypeRank()) {
            lExpType = this.symRoot.typeInt;
        }
        if ((lExp1 = pOperand1).getType() != lExpType) {
            lExp1 = this.hirRoot.hir.convExp(lExpType, (Exp)lExp1.copyWithOperands());
        }
        if ((lExp2 = pOperand2).getType() != lExpType) {
            lExp2 = this.hirRoot.hir.convExp(lExpType, (Exp)lExp2.copyWithOperands());
        }
        return this.hirRoot.hir.exp(pOperator, lExp1, lExp2);
    }

    protected Exp integralPromotion(int pOperator, Exp pOperand1) {
        Exp lExp1;
        Type lExpType = pOperand1.getType();
        if (lExpType.getTypeRank() < this.symRoot.typeInt.getTypeRank()) {
            lExpType = this.symRoot.typeInt;
        }
        if ((lExp1 = pOperand1).getType() != lExpType) {
            lExp1 = this.hirRoot.hir.convExp(lExpType, (Exp)lExp1.copyWithOperands());
        }
        return this.hirRoot.hir.exp(pOperator, lExp1);
    }

    protected AssignStmt makeAssignStmt(Var pVariable, Exp pExp) {
        Type lType = pVariable.getSymType();
        Exp lExp = pExp;
        if (pExp.getType() != lType) {
            lExp = this.hirRoot.hir.convExp(lType, lExp);
        }
        return this.hirRoot.hir.assignStmt(this.hirRoot.hir.varNode(pVariable), lExp);
    }

    protected Type typeForArithmeticExp(Type pType) {
        Type lType = pType;
        if (lType.getTypeRank() < this.symRoot.typeInt.getTypeRank()) {
            lType = this.symRoot.typeInt;
        }
        return lType;
    }

    protected HIR replaceExpAdjustingType(Exp lOld, Exp lNew) {
        if (this.fDbgLevel > 2) {
            this.dbgOut(3, "\n replaceExpAdjustingType " + lOld.toStringWithChildren() + " with " + lNew.toStringWithChildren());
        }
        Exp lExp = lNew;
        Type lOldType = lOld.getType();
        Type lNewType = lNew.getType();
        if (lOldType instanceof PointerType && lNewType instanceof VectorType) {
            lExp = this.hirRoot.hir.decayExp(lNew);
        } else if (lOldType instanceof VectorType && lNewType instanceof PointerType) {
            lExp = this.hirRoot.hir.undecayExp(lNew, ((VectorType)lOldType).getElemCount());
        } else if (lOldType != lNewType) {
            lExp = this.hirRoot.hir.convExp(lOldType, lNew);
        }
        if (this.fDbgLevel > 2 && lExp != lNew) {
            this.dbgOut(3, " changing to " + lExp.toStringWithChildren());
        }
        Exp lNewExp = (Exp)lOld.replaceThisNode(lExp);
        return lNewExp;
    }

    protected boolean isSameTree(HIR pTree1, HIR pTree2) {
        if (pTree1 == pTree2) {
            return true;
        }
        if (pTree1 == null || pTree2 == null) {
            return false;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgOpt1.print(7, " isSameTree " + pTree1.getIrName() + " " + pTree2.getIrName());
        }
        if (pTree1.getOperator() != pTree2.getOperator()) {
            return false;
        }
        if (this.patternCode(pTree1) != this.patternCode(pTree2)) {
            return false;
        }
        if (pTree1 instanceof SymNode) {
            return pTree1.getSym() == pTree2.getSym();
        }
        int lChildCount = pTree1.getChildCount();
        if (pTree2.getChildCount() != lChildCount || pTree1.getType() != pTree2.getType()) {
            return false;
        }
        if (pTree1 instanceof BlockStmt) {
            Stmt lStmt2;
            Stmt lStmt1 = ((BlockStmt)pTree1).getFirstStmt();
            for (lStmt2 = ((BlockStmt)pTree2).getFirstStmt(); lStmt1 != null && lStmt2 != null; lStmt1 = lStmt1.getNextStmt(), lStmt2 = lStmt2.getNextStmt()) {
                if (this.isSameTree(lStmt1, lStmt2)) {
                    continue;
                }
                return false;
            }
            return lStmt1 == null && lStmt2 == null;
        }
        if (pTree1 instanceof IrList) {
            HIR lHir2;
            HIR lHir1;
            ListIterator lIt1 = ((IrList)((Object)pTree1)).iterator();
            ListIterator lIt2 = ((IrList)((Object)pTree2)).iterator();
            if (lIt1.hasNext() && lIt2.hasNext() && !this.isSameTree(lHir1 = (HIR)lIt1.next(), lHir2 = (HIR)lIt2.next())) {
                return false;
            }
            return !lIt1.hasNext() && !lIt2.hasNext();
        }
        for (int lChild = 1; lChild <= lChildCount; ++lChild) {
            if (this.isSameTree((HIR)pTree1.getChild(lChild), (HIR)pTree2.getChild(lChild))) continue;
            return false;
        }
        return true;
    }

    protected void dbgOut(int pLevel, String pMessage) {
        this.ioRoot.dbgOpt1.print(pLevel, pMessage);
    }

    protected void dbgOut(int pLevel, String pMessageClass, String pMessage) {
        this.ioRoot.dbgOpt1.print(pLevel, pMessageClass, pMessage);
    }
}

