/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.FlowRoot;
import coins.aflow.FlowResults;
import coins.flow.BBlock;
import coins.flow.FlowUtil;
import coins.flow.NodeListIterator;
import coins.flow.SetRefRepr;
import coins.flow.SetRefReprList;
import coins.flow.SubpFlow;
import coins.ir.IR;
import coins.ir.hir.HIR;
import coins.opt.OptError;
import coins.opt.OptUtil;

public class ConstFolding {
    static final int JAVA_BYTE_SIZE = 1;
    static final int JAVA_CHAR_SIZE = 2;
    static final int JAVA_SHORT_SIZE = 2;
    static final int JAVA_INT_SIZE = 4;
    static final int JAVA_LONG_SIZE = 8;
    public final FlowRoot flowRoot;
    FlowResults fResults;
    protected SubpFlow fSubpFlow;

    public ConstFolding(FlowResults pResults) {
        this.flowRoot = pResults.flowRoot;
        this.fResults = pResults;
        this.fSubpFlow = this.flowRoot.fSubpFlow;
    }

    public boolean doSubp(SubpFlow pSubpFlow) {
        boolean lChanged = false;
        for (BBlock lBBlock : pSubpFlow.getListOfBBlocksFromEntry()) {
            lChanged = this.doBBlock(lBBlock) || lChanged;
        }
        return lChanged;
    }

    public boolean doBBlock(BBlock pBBlock) {
        if (pBBlock == null || pBBlock.getBBlockNumber() == 0) {
            return false;
        }
        SetRefReprList lSetRefReprs = this.fSubpFlow.getSetRefReprList(pBBlock);
        IR lNewNode = null;
        boolean lFolded = false;
        Object lDeletedFlag = new Object();
        for (SetRefRepr lSetRefRepr : lSetRefReprs) {
            NodeListIterator lNodeListIt = lSetRefRepr.nodeListIterator();
            while (lNodeListIt.hasNext()) {
                IR lIR = lNodeListIt.next();
                if (ConstFolding.isDeleted(lIR, lDeletedFlag) || !FlowUtil.isConstNode(lIR)) continue;
                IR lParent = lIR.getParent();
                while (lParent != null && (lNewNode = OptUtil.fold(lParent, this.flowRoot)) != lParent) {
                    ConstFolding.flagDeleted(lParent, lDeletedFlag);
                    if (!FlowUtil.isConstNode(lNewNode)) break;
                    lParent = lNewNode.getParent();
                }
                if (lNewNode == lIR.getParent()) continue;
                lFolded = true;
            }
        }
        return lFolded;
    }

    private static void flagDeleted(IR pParent, Object pDeleteFlag) {
        ((HIR)pParent).setWork(pDeleteFlag);
        if (pParent instanceof HIR) {
            for (int i = 1; i <= pParent.getChildCount(); ++i) {
                if (pParent.getChild(i) == null) continue;
                ((HIR)pParent.getChild(i)).setWork(pDeleteFlag);
            }
        } else {
            throw new OptError();
        }
    }

    private static boolean isDeleted(IR pIR, Object pDeleteFlag) {
        return ((HIR)pIR).getWork() == pDeleteFlag;
    }
}

