/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.FlowRoot;
import coins.flow.SetRefRepr;
import coins.flow.SetRefReprList;
import coins.flow.SubpFlow;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.VarNode;
import coins.opt.CommonSubexpElim;
import coins.opt.OptUtil;
import coins.sym.ExpId;
import coins.sym.FlowAnalSym;
import coins.sym.Var;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CommonSubexpElimHir
extends CommonSubexpElim {
    public final HIR hir;
    protected Map fGlobalExpTempMap;
    protected Map fGlobalTempExpMap;

    public CommonSubexpElimHir(FlowRoot pFlowRoot) {
        super(pFlowRoot);
        this.hir = this.flowRoot.hirRoot.hir;
    }

    HIR eliminateSimple(HIR pCompoundNode, HIR pVarNode, SubpFlow pSubpFlow, Set pModSyms, boolean pMod) {
        if (pCompoundNode.getOperator() == 64) {
            return null;
        }
        VarNode lNewNode = (VarNode)((VarNode)pVarNode).copyWithOperands();
        OptUtil.replaceNode(pCompoundNode, lNewNode);
        VarNode lIR = lNewNode;
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, "elimSimple ", ((Object)pVarNode).toString());
        }
        return pVarNode;
    }

    HIR eliminateComplex(HIR pCompoundNode, HIR pPrevCompoundNode, SetRefRepr pPrevCalcSetRefRepr, SetRefReprList pSetRefReprs, Map pCompoundToNodeAndSetRefRepr, Map pContainsMap) {
        if (pCompoundNode.getType().getTypeKind() == 14) {
            return null;
        }
        if (pCompoundNode.getOperator() == 64) {
            return null;
        }
        if (pCompoundNode.getType().getTypeKind() == 23 && pCompoundNode.getParent().getOperator() == 17) {
            return null;
        }
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, "elimComplex ", ((Object)pCompoundNode).toString() + " prev " + ((Object)pPrevCompoundNode).toString() + " pPrevCalcSetRefRepr " + ((Object)pPrevCalcSetRefRepr).toString() + " pSetRefReprs " + pSetRefReprs.toString() + " pCompoundToNodeAndSetRefRepr " + pCompoundToNodeAndSetRefRepr.toString() + " pContainsMap " + pContainsMap.toString());
        }
        if (!pPrevCalcSetRefRepr.sets()) {
            return null;
        }
        AssignStmt lAssign = (AssignStmt)pPrevCalcSetRefRepr.getIR();
        Var lInsertedLHSVar = this.symRoot.symTableCurrent.generateVar(pPrevCompoundNode.getType(), this.symRoot.subpCurrent);
        Exp lInsertedRHS = (Exp)pPrevCompoundNode.copyWithOperands();
        this.recordTempExpCorrespondence(lInsertedLHSVar, (Exp)pPrevCompoundNode);
        VarNode lInsertedLHS = this.hir.varNode(lInsertedLHSVar);
        AssignStmt lInsertedStmt = this.hir.assignStmt(lInsertedLHS, lInsertedRHS);
        lAssign.insertPreviousStmt(lInsertedStmt, lAssign.getBlockStmt());
        VarNode lNewNode = this.hir.varNode(lInsertedLHSVar);
        VarNode lNewNode0 = this.hir.varNode(lInsertedLHSVar);
        OptUtil.replaceNode(pPrevCompoundNode, lNewNode0);
        OptUtil.replaceNode(pCompoundNode, lNewNode);
        return lInsertedLHS;
    }

    protected void registerUseSyms(HIR pSubtree, Map pContainsMap, Object pCompound) {
        ExpId lExpId = (ExpId)pCompound;
        for (FlowAnalSym lFlowAnalSym : lExpId.getOperandSet()) {
            if (pContainsMap.get(lFlowAnalSym) == null) {
                HashSet<ExpId> lSet = new HashSet<ExpId>();
                lSet.add(lExpId);
                pContainsMap.put(lFlowAnalSym, lSet);
                continue;
            }
            ((Set)pContainsMap.get(lFlowAnalSym)).add(lExpId);
        }
    }

    Set operandSet(Object o) {
        return ((ExpId)o).getOperandSet();
    }

    void reregisterSubexps(Object pCompound, SetRefRepr pSetRefRepr, Map pCompoundToNodeAndSetRefRepr) {
    }

    public void recordTempExpCorrespondence(Var pTempVar, Exp pExp) {
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, " recordTempExpCorrespondence", pTempVar.getName() + " " + pExp.toStringWithChildren());
        }
        this.flowRoot.flow.getSubpFlow().setExpOfTemp(pTempVar, (Exp)pExp.copyWithOperands());
        ExpId lExpId = pExp.getExpId();
        if (lExpId != null) {
            this.fGlobalExpTempMap.put(lExpId, pTempVar);
            this.fGlobalTempExpMap.put(pTempVar, lExpId);
            if (this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgOpt1.print(4, " expId " + lExpId.toStringShort());
            }
        }
    }
}

