/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.PassException;
import coins.mdf.DataAccessCondition;
import coins.mdf.ExecutionDecisionCondition;
import coins.mdf.FinishCondition;
import coins.mdf.MacroFlowGraph;
import coins.mdf.MacroTask;
import coins.mdf.MdfEnvironment;
import coins.mdf.NonExecutionDecisionCondition;
import java.util.LinkedList;
import java.util.ListIterator;

public class MdfConditions {
    private MdfEnvironment env;
    private MacroFlowGraph mfg;
    public final ExecutionDecisionCondition exec;
    public final NonExecutionDecisionCondition nonExec;
    public final DataAccessCondition access;
    public final FinishCondition finish;

    public MdfConditions(MdfEnvironment e, MacroFlowGraph g) throws PassException {
        this.env = e;
        this.mfg = g;
        this.exec = new ExecutionDecisionCondition(this.env, this.mfg);
        this.nonExec = new NonExecutionDecisionCondition(this.env, this.mfg);
        this.access = new DataAccessCondition(this.env, this.mfg);
        this.finish = new FinishCondition(this.env, this.mfg);
    }

    int[] readyTasks() {
        LinkedList<MacroTask> ready = new LinkedList<MacroTask>();
        ListIterator ite = this.mfg.listIterator();
        while (ite.hasNext()) {
            MacroTask mt = (MacroTask)ite.next();
            if (!this.exec.isReady[mt.taskNumber()] || !this.nonExec.isReady[mt.taskNumber()] || !this.access.isReady[mt.taskNumber()]) continue;
            ready.add(mt);
            this.env.println("MDF : Ready Task : " + mt.taskNumber(), 2000);
        }
        int[] result = new int[ready.size()];
        int count = 0;
        for (MacroTask mt : ready) {
            result[count] = mt.taskNumber();
            ++count;
        }
        return result;
    }
}

