/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.PassException;
import coins.aflow.BBlock;
import coins.aflow.BBlockSubtreeIterator;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpNode;
import coins.mdf.MdfEnvironment;
import coins.sym.Label;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.LinkedList;

public class MacroTask {
    public static final int THR = 2000;
    public final LinkedList predList;
    public final LinkedList succList;
    public final Label label;
    private MdfEnvironment env;
    private int number;
    private LinkedList blkList;
    private final String exitName = "exit";

    public MacroTask(MdfEnvironment e, int num, BBlock blk, Label lab) {
        this.env = e;
        this.label = lab;
        this.number = num;
        this.blkList = new LinkedList();
        this.blkList.add(blk);
        this.predList = new LinkedList();
        this.succList = new LinkedList();
    }

    public MacroTask(MdfEnvironment e, int num, Label lab) {
        this.env = e;
        this.label = lab;
        this.number = num;
        this.blkList = new LinkedList();
        this.predList = new LinkedList();
        this.succList = new LinkedList();
    }

    public int taskNumber() {
        return this.number;
    }

    public BBlock entryBlk() throws PassException {
        BBlock entryBlk = null;
        for (BBlock blk : this.blkList) {
            if (blk.getPredList().size() == 0) {
                entryBlk = blk;
            }
            for (BBlock pred : blk.getPredList()) {
                if (this.blkList.contains(pred)) continue;
                if (entryBlk != null && !entryBlk.equals(blk)) {
                    System.err.println("MacroTask ERROR : several entry block in MT " + this.number);
                    throw new PassException("mdf", "several entry block in a macrotask");
                }
                entryBlk = blk;
            }
        }
        return entryBlk;
    }

    public LinkedList exitBlks() {
        LinkedList<BBlock> exitBlks = new LinkedList<BBlock>();
        for (BBlock blk : this.blkList) {
            if (blk.getSuccList().size() == 0) {
                exitBlks.add(blk);
                continue;
            }
            for (BBlock succ : blk.getSuccList()) {
                if (this.blkList.contains(succ) || exitBlks.contains(blk)) continue;
                exitBlks.add(blk);
            }
        }
        return exitBlks;
    }

    boolean hasReturn() {
        for (BBlock blk : this.blkList) {
            BBlockSubtreeIterator ite = blk.bblockSubtreeIterator();
            while (ite.hasNext()) {
                Stmt node = (Stmt)ite.next();
                if (!(node instanceof ReturnStmt)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasCall() {
        for (BBlock blk : this.blkList) {
            BBlockSubtreeIterator ite = blk.bblockSubtreeIterator();
            while (ite.hasNext()) {
                SubpNode callee;
                Exp exp;
                Exp mayCall;
                Stmt node = (Stmt)ite.next();
                if (!(node instanceof ExpStmt) || (mayCall = ((ExpStmt)node).getExp()) == null || mayCall.getOperator() != 33 || !((exp = ((ExpStmt)node).getExp()) instanceof FunctionExp) || (callee = ((FunctionExp)exp).getFunctionNode()) == null) continue;
                return true;
            }
        }
        return false;
    }

    public BBlock[] blks() throws PassException {
        LinkedList sortedList = this.postOrdering(this.entryBlk(), new LinkedList(), new LinkedList());
        Object[] o = sortedList.toArray();
        BBlock[] blks = new BBlock[o.length];
        for (int i = 0; i < o.length; ++i) {
            blks[i] = (BBlock)o[o.length - 1 - i];
        }
        return blks;
    }

    private LinkedList postOrdering(BBlock blk, LinkedList list, LinkedList visited) {
        if (visited.contains(blk)) {
            return list;
        }
        visited.add(blk);
        if (list.contains(blk) || !this.blkList.contains(blk)) {
            return list;
        }
        for (BBlock succ : blk.getSuccList()) {
            this.postOrdering(succ, list, visited);
        }
        list.add(blk);
        return list;
    }

    BBlock addBasicBlk(BBlock blk) {
        if (blk == null) {
            return null;
        }
        if (blk.getPredList().size() == 0 && !blk.isEntryBBlock()) {
            return null;
        }
        this.blkList.add(blk);
        return blk;
    }

    MacroTask concat(MacroTask mt) throws PassException {
        if (mt.predList.size() == 1 && this.succList.size() == 1 && mt.predList.contains(this)) {
            BBlock[] blks = mt.blks();
            for (int i = 0; i < blks.length; ++i) {
                if (this.blkList.contains(blks[i])) continue;
                this.blkList.add(blks[i]);
            }
            this.succList.clear();
            for (MacroTask succ : mt.succList) {
                succ.predList.remove(mt);
                if (succ.equals(this)) continue;
                this.succList.add(succ);
                if (succ.predList.contains(this)) continue;
                succ.predList.add(this);
            }
            return this;
        }
        if (this.predList.size() == 1 && mt.succList.size() == 1 && this.predList.contains(mt)) {
            BBlock[] blks = mt.blks();
            for (int i = 0; i < blks.length; ++i) {
                if (this.blkList.contains(blks[i])) continue;
                this.blkList.add(blks[i]);
            }
            this.predList.clear();
            for (MacroTask pred : mt.predList) {
                pred.succList.remove(mt);
                if (pred.equals(this)) continue;
                this.predList.add(pred);
                if (pred.succList.contains(this)) continue;
                pred.succList.add(this);
            }
            return this;
        }
        return null;
    }

    public String toString() {
        String str = "MT[" + this.number + "] : block{ ";
        for (BBlock blk : this.blkList) {
            str = str + blk.getBBlockNumber() + " ";
        }
        str = str + "} pred{ ";
        for (MacroTask mt : this.predList) {
            str = str + mt.taskNumber() + " ";
        }
        str = str + "} succ{ ";
        for (MacroTask mt : this.succList) {
            str = str + mt.taskNumber() + " ";
        }
        str = str + "}";
        return str;
    }

    void printGraph(OutputStreamWriter output) {
        try {
            output.write(this.number + " [fontsize=10,shape=box,label=\"");
        }
        catch (IOException e) {
            this.env.output.print(this.number + " [fontsize=10,label=\"");
        }
        try {
            output.write("MT : " + this.number + "\\l\"]\n");
        }
        catch (IOException e) {
            this.env.output.print("MT : " + this.number + " \\l\"]\n");
        }
        try {
            output.write(this.number + " -> {");
        }
        catch (IOException e) {
            this.env.output.print(this.number + " -> {");
        }
        for (MacroTask mt : this.succList) {
            try {
                output.write(mt.taskNumber() + " ");
            }
            catch (IOException e) {
                this.env.output.println(mt.taskNumber() + " ");
            }
        }
        try {
            output.write("}\n");
        }
        catch (IOException e) {
            this.env.output.println("}");
        }
    }
}

