/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.PassException;
import coins.aflow.BBlock;
import coins.aflow.FlowAnalSymVector;
import coins.mdf.MacroFlowGraph;
import coins.mdf.MacroTask;
import coins.mdf.MdfEnvironment;
import coins.mdf.Util;
import coins.sym.FlowAnalSym;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class DataDependence {
    public static final int THR = 2000;
    public static final int THR2 = 10000;
    private MdfEnvironment env;
    private MacroFlowGraph mfg;
    private Hashtable dependMap;
    private Hashtable defMap;
    private Hashtable useMap;
    private Util util;

    public DataDependence(MdfEnvironment e, MacroFlowGraph g) throws PassException {
        this.env = e;
        this.mfg = g;
        this.util = new Util(this.env, this.mfg);
        this.dependMap = new Hashtable();
        this.findDefUse();
        ListIterator ite = this.mfg.listIterator();
        while (ite.hasNext()) {
            MacroTask mt = (MacroTask)ite.next();
            LinkedList list = this.util.findPreBlks(mt, new LinkedList());
            LinkedList<MacroTask> dependList = new LinkedList<MacroTask>();
            FlowAnalSymVector useVector = (FlowAnalSymVector)this.useMap.get(mt);
            FlowAnalSymVector defVector = (FlowAnalSymVector)this.defMap.get(mt);
            for (MacroTask preTask : list) {
                if (preTask == mt || dependList.contains(preTask)) continue;
                FlowAnalSymVector preDefVect = (FlowAnalSymVector)this.defMap.get(preTask);
                FlowAnalSymVector preUseVect = (FlowAnalSymVector)this.useMap.get(preTask);
                FlowAnalSymVector ansVector = this.mfg.subpFlow.flowAnalSymVector();
                preDefVect.vectorAnd(useVector, ansVector);
                if (!ansVector.isZero()) {
                    dependList.add(preTask);
                    continue;
                }
                ansVector.vectorReset();
                preUseVect.vectorAnd(defVector, ansVector);
                if (!ansVector.isZero()) {
                    dependList.add(preTask);
                    continue;
                }
                ansVector.vectorReset();
                defVector.vectorAnd(preDefVect, ansVector);
                if (ansVector.isZero()) continue;
                dependList.add(preTask);
            }
            this.dependMap.put(mt, dependList);
        }
    }

    public LinkedList depend(MacroTask mt) {
        LinkedList list = (LinkedList)this.dependMap.get(mt);
        if (list == null) {
            return new LinkedList();
        }
        return list;
    }

    LinkedList threadPrivateVariable() throws PassException {
        LinkedList<FlowAnalSym> result = new LinkedList<FlowAnalSym>();
        FlowAnalSymVector resVect = this.mfg.subpFlow.flowAnalSymVector();
        this.findDefUse();
        Iterator ite = this.mfg.listIterator();
        while (ite.hasNext()) {
            MacroTask mt = (MacroTask)ite.next();
            FlowAnalSymVector useVector = (FlowAnalSymVector)this.useMap.get(mt);
            resVect.vectorOr(useVector, resVect);
        }
        resVect.vectorNot(resVect);
        for (FlowAnalSym s : resVect.flowAnalSyms()) {
            if (s.isGlobal() || !this.mfg.symTab.isInThisSymTable(s)) continue;
            result.add(s);
        }
        return result;
    }

    private void findDefUse() throws PassException {
        this.mfg.subpFlow.makeDominatorTree();
        this.defMap = new Hashtable();
        this.useMap = new Hashtable();
        ListIterator ite = this.mfg.listIterator();
        while (ite.hasNext()) {
            FlowAnalSymVector useVector;
            MacroTask mt = (MacroTask)ite.next();
            FlowAnalSymVector defVector = (FlowAnalSymVector)this.defMap.get(mt);
            if (defVector == null) {
                defVector = this.mfg.subpFlow.flowAnalSymVector();
                this.defMap.put(mt, defVector);
            }
            if ((useVector = (FlowAnalSymVector)this.useMap.get(mt)) == null) {
                useVector = this.mfg.subpFlow.flowAnalSymVector();
                this.useMap.put(mt, useVector);
            }
            BBlock[] blks = mt.blks();
            for (int i = 0; i < blks.length; ++i) {
                FlowAnalSymVector blkDefVector = blks[i].getPDefined();
                defVector.vectorOr(blkDefVector, defVector);
                FlowAnalSymVector blkUseVector = blks[i].getPExposed();
                List dom = blks[i].getDomForSubpFlow();
                LinkedList preBlks = this.util.findMtPreBlks(mt, blks[i], new LinkedList());
                FlowAnalSymVector tmpVect = this.mfg.subpFlow.flowAnalSymVector();
                blkUseVector.vectorCopy(tmpVect);
                ListIterator preIte = preBlks.listIterator();
                while (preIte.hasNext()) {
                    BBlock preBlk = (BBlock)preIte.next();
                    if (preBlk == blks[i] || !dom.contains(preBlk)) continue;
                    FlowAnalSymVector preDefVector = preBlk.getPDefined();
                    tmpVect.vectorSub(preDefVector, tmpVect);
                }
                useVector.vectorOr(tmpVect, useVector);
            }
            this.env.print("MDF : def[" + mt.taskNumber() + "] : " + defVector + "\n      ", 10000);
            for (FlowAnalSym s : defVector.flowAnalSyms()) {
                this.env.print(" " + s.getName(), 10000);
            }
            this.env.println("", 10000);
            this.env.print("MDF : use[" + mt.taskNumber() + "] : " + useVector + "\n      ", 10000);
            for (FlowAnalSym s : useVector.flowAnalSyms()) {
                this.env.print(" " + s.getName(), 10000);
            }
            this.env.println("", 10000);
        }
    }

    void print() {
        ListIterator ite = this.mfg.listIterator();
        while (ite.hasNext()) {
            MacroTask mt = (MacroTask)ite.next();
            LinkedList list = (LinkedList)this.dependMap.get(mt);
            String str = mt.toString() + " DD{ ";
            ListIterator listIte = list.listIterator();
            while (listIte.hasNext()) {
                MacroTask task = (MacroTask)listIte.next();
                str = str + task.taskNumber() + " ";
            }
            str = str + "} " + mt.hasCall();
            this.env.output.println(str);
        }
    }
}

