/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.mdf.MacroFlowGraph;
import coins.mdf.MacroTask;
import coins.mdf.MdfEnvironment;
import coins.mdf.PostDominators;
import coins.mdf.Util;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;

public class ControlDependence {
    private MacroFlowGraph mfg;
    private Hashtable dependMap;
    private MdfEnvironment env;
    private Util util;
    private PostDominators pdom;

    public ControlDependence(MdfEnvironment e, MacroFlowGraph g) {
        this.env = e;
        this.mfg = g;
        this.util = new Util(this.env, this.mfg);
        this.dependMap = new Hashtable();
        this.pdom = new PostDominators(this.env, this.mfg);
        ListIterator ite = this.mfg.listIterator();
        while (ite.hasNext()) {
            this.analyze2((MacroTask)ite.next());
        }
    }

    public LinkedList depend(MacroTask mt) {
        LinkedList list = (LinkedList)this.dependMap.get(mt);
        if (list == null) {
            return new LinkedList();
        }
        return list;
    }

    void print() {
        ListIterator ite = this.mfg.listIterator();
        while (ite.hasNext()) {
            MacroTask mt = (MacroTask)ite.next();
            LinkedList list = this.depend(mt);
            String str = mt.toString() + " CD{ ";
            ListIterator listIte = list.listIterator();
            while (listIte.hasNext()) {
                MacroTask task = (MacroTask)listIte.next();
                str = str + task.taskNumber() + " ";
            }
            str = str + "}";
            this.env.output.println(str);
        }
    }

    private void analyze2(MacroTask mt) {
        LinkedList<MacroTask> depends = new LinkedList<MacroTask>();
        int number = mt.taskNumber();
        ListIterator ite = this.mfg.listIterator();
        while (ite.hasNext()) {
            MacroTask task = (MacroTask)ite.next();
            if (this.pdom.pdom[task.taskNumber()][number] != 0) continue;
            for (MacroTask succ : task.succList) {
                if (this.pdom.pdom[succ.taskNumber()][number] != 1 || depends.contains(task)) continue;
                depends.add(task);
            }
        }
        this.dependMap.put(mt, depends);
    }
}

