/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.mdf.MacroFlowGraph;
import coins.mdf.MacroTask;
import coins.mdf.MdfEnvironment;
import coins.mdf.Util;
import java.util.ListIterator;

abstract class Conditions {
    protected final MdfEnvironment env;
    protected final MacroFlowGraph mfg;
    protected final int[][] vector;
    protected final int elemSize;
    protected final int vectSize;
    protected final boolean[] isReady;

    protected Conditions(MdfEnvironment e, MacroFlowGraph g) {
        this.env = e;
        this.mfg = g;
        this.elemSize = this.mfg.bound() + this.mfg.controlBranch.size();
        this.vectSize = this.mfg.bound();
        this.vector = new int[this.vectSize][this.elemSize];
        this.isReady = new boolean[this.elemSize];
        for (int i = 0; i < this.vectSize; ++i) {
            for (int j = 0; j < this.elemSize; ++j) {
                this.vector[i][j] = 0;
            }
        }
    }

    protected Conditions(MdfEnvironment e, MacroFlowGraph g, int size) {
        this.env = e;
        this.mfg = g;
        this.elemSize = this.mfg.bound() + this.mfg.controlBranch.size();
        this.vectSize = size;
        this.vector = new int[this.vectSize][this.elemSize];
        this.isReady = new boolean[this.elemSize];
        for (int i = 0; i < this.vectSize; ++i) {
            for (int j = 0; j < this.elemSize; ++j) {
                this.vector[i][j] = 0;
            }
        }
    }

    protected int[] bitVector(int id) {
        Util util = new Util(this.env, this.mfg);
        int[] target = this.vector[id];
        int wordSize = util.wordSize();
        int[] vect = new int[util.vectorSize()];
        for (int i = 0; i < vect.length; ++i) {
            vect[i] = 0;
            for (int j = 0; j < wordSize && target.length > j + i * wordSize; ++j) {
                if (target[j + i * wordSize] != 1) continue;
                int mask = 1 << wordSize - j - 1;
                vect[i] = vect[i] | mask;
            }
        }
        return vect;
    }

    protected void showVector(String name) {
        this.env.output.println(name);
        for (int i = 0; i < this.vectSize; ++i) {
            this.env.output.print("Cond[" + i + "] : ");
            for (int j = 0; j < this.elemSize; ++j) {
                this.env.output.print(this.vector[i][j]);
            }
            this.env.output.println();
        }
    }

    public String toString() {
        String result = "";
        ListIterator ite = this.mfg.listIterator();
        while (ite.hasNext()) {
            MacroTask mt = (MacroTask)ite.next();
            result = result + "MT[" + mt.taskNumber() + "] : " + this.toString(mt) + "\n";
        }
        return result;
    }

    public String toString(MacroTask mt) {
        int i;
        String result = "";
        boolean hasPrev = false;
        for (i = 0; i < this.mfg.bound(); ++i) {
            if (this.vector[mt.taskNumber()][i] != 1) continue;
            if (hasPrev) {
                result = result + " & " + i;
                continue;
            }
            result = result + i;
            hasPrev = true;
        }
        for (i = this.mfg.bound(); i < this.elemSize; ++i) {
            int number;
            MacroTask[] pair;
            if (this.vector[mt.taskNumber()][i] != 1 || (pair = this.mfg.controlBranch.branchPair(number = i - this.mfg.bound())) == null) continue;
            if (hasPrev) {
                result = result + " & (" + pair[0].taskNumber() + " -> " + pair[1].taskNumber() + ")";
                continue;
            }
            result = result + "(" + pair[0].taskNumber() + " -> " + pair[1].taskNumber() + ")";
            hasPrev = true;
        }
        return result;
    }
}

