/*
 * Decompiled with CFR 0.152.
 */
package coins.lparallel;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.aflow.Flow;
import coins.aflow.FlowResults;
import coins.aflow.ShowFlow;
import coins.aflow.SubpFlow;
import coins.ir.hir.SubpDefinition;
import coins.lparallel.LoopParallel;
import coins.lparallel.LoopParallelConv;
import coins.lparallel.LoopTable;
import coins.lparallel.OpenMPInfo;
import java.io.PrintStream;
import java.util.LinkedList;

public class LoopParallelImpl
implements LoopParallel {
    public HirRoot hirRoot;
    public IoRoot ioRoot;
    public FlowRoot flowRoot;
    public PrintStream printOut;
    public SubpFlow fSubpFlow;
    public Flow fFlow;
    public FlowResults fresults;

    public LoopParallelImpl(HirRoot phirRoot, IoRoot pioRoot, SubpDefinition pSubpDef, FlowRoot pflowRoot) {
        this.hirRoot = phirRoot;
        this.ioRoot = pioRoot;
        this.flowRoot = pflowRoot;
        this.fFlow = pflowRoot.aflow;
        this.fresults = new FlowResults(this.flowRoot);
        this.flowRoot.subpFlow = this.fSubpFlow = this.fFlow.subpFlow(pSubpDef, this.fresults);
        this.fFlow.setSubpFlow(this.fSubpFlow);
        this.printOut = this.ioRoot.printOut;
    }

    public void LoopAnal() {
        if (this.ioRoot.dbgPara1.getLevel() > 0) {
            this.ioRoot.dbgPara1.print(1, "LoopAnal " + this.fSubpFlow.getSubpSym().getName());
        }
        this.fSubpFlow.controlFlowAnal();
        this.fSubpFlow.makeDominatorTree();
        this.fSubpFlow.makePostdominatorTree();
        this.fresults.find("Initiate", this.fSubpFlow);
        if (this.ioRoot.dbgPara1.getLevel() > 1) {
            ShowFlow lShowFlow = new ShowFlow(this.fresults);
            lShowFlow.showControlFlow(this.fSubpFlow);
            lShowFlow.showDominatorTree(this.fSubpFlow);
            lShowFlow.showPostdominatorTree(this.fSubpFlow);
            if (this.ioRoot.dbgPara1.getLevel() > 3) {
                lShowFlow.showVectorsByName("PDef", this.fSubpFlow);
                lShowFlow.showVectorsByName("DKill", this.fSubpFlow);
                lShowFlow.showVectorsByName("PReach", this.fSubpFlow);
                lShowFlow.showVectorsByName("DDefined", this.fSubpFlow);
                lShowFlow.showVectorsByName("PDefined", this.fSubpFlow);
                lShowFlow.showVectorsByName("PExposed", this.fSubpFlow);
                lShowFlow.showVectorsByName("PUsed", this.fSubpFlow);
                lShowFlow.showVectorsByName("DEGen", this.fSubpFlow);
                lShowFlow.showVectorsByName("PEKill", this.fSubpFlow);
                lShowFlow.showVectorsByName("DAvailIn", this.fSubpFlow);
                lShowFlow.showVectorsByName("DAvailOut", this.fSubpFlow);
                lShowFlow.showVectorsByName("PLiveIn", this.fSubpFlow);
                lShowFlow.showVectorsByName("PLiveOut", this.fSubpFlow);
                lShowFlow.showVectorsByName("DDefIn", this.fSubpFlow);
                lShowFlow.showVectorsByName("DDefOut", this.fSubpFlow);
                lShowFlow.showPDefUse(this.fSubpFlow);
                lShowFlow.showPUseDef(this.fSubpFlow);
            }
        }
        this.fresults.find("LoopParallelList", this.fSubpFlow);
        LinkedList LoopInfo = (LinkedList)this.fresults.get("LoopParallelList", this.fSubpFlow);
        for (LoopTable lTable : LoopInfo) {
            this.fresults.get("LoopParallel", this.fSubpFlow, lTable);
        }
    }

    public void LoopAnalLoopList(LinkedList pLoopList) {
        this.fSubpFlow.controlFlowAnal();
        this.fSubpFlow.makeDominatorTree();
        this.fSubpFlow.makePostdominatorTree();
        this.fresults.clear();
        this.fresults.find("Initiate", this.fSubpFlow);
        this.fresults.find("LoopParallelList", this.fSubpFlow, pLoopList);
        LinkedList LoopInfo = (LinkedList)this.fresults.get("LoopParallelList", this.fSubpFlow);
        if (LoopInfo == null) {
            return;
        }
        for (LoopTable lTable : LoopInfo) {
            this.fresults.get("LoopParallel", this.fSubpFlow, lTable);
        }
    }

    public void ReconstructHir() {
        LoopParallelConv Inf = new LoopParallelConv(this.fSubpFlow, this.fresults);
        Inf.DeleteInduction();
        Inf.ChangeCommonPrivate();
        Inf.AddConditionalInitPart();
    }

    public void SetOpenMPInfo() {
        OpenMPInfo Inf = new OpenMPInfo(this.fSubpFlow, this.fresults);
        if (this.ioRoot.dbgPara1.getLevel() > 0) {
            System.out.print("\nshowLoopAnalResult|n");
            Inf.showLoopAnalResult();
        }
        Inf.setPragmaInfo();
        Inf.setErrorInfo();
    }

    private void Trace(String s) {
        System.out.println(s);
    }
}

