/*
 * Decompiled with CFR 0.152.
 */
package coins.lparallel;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.PassException;
import coins.SymRoot;
import coins.aflow.FlowResults;
import coins.driver.CoinsOptions;
import coins.driver.CommandLine;
import coins.driver.CompileSpecification;
import coins.driver.CompilerDriver;
import coins.driver.Driver;
import coins.driver.Suffix;
import coins.driver.TemporaryFileManager;
import coins.driver.Trace;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.InfStmt;
import coins.ir.hir.Program;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.TestHir;
import coins.lparallel.LoopParallelImpl;
import coins.lparallel.RegisterClasses;
import coins.opt.Opt;
import coins.sym.StringConst;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.TestSym;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;

public class LoopPara
extends Driver {
    public TemporaryFileManager fTemporaryFileManager;
    File fHir2CFile;
    public boolean fstophir2c = true;
    String fOpenMPTmpFileName;
    private static final String HIR_OPT_OPTION = "hirOpt";
    private static final char OPT_OPTION_DELIMITER = '/';
    protected static final String DEFAULT_OPENMP_NAME = "omcc";
    protected Set fSubprogramsToBeParallelized;

    public boolean makeCSourceFromHirBase(String pModifier, HirRoot hirRoot, SymRoot symRoot, IoRoot io) throws IOException, PassException {
        if (this.fTemporaryFileManager == null) {
            this.fTemporaryFileManager = new TemporaryFileManager();
        }
        this.fHir2CFile = this.createHir2CFile(io, pModifier);
        FileOutputStream out = new FileOutputStream(this.fHir2CFile);
        this.callHirBaseToC(hirRoot, symRoot, io, out);
        return true;
    }

    private File createHir2CFile(IoRoot io, String pModifier) throws IOException, PassException {
        File openMPFile;
        if (this.fstophir2c) {
            CoinsOptions coinsOptions = io.getCompileSpecification().getCoinsOptions();
            File source = io.getSourceFile();
            String sourcePath = source.getPath();
            String root = sourcePath.substring(0, sourcePath.lastIndexOf(46));
            String Hir2CFileName = root.concat("-" + pModifier + ".c");
            openMPFile = new File(Hir2CFileName);
        } else {
            openMPFile = this.createTmpFile(".c");
        }
        return openMPFile;
    }

    private File createTmpFile(String suffix) throws IOException, PassException {
        return this.fTemporaryFileManager.createTemporaryFile("COINSLOOP", suffix);
    }

    protected void OpenMPCompile(String timing, HirRoot hirRoot, SymRoot symRoot, OutputStream out, IoRoot io) throws IOException, PassException {
        Trace trace = io.getCompileSpecification().getTrace();
        CoinsOptions coinsOptions = io.getCompileSpecification().getCoinsOptions();
        CompileSpecification spec = io.getCompileSpecification();
        File source = io.getSourceFile();
        LinkedList<String> options = new LinkedList<String>();
        String sourcePath = source.getPath();
        File tmpFile = this.createTmpFile(".s");
        String commandName = DEFAULT_OPENMP_NAME;
        options.add(0, "-S");
        options.add(1, this.fHir2CFile.getPath());
        options.add(2, "-o");
        options.add(3, tmpFile.getPath());
        String[] commandLine = this.makeCommandLine(commandName, options);
        int ret = this.runProgram(commandLine, null, null, io);
        if (ret != 0) {
            throw new PassException("OpenMP Compiler", "Error(s) in OpenMP Compiler.");
        }
        this.storeToFile(new FileInputStream(tmpFile), out);
    }

    private void storeToFile(InputStream in, OutputStream lOut) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = in.read(buffer)) > 0) {
            lOut.write(buffer, 0, len);
        }
        lOut.close();
    }

    public void LoopParallel(HirRoot hirRoot, SymRoot symRoot, IoRoot ioRoot) {
        FlowRoot flowRoot = new FlowRoot(hirRoot);
        this.fSubprogramsToBeParallelized = this.getSubprogramsToBeParallelized(hirRoot, symRoot, ioRoot);
        IrList SubpDefList = ((Program)hirRoot.programRoot).getSubpDefinitionList();
        FlowResults.putRegClasses(new RegisterClasses());
        ListIterator subpDefIterator = SubpDefList.iterator();
        CoinsOptions coinsOptions = ioRoot.getCompileSpecification().getCoinsOptions();
        String Opt2 = coinsOptions.isSet("LoopOpt") ? coinsOptions.getArg("LoopOpt") : "";
        while (subpDefIterator.hasNext()) {
            SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
            if (!this.fSubprogramsToBeParallelized.contains(subpDef.getSubpSym())) continue;
            LoopParallelImpl LoopParallel2 = new LoopParallelImpl(hirRoot, ioRoot, subpDef, flowRoot);
            LoopParallel2.LoopAnal();
            LoopParallel2.ReconstructHir();
            LoopParallel2.SetOpenMPInfo();
        }
    }

    public void hir2OpenMP(HirRoot pHirRoot, SymRoot pSymRoot, IoRoot pIoRoot) throws IOException, PassException {
        this.LoopParallel(pHirRoot, pSymRoot, pIoRoot);
        this.fTemporaryFileManager = new TemporaryFileManager();
        this.fstophir2c = true;
        boolean lSucceeded = this.makeCSourceFromHirBase("loop", pHirRoot, pSymRoot, pIoRoot);
        if (!lSucceeded) {
            pIoRoot.msgError.put("hir2OpenMP(PASSExcept)");
            throw new PassException("HIR to C", "Stop HIR TO C");
        }
    }

    public Set getSubprogramsToBeParallelized(HirRoot hirRoot, SymRoot symRoot, IoRoot ioRoot) {
        HashSet lToBeParallelized = new HashSet();
        HashSet<Subp> lSubprograms = new HashSet<Subp>();
        Program lProgram = (Program)hirRoot.programRoot;
        ListIterator lIter = lProgram.getSubpDefinitionList().iterator();
        while (lIter.hasNext()) {
            SubpDefinition lSubpDef = (SubpDefinition)lIter.next();
            lSubprograms.add(lSubpDef.getSubpSym());
        }
        ioRoot.dbgPara1.print(3, "Subprograms Defined " + lSubprograms + "\n");
        HIR lProgInitPart = (HIR)lProgram.getInitiationPart();
        if (lProgInitPart instanceof BlockStmt) {
            for (Stmt lStmt = ((BlockStmt)lProgInitPart).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                String lOptionName;
                if (!(lStmt instanceof InfStmt) || ((InfStmt)lStmt).getInfKind() != "parallel") continue;
                ioRoot.dbgPara1.print(3, lStmt.toString() + "\n");
                IrList lOptionList = ((InfStmt)lStmt).getInfList("parallel");
                Object lObject = lOptionList.get(0);
                ioRoot.dbgPara1.print(3, " option name " + lObject + " " + lObject.getClass() + " " + lOptionList + "\n");
                if (lObject instanceof String) {
                    lOptionName = (String)lObject;
                } else if (lObject instanceof StringConst) {
                    lOptionName = ((StringConst)lObject).getStringBody();
                } else if (lObject instanceof Sym) {
                    lOptionName = ((Sym)lObject).getName();
                } else {
                    ioRoot.dbgPara1.print(1, "\nUnknown option kind" + lObject + "\n");
                    continue;
                }
                lOptionName = lOptionName.intern();
                if (lOptionName == "doAllFunc") {
                    int lIndex = 0;
                    ListIterator lIt = lOptionList.iterator();
                    while (lIt.hasNext()) {
                        Object lSubp = lIt.next();
                        ioRoot.dbgPara1.print(4, " " + lSubp + " " + lSubp.getClass() + "\n");
                        if (lSubp instanceof Subp) {
                            lToBeParallelized.add(lSubp);
                        }
                        ++lIndex;
                    }
                    continue;
                }
                if (lOptionName == "doAllFuncAll") {
                    lToBeParallelized.addAll(lSubprograms);
                    continue;
                }
                ioRoot.dbgPara1.print(1, "\nUnknown option " + lOptionName + "\n");
            }
        }
        ioRoot.dbgPara1.print(2, "To be parallelized", ((Object)lToBeParallelized).toString());
        return lToBeParallelized;
    }

    public void compile(File sourceFile, Suffix suffix, InputStream in, OutputStream out, IoRoot io) throws IOException, PassException {
        FlowRoot hirFlowRoot;
        CoinsOptions coinsOptions = io.getCompileSpecification().getCoinsOptions();
        boolean hirAnal = coinsOptions.isSet("hirAnal");
        boolean hirOpt = coinsOptions.isSet(HIR_OPT_OPTION);
        Trace trace = io.getCompileSpecification().getTrace();
        SymRoot symRoot = new SymRoot(io);
        HirRoot hirRoot = new HirRoot(symRoot);
        symRoot.attachHirRoot(hirRoot);
        symRoot.initiate();
        this.makeHirFromSource(sourceFile, hirRoot, suffix, in, io);
        this.makeCSourceFromHirBase("new", hirRoot, symRoot, io);
        if (hirOpt) {
            hirFlowRoot = new FlowRoot(hirRoot);
            this.optimizeHir(hirRoot, hirFlowRoot, symRoot, io);
        }
        this.LoopParallel(hirRoot, symRoot, io);
        this.testSym(hirRoot, io);
        hirFlowRoot = new FlowRoot(hirRoot);
        this.testHir(hirRoot, hirFlowRoot, io);
        trace.trace(this.myName, 5000, "compile(pass 4 -- HIR to C Source) ");
        if (this.makeCSourceFromHirBase("loop", hirRoot, symRoot, io)) {
            trace.trace(this.myName, 5000, "compile(pass 5 -- OpenMP Compile)");
            if (this.fstophir2c) {
                trace.trace(this.myName, 5000, "compile(PASSExcept)");
                throw new PassException("HIR to C", "Stop HIR TO C");
            }
            this.OpenMPCompile("loop", hirRoot, symRoot, out, io);
            trace.trace(this.myName, 5000, "compile(END)");
        }
    }

    protected void testSym(HirRoot pHirRoot, IoRoot io) throws IOException, PassException {
        CoinsOptions coinsOptions = io.getCompileSpecification().getCoinsOptions();
        if (coinsOptions.isSet("debug") || coinsOptions.isSet("testSym")) {
            new TestSym(pHirRoot);
        }
    }

    protected void testHir(HirRoot hirRoot, FlowRoot hirFlowRoot, IoRoot io) throws IOException, PassException {
        CoinsOptions coinsOptions = io.getCompileSpecification().getCoinsOptions();
        if (coinsOptions.isSet("debug") || coinsOptions.isSet("testHir")) {
            new TestHir(hirRoot, hirFlowRoot);
        }
    }

    protected void optimizeHir(HirRoot hirRoot, FlowRoot hirFlowRoot, SymRoot symRoot, IoRoot io) {
        String lOptArg = io.getCompileSpecification().getCoinsOptions().getArg(HIR_OPT_OPTION);
        ArrayList<String> lOpts = new ArrayList<String>();
        if (this.includedInDelimitedList("cf", '/', lOptArg)) {
            lOpts.add("cf");
        }
        if (this.includedInDelimitedList("cpf", '/', lOptArg)) {
            lOpts.add("cpf");
        }
        if (this.includedInDelimitedList("cse", '/', lOptArg)) {
            lOpts.add("cse");
        }
        if (this.includedInDelimitedList("dce", '/', lOptArg)) {
            lOpts.add("dce");
        }
        boolean lOptimized = new Opt(hirFlowRoot).doHir(lOpts);
    }

    public void assemble(File sourceFile, Suffix suffix, InputStream in, File out, IoRoot io) throws IOException, PassException {
        String[] commandLine;
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        File tmpFile = this.createTmpFile(".s");
        FileOutputStream tmpout = new FileOutputStream(tmpFile);
        this.storeToFile(in, tmpout);
        trace.trace(this.myName, 5000, "assemble");
        List options = spec.getAssemblerOptions();
        trace.trace(this.myName, 5000, "assemble(1)");
        options.add("-c");
        options.add("-o");
        options.add(out.getPath());
        options.add(tmpFile.getPath());
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        String commandName = DEFAULT_OPENMP_NAME;
        if (coinsOptions.isSet("assembler")) {
            commandName = coinsOptions.getArg("assembler");
        }
        if (this.runProgram(commandLine = this.makeCommandLine(commandName, options), in, null, io) != 0) {
            throw new PassException(sourceFile, "assembler", "Error(s) in assembler.");
        }
    }

    public void link(File out, IoRoot io) throws IOException, PassException {
        String[] commandLine;
        Trace trace = io.getCompileSpecification().getTrace();
        List options = io.getCompileSpecification().getLinkerOptions();
        options.add(0, "-o");
        options.add(1, out.getPath());
        trace.trace(this.myName, 5000, "link(1)");
        CoinsOptions coinsOptions = io.getCompileSpecification().getCoinsOptions();
        String commandName = DEFAULT_OPENMP_NAME;
        if (coinsOptions.isSet("linker")) {
            commandName = coinsOptions.getArg("linker");
        }
        if (this.runProgram(commandLine = this.makeCommandLine(commandName, options), null, null, io) != 0) {
            throw new PassException("linker", "Error(s) in linker.");
        }
    }

    public void cleanup(CompileSpecification spec) {
        CoinsOptions lCoinsOptions = spec.getCoinsOptions();
        if (!lCoinsOptions.isSet("debug")) {
            spec.getTrace().trace("Driver", 5000, "cleaning up...");
            this.fTemporaryFileManager.cleanupTemporaryFiles();
        }
    }

    private void loadDefaultSettings(CompileSpecification spec) {
        this.defaultSettings = new Properties();
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        File libDir = coinsOptions.getLibDir();
        File settingFile = new File(libDir, "settings");
        if (settingFile.exists()) {
            try {
                this.defaultSettings.load(new FileInputStream(settingFile));
            }
            catch (IOException e) {
                spec.getWarning().warning("Couldn't load the default setting file: " + settingFile.getPath());
            }
        }
    }

    protected void go(String[] args) {
        try {
            CommandLine spec = new CommandLine(args);
            this.fTemporaryFileManager = new TemporaryFileManager();
            this.loadDefaultSettings(spec);
            int status = new CompilerDriver(spec).go(this);
            this.cleanup(spec);
            System.exit(status);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        new LoopPara().go(args);
    }
}

