/*
 * Decompiled with CFR 0.152.
 */
package coins.lparallel;

import coins.aflow.FlowAdapter;
import coins.aflow.FlowResults;
import coins.aflow.SubpFlow;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ForStmt;
import coins.ir.hir.IfStmt;
import coins.ir.hir.InfStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SwitchStmt;
import coins.lparallel.LoopTable;
import coins.lparallel.LoopUtil;
import java.util.Iterator;
import java.util.LinkedList;

public class FindLoopParallelList
extends FlowAdapter {
    private LinkedList fLoopInfo;
    private SubpFlow fSubpFlow;
    private LoopUtil fUtil;
    private boolean lParallelizeFlag;
    int fDbgLevel;

    public FindLoopParallelList(FlowResults pResults) {
        super(pResults);
    }

    public void find(SubpFlow pSubpFlow) {
        Stmt hirBody = pSubpFlow.getSubpDefinition().getHirBody();
        this.fLoopInfo = new LinkedList();
        this.fSubpFlow = pSubpFlow;
        this.fUtil = new LoopUtil(this.fResults, this.fSubpFlow);
        this.fDbgLevel = this.ioRoot.dbgPara1.getLevel();
        this.lParallelizeFlag = false;
        this.HirBodySearch(hirBody, null);
        this.fResults.put("LoopParallelList", pSubpFlow, this.fLoopInfo);
        this.ioRoot.dbgPara1.print(3, "\nput LoopParallelList " + this.fLoopInfo);
    }

    public void find(SubpFlow pSubpFlow, LinkedList pList) {
        Stmt hirBody = pSubpFlow.getSubpDefinition().getHirBody();
        this.fLoopInfo = new LinkedList();
        this.fSubpFlow = pSubpFlow;
        this.fUtil = new LoopUtil(this.fResults, this.fSubpFlow);
        this.fDbgLevel = this.ioRoot.dbgPara1.getLevel();
        this.lParallelizeFlag = false;
        this.HirBodySearch(hirBody, null);
        LinkedList LoopInfo = this.getLoopList(pList);
        this.fResults.put("LoopParallelList", pSubpFlow, LoopInfo);
        this.ioRoot.dbgPara1.print(3, "\nput LoopParallelList LoopInfo " + LoopInfo);
    }

    private LinkedList getLoopList(LinkedList pList) {
        LinkedList<LoopTable> LoopInfo = new LinkedList<LoopTable>();
        for (ForStmt Loopst : pList) {
            LoopTable l = this.getLoopTable(this.fLoopInfo, Loopst);
            if (l == null) continue;
            LoopInfo.add(l);
        }
        return LoopInfo;
    }

    private LoopTable getLoopTable(LinkedList pLoopInfo, ForStmt pForStmt) {
        if (pLoopInfo == null) {
            return null;
        }
        for (LoopTable lTable : pLoopInfo) {
            LoopTable l = this.getLoopTable(lTable.InnerLoopList, pForStmt);
            if (l != null) {
                return l;
            }
            if (pForStmt != lTable.LoopStmt) continue;
            return lTable;
        }
        return null;
    }

    private void FindLoop(SubpFlow pSubpFlow, LoopTable pTable) {
        Iterator Ie = pTable.InnerLoopList.iterator();
        while (Ie.hasNext()) {
            this.FindLoop(pSubpFlow, (LoopTable)Ie.next());
        }
        this.fResults.find("LoopParallel", pSubpFlow, pTable);
    }

    private void HirBodySearch(Stmt pTree, LoopTable pTable) {
        this.LoopSearch(pTree, pTable, 0);
    }

    private boolean LoopSearch(Stmt pstmt, LoopTable pTable, int LoopNestLevel) {
        Stmt nextStmt = pstmt;
        boolean ForExist = false;
        LoopTable lTable = pTable;
        block14: while (nextStmt != null) {
            int op = nextStmt.getOperator();
            switch (op) {
                case 23: {
                    IfStmt stmtIF = (IfStmt)nextStmt;
                    if (this.LoopSearch(stmtIF.getThenPart(), pTable, LoopNestLevel)) {
                        ForExist = true;
                    }
                    if (this.LoopSearch(stmtIF.getElsePart(), pTable, LoopNestLevel)) {
                        ForExist = true;
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block14;
                }
                case 4: {
                    InfStmt lInfStmt = (InfStmt)nextStmt;
                    String lInfKind = lInfStmt.getInfKind().intern();
                    if (lInfKind == "parallel") {
                        String lOptionName;
                        IrList lOptionList = lInfStmt.getInfList(lInfKind);
                        Object lObject = lOptionList.get(0);
                        this.ioRoot.dbgPara1.print(3, lInfStmt.toString() + " " + lObject + " " + lObject.getClass() + " " + lOptionList + "\n");
                        if (lObject instanceof String && ((lOptionName = ((String)lObject).intern()) == "doAll" || lOptionName == "forceDoAll")) {
                            this.lParallelizeFlag = true;
                        }
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block14;
                }
                case 25: 
                case 27: {
                    LoopStmt stmtLOOP;
                    if (this.lParallelizeFlag) {
                        this.ioRoot.dbgPara1.print(3, "\n parallelize " + nextStmt.toStringShort());
                        stmtLOOP = (LoopStmt)nextStmt;
                        lTable = this.SetLoopInfo((ForStmt)nextStmt, pTable);
                        ForExist = true;
                        if (this.LoopSearch(stmtLOOP.getLoopBodyPart(), lTable, LoopNestLevel)) {
                            ForExist = true;
                        }
                        nextStmt = nextStmt.getNextStmt();
                        this.lParallelizeFlag = false;
                        continue block14;
                    }
                    this.ioRoot.dbgPara1.print(3, "\n do not parallelize " + nextStmt.toStringShort());
                    stmtLOOP = (LoopStmt)nextStmt;
                    if (this.LoopSearch(stmtLOOP.getLoopBodyPart(), pTable, LoopNestLevel)) {
                        ForExist = true;
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block14;
                }
                case 24: 
                case 26: {
                    LoopStmt stmtLOOP = (LoopStmt)nextStmt;
                    if (this.LoopSearch(stmtLOOP.getLoopBodyPart(), pTable, LoopNestLevel)) {
                        ForExist = true;
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block14;
                }
                case 21: {
                    if (((LabeledStmt)nextStmt).getStmt() != null) {
                        nextStmt = ((LabeledStmt)nextStmt).getStmt();
                        continue block14;
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block14;
                }
                case 28: {
                    nextStmt = nextStmt.getNextStmt();
                    continue block14;
                }
                case 32: {
                    SwitchStmt stmtSWITCH = (SwitchStmt)nextStmt;
                    if (this.LoopSearch(stmtSWITCH.getBodyStmt(), pTable, LoopNestLevel)) {
                        ForExist = true;
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block14;
                }
                case 33: 
                case 36: {
                    nextStmt = nextStmt.getNextStmt();
                    continue block14;
                }
                case 35: {
                    if (this.LoopSearch(((BlockStmt)nextStmt).getFirstStmt(), pTable, LoopNestLevel)) {
                        ForExist = true;
                    }
                    nextStmt = nextStmt.getNextStmt();
                    continue block14;
                }
                case 22: {
                    nextStmt = nextStmt.getNextStmt();
                    continue block14;
                }
                case 34: {
                    nextStmt = nextStmt.getNextStmt();
                    continue block14;
                }
                case 15: {
                    nextStmt = nextStmt.getNextStmt();
                    continue block14;
                }
            }
            nextStmt = nextStmt.getNextStmt();
        }
        return ForExist;
    }

    private LoopTable SetLoopInfo(ForStmt pstmt, LoopTable pTable) {
        LoopTable lTable = new LoopTable(pstmt, this.fSubpFlow);
        if (pTable == null) {
            this.fLoopInfo.add(lTable);
        }
        if (pTable != null) {
            pTable.InnerLoopList.add(lTable);
            pTable.InnerLoop = false;
            lTable.OuterLoop = pTable;
            lTable.fNestLevel = pTable.fNestLevel + 1;
        }
        return lTable;
    }

    private void Trace(String s, int n) {
        this.fResults.flowRoot.hirRoot.ioRoot.dbgPara1.print(n, "//" + s + "\n");
    }
}

