/*
 * Decompiled with CFR 0.152.
 */
package coins.ir.hir;

import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.SubscriptedExp;
import coins.ir.hir.VarNode;
import coins.sym.Type;
import coins.sym.VectorType;
import java.util.ArrayList;
import java.util.Map;

public class SubsPtrTransformation {
    IoRoot ioRoot;
    HirRoot hirRoot;
    SymRoot symRoot;
    protected final int fDbgLevel;

    public SubsPtrTransformation(HirRoot pHirRoot) {
        this.hirRoot = pHirRoot;
        this.symRoot = this.hirRoot.symRoot;
        this.ioRoot = this.hirRoot.ioRoot;
        this.fDbgLevel = this.ioRoot.dbgHir.getLevel();
    }

    public ArrayList listUpSubsNodes(HIR pHir) {
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgHir.print(2, "listUpSubsNodes", pHir.toStringShort());
        }
        ArrayList<HIR> lSubsNodeList = new ArrayList<HIR>(300);
        HirIterator lIterator = this.hirRoot.hir.hirIterator(pHir);
        while (lIterator.hasNext()) {
            HIR lHir = lIterator.next();
            if (!(lHir instanceof SubscriptedExp)) continue;
            lSubsNodeList.add(lHir);
        }
        return lSubsNodeList;
    }

    public boolean subsToPtrTrasnsformation(HIR pHir, Map pPtrSubsCorrespondence) {
        HIR hir = this.hirRoot.hir;
        HIR lResult = pHir;
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgHir.print(2, "subsToPtrTransformation", pHir.toStringShort());
        }
        ArrayList lSubsNodeList = this.listUpSubsNodes(pHir);
        for (int i = lSubsNodeList.size() - 1; i >= 0; --i) {
            SubscriptedExp lSubscriptedExp = (SubscriptedExp)lSubsNodeList.get(i);
            Exp lVectorVarExp = (Exp)((HIR)lSubscriptedExp.getChild1()).copyWithOperands();
            Exp lSubscriptExp = (Exp)((HIR)lSubscriptedExp.getChild2()).copyWithOperands();
            Type lElemType = lSubscriptedExp.getType();
            Exp lSizeExp = (Exp)lElemType.getSizeExp().copyWithOperands();
            Exp lOffsetExp = hir.exp(41, lSubscriptExp, lSizeExp);
            Exp lPointerExp = hir.exp(68, hir.exp(38, hir.exp(66, lVectorVarExp), lOffsetExp));
            pPtrSubsCorrespondence.put(lPointerExp, lSubscriptedExp);
            lSubscriptedExp.replaceThisNode(lPointerExp);
        }
        if (this.fDbgLevel >= 4) {
            this.ioRoot.dbgHir.print(4, "Result of subsToPtrTransformation of", ((Object)pHir).toString());
            lResult.print(1, true);
        }
        return !lSubsNodeList.isEmpty();
    }

    public boolean ptrToSubsTransformation(HIR pHir, Map pPtrSubsCorrespondence) {
        HIR lResult = pHir;
        HIR hir = this.hirRoot.hir;
        if (pPtrSubsCorrespondence == null) {
            return false;
        }
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgHir.print(2, "ptrToSubsTransformation", pHir.toStringShort());
            this.ioRoot.dbgHir.print(3, "PtrSubsCorrespondence", pPtrSubsCorrespondence.toString());
        }
        ArrayList lPtrNodesList = this.listUpPtrNodes(pHir);
        for (int i = lPtrNodesList.size() - 1; i >= 0; --i) {
            Exp lPtrNode = (Exp)lPtrNodesList.get(i);
            if (!pPtrSubsCorrespondence.containsKey(lPtrNode) && !(lPtrNode.getChild1().getChild1().getChild1() instanceof VarNode)) continue;
            Exp lVarExp = (Exp)((HIR)lPtrNode.getChild1().getChild1().getChild1());
            Exp lVarExpCopied = (Exp)lVarExp.copyWithOperands();
            Exp lIndexExp = (Exp)((HIR)lPtrNode.getChild1().getChild2().getChild1());
            Exp lIndexExpCopied = (Exp)lIndexExp.copyWithOperands();
            SubscriptedExp lSubscriptedExp = hir.subscriptedExp(lVarExpCopied, lIndexExpCopied);
            lPtrNode.replaceThisNode(lSubscriptedExp);
        }
        if (this.fDbgLevel >= 4) {
            this.ioRoot.dbgHir.print(4, "Result of ptrToSubsTransformation of", ((Object)pHir).toString());
            lResult.print(1, true);
        }
        return !lPtrNodesList.isEmpty();
    }

    public ArrayList listUpPtrNodes(HIR pHir) {
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgHir.print(2, "listUpPtrNodes", pHir.toStringShort());
        }
        ArrayList<HIR> lPtrNodeList = new ArrayList<HIR>(300);
        HirIterator lIterator = this.hirRoot.hir.hirIterator(pHir);
        while (lIterator.hasNext()) {
            HIR lHir = lIterator.next();
            if (lHir == null || lHir.getOperator() != 68 || lHir.getChild1().getOperator() != 38 || lHir.getChild1().getChild1().getOperator() != 66 || lHir.getChild1().getChild2().getOperator() != 41 || !(((HIR)lHir.getChild1().getChild1().getChild1()).getType() instanceof VectorType)) continue;
            lPtrNodeList.add(lHir);
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgHir.print(4, "contents-nodes list", lPtrNodeList.toString());
        }
        return lPtrNodeList;
    }
}

