/*
 * Decompiled with CFR 0.152.
 */
package coins.ir.hir;

import coins.CompileError;
import coins.HirRoot;
import coins.IoRoot;
import coins.flow.LoopInf;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.ForStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HIR_Impl;
import coins.ir.hir.HirVisitor;
import coins.ir.hir.IfStmt;
import coins.ir.hir.IndexedLoopStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.RepeatStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.StmtImpl;
import coins.ir.hir.UntilStmt;
import coins.ir.hir.WhileStmt;
import coins.sym.Label;

public abstract class LoopStmtImpl
extends StmtImpl
implements LoopStmt {
    Label fLoopBackLabel;
    Label fLoopStepLabel;
    Label fLoopEndLabel;
    LoopInf fLoopInf = null;
    private BlockStmt fConditionalInitBlock = null;

    public LoopStmtImpl() {
    }

    public LoopStmtImpl(HirRoot pHirRoot) {
        super(pHirRoot);
    }

    public void setChildrenOfLoop(Stmt pInitPart, Label pLoopBackLabel, Stmt pConditionalInitPart, Exp pStartCondition, Stmt pLoopBody, Label pLoopStepLabel, Exp pEndCondition, Stmt pLoopStepPart, Label pLoopEndLabel, Stmt pLoopEndPart) {
        BlockStmt lLoopBodyBlock;
        LabeledStmt lLoopBackPoint = null;
        LabeledStmt lLoopBodyPoint = null;
        Object lEndConditionPoint = null;
        LabeledStmt lLoopStepPoint = null;
        LabeledStmt lLoopEndPoint = null;
        this.fLoopBackLabel = pLoopBackLabel;
        if (this.fLoopBackLabel == null) {
            this.fLoopBackLabel = this.hirRoot.symRoot.symTableCurrent.generateLabel();
        }
        this.fLoopBackLabel.setLabelKind(6);
        this.fLoopBackLabel.setOriginHir(this);
        lLoopBackPoint = pStartCondition == null ? this.hirRoot.hir.labeledStmt(this.fLoopBackLabel, null) : this.hirRoot.hir.labeledStmt(this.fLoopBackLabel, this.hirRoot.hir.expStmt(pStartCondition));
        Stmt lLoopBody = pLoopBody;
        if (pLoopBody == null) {
            lLoopBody = this.hirRoot.hir.blockStmt(null);
        }
        if (lLoopBody.getOperator() != 21 || lLoopBody.getLabel().getLabelKind() != 7) {
            Label lLoopBodyLabel = this.hirRoot.symRoot.symTableCurrent.generateLabel();
            lLoopBodyLabel.setLabelKind(7);
            lLoopBodyLabel.setOriginHir(this);
            lLoopBodyBlock = this.hirRoot.hir.blockStmt(lLoopBody);
            lLoopBodyPoint = this.hirRoot.hir.labeledStmt(lLoopBodyLabel, lLoopBodyBlock);
        } else {
            Stmt lLoopBody2 = ((LabeledStmt)lLoopBody).getStmt();
            if (lLoopBody2 != null) {
                lLoopBody2.cutParentLink();
            }
            lLoopBodyBlock = this.hirRoot.hir.blockStmt(lLoopBody2);
            ((LabeledStmt)lLoopBody).setStmt(lLoopBodyBlock);
            lLoopBodyPoint = (LabeledStmt)lLoopBody;
        }
        this.fLoopStepLabel = pLoopStepLabel;
        if (this.fLoopStepLabel == null) {
            this.fLoopStepLabel = this.hirRoot.symRoot.symTableCurrent.generateLabel();
        }
        this.fLoopStepLabel.setLabelKind(8);
        this.fLoopStepLabel.setOriginHir(this);
        lLoopStepPoint = this.hirRoot.hir.labeledStmt(this.fLoopStepLabel, null);
        lLoopBodyBlock.addLastStmt(lLoopStepPoint);
        ExpStmt lEndConditionStmt = this.hirRoot.hir.expStmt(pEndCondition);
        this.fLoopEndLabel = pLoopEndLabel;
        if (this.fLoopEndLabel == null) {
            this.fLoopEndLabel = this.hirRoot.symRoot.symTableCurrent.generateLabel();
        }
        this.fLoopEndLabel.setLabelKind(21);
        this.fLoopEndLabel.setOriginHir(this);
        lLoopEndPoint = pLoopEndPart == null ? this.hirRoot.hir.labeledStmt(this.fLoopEndLabel, null) : (pLoopEndPart.getOperator() != 21 ? this.hirRoot.hir.labeledStmt(this.fLoopEndLabel, pLoopEndPart) : (LabeledStmt)pLoopEndPart);
        this.fAdditionalChild = new HIR[6];
        this.fChildCount = 7;
        this.setChildren(pInitPart, pConditionalInitPart, lLoopBackPoint, lLoopBodyPoint, lEndConditionStmt);
        this.fAdditionalChild[3] = pLoopStepPart;
        this.fAdditionalChild[4] = lLoopEndPoint;
        if (pLoopStepPart != null) {
            ((HIR_Impl)((Object)pLoopStepPart)).fParentNode = this;
        }
        ((HIR_Impl)((Object)lLoopEndPoint)).fParentNode = this;
        if (pConditionalInitPart != null) {
            Exp lInitCondition = pStartCondition != null ? (Exp)pStartCondition.copyWithOperandsChangingLabels(null) : null;
            Stmt lConditionalInitPart = this.makeConditionalInitPart(lInitCondition, pConditionalInitPart);
            Label lConditionalInitLabel = lConditionalInitPart.getLabel();
            lConditionalInitLabel.setLabelKind(5);
            lConditionalInitLabel.setOriginHir(this);
            this.setChild2(lConditionalInitPart);
        }
        this.fMultiBlock = true;
        if (this.fDbgLevel > 6) {
            this.hirRoot.ioRoot.dbgHir.print(7, "LoopStmtImpl", this.toStringWithChildren());
        }
    }

    public Stmt getLoopInitPart() {
        return (Stmt)this.fChildNode1;
    }

    public BlockStmt getConditionalInitPart() {
        return this.fConditionalInitBlock;
    }

    public Stmt getConditionalInitPart2() {
        return this.fConditionalInitBlock;
    }

    public Exp getLoopStartCondition() {
        Exp lResult = null;
        LabeledStmt lLoopBackPoint = (LabeledStmt)this.getChild(3);
        if (lLoopBackPoint != null && lLoopBackPoint.getStmt() != null) {
            Stmt lLoopBackStmt = lLoopBackPoint.getStmt();
            if (lLoopBackStmt instanceof LabeledStmt) {
                lLoopBackStmt = ((LabeledStmt)lLoopBackStmt).getStmt();
            }
            if (lLoopBackStmt instanceof ExpStmt) {
                lResult = ((ExpStmt)lLoopBackStmt).getExp();
            }
        }
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(5, " getLoopStartCondition " + lResult);
        }
        return lResult;
    }

    public LabeledStmt getLoopBackPoint() {
        return (LabeledStmt)this.fAdditionalChild[0];
    }

    public Stmt getLoopBodyPart() {
        return (Stmt)this.fAdditionalChild[1];
    }

    public Exp getLoopEndCondition() {
        Exp lResult = null;
        HIR lEndConditionPoint = (HIR)this.fAdditionalChild[2];
        if (lEndConditionPoint != null) {
            LabeledStmt lLabeledStmt;
            if (lEndConditionPoint.getOperator() == 36) {
                lResult = ((ExpStmt)lEndConditionPoint).getExp();
            } else if (lEndConditionPoint instanceof Exp) {
                lResult = (Exp)lEndConditionPoint;
            } else if (lEndConditionPoint instanceof LabeledStmt && (lLabeledStmt = (LabeledStmt)lEndConditionPoint).getStmt() instanceof ExpStmt) {
                lResult = ((ExpStmt)lLabeledStmt.getStmt()).getExp();
            }
        }
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(5, " getLoopEndCondition " + lResult);
        }
        return lResult;
    }

    public Stmt getLoopStepPart() {
        return (Stmt)this.fAdditionalChild[3];
    }

    public LabeledStmt getLoopEndPart() {
        return (LabeledStmt)this.fAdditionalChild[4];
    }

    public Label getLoopBackLabel() {
        return this.getLoopBackPoint().getLabel();
    }

    public Label getLoopBodyLabel() {
        if (this.fAdditionalChild[1] instanceof LabeledStmt) {
            return ((LabeledStmt)this.fAdditionalChild[1]).getLabel();
        }
        return null;
    }

    public Label getLoopStepLabel() {
        return this.fLoopStepLabel;
    }

    private LabeledStmt getLoopStepLabeledStmt() {
        Stmt lLoopBody = this.getLoopBodyPart();
        if (lLoopBody != null) {
            Stmt lLoopStepLabeledStmt;
            Stmt lLoopBodyBlock = lLoopBody;
            if (lLoopBody instanceof LabeledStmt) {
                lLoopBodyBlock = ((LabeledStmt)lLoopBody).getStmt();
            }
            if (lLoopBodyBlock instanceof BlockStmt && (lLoopStepLabeledStmt = ((BlockStmt)lLoopBodyBlock).getLastStmt()) instanceof LabeledStmt) {
                return (LabeledStmt)lLoopStepLabeledStmt;
            }
        }
        return null;
    }

    public Label getLoopEndLabel() {
        return this.getLoopEndPart().getLabel();
    }

    public LoopInf getLoopInf() {
        return this.fLoopInf;
    }

    public void setLoopInf(LoopInf pLoopInf) {
        this.fLoopInf = pLoopInf;
    }

    public void addToLoopInitPart(Stmt pStmt) {
        if (pStmt == null) {
            return;
        }
        pStmt.cutParentLink();
        Stmt lStmt = this.getLoopInitPart();
        Stmt lNewStmt = lStmt == null ? (Stmt)pStmt.copyWithOperands() : ((Stmt)lStmt.copyWithOperands()).combineStmt(pStmt, true);
        this.replaceSource(1, lNewStmt);
    }

    public void addToConditionalInitPart(Stmt pStmt) {
        if (pStmt == null) {
            return;
        }
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(4, "addToConditionalInitPart", pStmt.toStringWithChildren());
        }
        if (this.getLoopStartCondition() == null) {
            if (this.fConditionalInitBlock == null) {
                this.fConditionalInitBlock = this.hirRoot.hir.blockStmt(pStmt);
                this.addToLoopInitPart(this.fConditionalInitBlock);
            } else {
                this.fConditionalInitBlock.addLastStmt(pStmt);
            }
            return;
        }
        Object lStmt3 = null;
        if (this.fConditionalInitBlock == null) {
            this.addConditionalInitToLoopInit(pStmt);
        } else {
            Stmt lNewConditionalInit = this.fConditionalInitBlock.combineStmt(pStmt, true);
            if (lNewConditionalInit != this.fConditionalInitBlock) {
                this.fConditionalInitBlock.replaceThisNode(lNewConditionalInit);
            }
        }
    }

    private void addConditionalInitToLoopInit(Stmt pConditionalInitPart) {
        if (this.fDbgLevel > 3) {
            IoRoot cfr_ignored_0 = this.hirRoot.ioRoot;
            this.hirRoot.ioRoot.dbgHir.print(4, "addConditionalInitToLoopInit", IoRoot.toStringObject(pConditionalInitPart));
        }
        if (pConditionalInitPart == null) {
            return;
        }
        Label lLoopBodyLabel = this.getLoopBodyLabel();
        Label lLoopEndLabel = this.getLoopEndLabel();
        BlockStmt lThenBlock = this.fConditionalInitBlock;
        if (lThenBlock == null) {
            lThenBlock = this.hirRoot.hir.blockStmt(pConditionalInitPart);
            lThenBlock.addLastStmt(this.hirRoot.hir.jumpStmt(lLoopBodyLabel));
            this.fConditionalInitBlock = lThenBlock;
            Exp lStartCondition = this.getLoopStartCondition();
            if (lStartCondition == null) {
                lStartCondition = this.hirRoot.hir.trueNode();
            }
            IfStmt lConditionalInitIfStmt = this.hirRoot.hir.ifStmt((Exp)lStartCondition.copyWithOperands(), lThenBlock, this.hirRoot.hir.jumpStmt(lLoopEndLabel));
            Stmt lLoopInitPart = this.getLoopInitPart();
            if (lLoopInitPart == null) {
                this.setChild1(lConditionalInitIfStmt);
            } else if (lLoopInitPart instanceof BlockStmt) {
                ((BlockStmt)lLoopInitPart).addLastStmt(lConditionalInitIfStmt);
            } else {
                Stmt lCombinedLoopInitPart = ((Stmt)lLoopInitPart.copyWithOperands()).combineStmt(lConditionalInitIfStmt, true);
                this.replaceSource1(lCombinedLoopInitPart);
            }
        } else {
            lThenBlock.addBeforeBranchStmt(pConditionalInitPart);
        }
        this.setFlag(5, true);
        if (this.fDbgLevel > 3) {
            IoRoot cfr_ignored_1 = this.hirRoot.ioRoot;
            IoRoot cfr_ignored_2 = this.hirRoot.ioRoot;
            this.hirRoot.ioRoot.dbgHir.print(4, "init " + IoRoot.toStringObject(this.getLoopInitPart()) + " then " + IoRoot.toStringObject(this.fConditionalInitBlock));
        }
    }

    protected Stmt makeConditionalInitPart(Exp pStartCondition, Stmt pConditionalInitPart) {
        Label lLoopBodyLabel = this.getLoopBodyLabel();
        Label lLoopEndLabel = this.getLoopEndLabel();
        Label lConditionalInitLabel = this.hirRoot.symRoot.symTableCurrent.generateLabel();
        BlockStmt lThenBlock = this.hirRoot.hir.blockStmt(pConditionalInitPart);
        lThenBlock.addLastStmt(this.hirRoot.hir.jumpStmt(lLoopBodyLabel));
        Exp lStartCondition = pStartCondition;
        if (lStartCondition == null) {
            lStartCondition = this.hirRoot.hir.trueNode();
        }
        LabeledStmt lConditionalInitStmt = this.hirRoot.hir.labeledStmt(lConditionalInitLabel, this.hirRoot.hir.ifStmt(lStartCondition, lThenBlock, this.hirRoot.hir.jumpStmt(lLoopEndLabel)));
        if (this.fDbgLevel > 3) {
            IoRoot cfr_ignored_0 = this.hirRoot.ioRoot;
            this.hirRoot.ioRoot.dbgHir.print(4, "makeConditionalInitPart", IoRoot.toStringObject(lConditionalInitStmt));
        }
        return lConditionalInitStmt;
    }

    public void addToLoopBodyPart(Stmt pStmt) {
        if (pStmt == null) {
            return;
        }
        pStmt.cutParentLink();
        Stmt lLoopBodyPartStmt = this.getLoopBodyPart();
        if (lLoopBodyPartStmt instanceof LabeledStmt) {
            lLoopBodyPartStmt = ((LabeledStmt)lLoopBodyPartStmt).getStmt();
        }
        LabeledStmt lStepLabeledStmt = this.getLoopStepLabeledStmt();
        if (lLoopBodyPartStmt instanceof BlockStmt && lStepLabeledStmt.getParent() == lLoopBodyPartStmt) {
            lStepLabeledStmt.insertPreviousStmt(pStmt);
            return;
        }
        Stmt lNewStmt = lLoopBodyPartStmt.combineStmt(pStmt, false);
        if (lNewStmt != lLoopBodyPartStmt) {
            if (lLoopBodyPartStmt instanceof LabeledStmt) {
                lLoopBodyPartStmt.setChild1(lNewStmt);
            } else {
                lLoopBodyPartStmt.replaceThisStmtWith(lNewStmt);
            }
        }
    }

    public void addToLoopStepPart(Stmt pStmt) {
        if (pStmt == null) {
            return;
        }
        pStmt.cutParentLink();
        Stmt lStmt = this.getLoopStepPart();
        if (lStmt == null) {
            this.setChild(6, pStmt);
        } else if (lStmt instanceof BlockStmt) {
            ((BlockStmt)lStmt).addBeforeBranchStmt(pStmt);
        } else if (lStmt instanceof LabeledStmt) {
            LabeledStmt lLabeledStmt = (LabeledStmt)lStmt;
            if (lLabeledStmt.getStmt() == null) {
                lLabeledStmt.setStmt(pStmt);
            } else {
                lLabeledStmt.getStmt().combineStmt(pStmt, true);
            }
        }
    }

    public void addToLoopEndPart(Stmt pStmt) {
        if (pStmt == null) {
            return;
        }
        pStmt.cutParentLink();
        LabeledStmt lStmt = this.getLoopEndPart();
        Stmt lNewStmt = lStmt.combineStmt(pStmt, false);
        if (lNewStmt != lStmt) {
            this.replaceSource(7, lStmt);
        }
    }

    public void setLoopStartCondition(Exp pCondition) {
        LabeledStmt lLoopBackPoint = (LabeledStmt)this.fAdditionalChild[0];
        if (lLoopBackPoint != null) {
            if (lLoopBackPoint.getStmt() == null) {
                lLoopBackPoint.setStmt(this.hirRoot.hir.expStmt(pCondition));
            } else if (lLoopBackPoint.getStmt().getOperator() == 36) {
                ((ExpStmt)lLoopBackPoint.getStmt()).setExp(pCondition);
            } else {
                lLoopBackPoint.setStmt(this.hirRoot.hir.expStmt(pCondition));
            }
        }
    }

    public void setLoopEndCondition(Exp pCondition) {
        ExpStmt lEndConditionPoint = (ExpStmt)this.fAdditionalChild[2];
        if (lEndConditionPoint != null && lEndConditionPoint.getOperator() == 36) {
            lEndConditionPoint.setExp(pCondition);
        }
    }

    public void replaceConditionalInitPart(LabeledStmt pNewStmt) throws CompileError {
        if (this.getConditionalInitPart() != null) {
            this.getConditionalInitPart().getLabel().setLabelKind(0);
        }
        if (pNewStmt == null) {
            this.replaceSource2(pNewStmt);
            return;
        }
        try {
            Stmt lStmtBody = pNewStmt.getStmt();
            Label lLabel = pNewStmt.getLabel();
            if (lStmtBody == null || lStmtBody.getOperator() != 23) {
                throw new CompileError(1211, "ConditionalInitPart does not take if-statement form");
            }
            this.replaceSource2(pNewStmt);
            lLabel.setLabelKind(5);
            lLabel.setOriginHir(this);
        }
        catch (CompileError error) {
            this.hirRoot.ioRoot.msgRecovered.put(error.getMessage());
        }
    }

    public void replaceBodyPart(LabeledStmt pNewStmt) {
        BlockStmt lLoopBodyBlock;
        if (this.getLoopBodyPart() != null) {
            this.getLoopBodyPart().getLabel().setLabelKind(0);
        }
        Label lLabel = pNewStmt.getLabel();
        Stmt lLoopBodyStmt = pNewStmt.getStmt();
        if (lLoopBodyStmt instanceof BlockStmt) {
            lLoopBodyBlock = (BlockStmt)lLoopBodyStmt;
        } else {
            lLoopBodyBlock = this.hirRoot.hir.blockStmt(lLoopBodyStmt);
            pNewStmt.setChild1(lLoopBodyBlock);
        }
        this.replaceSource(4, pNewStmt);
        lLabel.setLabelKind(7);
        lLabel.setOriginHir(this);
        LabeledStmt lLoopStepLabeledStmt = this.getLoopStepLabeledStmt();
        if (lLoopStepLabeledStmt == null) {
            Label lLoopStepLabel = this.hirRoot.symRoot.symTableCurrent.generateLabel();
            lLoopStepLabel.setLabelKind(8);
            lLoopStepLabel.setOriginHir(this);
            this.fLoopStepLabel = lLoopStepLabel;
            lLoopStepLabeledStmt = this.hirRoot.hir.labeledStmt(this.fLoopStepLabel, null);
            lLoopBodyBlock.addLastStmt(lLoopStepLabeledStmt);
        }
    }

    public boolean isSimpleForLoop() {
        return this instanceof ForStmt && this.isEmpty((HIR)this.getChild2()) && this.isEmpty((HIR)this.getChild(5));
    }

    public boolean isSimpleWhileLoop() {
        return this instanceof WhileStmt && this.isEmpty((HIR)this.getChild1()) && this.isEmpty((HIR)this.getChild2()) && this.isEmpty((HIR)this.getChild(5)) && this.isEmpty((HIR)this.getChild(6));
    }

    public boolean isSimpleRepeatLoop() {
        return this instanceof RepeatStmt && this.isEmpty((HIR)this.getChild1()) && this.isEmpty((HIR)this.getChild2()) && this.isEmpty((HIR)this.getChild(3)) && this.isEmpty((HIR)this.getChild(6));
    }

    public boolean isSimpleUntilLoop() {
        return this instanceof UntilStmt && this.isEmpty((HIR)this.getChild1()) && this.isEmpty((HIR)this.getChild2()) && this.isEmpty((HIR)this.getChild(3)) && this.isEmpty((HIR)this.getChild(6));
    }

    public boolean isSimpleIndexedLoop() {
        return this instanceof IndexedLoopStmt && this.isEmpty((HIR)this.getChild2()) && this.isEmpty((HIR)this.getChild(5));
    }

    public boolean isLoopStmt() {
        return true;
    }

    public void combineWithConditionalExp(Stmt pStmt, HIR pCond) {
        LabeledStmt lStartConditionPart = (LabeledStmt)this.getChild(3);
        ExpStmt lEndConditionPart = (ExpStmt)this.getChild(5);
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(4, "combineWithConditionalExp ", this.toStringShort() + " " + pStmt.toStringWithChildren() + " Condition " + pCond.toStringWithChildren() + " StartCond " + lStartConditionPart + " EndCond " + lEndConditionPart + "\n");
        }
        if (lStartConditionPart != null && lStartConditionPart.getStmt() != null && lStartConditionPart.getStmt().contains(pCond)) {
            Stmt lInitiationPart = this.getLoopInitPart();
            if (lInitiationPart == null) {
                this.setChild(1, pStmt);
            } else {
                Stmt lOriginalStmt = lInitiationPart;
                Stmt lResultStmt = lInitiationPart.combineStmt(pStmt, true);
                lOriginalStmt.cutParentLink();
                this.setChild1(lResultStmt);
            }
            if (this.fDbgLevel > 3) {
                this.hirRoot.ioRoot.dbgHir.print(4, "StartConditionPart contains " + pCond.toStringShort(), "modifiedInitPart " + this.getLoopInitPart());
            }
            this.addToLoopStepPart((Stmt)pStmt.copyWithOperands());
            if (this.fDbgLevel > 3) {
                this.hirRoot.ioRoot.dbgHir.print(4, " modifiedStepPart " + this.getLoopStepPart().toStringWithChildren());
            }
        } else if (lEndConditionPart.contains(pCond)) {
            LabeledStmt lLoopStepLabeledStmt;
            if (this.fDbgLevel > 3) {
                this.hirRoot.ioRoot.dbgHir.print(4, "EndConditionPart contains ", pCond.toStringShort() + " Add to loop step part.");
            }
            if ((lLoopStepLabeledStmt = this.getLoopStepLabeledStmt()) != null) {
                lLoopStepLabeledStmt.combineStmt(pStmt, true);
                if (this.fDbgLevel > 3) {
                    this.hirRoot.ioRoot.dbgHir.print(4, " modifiedStepPart " + this.getLoopStepLabeledStmt());
                }
            } else {
                this.hirRoot.ioRoot.msgRecovered.put(5024, "combineWithConditionalExp got null from getLoopStepLabeledStmt() " + this);
            }
        } else {
            this.hirRoot.ioRoot.msgRecovered.put(5024, "combineWithConditionalExp has illegal ExpStmt parameter " + pCond);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        LoopStmt lTree;
        try {
            lTree = (LoopStmt)super.clone();
        }
        catch (CloneNotSupportedException e) {
            this.hirRoot.ioRoot.msgRecovered.put(1100, "CloneNotSupportedException(LoopStmtImpl) " + this.toString());
            return null;
        }
        ((LoopStmtImpl)lTree).fLoopBackLabel = this.fLoopBackLabel;
        ((LoopStmtImpl)lTree).fLoopStepLabel = this.fLoopStepLabel;
        ((LoopStmtImpl)lTree).fLoopEndLabel = this.fLoopEndLabel;
        return lTree;
    }

    public HIR copyWithOperandsChangingLabels(IrList pLabelCorrespondence) {
        LoopStmtImpl lTree = (LoopStmtImpl)super.copyWithOperandsChangingLabels(pLabelCorrespondence);
        lTree.fLoopBackLabel = ((Stmt)lTree.getChild(3)).getLabel();
        Stmt lLoopBody = lTree.getLoopBodyPart();
        if (lLoopBody instanceof LabeledStmt) {
            lLoopBody = ((LabeledStmt)lLoopBody).getStmt();
        }
        lTree.fLoopStepLabel = null;
        if (lLoopBody instanceof BlockStmt) {
            lTree.fLoopStepLabel = ((BlockStmt)lLoopBody).getLastStmt().getLabel();
        }
        if (lTree.fLoopStepLabel == null) {
            lTree.fLoopStepLabel = ((Stmt)lTree.getChild(5)).getLabel();
        }
        lTree.fLoopEndLabel = ((Stmt)lTree.getChild(7)).getLabel();
        return lTree;
    }

    public void accept(HirVisitor pVisitor) {
        pVisitor.atLoopStmt(this);
    }
}

