/*
 * Decompiled with CFR 0.152.
 */
package coins.ir.hir;

import coins.HasStringObject;
import coins.HirRoot;
import coins.ir.IrList;
import coins.ir.IrListImpl;
import coins.ir.hir.HIR;
import coins.ir.hir.HirList;
import coins.sym.ExpId;
import coins.sym.FlagBox;
import coins.sym.FlagBoxImpl;
import coins.sym.Sym;
import java.util.ListIterator;

public class HirAnnex {
    public final HirRoot hirRoot;
    protected FlagBox fFlagBox;
    protected int fIndexNo;
    protected ExpId fExpId = null;
    protected IrList fInfList = null;
    protected Object fWork;

    public HirAnnex(HirRoot pHirRoot) {
        this.hirRoot = pHirRoot;
    }

    boolean getFlag(int pFlagNumber) {
        if (this.fFlagBox == null) {
            return false;
        }
        return this.fFlagBox.getFlag(pFlagNumber);
    }

    void setFlag(int pFlagNumber, boolean pYesNo) {
        if (this.fFlagBox == null) {
            this.fFlagBox = new FlagBoxImpl();
        }
        this.fFlagBox.setFlag(pFlagNumber, pYesNo);
    }

    public boolean flagsAreAllFalse() {
        if (this.fFlagBox == null) {
            return true;
        }
        return this.fFlagBox.allFalse();
    }

    public FlagBox getFlagBox() {
        return this.fFlagBox;
    }

    public void addInf(String pInfKindInterned, Object pInfObject) {
        IrList lObjList;
        if (pInfObject instanceof IrList || pInfObject instanceof HirList) {
            lObjList = (IrList)pInfObject;
        } else {
            lObjList = new IrListImpl(this.hirRoot);
            lObjList.add(pInfObject);
        }
        if (this.fInfList == null) {
            this.fInfList = new IrListImpl(this.hirRoot);
            this.fInfList.add(pInfKindInterned);
            this.fInfList.add(lObjList);
        } else if (this.fInfList.contains(pInfKindInterned)) {
            lObjList = (IrList)this.fInfList.get(this.fInfList.indexOf(pInfKindInterned) + 1);
            lObjList.remove(0);
            lObjList.set(0, pInfObject);
        } else {
            this.fInfList.add(pInfKindInterned);
            this.fInfList.add(lObjList);
        }
    }

    public Object getInf(String pInfKindInterned) {
        if (this.fInfList == null) {
            return null;
        }
        int lIndex = this.fInfList.indexOf(pInfKindInterned);
        if (lIndex < 0) {
            return null;
        }
        IrList lInfList = (IrList)this.fInfList.get(lIndex + 1);
        if (lInfList == null) {
            return null;
        }
        if (lInfList.isEmpty()) {
            return null;
        }
        return lInfList;
    }

    public void removeInf(String pInfKindInterned) {
        if (this.fInfList == null) {
            return;
        }
        int lIndex = this.fInfList.indexOf(pInfKindInterned);
        if (lIndex >= 0) {
            this.fInfList.remove(lIndex + 1);
            this.fInfList.remove(lIndex);
        }
    }

    public IrList getInfList() {
        return this.fInfList;
    }

    public void setWork(Object pWork) {
        this.fWork = pWork;
    }

    public Object getWork() {
        return this.fWork;
    }

    public int getIndex() {
        return this.fIndexNo;
    }

    public void setIndex(int pIndex) {
        this.fIndexNo = pIndex;
    }

    public Object clone() throws CloneNotSupportedException {
        HirAnnex lAnnex;
        try {
            lAnnex = (HirAnnex)super.clone();
            if (this.fFlagBox != null) {
                lAnnex.fFlagBox = new FlagBoxImpl();
            }
            lAnnex.fIndexNo = 0;
            lAnnex.fExpId = this.fExpId;
            lAnnex.fWork = this.fWork;
            if (this.hirRoot.ioRoot.dbgHir.getLevel() > 4) {
                this.hirRoot.ioRoot.dbgHir.print(6, " lAnnex.work " + lAnnex.fWork);
            }
            if (this.fInfList != null) {
                lAnnex.fInfList = (IrList)((Object)((HIR)((Object)this.fInfList)).copyWithOperands());
            }
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return lAnnex;
    }

    public String toString() {
        StringBuffer lBuffer = new StringBuffer(" " + this.fIndexNo);
        if (this.fExpId != null) {
            lBuffer.append(" ").append(this.fExpId.getName());
        }
        if (this.fFlagBox != null) {
            lBuffer.append(" " + ((Object)this.fFlagBox).toString());
        }
        if (this.fInfList != null) {
            lBuffer.append(this.toStringInfList(this.fInfList));
        }
        return lBuffer.toString();
    }

    public String toStringInf() {
        StringBuffer lBuffer = new StringBuffer("inf ");
        if (this.fInfList != null) {
            lBuffer.append(this.toStringInfList(this.fInfList));
        }
        return lBuffer.toString();
    }

    protected String toStringInfList(IrList pInfList) {
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append(" (list ");
        ListIterator listIterator = pInfList.iterator();
        while (listIterator.hasNext()) {
            Object lObject = listIterator.next();
            if (lObject instanceof String) {
                lBuffer.append((String)lObject + " ");
                continue;
            }
            if (lObject instanceof IrList) {
                lBuffer.append(this.toStringInfList((IrList)lObject)).append(" ");
                continue;
            }
            if (lObject instanceof HirList) {
                lBuffer.append(this.toStringInfList((IrList)lObject)).append(" ");
                continue;
            }
            if (lObject instanceof HIR) {
                lBuffer.append("<" + ((HIR)lObject).toStringShort() + "> ");
                continue;
            }
            if (lObject instanceof Sym) {
                lBuffer.append(((Sym)lObject).getName() + " ");
                continue;
            }
            if (lObject instanceof HasStringObject) {
                lBuffer.append(((Object)((HasStringObject)lObject)).toString()).append(" ");
                continue;
            }
            if (lObject == null) continue;
            lBuffer.append(" " + lObject + " " + lObject.getClass());
        }
        lBuffer.append(")");
        return lBuffer.toString();
    }
}

