/*
 * Decompiled with CFR 0.152.
 */
package coins.hir2c;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.PassException;
import coins.SymRoot;
import coins.cfront.Cfront;
import coins.driver.CommandLine;
import coins.driver.CompileSpecification;
import coins.driver.CompilerDriver;
import coins.driver.Trace;
import coins.hir2c.HirBaseToCImpl;
import coins.ir.hir.HIR;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.ParseException;

public class Hir2C
extends Cfront {
    private void makeCSourceFromHirBase(HirRoot hirRoot, SymRoot symRoot, IoRoot ioRoot) {
        Trace trace = ioRoot.getCompileSpecification().getTrace();
        HirBaseToCImpl HirToC = new HirBaseToCImpl(hirRoot, symRoot, ioRoot.printOut, trace);
        HirToC.Converter();
    }

    public void compile(File sourceFile, InputStream in, OutputStream out, IoRoot pio) throws IOException, PassException {
        CompileSpecification spec = pio.getCompileSpecification();
        boolean hirAnal = spec.getCoinsOptions().isSet("hirAnal");
        boolean lirAnal = spec.getCoinsOptions().isSet("lirAnal");
        IoRoot io = new IoRoot(sourceFile, System.out, new PrintStream(out), System.err, spec);
        SymRoot symRoot = new SymRoot(io);
        HirRoot hirRoot = new HirRoot(symRoot);
        symRoot.attachHirRoot(hirRoot);
        symRoot.initiate();
        hirRoot.programRoot = this.makeHirCFromCSource(hirRoot, in, io);
        spec.getTrace().trace(this.myName, 5000, "compile(1)");
        hirRoot.programRoot = this.makeHirBaseFromC(hirRoot, (HIR)hirRoot.programRoot, io);
        spec.getTrace().trace(this.myName, 5000, "compile(2)");
        FlowRoot hirFlowRoot = hirAnal ? this.makeHIRFlowAnalysis(hirRoot, symRoot, io) : new FlowRoot(hirRoot);
        spec.getTrace().trace(this.myName, 5000, "compile(3)");
        this.optimizeHirAfterFlowAnalysis(hirRoot, hirFlowRoot, symRoot, io);
        spec.getTrace().trace(this.myName, 5000, "compile(4)");
        this.makeCSourceFromHirBase(hirRoot, symRoot, io);
        Trace trace = io.getCompileSpecification().getTrace();
        if (io.getCompileSpecification().getTrace().shouldTrace("Sym", 1)) {
            trace.trace(this.myName, 1, "\nSym after code generation ");
            symRoot.symTable.printSymTableAllDetail(symRoot.symTableRoot);
            symRoot.symTableConst.printSymTableDetail();
        }
        throw new PassException(sourceFile, this.myName, "No further processing is required.");
    }

    public static void main(String[] args) {
        try {
            CommandLine spec = new CommandLine(args);
            int status = new CompilerDriver(spec).go(new Hir2C());
            System.exit(status);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }
}

