/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.flow.FlowUtil;
import coins.flow.UseDefChain;
import coins.flow.UseDefChainImpl;
import coins.flow.UseDefList;
import coins.ir.IR;
import coins.ir.hir.HIR;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UseDefListImpl
implements UseDefList {
    public final FlowRoot flowRoot;
    protected Map fUseDefChainMap;
    protected List fUseDefChainList = null;

    public UseDefListImpl(FlowRoot pFlowRoot) {
        this.flowRoot = pFlowRoot;
        this.fUseDefChainMap = new HashMap();
    }

    public UseDefChain addUseDefChain(IR pUseNode) {
        if (!this.fUseDefChainMap.containsKey(pUseNode)) {
            UseDefChainImpl lUseDefChain = new UseDefChainImpl(this.flowRoot, pUseNode);
            this.fUseDefChainMap.put(pUseNode, lUseDefChain);
            return lUseDefChain;
        }
        return (UseDefChain)this.fUseDefChainMap.get(pUseNode);
    }

    public UseDefChain getUseDefChain(IR pUseNode) {
        if (this.fUseDefChainMap.containsKey(pUseNode)) {
            return (UseDefChain)this.fUseDefChainMap.get(pUseNode);
        }
        return this.addUseDefChain(pUseNode);
    }

    public UseDefChain getOrAddUseDefChain(IR pUseNode) {
        UseDefChain lUseDefChain = this.getUseDefChain(pUseNode);
        if (lUseDefChain == null) {
            lUseDefChain = this.addUseDefChain(pUseNode);
        }
        return lUseDefChain;
    }

    public List getUseDefChainList() {
        if (this.fUseDefChainList == null) {
            this.fUseDefChainList = new ArrayList();
            Set lUseNodeSet = this.fUseDefChainMap.keySet();
            for (IR lUseNode : lUseNodeSet) {
                this.fUseDefChainList.add(lUseNode);
            }
        }
        return this.fUseDefChainList;
    }

    public void print() {
        this.flowRoot.ioRoot.printOut.print("\nUseDefList ");
        this.flowRoot.ioRoot.printOut.print(this.toStringByName());
    }

    public String toString() {
        return this.toStringByName();
    }

    public String toStringByName() {
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append("\nUseDefList ");
        UseDefChain lUseDefChain = null;
        Set lUseNodeSet = this.fUseDefChainMap.keySet();
        List lUseNodeList = FlowUtil.sortSetOfNodesByIndex(lUseNodeSet, this.flowRoot.fSubpFlow.getIrIndexMax());
        HIR[] lNullDefList = new HIR[lUseNodeSet.size() + 1];
        int lNullDefIndex = 0;
        for (IR lUseNode : lUseNodeList) {
            if (lUseNode == null || (lUseDefChain = (UseDefChain)this.fUseDefChainMap.get(lUseNode)) == null) continue;
            if (lUseDefChain.getDefList() == null || lUseDefChain.getDefList().isEmpty() || lUseDefChain.getDefList().size() == 1 && (lUseDefChain.getDefList().get(0) == null || ((HIR)lUseDefChain.getDefList().get(0)).getIndex() == 0)) {
                lNullDefList[lNullDefIndex] = (HIR)lUseDefChain.getUseNode();
                ++lNullDefIndex;
                continue;
            }
            lBuffer.append("\n " + lUseDefChain.toStringByName());
        }
        if (lNullDefIndex > 0) {
            lBuffer.append("\n use nodes with no def node:");
            for (int lIndex = 0; lIndex < lNullDefIndex; ++lIndex) {
                lBuffer.append(" " + lNullDefList[lIndex].toStringShort());
            }
        }
        return lBuffer.toString();
    }
}

