/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.aflow.FlowResults;
import coins.alias.AliasAnal;
import coins.alias.AliasAnalHir1;
import coins.alias.RecordAlias;
import coins.alias.alias2.AliasAnalHir2;
import coins.flow.BBlock;
import coins.flow.BBlockHir;
import coins.flow.BBlockHirImpl;
import coins.flow.BBlockHirNodeIteratorImpl;
import coins.flow.BBlockHirSubtreeIteratorImpl;
import coins.flow.BBlockImpl;
import coins.flow.BBlockNodeIterator;
import coins.flow.BBlockStmtIterator;
import coins.flow.BBlockSubtreeIterator;
import coins.flow.BBlockVector;
import coins.flow.BBlockVectorImpl;
import coins.flow.ControlFlowImpl;
import coins.flow.DefUseList;
import coins.flow.DefUseListImpl;
import coins.flow.DefVector;
import coins.flow.DefVectorImpl;
import coins.flow.DefVectorIterator;
import coins.flow.DefVectorIteratorImpl;
import coins.flow.ExpInf;
import coins.flow.ExpVector;
import coins.flow.ExpVectorImpl;
import coins.flow.ExpVectorIterator;
import coins.flow.ExpVectorIteratorImpl;
import coins.flow.Flow;
import coins.flow.FlowAdapter;
import coins.flow.FlowAnalSymVector;
import coins.flow.FlowAnalSymVectorImpl;
import coins.flow.FlowUtil;
import coins.flow.HirSubpFlowImpl;
import coins.flow.PointVector;
import coins.flow.PointVectorImpl;
import coins.flow.PointVectorIterator;
import coins.flow.PointVectorIteratorImpl;
import coins.flow.SetRefRepr;
import coins.flow.SetRefReprList;
import coins.flow.SubpFlow;
import coins.flow.UseDefList;
import coins.flow.UseDefListImpl;
import coins.ir.IR;
import coins.ir.hir.AsmStmt;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirList;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.VarNode;
import coins.sym.ExpId;
import coins.sym.FlowAnalSym;
import coins.sym.Label;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.SymIterator;
import coins.sym.SymTable;
import coins.sym.SymTableImpl;
import coins.sym.Var;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public abstract class SubpFlowImpl
implements SubpFlow {
    public final FlowRoot flowRoot;
    public final IoRoot ioRoot;
    public final SymRoot symRoot;
    public final HirRoot hirRoot;
    public Flow flow;
    protected int fUsedGlobalSymCount = 0;
    protected int fPointVectorBitCount;
    protected int fPointVectorWordCount;
    protected int fExpVectorBitCount;
    protected int fExpVectorWordCount;
    protected int fDefVectorBitCount;
    protected int fDefVectorWordCount;
    protected int fBBlockVectorBitCount;
    protected int fBBlockVectorWordCount;
    protected SubpDefinition fSubpDefinition;
    protected BBlock fPrevBBlockInSearch;
    protected int fNodeCount = 0;
    protected IR[] fFlowIrLink;
    protected int fFlowIrLinkSize;
    protected int fBBlockCount = 0;
    protected int fUsedSymCount = 0;
    protected int fSymExpCount = 0;
    protected int fDefRefCount = 0;
    protected int fDefCount = 0;
    protected BBlock fEntryBBlock = null;
    protected int fAssignCount = 0;
    protected int fCallCount = 0;
    protected BBlock fExitBBlock = null;
    protected ArrayList fBBlockTable = null;
    protected List fBBlockList = null;
    protected List fListOfBBlocksFromEntry = null;
    protected List fListOfBBlocksFromExit = null;
    protected Set fUsedSymSet = null;
    protected FlowAnalSym[] fSymIndexTable = null;
    protected List fDfoList = null;
    protected List fInverseDfoList = null;
    protected int fExpIdNumber = 0;
    protected Set fDefinedSyms = null;
    protected FlowAnalSym[] fFlowAnalSymTable = null;
    protected BBlock[] fBBlockOfIR;
    protected int[] fDefRefIndex;
    protected int[] fDefIndex;
    protected Map fBBlockOfLabel = null;
    protected List fExpIdList = null;
    protected Set fMaximalCompoundVars = null;
    protected Set fGlobalSymsUsed = null;
    protected DefUseList fDefUseList = null;
    protected UseDefList fUseDefList = null;
    protected DefUseList fDefUseExhaustiveList = null;
    protected UseDefList fUseDefExhaustiveList = null;
    protected List[] fDefNodeListOfSym;
    protected List[] fUseNodeListOfSym;
    public boolean fHirAnalExtended = false;
    protected SetRefRepr[] fSetRefReprTable = null;
    protected int fIrIndexMin = 0;
    protected int fIrIndexMax = 0;
    protected ExpId[] fExpIdTable;
    protected int fMaxIndexOfCopiedNode;
    public List fSubtreesCopied;
    protected Set fSetOfGlobalVariables = null;
    protected Set fSetOfAddressTakenVariables = null;
    protected Map fTempExpCorrespondence;
    protected AliasAnal fAlias = null;
    protected RecordAlias fRecordAlias = null;
    protected IR[] fDefRefPoint;
    protected IR[] fDefPoint;
    public boolean[] hasCall;
    public boolean hasCallInSubp;
    public boolean[] hasUsePointer;
    public boolean[] hasStructUnion;
    public boolean[] hasPointerAssign;
    protected SetRefReprList[] fArrayOfSetRefReprList;
    protected BBlockVector[] fDom = null;
    protected BBlockVector[] fPostDom = null;
    protected List[] fDomList = null;
    protected List[] fPostDomList = null;
    public Set fSubtreesContainingCall;
    protected int[] fComputedFlag = new int[31];
    public final int fDbgLevel;
    protected int fComplexity;
    protected final int fNodeCountLim1 = 1000;
    protected final int fNodeCountLim2 = 3000;
    protected final int fSymCountLim1 = 100;
    protected final int fSymCountLim2 = 200;
    protected FlowAdapter fFlowAdapter;
    public boolean fIteratorInitiated = false;
    public Map fMultipleSetRef = null;
    protected boolean failed = false;
    protected coins.aflow.SubpFlow fAflowSubpFlow = null;

    public SubpFlowImpl(FlowRoot pFlowRoot, SubpDefinition pSubpDefinition) {
        this.flowRoot = pFlowRoot;
        this.ioRoot = pFlowRoot.ioRoot;
        this.symRoot = pFlowRoot.symRoot;
        this.hirRoot = pFlowRoot.hirRoot;
        this.hirRoot.attachFlowRoot(this.flowRoot);
        this.flow = pFlowRoot.flow;
        this.fDbgLevel = this.ioRoot.dbgFlow.getLevel();
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgFlow.print(2, "\nSubpFlowImpl", pSubpDefinition.getSubpSym().getName());
        }
        if (this.flowRoot.fSubpFlow != null && this.flowRoot.fSubpFlow.getSubpSym() != pSubpDefinition.getSubpSym()) {
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgFlow.print(2, "reset previous flow information", this.flowRoot.fSubpFlow.getSubpSym().getName());
            }
            this.flowRoot.fSubpFlow.clearControlFlow();
            this.flowRoot.fSubpFlow.clearDataFlow();
        }
        this.fSubpDefinition = pSubpDefinition;
        this.flowRoot.fSubpFlow = this;
        if (pSubpDefinition != null) {
            pFlowRoot.subpUnderAnalysis = pSubpDefinition.getSubpSym();
            if (pSubpDefinition.getSymTable() != null) {
                this.symRoot.symTableCurrentSubp = this.symRoot.symTableCurrent = pSubpDefinition.getSymTable();
            }
        }
        this.fSubtreesContainingCall = new HashSet();
        this.fComplexity = 1;
        this.fFlowAdapter = new FlowAdapter(this.flowRoot);
    }

    public SubpFlowImpl() {
        this.flowRoot = null;
        this.ioRoot = null;
        this.symRoot = null;
        this.hirRoot = null;
        this.fDbgLevel = 0;
    }

    public BBlock getEntryBBlock() {
        return this.fEntryBBlock;
    }

    public void setEntryBBlock(BBlock pBlock) {
        this.fEntryBBlock = pBlock;
        this.fEntryBBlock.setFlag(7, true);
    }

    public BBlock getExitBBlock() {
        return this.fExitBBlock;
    }

    public void setExitBBlock(BBlock pBlock) {
        this.fExitBBlock = pBlock;
        this.fExitBBlock.setFlag(8, true);
    }

    public void copyFlowAnalData(SubpFlow pSubpFlow) {
        this.fBBlockCount = ((SubpFlowImpl)pSubpFlow).fBBlockCount;
    }

    public BBlock bblock(LabeledStmt pLabeledStmt) {
        ++this.fBBlockCount;
        BBlockHirImpl lBBlock = new BBlockHirImpl(this.flowRoot, pLabeledStmt, this.fBBlockCount);
        this.flowRoot.fSubpFlow.recordBBlock(lBBlock, this.fBBlockCount);
        return lBBlock;
    }

    public BBlock bblock() {
        BBlockHirImpl lBBlock = new BBlockHirImpl(this.flowRoot, null, 0);
        return lBBlock;
    }

    public ExpVector expVector() {
        ExpVectorImpl lExpVector = new ExpVectorImpl(this);
        return lExpVector;
    }

    public PointVector pointVector() {
        PointVectorImpl lPointVector = new PointVectorImpl(this);
        return lPointVector;
    }

    public DefVector defVector() {
        DefVectorImpl lDefVector = new DefVectorImpl(this);
        return lDefVector;
    }

    public void resetFlowSymLinkForRecordedSym() {
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(2, "resetFlowSymLinkForRecordedSym", "SymExpCount " + this.getSymExpCount() + " " + this.fSymExpCount + " UsedSymCount " + this.getUsedSymCount());
            if (this.fSymIndexTable != null) {
                this.flowRoot.ioRoot.dbgFlow.print(2, " fUsedSymSet.size " + this.fUsedSymSet.size());
            }
        }
        if (this.fSymIndexTable != null) {
            for (int i = 0; i < this.fSymExpCount; ++i) {
                FlowAnalSym lSym = this.getIndexedSym(i);
                if (!(lSym instanceof FlowAnalSym)) continue;
                if (this.fDbgLevel > 0) {
                    this.flow.dbg(6, " " + lSym.getName());
                }
                this.flow.dbg(2, " " + lSym.getName());
                lSym.resetFlowAnalInf();
            }
        }
    }

    public void resetFlowSymLink(SymTable pSymTable) {
        if (pSymTable == null) {
            return;
        }
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(2, "resetFlowSymLink", ((SymTableImpl)pSymTable).fTableName + " owner " + pSymTable.getOwnerName());
        }
        if (pSymTable == this.flowRoot.symRoot.symTableRoot || pSymTable.getOwner() == null) {
            this.resetGlobalFlowSymLink();
            return;
        }
        if (this.fSymIndexTable == null) {
            return;
        }
        HashSet<FlowAnalSym> lAccessedSyms = new HashSet<FlowAnalSym>();
        for (int lUsedSymIndex = 0; lUsedSymIndex < this.fSymExpCount; ++lUsedSymIndex) {
            FlowAnalSym lUsedSym = this.fSymIndexTable[lUsedSymIndex];
            if (lUsedSym == null) continue;
            lAccessedSyms.add(lUsedSym);
        }
        SymIterator lIterator = pSymTable.getSymIterator();
        while (lIterator.hasNext()) {
            Sym lSym = lIterator.next();
            if (!(lSym instanceof FlowAnalSym) || !lAccessedSyms.contains(lSym)) continue;
            if (this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgFlow.print(4, " " + lSym.getName());
            }
            ((FlowAnalSym)lSym).resetFlowAnalInf();
        }
        this.resetFlowSymLink(pSymTable.getFirstChild());
        this.resetFlowSymLink(pSymTable.getBrother());
    }

    public void resetGlobalFlowSymLink() {
        SymTable lSymTable;
        SymTable lSymTableCurrent = this.getSubpDefinition().getSymTable();
        if (lSymTableCurrent == null) {
            lSymTable = this.flowRoot.symRoot.symTableRoot;
        } else {
            lSymTable = lSymTableCurrent.getParent();
            if (lSymTable == null) {
                lSymTable = this.flowRoot.symRoot.symTableRoot;
            }
        }
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(2, "resetGlobalFlowSymLink", "owner " + lSymTable.getOwnerName());
        }
        this.resetFlowSymLinkForTable(lSymTable);
    }

    public void resetFlowSymLinkForTable(SymTable pSymTable) {
        if (pSymTable == null) {
            return;
        }
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(3, "resetFlowSymLinkForTable", ((SymTableImpl)pSymTable).fTableName + " owner " + pSymTable.getOwnerName());
        }
        SymIterator lIterator = pSymTable.getSymIterator();
        while (lIterator.hasNext()) {
            Sym lSym = lIterator.next();
            if (lSym instanceof FlowAnalSym) {
                if (this.fDbgLevel > 3) {
                    this.flowRoot.ioRoot.dbgFlow.print(4, " " + lSym.getName());
                }
                ((FlowAnalSym)lSym).resetFlowAnalInf();
                continue;
            }
            if (!(lSym instanceof Label)) continue;
        }
        this.resetFlowSymLinkForTable(pSymTable.getParent());
    }

    public BBlock getBBlock(int pBlockNumber) {
        BBlock lBBlock = (BBlock)this.fBBlockTable.get(pBlockNumber);
        if (lBBlock != null) {
            if (lBBlock.getFlag(3)) {
                return null;
            }
            return lBBlock;
        }
        return null;
    }

    public void recordBBlock(BBlock pBlock, int pBlockNumber) {
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, "recordBBlock", Integer.toString(pBlockNumber, 10));
        }
        this.fBBlockTable.add(pBlockNumber, pBlock);
        if (pBlock.getLabel() != null && this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, " " + pBlock.getLabel().getName());
        }
        if (pBlockNumber == 1) {
            this.setEntryBBlock(pBlock);
        }
    }

    public FlowAnalSym getIndexedSym(int pSymIndex) {
        if (pSymIndex < this.fSymExpCount) {
            return this.fSymIndexTable[pSymIndex];
        }
        return null;
    }

    protected int recordSym(FlowAnalSym pSym) {
        if (pSym != null) {
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgFlow.print(6, "recordSym", pSym.getName());
            }
            if (!this.fUsedSymSet.contains(pSym)) {
                ++this.fSymExpCount;
                this.fUsedSymSet.add(pSym);
                pSym.setIndex(this.fSymExpCount);
                if (pSym.isGlobal()) {
                    this.fGlobalSymsUsed.add(pSym);
                    if (pSym instanceof Var) {
                        this.fSetOfGlobalVariables.add(pSym);
                    }
                }
                if (this.fDbgLevel > 3) {
                    this.ioRoot.dbgFlow.print(6, " index " + this.fSymExpCount);
                }
            }
            return pSym.getIndex();
        }
        return 0;
    }

    public IR getIndexedNode(int pNodeIndex) {
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(7, "getIndexedNode", "(" + pNodeIndex + ")");
        }
        IR lIr = this.fFlowIrLink[pNodeIndex - this.fIrIndexMin];
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(7, IoRoot.toStringObjectShort(lIr));
        }
        return lIr;
    }

    public BBlock getBBlockFromNodeIndex(int pNodeIndex) {
        return this.fBBlockOfIR[pNodeIndex - this.fIrIndexMin];
    }

    public int getNumberOfBBlocks() {
        return this.fBBlockCount;
    }

    public int getNumberOfNodes() {
        return this.fNodeCount;
    }

    public void setNumberOfNodes(int pCount) {
        this.fNodeCount = pCount;
    }

    public int getSymExpCount() {
        return this.fSymExpCount;
    }

    public int getUsedSymCount() {
        return this.fUsedSymCount;
    }

    public String generateExpIdName() {
        String lName = null;
        boolean lFound = false;
        while (!lFound) {
            ++this.fExpIdNumber;
            lName = ("_xId" + Integer.toString(this.fExpIdNumber, 10)).intern();
            Sym lSym = this.symRoot.symTableFlow.searchLocal(lName, 0, false);
            if (lSym == null) break;
            if (!(lSym instanceof ExpId)) continue;
            ((FlowAnalSym)lSym).resetFlowAnalInf();
            ((ExpId)lSym).resetFlowAnalInf();
            break;
        }
        return lName;
    }

    public SubpDefinition getSubpDefinition() {
        return this.fSubpDefinition;
    }

    public Subp getSubpSym() {
        return this.fSubpDefinition.getSubpSym();
    }

    public int getNumberOfDefUsedGlobalSymbols() {
        return this.fUsedGlobalSymCount;
    }

    public int getPointVectorBitCount() {
        return this.fPointVectorBitCount;
    }

    public void setPointVectorBitCount(int pBitCount) {
        this.fPointVectorBitCount = pBitCount;
        this.fPointVectorWordCount = (this.fPointVectorBitCount + 63) / 64;
    }

    public int getPointVectorWordCount() {
        return this.fPointVectorWordCount;
    }

    public int getExpVectorBitCount() {
        return this.fExpVectorBitCount;
    }

    public void setExpVectorBitCount(int pBitCount) {
        this.fExpVectorBitCount = pBitCount;
        this.fExpVectorWordCount = (this.fExpVectorBitCount + 63) / 64;
    }

    public int getExpVectorWordCount() {
        return this.fExpVectorWordCount;
    }

    public int getDefVectorBitCount() {
        return this.fDefVectorBitCount;
    }

    public void setDefVectorBitCount(int pBitCount) {
        this.fDefVectorBitCount = pBitCount;
        this.fDefVectorWordCount = (this.fDefVectorBitCount + 63) / 64;
    }

    public int getDefVectorWordCount() {
        return this.fDefVectorWordCount;
    }

    public int getBBlockVectorBitCount() {
        return this.fBBlockVectorBitCount;
    }

    public void setBBlockVectorBitCount(int pBitCount) {
        this.fBBlockVectorBitCount = pBitCount;
        this.fBBlockVectorWordCount = (this.fBBlockVectorBitCount + 63) / 64;
    }

    public int getBBlockVectorWordCount() {
        return this.fBBlockVectorWordCount;
    }

    public void setPrevBBlockInSearch(BBlock pPrev) {
        this.fPrevBBlockInSearch = pPrev;
    }

    public BBlock getPrevBBlockInSearch() {
        return this.fPrevBBlockInSearch;
    }

    public Set getDefinedSyms() {
        return this.fDefinedSyms;
    }

    public Set getUsedSyms() {
        return this.fUsedSymSet;
    }

    public void summarize() {
        Sym lLinkedSym;
        FlowAnalSym lSym;
        int lNextIndex;
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, "summarize", "used source symbols " + this.fUsedSymCount + " used symbols " + this.getSymExpCount() + " BBlock count " + this.fBBlockCount);
            this.ioRoot.dbgFlow.print(4, " ", "defined");
        }
        ExpVectorImpl lDefined = new ExpVectorImpl(this);
        ExpVectorImpl lUsed = new ExpVectorImpl(this);
        for (int lBBlockNumber = 1; lBBlockNumber <= this.fBBlockCount; ++lBBlockNumber) {
            BBlock lBBlock = this.getBBlock(lBBlockNumber);
            if (lBBlock == null) continue;
            if (lBBlock.getDefined() != null) {
                lBBlock.getDefined().vectorOr(lDefined, lDefined);
            }
            if (lBBlock.getUsed() == null) continue;
            lBBlock.getUsed().vectorOr(lUsed, lUsed);
        }
        ExpVectorIterator lVectIterator = this.flowRoot.fSubpFlow.expVectorIterator(lDefined);
        while (lVectIterator.hasNext()) {
            lNextIndex = lVectIterator.nextIndex();
            if (lNextIndex <= 0 || (lSym = this.getIndexedSym(lNextIndex)) == null) continue;
            this.fDefinedSyms.add(lSym);
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgFlow.print(4, " " + lSym.getName());
            }
            lLinkedSym = null;
            if (lSym instanceof ExpId) {
                lLinkedSym = ((ExpId)lSym).getLinkedSym();
            }
            if (lLinkedSym == null || !(lLinkedSym instanceof FlowAnalSym)) continue;
            this.fDefinedSyms.add(lLinkedSym);
            if (this.fDbgLevel <= 3) continue;
            this.ioRoot.dbgFlow.print(4, "(" + lLinkedSym.getName() + ")");
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, " ", "used");
        }
        lVectIterator = this.flowRoot.fSubpFlow.expVectorIterator(lUsed);
        while (lVectIterator.hasNext()) {
            lNextIndex = lVectIterator.nextIndex();
            if (lNextIndex <= 0 || (lSym = this.getIndexedSym(lNextIndex)) == null) continue;
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgFlow.print(4, " " + lSym.getName());
            }
            lLinkedSym = null;
            if (lSym instanceof ExpId) {
                lLinkedSym = ((ExpId)lSym).getLinkedSym();
            }
            if (lLinkedSym == null || !(lLinkedSym instanceof FlowAnalSym)) continue;
            this.fDefinedSyms.add(lLinkedSym);
            if (this.fDbgLevel <= 3) continue;
            this.ioRoot.dbgFlow.print(4, "(" + lLinkedSym.getName() + ")");
        }
    }

    public Iterator cfgIterator() {
        this.flow.dbg(3, "get", "cfgIterator");
        if (this.flow.getFlowAnalStateLevel() >= 2) {
            if (this.fDfoList == null) {
                if (this.fDbgLevel > 0) {
                    this.flow.dbg(4, " Make DfoList");
                }
                this.fDfoList = new LinkedList();
                for (BBlock lBBlock = this.fEntryBBlock; lBBlock != null; lBBlock = lBBlock.getNextInDFO()) {
                    this.fDfoList.add(lBBlock);
                    if (this.fDbgLevel <= 0) continue;
                    this.flow.dbg(4, " B" + lBBlock.getBBlockNumber());
                }
            }
        } else {
            this.ioRoot.msgRecovered.put(5011, "Incomplete flow information (cfgIterator)");
        }
        return this.fDfoList.iterator();
    }

    public Iterator cfgFromExitIterator() {
        if (this.fDbgLevel > 0) {
            this.flow.dbg(3, "get", "cfgFromExitIterator");
        }
        if (this.flow.getFlowAnalStateLevel() >= 2) {
            if (this.fInverseDfoList == null) {
                if (this.fDbgLevel > 0) {
                    this.flow.dbg(4, " Make InverseDfoList");
                }
                this.fInverseDfoList = new LinkedList();
                for (BBlock lBBlock = this.fExitBBlock; lBBlock != null; lBBlock = lBBlock.getNextInInverseDFO()) {
                    this.fInverseDfoList.add(lBBlock);
                    if (this.fDbgLevel <= 0) continue;
                    this.flow.dbg(4, " B" + lBBlock.getBBlockNumber());
                }
            }
        } else {
            this.ioRoot.msgRecovered.put(5012, "Incomplete flow information (cfgFromExitIterator)");
        }
        return this.fInverseDfoList.iterator();
    }

    public PointVectorIterator pointVectorIterator(PointVector pPointVector) {
        return new PointVectorIteratorImpl((SubpFlow)this, pPointVector);
    }

    public DefVectorIterator defVectorIterator(DefVector pDefVector) {
        return new DefVectorIteratorImpl((SubpFlow)this, pDefVector);
    }

    public ExpVectorIterator expVectorIterator(ExpVector pExpVector) {
        return new ExpVectorIteratorImpl((SubpFlow)this, pExpVector);
    }

    public BBlockSubtreeIterator bblockSubtreeIterator(BBlock pBBlock) {
        return new BBlockHirSubtreeIteratorImpl(this.flowRoot, pBBlock);
    }

    public BBlockStmtIterator bblockStmtIterator(BBlockHir pBBlock) {
        return new BBlockStmtIterator(pBBlock);
    }

    public BBlockNodeIterator bblockNodeIterator(BBlock pBBlock) {
        return new BBlockHirNodeIteratorImpl(this.flowRoot, pBBlock);
    }

    public int getFlowAnalStateLevel() {
        return this.flowRoot.flow.getFlowAnalStateLevel();
    }

    public void setFlowAnalStateLevel(int pState) {
        this.flowRoot.flow.setFlowAnalStateLevel(pState);
    }

    public ArrayList getBBlockTable() {
        return this.fBBlockTable;
    }

    public List getBBlockList() {
        if (this.fBBlockList == null) {
            this.fBBlockList = new ArrayList(this.getBBlockTable().size());
            for (BBlock lBBlock : this.getBBlockTable()) {
                if (lBBlock == null || lBBlock.getBBlockNumber() <= 0) continue;
                this.fBBlockList.add(lBBlock);
            }
            if (this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgFlow.print(5, "getBBlockList", this.fBBlockList.toString());
            }
        }
        return this.fBBlockList;
    }

    public List getReachableBBlocks() {
        return this.getListOfBBlocksFromEntry();
    }

    public void initiateControlFlowAnal(SubpDefinition pSubpDefinition, int pIndexMin, int pIndexMax) {
        for (int lIndex = 0; lIndex < 30; ++lIndex) {
            this.fComputedFlag[lIndex] = 0;
        }
        this.fIrIndexMin = pSubpDefinition.getNodeIndexMin();
        this.fIrIndexMax = pSubpDefinition.getNodeIndexMax();
        if (this.fIrIndexMin != pIndexMin || this.fIrIndexMax != pIndexMax || this.fIrIndexMax < this.fIrIndexMin) {
            this.ioRoot.msgRecovered.put(5555, "IndexMin/Max does not match. ");
            this.resetComputedFlag(2);
            pSubpDefinition.setIndexNumberToAllNodes(this.fIrIndexMin, true);
            this.setComputedFlag(2);
            this.fIrIndexMax = pSubpDefinition.getNodeIndexMax();
        }
        this.setComputedFlag(2);
        this.clearControlFlow();
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(2, "initiateControlFlowAnal", pSubpDefinition.getSubpSym().getName() + " index " + this.fIrIndexMin + "-" + this.fIrIndexMax);
        }
    }

    public void initiateDataFlowAnal(SubpDefinition pSubpDefinition) {
        this.fIrIndexMin = pSubpDefinition.getNodeIndexMin();
        this.fIrIndexMax = pSubpDefinition.getNodeIndexMax();
        if (this.fComputedFlag == null) {
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgFlow.print(1, "SubpFlowImpl.initiateControlFlowAnal", "requires control flow analysis " + pSubpDefinition.getSubpSym().getName());
            }
            this.flow.controlFlowAnal(this.flowRoot.fSubpFlow);
            this.fIrIndexMin = pSubpDefinition.getNodeIndexMin();
            this.fIrIndexMax = pSubpDefinition.getNodeIndexMax();
        }
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(2, "SubpFlowImpl.initiateDataFlowAnal end", pSubpDefinition.getSubpSym().getName() + " index " + this.fIrIndexMin + "-" + this.fIrIndexMax + " used source symbols " + this.fUsedSymCount);
        }
        this.setPointVectorBitCount(63);
        this.setExpVectorBitCount(63);
        this.clearDataFlow();
    }

    public BBlock getBBlock(HIR pHir) {
        return this.fBBlockOfIR[pHir.getIndex() - this.fIrIndexMin];
    }

    public void setBBlock(HIR pHir, BBlock pBBlock) {
        this.fBBlockOfIR[pHir.getIndex() - this.fIrIndexMin] = pBBlock;
    }

    public BBlock getBBlock0(Label pLabel) {
        return (BBlock)this.fBBlockOfLabel.get(pLabel);
    }

    public BBlock getBBlockForLabel(Label pLabel) {
        return (BBlock)this.fBBlockOfLabel.get(pLabel);
    }

    public void setBBlock(Label pLabel, BBlock pBBlock) {
        this.fBBlockOfLabel.put(pLabel, pBBlock);
    }

    public HIR getLinkedSubtreeOfExpId(ExpId pExpId) {
        if (pExpId == null) {
            return null;
        }
        ExpInf lExpInf = pExpId.getExpInf();
        return (HIR)lExpInf.fLinkedIR;
    }

    public DefUseList getDefUseList() {
        if (this.fDefUseList == null) {
            this.fDefUseList = new DefUseListImpl(this.flowRoot);
        }
        if (!this.isComputed(24) && this.flowRoot.dataFlow != null) {
            this.flowRoot.dataFlow.findDefUse();
        }
        return this.fDefUseList;
    }

    public DefUseList getListOfDefUseList() {
        if (this.fDefUseList == null) {
            this.fDefUseList = new DefUseListImpl(this.flowRoot);
        }
        return this.fDefUseList;
    }

    public DefUseList getDefUseExhaustiveList() {
        if (this.fDefUseExhaustiveList == null) {
            this.fDefUseExhaustiveList = new DefUseListImpl(this.flowRoot);
        }
        if (!this.isComputed(24) && this.flowRoot.dataFlow != null) {
            this.flowRoot.dataFlow.findDefUseExhaustively();
        }
        return this.fDefUseExhaustiveList;
    }

    public DefUseList getListOfDefUseExhaustiveList() {
        if (this.fDefUseExhaustiveList == null) {
            this.fDefUseExhaustiveList = new DefUseListImpl(this.flowRoot);
        }
        return this.fDefUseExhaustiveList;
    }

    public List getDefNodeList(FlowAnalSym pSym) {
        int lIndex = pSym.getIndex();
        if (this.fDefNodeListOfSym == null) {
            this.fDefNodeListOfSym = new List[this.getSymExpCount() + 1];
        }
        if (this.fDefNodeListOfSym[lIndex] == null) {
            this.fDefNodeListOfSym[lIndex] = new ArrayList();
        }
        return this.fDefNodeListOfSym[lIndex];
    }

    public void addDefNode(FlowAnalSym pSym, IR pDefNode) {
        int lIndex = pSym.getIndex();
        if (this.fDefNodeListOfSym == null) {
            this.fDefNodeListOfSym = new List[this.getSymExpCount() + 1];
        }
        if (this.fDefNodeListOfSym[lIndex] == null) {
            this.fDefNodeListOfSym[lIndex] = new ArrayList();
        }
        this.fDefNodeListOfSym[lIndex].add(pDefNode);
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(6, "addDefNodeList " + pSym + " " + pSym.getIndex() + pDefNode);
        }
    }

    public UseDefList getUseDefList() {
        if (this.fUseDefList == null) {
            this.fUseDefList = new UseDefListImpl(this.flowRoot);
        }
        if (!this.isComputed(25) && this.flowRoot.dataFlow != null) {
            this.flowRoot.dataFlow.findUseDef();
        }
        return this.fUseDefList;
    }

    public UseDefList getListOfUseDefList() {
        if (this.fUseDefList == null) {
            this.fUseDefList = new UseDefListImpl(this.flowRoot);
        }
        return this.fUseDefList;
    }

    public UseDefList getUseDefExhaustiveList() {
        if (this.fUseDefExhaustiveList == null) {
            this.fUseDefExhaustiveList = new UseDefListImpl(this.flowRoot);
        }
        if (!this.isComputed(25) && this.flowRoot.dataFlow != null) {
            this.flowRoot.dataFlow.findUseDefExhaustively();
        }
        return this.fUseDefExhaustiveList;
    }

    public UseDefList getListOfUseDefExhaustiveList() {
        if (this.fUseDefExhaustiveList == null) {
            this.fUseDefExhaustiveList = new UseDefListImpl(this.flowRoot);
        }
        return this.fUseDefExhaustiveList;
    }

    public List geUseNodeList(FlowAnalSym pSym) {
        int lIndex = pSym.getIndex();
        if (this.fUseNodeListOfSym == null) {
            this.fUseNodeListOfSym = new List[this.getSymExpCount() + 1];
        }
        if (this.fUseNodeListOfSym[lIndex] == null) {
            this.fUseNodeListOfSym[lIndex] = new ArrayList();
        }
        return this.fUseNodeListOfSym[lIndex];
    }

    public void addUseNode(FlowAnalSym pSym, IR pUseNode) {
        int lIndex = pSym.getIndex();
        if (this.fUseNodeListOfSym == null) {
            this.fUseNodeListOfSym = new List[this.getSymExpCount() + 1];
        }
        if (this.fUseNodeListOfSym[lIndex] == null) {
            this.fUseNodeListOfSym[lIndex] = new ArrayList();
        }
        this.fUseNodeListOfSym[lIndex].add(pUseNode);
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(6, "addUseDefList " + pSym + " " + pSym.getIndex() + pUseNode);
        }
    }

    public BBlockVector bblockVector() {
        BBlockVectorImpl lBBlockVector = new BBlockVectorImpl(this);
        return lBBlockVector;
    }

    public FlowAnalSymVector flowAnalSymVector() {
        return new FlowAnalSymVectorImpl(this);
    }

    public Set setOfGlobalVariables() {
        return this.fGlobalSymsUsed;
    }

    public Set setOfAddressTakenVariables() {
        return this.fSetOfAddressTakenVariables;
    }

    public void clearControlFlow() {
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(2, "\n subpFlow.clearControlFlow() " + this.fSubpDefinition.getSubpSym().getName() + " IrIndex " + this.fIrIndexMin + "-" + this.fIrIndexMax);
        }
        this.failed = false;
        this.resetFlowSymLinkForRecordedSym();
        this.resetFlowSymLink(this.symRoot.symTableFlow);
        this.resetGlobalFlowSymLink();
        int lNodeCount = this.fIrIndexMax - this.fIrIndexMin + 1;
        this.fUsedSymSet = new HashSet();
        this.fSymExpCount = 0;
        this.fUsedSymCount = 0;
        this.fBBlockTable = new ArrayList(lNodeCount / 5);
        this.fBBlockList = null;
        this.fBBlockCount = 0;
        this.fBBlockOfIR = new BBlock[lNodeCount * 2 + 2];
        this.fBBlockOfLabel = new HashMap();
        this.fSetOfAddressTakenVariables = null;
        this.fEntryBBlock = null;
        this.fExitBBlock = null;
        this.fListOfBBlocksFromEntry = null;
        this.fListOfBBlocksFromExit = null;
        this.fDfoList = null;
        this.fInverseDfoList = null;
        this.fGlobalSymsUsed = new HashSet();
        this.fSetOfGlobalVariables = new HashSet();
        this.fAssignCount = 0;
        this.fCallCount = 0;
        this.fComputedFlag = new int[31];
        this.flow.setFlowAnalStateLevel(0);
        if (this.flowRoot.isHirAnalysis()) {
            ((HirSubpFlowImpl)this).fStmtExpSeq = null;
            ((HirSubpFlowImpl)this).fStmtExpSeqIndexForBBlock = null;
        }
        this.fSubtreesContainingCall = new HashSet();
        this.fSetRefReprTable = new SetRefRepr[lNodeCount + 3];
        this.fArrayOfSetRefReprList = null;
        this.fExpIdList = new ArrayList(lNodeCount / 2);
        this.fExpIdNumber = 1;
        this.fIteratorInitiated = false;
        this.fDefinedSyms = new HashSet();
        this.fDom = null;
        this.fPostDom = null;
        this.fDomList = null;
        this.fPostDomList = null;
    }

    public void clearDataFlow() {
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(2, "\n subpFlow.clearDataFlow() " + this.fSubpDefinition.getSubpSym().getName());
        }
        int lNodeCount = this.fIrIndexMax - this.fIrIndexMin + 1;
        this.failed = false;
        if (this.fSetRefReprTable == null) {
            this.fSetRefReprTable = new SetRefRepr[lNodeCount + 2];
        }
        this.fTempExpCorrespondence = new HashMap();
        this.fRecordAlias = null;
        this.fDefRefCount = 0;
        this.fDefCount = 0;
        this.fDefUseList = null;
        this.hasCall = null;
        this.hasStructUnion = null;
        this.hasPointerAssign = null;
        this.fMaximalCompoundVars = new HashSet();
        if (this.fBBlockTable != null) {
            if (this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgFlow.print(4, "\n resetForDataFlowAnal of BBlocks");
            }
            for (int lNumber = 0; lNumber < this.fBBlockTable.size(); ++lNumber) {
                BBlock lBBlock = (BBlock)this.fBBlockTable.get(lNumber);
                if (lBBlock == null) continue;
                ((BBlockImpl)lBBlock).resetForDataFlowAnal();
                if (this.fDbgLevel <= 3) continue;
                this.flowRoot.ioRoot.dbgFlow.print(4, " B" + lNumber);
            }
        }
        if (this.isComputed(8)) {
            this.resetComputedFlag(9);
        } else if (this.isComputed(7)) {
            this.resetComputedFlag(8);
        } else {
            this.resetComputedFlag(7);
        }
        this.fMultipleSetRef = null;
    }

    public void resetControlAndDataFlowInformation() {
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(2, "\n resetControlAndDataFlowInformation ");
        }
        this.resetComputedFlag(2);
        this.fSubpDefinition.setIndexNumberToAllNodes(this.fSubpDefinition.getNodeIndexMin(), true);
        this.setComputedFlag(2);
        this.clearControlFlow();
        this.clearDataFlow();
    }

    public void resetExpId() {
        if (this.symRoot.symTableFlow.getOwner() == null) {
            return;
        }
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(2, " resetExpId of " + this.symRoot.symTableCurrent.getOwner().getName() + " " + this.symRoot.symTableFlow.toString());
        }
        SymIterator lIterator = this.symRoot.symTableFlow.getSymIterator();
        while (lIterator.hasNext()) {
            Sym lSym = lIterator.next();
            if (!(lSym instanceof ExpId)) continue;
            if (this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgFlow.print(4, " " + lSym.getName());
            }
            ((FlowAnalSym)lSym).resetFlowAnalInf();
        }
    }

    public Set computeSetOfGlobalVariables() {
        if (this.fDbgLevel > 0) {
            this.flowRoot.flow.dbg(2, "\nglobalVariables ", this.fSetOfGlobalVariables.toString());
        }
        return this.fSetOfGlobalVariables;
    }

    public Set computeSetOfAddressTakenVariables() {
        HashSet lAddressTakenVariables = new HashSet();
        if (this.flowRoot.isHirAnalysis()) {
            Stmt lSubpBody = this.fSubpDefinition.getHirBody();
            this.computeSetOfAddressTakenVariables(lSubpBody, lAddressTakenVariables, false);
        }
        this.fSetOfAddressTakenVariables = lAddressTakenVariables;
        this.flowRoot.flow.dbg(2, "\naddressTakenVariables ", ((Object)lAddressTakenVariables).toString());
        return lAddressTakenVariables;
    }

    public void computeSetOfAddressTakenVariables(HIR pHir, Set pSet, boolean pAddrOperand) {
        if (pHir != null) {
            if (pHir instanceof VarNode) {
                FlowAnalSym lSym = pHir.getSymOrExpId();
                if (pAddrOperand && lSym instanceof Var) {
                    pSet.add(lSym);
                }
            } else {
                switch (pHir.getOperator()) {
                    case 64: {
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild1(), pSet, true);
                        break;
                    }
                    case 17: {
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild1(), pSet, pAddrOperand);
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild2(), pSet, false);
                        break;
                    }
                    case 20: {
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild1(), pSet, false);
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild2(), pSet, pAddrOperand);
                        break;
                    }
                    case 66: {
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild1(), pSet, true);
                        break;
                    }
                    case 21: {
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild2(), pSet, false);
                        break;
                    }
                    case 35: {
                        for (Stmt lStmt = ((BlockStmt)pHir).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                            this.computeSetOfAddressTakenVariables(lStmt, pSet, false);
                        }
                        break;
                    }
                    case 14: {
                        ListIterator lIterator = ((HirList)pHir).iterator();
                        while (lIterator.hasNext()) {
                            HIR lHir = (HIR)lIterator.next();
                            if (lHir == null) continue;
                            this.computeSetOfAddressTakenVariables(lHir, pSet, false);
                        }
                        break;
                    }
                    default: {
                        if (pHir.getChildCount() <= 0) break;
                        for (int i = 1; i <= pHir.getChildCount(); ++i) {
                            this.computeSetOfAddressTakenVariables((HIR)pHir.getChild(i), pSet, false);
                        }
                    }
                }
            }
        }
    }

    public void setRestructureFlag() {
        if (this.fDbgLevel >= 2) {
            this.ioRoot.dbgFlow.print(2, " setResturctureFlag ");
        }
        this.setFlowAnalStateLevel(1);
        for (int i = 3; i < 30; ++i) {
            this.fComputedFlag[i] = 0;
        }
    }

    public boolean getRestructureFlag() {
        return this.getFlowAnalStateLevel() <= 1;
    }

    public void setRecordAlias(RecordAlias pRecordAlias) {
        this.fRecordAlias = pRecordAlias;
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, " setRecordAlias", this.fSubpDefinition.getSubpSym().getName());
        }
    }

    public RecordAlias getRecordAlias() {
        if (this.fRecordAlias == null) {
            this.fAlias = this.getComplexityLevel() <= 1 ? new AliasAnalHir2(this.flowRoot.hirRoot) : new AliasAnalHir1(this.flowRoot.hirRoot);
            this.fRecordAlias = new RecordAlias(this.fAlias, this.fSubpDefinition, this);
        }
        return this.fRecordAlias;
    }

    public SetRefRepr getSetRefReprOfIR(IR pIR) {
        if (pIR instanceof HIR) {
            ExpId lExpId = this.getExpId((HIR)pIR);
            if (lExpId != null) {
                return lExpId.getExpInf().getSetRefRepr();
            }
            if (pIR instanceof AssignStmt || pIR instanceof AsmStmt || pIR.getOperator() == 33) {
                return this.fSetRefReprTable[pIR.getIndex() - this.fIrIndexMin];
            }
        }
        return null;
    }

    public void setSetRefReprOfIR(SetRefRepr pSetRefRepr, IR pIR) {
        this.fSetRefReprTable[pIR.getIndex() - this.fIrIndexMin] = pSetRefRepr;
    }

    public void correlateBBlockAndIR() {
    }

    public void allocateBBlockOfIR() {
        if (this.fDbgLevel > 0) {
            this.flowRoot.flow.dbg(2, "allocateBBlockOfIR", "size " + this.fIrIndexMax + "-" + this.fIrIndexMin + "-1");
        }
        this.fBBlockOfIR = new BBlock[this.fIrIndexMax - this.fIrIndexMin + 2];
    }

    public BBlock getBBlockOfIR(int pIndex) {
        if (this.fBBlockOfIR == null) {
            this.flowRoot.ioRoot.msgRecovered.put(5555, "getBBlockOfIR requires allocateBBlockOfIR. index " + pIndex);
            this.allocateBBlockOfIR();
        }
        if (pIndex < this.fIrIndexMin) {
            this.flowRoot.ioRoot.msgRecovered.put(5555, "setBBlockOfIR with invalid index " + pIndex + " fIndexMin " + this.fIrIndexMin);
        }
        return this.fBBlockOfIR[pIndex - this.fIrIndexMin];
    }

    public void setBBlockOfIR(BBlock pBBlock, int pIndex) {
        if (this.fBBlockOfIR == null) {
            this.allocateBBlockOfIR();
        }
        if (pIndex < this.fIrIndexMin) {
            this.flowRoot.ioRoot.msgRecovered.put(5555, "setBBlockOfIR with invalid index " + pIndex + " fIndexMin " + this.fIrIndexMin);
        } else {
            this.fBBlockOfIR[pIndex - this.fIrIndexMin] = pBBlock;
        }
    }

    public int getIrIndexMin() {
        return this.fIrIndexMin;
    }

    public int getIrIndexMax() {
        return this.fIrIndexMax;
    }

    public int getDefCount() {
        return this.fDefCount;
    }

    public ExpId getExpId(IR pIr) {
        if (this.isComputedOrUnderComputation(7)) {
            if (pIr != null && this.fExpIdTable != null && pIr.getIndex() >= this.fIrIndexMin && (pIr.getIndex() <= this.fIrIndexMax || pIr.getIndex() <= this.fMaxIndexOfCopiedNode)) {
                return this.fExpIdTable[pIr.getIndex() - this.fIrIndexMin];
            }
            return null;
        }
        return null;
    }

    public ExpId getExpId(IR pIr, int pIndex) {
        if (pIr != null) {
            return this.fExpIdTable[pIndex - this.fIrIndexMin];
        }
        return null;
    }

    public void setExpId(IR pIr, ExpId pExpId) {
        if (pIr != null && pExpId != null) {
            BBlock lBBlock;
            int lIndex = pIr.getIndex();
            if (this.fExpIdTable != null && lIndex >= this.fIrIndexMin) {
                this.fExpIdTable[pIr.getIndex() - this.fIrIndexMin] = pExpId;
            }
            if (this.fBBlockOfIR != null && (lBBlock = this.fBBlockOfIR[lIndex - this.fIrIndexMin]) instanceof BBlockHirImpl) {
                ((BBlockHirImpl)lBBlock).addToExpNodeList(pExpId, (HIR)pIr);
            }
        }
    }

    public IR getRefPoint(int pIndex) {
        return this.fDefRefPoint[pIndex];
    }

    public IR getDefPoint(int pIndex) {
        return this.fDefPoint[pIndex];
    }

    public int getDefIndex(int pNodeIndex) {
        return this.fDefIndex[pNodeIndex];
    }

    public int recordDefRefPoint(IR pIR) {
        this.fDefRefIndex[pIR.getIndex() - this.fIrIndexMin] = ++this.fDefRefCount;
        this.fDefRefPoint[this.fDefRefCount] = pIR;
        return this.fDefRefCount;
    }

    public int recordDefPoint(IR pIR) {
        this.fDefIndex[pIR.getIndex() - this.fIrIndexMin] = ++this.fDefCount;
        this.fDefPoint[this.fDefCount] = pIR;
        return this.fDefCount;
    }

    public int getAssignCount() {
        return this.fAssignCount;
    }

    public int getCallCount() {
        return this.fCallCount;
    }

    public void computeBBlockSetRefReprs() {
        if (this.fDbgLevel > 0) {
            this.flowRoot.flow.dbg(4, "\ncomputeBBlockSetRefReprs");
        }
        if (this.flowRoot.isHirAnalysis()) {
            ((HirSubpFlowImpl)this).recordSetRefReprs();
        }
    }

    public SetRefReprList getSetRefReprList(BBlock pBBlock) {
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, "getSetRefReprList", "B" + pBBlock.getBBlockNumber());
        }
        if (this.fArrayOfSetRefReprList == null) {
            this.computeBBlockSetRefReprs();
        }
        SetRefReprList lSetRefReprList = this.fArrayOfSetRefReprList[pBBlock.getBBlockNumber()];
        if (this.fDbgLevel > 3 && lSetRefReprList != null) {
            this.flowRoot.ioRoot.dbgFlow.print(6, "lSetRefReprList", lSetRefReprList.toString());
        }
        return lSetRefReprList;
    }

    public void setSetRefReprList(BBlock pBBlock, SetRefReprList pSetRefReprList) {
        int lBBlockNumber = pBBlock == null ? 0 : pBBlock.getBBlockNumber();
        this.fArrayOfSetRefReprList[lBBlockNumber] = pSetRefReprList;
    }

    public Set subtreesContainingCall() {
        return this.fSubtreesContainingCall;
    }

    public void setExpOfTemp(Var pTempVar, Exp pExp) {
        this.fTempExpCorrespondence.put(pTempVar, pExp);
    }

    public Exp getExpOfTemp(Var pTempVar) {
        if (this.fTempExpCorrespondence == null) {
            return null;
        }
        if (this.fTempExpCorrespondence.containsKey(pTempVar)) {
            return (Exp)this.fTempExpCorrespondence.get(pTempVar);
        }
        return null;
    }

    public List getListOfBBlocksFromEntry() {
        if (this.fListOfBBlocksFromEntry == null) {
            this.fListOfBBlocksFromEntry = new ArrayList(40);
            Iterator lIterator = this.cfgIterator();
            while (lIterator.hasNext()) {
                BBlock lBBlock = (BBlock)lIterator.next();
                if (lBBlock == null) continue;
                this.fListOfBBlocksFromEntry.add(lBBlock);
            }
        }
        return this.fListOfBBlocksFromEntry;
    }

    public List getListOfBBlocksFromExit() {
        if (this.fListOfBBlocksFromExit == null) {
            this.fListOfBBlocksFromExit = new ArrayList(40);
            Iterator lIterator = this.cfgFromExitIterator();
            while (lIterator.hasNext()) {
                BBlock lBBlock = (BBlock)lIterator.next();
                if (lBBlock == null) continue;
                this.fListOfBBlocksFromExit.add(lBBlock);
            }
        }
        return this.fListOfBBlocksFromExit;
    }

    public FlowRoot getFlowRoot() {
        return this.flowRoot;
    }

    public boolean isComputed(int pItemIndex) {
        return this.fComputedFlag[pItemIndex] > 1;
    }

    public void setComputedFlag(int pItemIndex) {
        this.fComputedFlag[pItemIndex] = pItemIndex;
        if (this.fDbgLevel > 0) {
            this.flowRoot.flow.dbg(5, " setComputedFlag " + pItemIndex);
        }
    }

    public void resetComputedFlag(int pItemIndex) {
        if (pItemIndex <= 7 && this.isComputed(7)) {
            this.resetExpId();
        }
        for (int lIndex = pItemIndex; lIndex < 30; ++lIndex) {
            this.fComputedFlag[lIndex] = 0;
        }
        if (this.fDbgLevel >= 2) {
            this.flow.dbg(2, "resetComputedFlag", "reset all flags greater or equal " + pItemIndex);
        }
    }

    public void setUnderComputation(int pItemIndex) {
        this.fComputedFlag[pItemIndex] = 1;
        if (this.fDbgLevel > 0) {
            this.flowRoot.flow.dbg(5, " setUnderComputation " + pItemIndex);
        }
    }

    public boolean isComputedOrUnderComputation(int pItemIndex) {
        return this.fComputedFlag[pItemIndex] != 0;
    }

    void printComputedFlag() {
        System.out.print("\n fComputedFlag ");
        for (int i = 1; i < 30; ++i) {
            System.out.print(" " + this.fComputedFlag[i]);
        }
    }

    public List getExpIdList() {
        return this.fExpIdList;
    }

    public void printExpIdAndIrCorrespondence() {
        System.out.print("\nExpId and IR correspondence\n");
        for (ExpId lExpId : this.fExpIdList) {
            if (lExpId != null) {
                HIR lHir = this.getLinkedSubtreeOfExpId(lExpId);
                if (lHir != null) {
                    System.out.print(" " + lExpId.getName() + "  " + lExpId.getIndex() + " " + lHir.toStringWithChildren());
                    if (FlowUtil.isAssignLHS(lHir)) {
                        System.out.print(" LHS\n");
                        continue;
                    }
                    System.out.print("\n");
                    continue;
                }
                System.out.print(" " + lExpId.getName() + " null \n");
                continue;
            }
            System.out.print(" null \n");
        }
    }

    public int getComplexityLevel() {
        return this.fComplexity;
    }

    public boolean hasCallUnder(IR pIR) {
        return pIR instanceof HIR && this.fSubtreesContainingCall.contains(pIR);
    }

    public FlowAdapter getFlowAdapter() {
        return this.fFlowAdapter;
    }

    public List changeListOfFlowBBlocksToListOfAflowBBlocks(List pListOfFlowBBlocks) {
        if (pListOfFlowBBlocks == null) {
            return null;
        }
        ArrayList<coins.aflow.BBlock> lListOfAflowBBlocks = new ArrayList<coins.aflow.BBlock>(pListOfFlowBBlocks.size());
        for (Object lObject : pListOfFlowBBlocks) {
            if (!(lObject instanceof BBlock)) continue;
            lListOfAflowBBlocks.add(((BBlock)lObject).getAflowBBlock());
        }
        return lListOfAflowBBlocks;
    }

    public Set getMaximalCompoundVars() {
        if (this.fMaximalCompoundVars == null) {
            this.fMaximalCompoundVars = new HashSet();
        }
        return this.fMaximalCompoundVars;
    }

    public FlowAnalSym[] getFlowAnalSymTable() {
        return this.fFlowAnalSymTable;
    }

    public BBlockVector getDominators(BBlock pBBlock) {
        if (this.fDom == null) {
            this.fDom = ((ControlFlowImpl)this.flowRoot.controlFlow).fDom;
        }
        return this.fDom[pBBlock.getBBlockNumber()];
    }

    public BBlockVector getPostDominators(BBlock pBBlock) {
        if (this.fPostDom == null) {
            this.fPostDom = ((ControlFlowImpl)this.flowRoot.controlFlow).fPostDom;
        }
        return this.fPostDom[pBBlock.getBBlockNumber()];
    }

    public List getDominatorList(BBlock pBBlock) {
        if (this.fDomList == null) {
            this.fDomList = new ArrayList[this.getNumberOfBBlocks() + 1];
            Iterator lIterator = this.cfgIterator();
            while (lIterator.hasNext()) {
                BBlock lBBlock = (BBlock)lIterator.next();
                if (lBBlock == null) continue;
                this.fDomList[lBBlock.getBBlockNumber()] = this.getDominators(lBBlock).getBBlockList();
            }
        }
        return this.fDomList[pBBlock.getBBlockNumber()];
    }

    public List getPostDominatorList(BBlock pBBlock) {
        if (this.fPostDomList == null) {
            this.fPostDomList = new ArrayList[this.getNumberOfBBlocks() + 1];
            Iterator lIterator = this.cfgIterator();
            while (lIterator.hasNext()) {
                BBlock lBBlock = (BBlock)lIterator.next();
                if (lBBlock == null) continue;
                this.fPostDomList[lBBlock.getBBlockNumber()] = this.getPostDominators(lBBlock).getBBlockList();
            }
        }
        return this.fDomList[pBBlock.getBBlockNumber()];
    }

    public coins.aflow.SubpFlow getAflowSubpFlow(FlowResults pFlowResults) {
        if (this.fAflowSubpFlow == null) {
            this.fAflowSubpFlow = new coins.aflow.HirSubpFlowImpl(this.fSubpDefinition, pFlowResults);
        }
        return this.fAflowSubpFlow;
    }

    public List sortExpIdCollection(Collection pExpIdCollection) {
        if (pExpIdCollection == null || pExpIdCollection.isEmpty()) {
            return new ArrayList();
        }
        ExpId[] lExpIdArray = new ExpId[this.fExpIdNumber + 1];
        ArrayList lSortedList = new ArrayList(pExpIdCollection.size());
        for (Object lSym : pExpIdCollection) {
            if (lSym instanceof ExpId) {
                ExpId lExpId = (ExpId)lSym;
                String lTail = lExpId.getName().substring(4);
                int lSuffix = Integer.parseInt(lTail, 10);
                lExpIdArray[lSuffix] = lExpId;
                continue;
            }
            lSortedList.add(lSym);
        }
        for (int i = 0; i < this.fExpIdNumber + 1; ++i) {
            if (lExpIdArray[i] == null) continue;
            lSortedList.add(lExpIdArray[i]);
        }
        if (this.fDbgLevel > 4) {
            this.ioRoot.dbgFlow.print(7, "sortExpIdCollection", lSortedList.toString());
        }
        return lSortedList;
    }

    public boolean isFailed() {
        return this.failed;
    }
}

