/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.flow.DataFlow;
import coins.flow.ExpVector;
import coins.flow.ExpVectorIterator;
import coins.flow.FlowAnalSymVector;
import coins.flow.PointVector;
import coins.flow.PointVectorIterator;
import coins.flow.ShowDataFlow;
import coins.flow.SubpFlow;
import coins.ir.IR;
import coins.ir.hir.HIR;
import coins.sym.ExpId;
import coins.sym.FlowAnalSym;
import java.util.Set;

public class ShowDataFlowByName
extends ShowDataFlow {
    protected final DataFlow dataFlow;

    public ShowDataFlowByName(DataFlow pDataFlow) {
        super(pDataFlow);
        this.dataFlow = pDataFlow;
    }

    public void showPointVectorByName(PointVector pPoint) {
        SubpFlow lSubpFlow = this.flowRoot.fSubpFlow;
        PointVectorIterator lIterator = lSubpFlow.pointVectorIterator(pPoint);
        while (lIterator.hasNext()) {
            IR lNextPoint = lSubpFlow.getDefPoint(lIterator.nextIndex());
            if (lNextPoint == null) continue;
            this.ioRoot.printOut.print(" " + ((HIR)lNextPoint).toStringShort());
        }
        this.ioRoot.printOut.print("\n");
    }

    public void showExpVectorByName(ExpVector pexp) {
        if (pexp instanceof FlowAnalSymVector) {
            this.ioRoot.printOut.print(((FlowAnalSymVector)pexp).toStringDescriptive() + "\n");
            return;
        }
        SubpFlow lSubpFlow = this.flowRoot.fSubpFlow;
        ExpVectorIterator lIterator = lSubpFlow.expVectorIterator(pexp);
        while (lIterator.hasNext()) {
            FlowAnalSym lFlowAnalSym;
            String lExpString = null;
            int lNextIndex = lIterator.nextIndex();
            if (lNextIndex <= 0 || (lFlowAnalSym = this.dataFlow.getFlowAnalSym(this.dataFlow.expReverseLookup(lNextIndex))) == null) continue;
            this.ioRoot.printOut.print(" " + lFlowAnalSym.getName());
            if (lFlowAnalSym instanceof ExpId) {
                if (((ExpId)lFlowAnalSym).getLinkedSym() != null) {
                    lExpString = ((ExpId)lFlowAnalSym).getLinkedSym().getName();
                }
                if (lExpString == null && this.ioRoot.dbgFlow.getLevel() >= 7) {
                    lExpString = ((HIR)((ExpId)lFlowAnalSym).getLinkedNode()).toStringWithChildren();
                }
            }
            if (lExpString == null) continue;
            this.ioRoot.printOut.print("(" + lExpString + ")");
        }
        this.ioRoot.printOut.print("\n");
    }

    public void showNodeSet(Set pSet) {
        for (IR lNextPoint : pSet) {
            if (lNextPoint == null) continue;
            this.ioRoot.printOut.print(" " + ((HIR)lNextPoint).toStringShort());
        }
        this.ioRoot.printOut.print("\n");
    }
}

