/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.alias.RecordAlias;
import coins.flow.BBlock;
import coins.flow.BBlockImpl;
import coins.flow.BitVector;
import coins.flow.DataFlow;
import coins.flow.DataFlowHirImpl;
import coins.flow.DefUseList;
import coins.flow.DefUseListImpl;
import coins.flow.DefVector;
import coins.flow.DefVectorIterator;
import coins.flow.ExpVector;
import coins.flow.Flow;
import coins.flow.FlowAnalSymVector;
import coins.flow.FlowUtil;
import coins.flow.HirSubpFlowImpl;
import coins.flow.ListValuedMap;
import coins.flow.SetRefRepr;
import coins.flow.SetRefReprHirEImpl;
import coins.flow.SetRefReprList;
import coins.flow.ShowDataFlow;
import coins.flow.ShowDataFlowByName;
import coins.flow.SubpFlow;
import coins.flow.SubpFlowImpl;
import coins.flow.UseDefList;
import coins.flow.UseDefListImpl;
import coins.ir.IR;
import coins.ir.hir.AsmStmt;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirList;
import coins.ir.hir.HirSeq;
import coins.sym.ExpId;
import coins.sym.FlowAnalSym;
import coins.sym.PointerType;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class DataFlowImpl
implements DataFlow {
    public final FlowRoot flowRoot;
    public final IoRoot ioRoot;
    public final SymRoot symRoot;
    public final HirRoot hirRoot;
    public final Flow flow;
    public ShowDataFlowByName showDataFlowByName;
    protected SubpFlow fSubpFlow;
    protected ShowDataFlow fShowDataFlow;
    protected int fDefCount = 0;
    protected DefVector DEF_ZERO;
    protected DefVector DEF_INVERTED;
    protected ExpVector EXP_ZERO;
    protected ExpVector EXP_INVERTED;
    protected int[] fDefNodeIndexTable;
    protected FlowAnalSym[] fFlowAnalSymTable;
    protected Set[] fUndefinedUseNodesOfSym;
    protected RecordAlias fRecordAlias;
    public final int fDbgFlow;

    public DataFlowImpl(FlowRoot pFlowRoot, SubpFlow pSubpFlow) {
        this.flowRoot = pFlowRoot;
        this.ioRoot = pFlowRoot.ioRoot;
        this.symRoot = pFlowRoot.symRoot;
        this.hirRoot = pFlowRoot.hirRoot;
        this.flow = pFlowRoot.flow;
        this.fSubpFlow = pSubpFlow;
        this.flowRoot.dataFlow = this;
        this.fDbgFlow = this.ioRoot.dbgFlow.getLevel();
    }

    public DataFlowImpl() {
        this.flowRoot = null;
        this.ioRoot = null;
        this.symRoot = null;
        this.hirRoot = null;
        this.flow = null;
        this.fDbgFlow = 0;
    }

    protected void initiateDataFlow() {
        if (this.fDbgFlow > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(2, "DataFlowImpl.initiateDataFlow", "state " + this.flow.getFlowAnalStateLevel());
        }
        if (this.flow.getFlowAnalStateLevel() < 2) {
            throw new RuntimeException("CFG Must Be Constructed Before DFA.");
        }
        this.clean();
        int lNodeCount = this.fSubpFlow.getNumberOfNodes();
        if (this.fDbgFlow > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(1, "\n Node count " + lNodeCount + " SymExpCount " + this.fSubpFlow.getSymExpCount() + " AssignCount " + this.fSubpFlow.getAssignCount() + " CallCount " + this.fSubpFlow.getCallCount());
        }
        if (this.flowRoot.isHirAnalysis()) {
            // empty if block
        }
        this.fUndefinedUseNodesOfSym = new HashSet[this.fSubpFlow.getSymExpCount() + 1];
        this.fDefNodeIndexTable = new int[this.fSubpFlow.getAssignCount() + this.fSubpFlow.getCallCount() + 1];
        this.recordSetRefReprs();
        this.fShowDataFlow = new ShowDataFlow(this);
        this.showDataFlowByName = new ShowDataFlowByName(this);
        this.fShowDataFlow.setShowDataFlowByName(this.showDataFlowByName);
        this.allocateSpace();
        this.DEF_ZERO = this.fSubpFlow.defVector();
        this.DEF_INVERTED = this.fSubpFlow.defVector();
        this.DEF_ZERO.vectorNot(this.DEF_INVERTED);
        this.EXP_ZERO = this.fSubpFlow.expVector();
        this.EXP_INVERTED = this.fSubpFlow.expVector();
        this.EXP_ZERO.vectorNot(this.EXP_INVERTED);
    }

    void recordSetRefReprs() {
        ((HirSubpFlowImpl)this.fSubpFlow).recordSetRefReprs();
        this.fDefCount = this.fSubpFlow.getDefCount();
    }

    public List getBBlockList() {
        return this.fSubpFlow.getBBlockList();
    }

    protected void recordExpId() {
    }

    public int getDefCount() {
        return this.fDefCount;
    }

    public int getFlowAnalSymCount() {
        return this.fSubpFlow.getSymExpCount();
    }

    public int getPointCount() {
        return this.fSubpFlow.getNumberOfNodes();
    }

    public FlowAnalSym getFlowAnalSym(int ExpIndex) {
        if (this.fDbgFlow > 0) {
            this.ioRoot.dbgFlow.print(1, "getFlowAnalSyms", "should use subclass method");
        }
        return null;
    }

    public int getDefIndex(int NodeIndex) {
        return this.fSubpFlow.getDefIndex(NodeIndex - this.fSubpFlow.getIrIndexMin());
    }

    public int getDefNodeIndex(int pDefSetRefReprNo) {
        return this.fDefNodeIndexTable[pDefSetRefReprNo];
    }

    public IR getNode(int pNodeIndex) {
        if (pNodeIndex == 0) {
            return null;
        }
        return this.fSubpFlow.getIndexedNode(pNodeIndex);
    }

    public IR getNodeFromDefIndex(int pDefIndex) {
        return this.fSubpFlow.getIndexedNode(this.getDefNodeIndex(pDefIndex));
    }

    protected void allocateSpace() {
        if (this.flowRoot.isHirAnalysis()) {
            int lPointBitCount;
            int lDefBitCount = lPointBitCount = this.fSubpFlow.getIrIndexMax() - this.fSubpFlow.getIrIndexMin() + 2;
            this.fSubpFlow.setDefVectorBitCount(lDefBitCount);
            int lExpBitCount = this.getFlowAnalSymCount() + 1;
            this.fSubpFlow.setPointVectorBitCount(lPointBitCount);
            this.fSubpFlow.setExpVectorBitCount(lExpBitCount);
            if (this.fDbgFlow > 3) {
                this.flowRoot.ioRoot.dbgFlow.print(4, "allocateSpace", " pointBitCount " + lPointBitCount + " defBitCount " + lDefBitCount + " fDefCount " + this.fDefCount + " expBitCount " + lExpBitCount);
            }
            for (int i = 1; i <= this.fSubpFlow.getNumberOfBBlocks(); ++i) {
                BBlock b = this.fSubpFlow.getBBlock(i);
                b.allocateSpaceForDataFlowAnalysis(lPointBitCount, lDefBitCount, lExpBitCount);
            }
        } else {
            this.fSubpFlow.setDefVectorBitCount(this.fDefCount);
            this.fSubpFlow.setPointVectorBitCount(this.fSubpFlow.getPointVectorBitCount());
            this.fSubpFlow.setExpVectorBitCount(this.fSubpFlow.getUsedSymCount());
            for (int i = 1; i <= this.fSubpFlow.getNumberOfBBlocks(); ++i) {
                BBlock b = this.fSubpFlow.getBBlock(i);
                b.allocateSpaceForDataFlowAnalysis(this.fSubpFlow.getPointVectorBitCount(), this.fDefCount, this.fSubpFlow.getUsedSymCount());
            }
        }
    }

    public void findDef() {
        if (this.fDbgFlow > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, "findDef ");
        }
        if (this.fSubpFlow.isComputedOrUnderComputation(9)) {
            this.flow.dbg(5, " Use computed one.");
            return;
        }
        this.fSubpFlow.setUnderComputation(9);
        for (BBlock lBBlock : this.getBBlockList()) {
            this.findDef(lBBlock);
        }
        this.fSubpFlow.setComputedFlag(9);
    }

    public void findDef(BBlock pBBlock) {
        if (this.fDbgFlow > 3) {
            this.ioRoot.dbgFlow.print(5, "findDef", "B" + pBBlock.getBlockNumber());
        }
        SetRefReprList lBBlockSetRefReprList = this.fSubpFlow.getSetRefReprList(pBBlock);
        HashSet<FlowAnalSym> lBBlockDefSet = new HashSet<FlowAnalSym>();
        ListIterator lBBlockSetRefReprIterator = lBBlockSetRefReprList.listIterator(lBBlockSetRefReprList.size());
        while (lBBlockSetRefReprIterator.hasPrevious()) {
            FlowAnalSym lDef;
            SetRefRepr lSetRefRepr = (SetRefRepr)lBBlockSetRefReprIterator.previous();
            if (this.fDbgFlow > 3) {
                this.ioRoot.dbgFlow.printObject(6, " SetRefRepr", lSetRefRepr);
            }
            if ((lDef = lSetRefRepr.getDefSym()) == null) continue;
            if (this.fDbgFlow > 3) {
                this.ioRoot.dbgFlow.printObject(6, " def ", lDef);
            }
            if (lDef instanceof ExpId && !((SubpFlowImpl)this.fSubpFlow).getMaximalCompoundVars().contains(lDef)) continue;
            lBBlockDefSet.add(lDef);
            int lDefBitPosition = this.defLookup(lSetRefRepr.getIR().getIndex());
            if (this.fDbgFlow > 3) {
                this.ioRoot.dbgFlow.print(6, " defPosition " + lDefBitPosition);
            }
            ((BBlockImpl)pBBlock).getDefVector().setBit(lDefBitPosition);
            ((SubpFlowImpl)this.fSubpFlow).getListOfDefUseList().addDefUseChain(lSetRefRepr.getIR());
        }
        if (this.fDbgFlow > 3) {
            this.flowRoot.flow.dbg(6, "findDef B" + pBBlock.getBBlockNumber(), ((BBlockImpl)pBBlock).getDefVector().toStringDescriptive());
        }
    }

    public void findKill() {
        if (this.fDbgFlow > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, "findKill ");
        }
        if (this.fSubpFlow.isComputedOrUnderComputation(10)) {
            this.flow.dbg(5, " Use computed one.");
            return;
        }
        this.fSubpFlow.setUnderComputation(10);
        for (BBlock lBBlock : this.getBBlockList()) {
            this.findKill(lBBlock);
        }
        this.fSubpFlow.setComputedFlag(10);
    }

    public void findKill(BBlock pBBlock) {
        if (this.fDbgFlow > 3) {
            this.ioRoot.dbgFlow.print(5, "findKill", "B" + pBBlock.getBlockNumber());
        }
        for (BBlock lBBlock : this.getBBlockList()) {
            if (pBBlock != lBBlock) {
                SetRefReprList lBBlockSetRefReprList = this.fSubpFlow.getSetRefReprList(lBBlock);
                for (SetRefRepr lSetRefRepr : lBBlockSetRefReprList) {
                    FlowAnalSym lDef = lSetRefRepr.getDefSym();
                    if (lDef == null || !pBBlock.isDefined(lDef)) continue;
                    int lDefBitPosition = this.defLookup(lSetRefRepr.getIR().getIndex());
                    ((BBlockImpl)pBBlock).getKillVector().setBit(lDefBitPosition);
                }
                continue;
            }
            HashMap<FlowAnalSym, IR> lVarToDefPosition = new HashMap<FlowAnalSym, IR>();
            SetRefReprList lBBlockSetRefReprList2 = this.fSubpFlow.getSetRefReprList(lBBlock);
            for (SetRefRepr lSetRefRepr2 : lBBlockSetRefReprList2) {
                FlowAnalSym lDef2 = lSetRefRepr2.getDefSym();
                if (lDef2 == null) continue;
                if (lVarToDefPosition.containsKey(lDef2)) {
                    HIR lPreviousDef = (HIR)lVarToDefPosition.get(lDef2);
                    int lDefBitPosition2 = this.defLookup(lPreviousDef.getIndex());
                    ((BBlockImpl)pBBlock).getKillVector().setBit(lDefBitPosition2);
                    if (this.fDbgFlow > 3) {
                        this.flowRoot.flow.dbg(6, "Kill previous def " + lDef2.getName() + " at " + lPreviousDef.toStringShort());
                    }
                }
                lVarToDefPosition.put(lDef2, lSetRefRepr2.getIR());
            }
        }
        if (this.fDbgFlow > 3) {
            this.flowRoot.flow.dbg(6, "findKill B" + pBBlock.getBBlockNumber(), ((BBlockImpl)pBBlock).getKillVector().toStringDescriptive());
        }
    }

    public void findDefined() {
        if (this.fDbgFlow > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, "findDefined ");
        }
        if (this.fSubpFlow.isComputedOrUnderComputation(12)) {
            this.flow.dbg(5, " Use computed one.");
            return;
        }
        this.fSubpFlow.setUnderComputation(12);
        for (BBlock lBBlock : this.getBBlockList()) {
            this.findDefined(lBBlock);
        }
        this.fSubpFlow.setComputedFlag(12);
    }

    public void findDefined(BBlock pBBlock) {
        SetRefReprList lBBlockSetRefReprList = this.fSubpFlow.getSetRefReprList(pBBlock);
        if (this.fDbgFlow > 3) {
            this.ioRoot.dbgFlow.print(5, "findDefined B", " " + pBBlock.getBlockNumber());
        }
        for (SetRefRepr lSetRefRepr : lBBlockSetRefReprList) {
            FlowAnalSym lDef;
            HIR lIrSubtree = (HIR)lSetRefRepr.getIR();
            if (this.fDbgFlow > 4) {
                this.ioRoot.dbgFlow.print(5, " " + IoRoot.toStringObjectShort(lIrSubtree));
            }
            if ((lDef = lSetRefRepr.getDefSym()) == null) continue;
            if (this.fDbgFlow > 3) {
                this.ioRoot.dbgFlow.print(5, " def " + lDef);
            }
            if (lDef instanceof Var) {
                this.fSubpFlow.getDefinedSyms().add(lDef);
            } else if (lDef instanceof ExpId && ((ExpId)lDef).isLHS()) {
                lDef = ((ExpId)lDef).getExpInf().getRValueExpId();
                if (this.fDbgFlow > 3) {
                    this.ioRoot.dbgFlow.print(5, " r-value " + lDef.getName());
                }
            }
            int lExpBitPosition = this.expLookup(lDef.getIndex());
            ((BBlockImpl)pBBlock).getDefinedVector().setBit(lExpBitPosition);
        }
        if (this.fDbgFlow > 3) {
            this.flowRoot.flow.dbg(6, "findDefined B" + pBBlock.getBBlockNumber(), ((BBlockImpl)pBBlock).getDefinedVector().toStringDescriptive());
        }
    }

    public void findUsed() {
        if (this.fDbgFlow > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, "findUsed ");
        }
        if (this.fSubpFlow.isComputedOrUnderComputation(13)) {
            this.flow.dbg(5, " Use computed one.");
            return;
        }
        this.fSubpFlow.setUnderComputation(13);
        for (BBlock lBBlock : this.getBBlockList()) {
            this.findUsed(lBBlock);
        }
        this.fSubpFlow.setComputedFlag(13);
    }

    public void findUsed(BBlock pBBlock) {
        SetRefReprList lBBlockSetRefReprList = this.fSubpFlow.getSetRefReprList(pBBlock);
        if (this.fDbgFlow > 3) {
            this.ioRoot.dbgFlow.print(5, "\nfindUsed B" + pBBlock.getBlockNumber());
        }
        for (SetRefRepr lSetRefRepr : lBBlockSetRefReprList) {
            HIR lIrSubtree = (HIR)lSetRefRepr.getIR();
            if (this.fDbgFlow > 4) {
                this.ioRoot.dbgFlow.print(5, " " + IoRoot.toStringObjectShort(lIrSubtree));
            }
            List lUseList = lSetRefRepr.useSymList();
            for (FlowAnalSym lUsedSym : lUseList) {
                if (this.fDbgFlow > 3) {
                    this.ioRoot.dbgFlow.print(5, " use " + lUsedSym);
                }
                int lExpBitPosition = this.expLookup(lUsedSym.getIndex());
                ((BBlockImpl)pBBlock).getUsedVector().setBit(lExpBitPosition);
            }
        }
        if (this.fDbgFlow > 3) {
            this.flowRoot.flow.dbg(6, "findUsed B" + pBBlock.getBBlockNumber(), ((BBlockImpl)pBBlock).getUsedVector().toStringDescriptive());
        }
    }

    public void findExposed() {
        if (this.fDbgFlow > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, "findExposed ");
        }
        if (this.fSubpFlow.isComputedOrUnderComputation(14)) {
            this.flow.dbg(5, " Use computed one.");
            return;
        }
        this.fSubpFlow.setUnderComputation(14);
        for (BBlock lBBlock : this.getBBlockList()) {
            this.findExposed(lBBlock);
        }
        this.fSubpFlow.setComputedFlag(14);
    }

    public void findExposed(BBlock pBBlock) {
        if (this.fDbgFlow > 3) {
            this.ioRoot.dbgFlow.print(5, "findExposed", "B" + pBBlock.getBlockNumber());
        }
        SetRefReprList lBBlockSetRefReprList = this.fSubpFlow.getSetRefReprList(pBBlock);
        FlowAnalSymVector lExposed = ((BBlockImpl)pBBlock).getExposedVector();
        HashSet<FlowAnalSym> lSetOfDefSyms = new HashSet<FlowAnalSym>();
        ListIterator lBBlockSetRefReprIterator = lBBlockSetRefReprList.listIterator(lBBlockSetRefReprList.size());
        while (lBBlockSetRefReprIterator.hasPrevious()) {
            FlowAnalSym lDefSym;
            SetRefRepr lSetRefRepr = (SetRefRepr)lBBlockSetRefReprIterator.previous();
            if (this.fDbgFlow > 3) {
                this.ioRoot.dbgFlow.printObject(7, "lSetRefRepr", lSetRefRepr);
            }
            if ((lDefSym = lSetRefRepr.getDefSym()) != null) {
                if (this.fDbgFlow > 3) {
                    this.ioRoot.dbgFlow.printObject(6, " lDef ", lDefSym);
                }
                lSetOfDefSyms.add(lDefSym);
            }
            Set lUseFlowAnalSyms = lSetRefRepr.getUseFlowAnalSyms();
            if (this.fDbgFlow > 3) {
                this.ioRoot.dbgFlow.printObject(6, " lUse ", lUseFlowAnalSyms);
            }
            lExposed.vectorOr(this.toExpVector(lUseFlowAnalSyms), lExposed);
        }
        for (FlowAnalSym lSym : lSetOfDefSyms) {
            int lExpBitPosition = this.expLookup(lSym.getIndex());
            lExposed.resetBit(lExpBitPosition);
        }
        if (this.fDbgFlow > 3) {
            this.flowRoot.flow.dbg(6, "findExposed B" + pBBlock.getBBlockNumber(), ((BBlockImpl)pBBlock).getExposedVector().toStringDescriptive());
        }
    }

    public void findEGen() {
        if (this.fDbgFlow > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, "findEGen ");
        }
        if (this.fSubpFlow.isComputedOrUnderComputation(15)) {
            this.flow.dbg(5, " Use computed one.");
            return;
        }
        this.fSubpFlow.setUnderComputation(15);
        this.fRecordAlias = this.fSubpFlow.getRecordAlias();
        for (BBlock lBBlock : this.getBBlockList()) {
            this.findEGen(lBBlock);
        }
        this.fSubpFlow.setComputedFlag(15);
    }

    protected void addEGenExpId(Set pEGenSet, Set pEKillSet, SetRefRepr pSetRefRepr) {
        Set lGenerated = ((SetRefReprHirEImpl)pSetRefRepr).expIdSet();
        HIR lHir = (HIR)pSetRefRepr.getIR();
        if (this.fDbgFlow > 3) {
            this.flow.dbg(5, "\n addEGenExpId", lHir.toStringShort() + " generates " + lGenerated);
        }
        if (this.fDbgFlow > 3) {
            this.flow.dbg(5, " kill", pEKillSet);
        }
        pEGenSet.addAll(lGenerated);
        pEKillSet.removeAll(lGenerated);
        HashSet lModSyms = new HashSet();
        lModSyms.addAll(pSetRefRepr.modSyms00());
        if (pSetRefRepr instanceof SetRefReprHirEImpl) {
            lModSyms.addAll(((SetRefReprHirEImpl)pSetRefRepr).modSymsStmt());
        }
        if (this.fDbgFlow > 3) {
            this.flow.dbg(6, "addEGen lModSyms", lModSyms);
        }
        if (this.fSubpFlow != null && this.fRecordAlias != null) {
            Set lModAlias = this.fRecordAlias.aliasSymGroup(lModSyms);
            lModSyms.addAll(lModAlias);
            if (this.fDbgFlow > 3) {
                this.flow.dbg(6, " modAlias ", lModSyms);
            }
        }
        Iterator lIt = pEGenSet.iterator();
        block0: while (lIt.hasNext()) {
            ExpId lExpId = (ExpId)lIt.next();
            Iterator lOperandIt = lExpId.getOperandSet0().iterator();
            while (lOperandIt.hasNext()) {
                if (!lModSyms.contains(lOperandIt.next())) continue;
                lIt.remove();
                continue block0;
            }
        }
        if (this.fSubpFlow != null) {
            List lExpIdList = this.fSubpFlow.getExpIdList();
            for (ExpId lExpId : lExpIdList) {
                if (lExpId == null) continue;
                Iterator lOperandIt = lExpId.getOperandSet0().iterator();
                while (lOperandIt.hasNext()) {
                    if (!lModSyms.contains(lOperandIt.next())) continue;
                    pEKillSet.add(lExpId);
                    if (this.fDbgFlow <= 3) continue;
                    this.flow.dbg(7, " add-to-EKill ", lExpId);
                }
            }
            if (this.fDbgFlow > 3) {
                this.flow.dbg(5, "\n  pEKillSet", pEKillSet);
                this.flow.dbg(6, " addEGen-result=", pEGenSet);
            }
        }
    }

    public void findEGen(BBlock pBBlock) {
        if (this.fDbgFlow > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(1, "findEGen", "should be used that of subclass");
        }
    }

    public void findEKill() {
        if (this.fDbgFlow > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, "findEKill ");
        }
        if (this.fSubpFlow.isComputedOrUnderComputation(16)) {
            this.flow.dbg(5, " Use computed one.");
            return;
        }
        this.fSubpFlow.setUnderComputation(16);
        this.findEGen();
        for (BBlock lBBlock : this.getBBlockList()) {
            this.findEKill(lBBlock);
        }
        this.fSubpFlow.setComputedFlag(16);
    }

    public void findEKill(BBlock pBBlock) {
    }

    public void findReach() {
        boolean lChanged;
        if (this.fDbgFlow > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, "findReach ");
        }
        if (this.fSubpFlow.isComputedOrUnderComputation(11)) {
            this.flow.dbg(5, " Use computed one.");
            return;
        }
        this.fSubpFlow.setUnderComputation(11);
        if (!this.fSubpFlow.isComputed(9)) {
            this.findDef();
        }
        if (!this.fSubpFlow.isComputed(10)) {
            this.findKill();
        }
        DefVector lSurvived = this.fSubpFlow.defVector();
        DefVector lPredReachOut = this.fSubpFlow.defVector();
        for (BBlock lBBlock : this.getBBlockList()) {
            ((BBlockImpl)lBBlock).getReachVector().vectorReset();
        }
        int lRepetition = 0;
        do {
            ++lRepetition;
            if (this.fDbgFlow > 3) {
                this.flowRoot.ioRoot.dbgFlow.print(4, "reach loop " + lRepetition);
            }
            lChanged = false;
            Iterator lCFGIterator = this.getBBlockList().iterator();
            while (lCFGIterator.hasNext()) {
                BBlock lBBlock;
                DefVector lNewReach = this.fSubpFlow.defVector();
                DefVector lDefSurvived = this.fSubpFlow.defVector();
                lBBlock = (BBlock)lCFGIterator.next();
                List lPredList = lBBlock.getPredList();
                for (BBlock lPredBBlock : lPredList) {
                    DefVector lPredDef = lPredBBlock.getDef();
                    DefVector lPredKill = lPredBBlock.getKill();
                    if (this.fDbgFlow >= 5) {
                        this.ioRoot.dbgFlow.print(5, "predDef ", "B" + lPredBBlock.getBBlockNumber());
                        this.showDataFlowByName.showPointVectorByName(lPredDef);
                        this.ioRoot.dbgFlow.print(5, "predKill ", "B" + lPredBBlock.getBBlockNumber());
                        this.showDataFlowByName.showPointVectorByName(lPredKill);
                    }
                    DefVector lPredReach = ((BBlockImpl)lPredBBlock).getReachVector();
                    lPredReach.vectorOr(lPredDef, lPredReachOut);
                    lPredReachOut.vectorSub(lPredKill, lPredReachOut);
                    lNewReach.vectorOr(lPredReachOut, lNewReach);
                }
                if (lNewReach.vectorEqual(((BBlockImpl)lBBlock).getReachVector())) continue;
                lChanged = true;
                ((BBlockImpl)lBBlock).setReach(lNewReach);
                if (this.fDbgFlow < 5) continue;
                this.ioRoot.dbgFlow.print(5, "changed reach ", "B" + lBBlock.getBBlockNumber());
                this.showDataFlowByName.showPointVectorByName(lNewReach);
            }
        } while (lChanged);
        this.fSubpFlow.setComputedFlag(11);
    }

    public void findAvailInAvailOut() {
        boolean lChanged;
        ExpVector lAvailIn;
        if (this.fDbgFlow > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, "findAvailInAvailOut ");
        }
        if (this.fSubpFlow.isComputedOrUnderComputation(17)) {
            this.flow.dbg(5, " Use computed one.");
            return;
        }
        this.fSubpFlow.setUnderComputation(17);
        this.fSubpFlow.setUnderComputation(18);
        ExpVector lSurvived = this.fSubpFlow.expVector();
        ExpVector lPredAvailOut = this.fSubpFlow.expVector();
        for (BBlock lBBlock : this.getBBlockList()) {
            lAvailIn = ((BBlockImpl)lBBlock).getAvailInVector();
            if (lBBlock.isEntryBlock()) {
                lAvailIn.vectorReset();
                continue;
            }
            this.EXP_INVERTED.vectorCopy(lAvailIn);
        }
        do {
            lChanged = false;
            Iterator lCFGIterator = this.getBBlockList().iterator();
            while (lCFGIterator.hasNext()) {
                BBlock lBBlock;
                ExpVector lNewAvailIn = this.fSubpFlow.expVector();
                lBBlock = (BBlock)lCFGIterator.next();
                if (this.fDbgFlow > 3) {
                    this.flowRoot.ioRoot.dbgFlow.print(5, " B" + lBBlock.getBBlockNumber());
                }
                if (lBBlock.isEntryBlock()) continue;
                List lPredList = lBBlock.getPredList();
                this.EXP_INVERTED.vectorCopy(lNewAvailIn);
                for (BBlock lPredBBlock : lPredList) {
                    ExpVector lPredEGen = lPredBBlock.getEGen();
                    ExpVector lPredEKill = lPredBBlock.getEKill();
                    ExpVector lPredAvailIn = ((BBlockImpl)lPredBBlock).getAvailInVector();
                    lPredAvailIn.vectorSub(lPredEKill, lSurvived);
                    lPredEGen.vectorOr(lSurvived, lPredAvailOut);
                    lNewAvailIn.vectorAnd(lPredAvailOut, lNewAvailIn);
                }
                if (lNewAvailIn.vectorEqual(((BBlockImpl)lBBlock).getAvailInVector())) continue;
                lChanged = true;
                ((BBlockImpl)lBBlock).setAvailIn(lNewAvailIn);
            }
        } while (lChanged);
        for (BBlock lBBlock : this.getBBlockList()) {
            ExpVector lEGen = lBBlock.getEGen();
            ExpVector lEKill = lBBlock.getEKill();
            lAvailIn = ((BBlockImpl)lBBlock).getAvailInVector();
            lAvailIn.vectorSub(lEKill, lSurvived);
            ExpVector lAvailOut = this.fSubpFlow.expVector();
            lEGen.vectorOr(lSurvived, lAvailOut);
            ((BBlockImpl)lBBlock).setAvailOut(lAvailOut);
        }
        this.fSubpFlow.setComputedFlag(17);
        this.fSubpFlow.setComputedFlag(18);
    }

    public void findLiveInLiveOut() {
        boolean lChanged;
        if (this.fDbgFlow > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, "findLiveInLiveOut\n");
        }
        if (this.fSubpFlow.isComputedOrUnderComputation(19)) {
            this.flow.dbg(5, " Use computed one.");
            return;
        }
        this.fSubpFlow.setUnderComputation(19);
        FlowAnalSymVector lSurvived = this.fSubpFlow.flowAnalSymVector();
        FlowAnalSymVector lSuccLiveIn = this.fSubpFlow.flowAnalSymVector();
        for (BBlock lBBlock : this.getBBlockList()) {
            ((BBlockImpl)lBBlock).getLiveOutVector().vectorReset();
        }
        do {
            lChanged = false;
            if (this.fDbgFlow > 3) {
                this.ioRoot.dbgFlow.print(5, "findLiveInLiveOut", "iteration ");
            }
            Iterator lCFGIterator = this.getBBlockList().listIterator(this.getBBlockList().size());
            while (lCFGIterator.hasPrevious()) {
                BBlock lBBlock;
                FlowAnalSymVector lNewLiveOut = this.fSubpFlow.flowAnalSymVector();
                lBBlock = (BBlock)lCFGIterator.previous();
                List lSuccList = lBBlock.getSuccList();
                if (this.fDbgFlow > 3) {
                    this.ioRoot.dbgFlow.print(5, " B " + lBBlock.getBlockNumber());
                }
                for (BBlock lSuccBBlock : lSuccList) {
                    FlowAnalSymVector lSuccExposed = lSuccBBlock.getExposed();
                    FlowAnalSymVector lSuccDefined = lSuccBBlock.getDefined();
                    FlowAnalSymVector lSuccLiveOut = ((BBlockImpl)lSuccBBlock).getLiveOutVector();
                    lSuccLiveOut.vectorSub(lSuccDefined, lSurvived);
                    lSuccExposed.vectorOr(lSurvived, lSuccLiveIn);
                    lNewLiveOut.vectorOr(lSuccLiveIn, lNewLiveOut);
                }
                if (lNewLiveOut.vectorEqual(((BBlockImpl)lBBlock).getLiveOutVector())) continue;
                lChanged = true;
                ((BBlockImpl)lBBlock).setLiveOut(lNewLiveOut);
            }
        } while (lChanged);
        for (BBlock lBBlock : this.getBBlockList()) {
            FlowAnalSymVector lExposed = lBBlock.getExposed();
            FlowAnalSymVector lDefined = lBBlock.getDefined();
            FlowAnalSymVector lLiveOut = ((BBlockImpl)lBBlock).getLiveOutVector();
            lLiveOut.vectorSub(lDefined, lSurvived);
            FlowAnalSymVector lLiveIn = this.fSubpFlow.flowAnalSymVector();
            lExposed.vectorOr(lSurvived, lLiveIn);
            ((BBlockImpl)lBBlock).setLiveIn(lLiveIn);
        }
        this.fSubpFlow.setComputedFlag(19);
        this.fSubpFlow.setComputedFlag(20);
    }

    public void findDefInDefOut() {
        boolean lChanged;
        FlowAnalSymVector lDefIn;
        if (this.fDbgFlow > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, "\n findDefInDefOut ");
        }
        if (this.fSubpFlow.isComputedOrUnderComputation(21)) {
            this.flow.dbg(5, " Use computed one.");
            return;
        }
        this.fSubpFlow.setUnderComputation(21);
        FlowAnalSymVector lPredDefOut = this.fSubpFlow.flowAnalSymVector();
        for (BBlock lBBlock : this.getBBlockList()) {
            lDefIn = ((BBlockImpl)lBBlock).getDefInVector();
            if (lBBlock.isEntryBlock()) {
                lDefIn.vectorReset();
                continue;
            }
            this.EXP_INVERTED.vectorCopy(lDefIn);
        }
        do {
            lChanged = false;
            Iterator lCFGIterator = this.getBBlockList().iterator();
            while (lCFGIterator.hasNext()) {
                BBlock lBBlock;
                FlowAnalSymVector lNewDefIn = this.fSubpFlow.flowAnalSymVector();
                lBBlock = (BBlock)lCFGIterator.next();
                if (lBBlock.isEntryBlock()) continue;
                List lPredList = lBBlock.getPredList();
                this.EXP_INVERTED.vectorCopy(lNewDefIn);
                for (BBlock lPredBBlock : lPredList) {
                    FlowAnalSymVector lPredDefined = lPredBBlock.getDefined();
                    FlowAnalSymVector lPredDefIn = ((BBlockImpl)lPredBBlock).getDefInVector();
                    lPredDefined.vectorOr(lPredDefIn, lPredDefOut);
                    lNewDefIn.vectorAnd(lPredDefOut, lNewDefIn);
                }
                if (lNewDefIn.vectorEqual(((BBlockImpl)lBBlock).getDefInVector())) continue;
                lChanged = true;
                ((BBlockImpl)lBBlock).setDefIn(lNewDefIn);
            }
        } while (lChanged);
        for (BBlock lBBlock : this.getBBlockList()) {
            FlowAnalSymVector lDefined = lBBlock.getDefined();
            lDefIn = ((BBlockImpl)lBBlock).getDefInVector();
            FlowAnalSymVector lDefOut = this.fSubpFlow.flowAnalSymVector();
            lDefined.vectorOr(lDefIn, lDefOut);
            ((BBlockImpl)lBBlock).setDefOut(lDefOut);
        }
        this.fSubpFlow.setComputedFlag(21);
        this.fSubpFlow.setComputedFlag(22);
    }

    public int defLookup(int pNodeIndex) {
        int lBitPosition = this.getDefIndex(pNodeIndex);
        return lBitPosition;
    }

    public int defReverseLookup(int pBitPosition) {
        int lNodeIndex = this.fDefNodeIndexTable[pBitPosition];
        return lNodeIndex;
    }

    public int expLookup(int pExpIdIndex) {
        int lBitPosition = pExpIdIndex;
        return lBitPosition;
    }

    public int expReverseLookup(int pBitPosition) {
        int lExpIdIndex = pBitPosition;
        return lExpIdIndex;
    }

    public Set getUseFlowAnalSyms(IR pSubtree) {
        return ((DataFlowHirImpl)this).getUseFlowAnalSymsForHir((HIR)pSubtree);
    }

    public Set getUseFlowAnalSymsForHir(HIR pSubtree) {
        if (this.fDbgFlow > 0) {
            this.ioRoot.dbgFlow.print(1, "getUseFlowAnalSymsForHir", "should use subclass method");
        }
        return null;
    }

    public Set getUseFlowAnalSyms(FlowAnalSym pFlowAnalSym) {
        return ((DataFlowHirImpl)this).getUseFlowAnalSyms(pFlowAnalSym);
    }

    public void clean() {
        if (this.fDbgFlow > 0) {
            this.flow.dbg(3, "\nclean");
        }
        ((SubpFlowImpl)this.fSubpFlow).failed = false;
        for (BBlock lBBlock : this.getBBlockList()) {
            if (lBBlock == null) continue;
            lBBlock.setWorkFA(null);
        }
    }

    public void findBasic() {
        this.findDef();
        this.findDefined();
        this.findKill();
        this.findExposed();
        this.findEGen();
        this.findEKill();
    }

    public void solveAll() {
        this.findReach();
        this.findAvailInAvailOut();
        this.findLiveInLiveOut();
        this.findDefInDefOut();
    }

    public void findAllBitVectors() {
        this.findBasic();
        this.solveAll();
    }

    public void findDefUse() {
        this.flow.dbg(5, "findDefUse ");
        if (this.fSubpFlow.isComputedOrUnderComputation(24)) {
            this.flow.dbg(5, " Use computed one.");
            return;
        }
        this.fSubpFlow.setUnderComputation(24);
        if (!this.fSubpFlow.isComputed(9)) {
            this.findDef();
        }
        if (!this.fSubpFlow.isComputed(11)) {
            this.findReach();
        }
        this.findUseDef();
        this.fSubpFlow.setComputedFlag(24);
    }

    public void findDefUseExhaustively() {
        this.flow.dbg(5, "findDefUseExhaustively ");
        if (this.fSubpFlow.isComputedOrUnderComputation(26)) {
            this.flow.dbg(5, " Use computed one.");
            return;
        }
        this.fSubpFlow.setUnderComputation(26);
        if (!this.fSubpFlow.isComputed(9)) {
            this.findDef();
        }
        if (!this.fSubpFlow.isComputed(11)) {
            this.findReach();
        }
        this.findUseDefExhaustively();
        this.fSubpFlow.setComputedFlag(26);
    }

    public void findUseDef() {
        if (this.fDbgFlow > 3) {
            this.flow.dbg(5, "findUseDef ");
        }
        if (this.fSubpFlow.isComputedOrUnderComputation(25)) {
            if (this.fDbgFlow > 3) {
                this.flow.dbg(5, " Use computed one.");
            }
            return;
        }
        this.fSubpFlow.setUnderComputation(25);
        if (!this.fSubpFlow.isComputed(12)) {
            this.findDefined();
        }
        if (!this.fSubpFlow.isComputed(13)) {
            this.findUsed();
        }
        if (!this.fSubpFlow.isComputed(11)) {
            this.findReach();
        }
        for (BBlock lBBlock : this.getBBlockList()) {
            this.findUseDef(lBBlock, false);
        }
        this.fSubpFlow.setComputedFlag(25);
        this.fSubpFlow.setComputedFlag(24);
    }

    public void findUseDefExhaustively() {
        if (this.fDbgFlow > 3) {
            this.flow.dbg(5, "findUseDefExhaustively ");
        }
        if (this.fSubpFlow.isComputedOrUnderComputation(27)) {
            if (this.fDbgFlow > 3) {
                this.flow.dbg(5, " Use computed one.");
            }
            return;
        }
        this.fSubpFlow.setUnderComputation(27);
        if (!this.fSubpFlow.isComputed(12)) {
            this.findDefined();
        }
        if (!this.fSubpFlow.isComputed(13)) {
            this.findUsed();
        }
        if (!this.fSubpFlow.isComputed(11)) {
            this.findReach();
        }
        for (BBlock lBBlock : this.getBBlockList()) {
            this.findUseDef(lBBlock, true);
        }
        this.fSubpFlow.setComputedFlag(27);
        this.fSubpFlow.setComputedFlag(26);
    }

    protected void findUseDef(BBlock pBBlock, boolean pExhaustive) {
        SetRefRepr lReachSetRefRepr;
        UseDefList lUseDefList;
        DefUseList lDefUseList;
        if (this.fDbgFlow > 3) {
            this.flow.dbg(5, "\nfindUseDef B" + pBBlock.getBBlockNumber() + " " + pBBlock.getIrLink() + " exhaustive " + pExhaustive);
        }
        DefVector lReach = pBBlock.getReach();
        ArrayList<HIR> lCallNodeStack = new ArrayList<HIR>();
        ListValuedMap lSymToDefNode = new ListValuedMap();
        if (pExhaustive) {
            lDefUseList = ((SubpFlowImpl)this.fSubpFlow).getListOfDefUseExhaustiveList();
            lUseDefList = ((SubpFlowImpl)this.fSubpFlow).getListOfUseDefExhaustiveList();
        } else {
            lDefUseList = ((SubpFlowImpl)this.fSubpFlow).getListOfDefUseList();
            lUseDefList = ((SubpFlowImpl)this.fSubpFlow).getListOfUseDefList();
        }
        HashSet<FlowAnalSym> lDefSyms = new HashSet<FlowAnalSym>();
        Set lUsedSyms = pBBlock.getUsed().flowAnalSyms();
        DefVectorIterator lReachIt = lReach.defVectorIterator();
        while ((lReachSetRefRepr = lReachIt.nextSetRefRepr()) != null) {
            IR lSetRefReprNode = lReachSetRefRepr.getIR();
            Set lModSyms = pExhaustive ? lReachSetRefRepr.modSyms00() : lReachSetRefRepr.modSyms();
            if (this.fDbgFlow > 3) {
                this.flow.dbg(5, "lReachSetRefRepr", "modSyms" + lModSyms + " " + lSetRefReprNode.toStringShort());
            }
            for (FlowAnalSym lFlowAnalSym : lModSyms) {
                if (lFlowAnalSym instanceof ExpId && !this.fSubpFlow.getMaximalCompoundVars().contains(lFlowAnalSym) || !lUsedSyms.contains(lFlowAnalSym)) continue;
                ((List)lSymToDefNode.get(lFlowAnalSym)).add(lSetRefReprNode);
                if (this.fDbgFlow > 3) {
                    this.flow.dbg(5, " add " + lSetRefReprNode.toStringShort() + " to " + lFlowAnalSym.getName());
                }
                lDefSyms.add(lFlowAnalSym);
            }
        }
        if (this.fDbgFlow > 3) {
            this.flow.dbg(5, " lDefSyms of reaching def " + ((Object)lDefSyms).toString());
            this.flow.dbg(5, "lSymToDefNode (by reaching def)", lSymToDefNode.toString());
        }
        SetRefRepr lSetRefReprOfBBlock22 = null;
        for (SetRefRepr lSetRefReprOfBBlock22 : this.fSubpFlow.getSetRefReprList(pBBlock)) {
            IR lCallNode;
            if (lSetRefReprOfBBlock22 == null) continue;
            this.flow.dbg(5, "\nlSetRefReprOfBBlock " + ((Object)lSetRefReprOfBBlock22).toString());
            ArrayList<IR> lSetNodeList = new ArrayList<IR>();
            HashSet<IR> lDeferedNodes = new HashSet<IR>();
            HIR lSubtree = (HIR)lSetRefReprOfBBlock22.getIR();
            HirIterator lHirIt = lSubtree.hirIterator(lSubtree);
            while (lHirIt.hasNext()) {
                Type lType;
                HIR c;
                int op;
                HIR parentUseNode;
                HIR lUseNode;
                FlowAnalSym lFlowAnalSym;
                HIR lNode = lHirIt.next();
                if (lNode == null) continue;
                Object var27_27 = null;
                if (this.fDbgFlow > 3) {
                    this.flow.dbg(5, "\n lNode " + lNode.toStringShort());
                }
                if (lNode instanceof AssignStmt) {
                    lSetNodeList.add(lNode.getChild1());
                    lDeferedNodes.add(lNode.getChild1());
                    continue;
                }
                if (lNode instanceof AsmStmt) {
                    if (!((SubpFlowImpl)this.fSubpFlow).fMultipleSetRef.containsKey(lNode)) continue;
                    HirSeq lSeq = (HirSeq)((SubpFlowImpl)this.fSubpFlow).fMultipleSetRef.get(lNode);
                    HirList lSetOperands = (HirList)lSeq.getChild(2);
                    ListIterator lIter = lSetOperands.iterator();
                    while (lIter.hasNext()) {
                        lSetNodeList.add((IR)lIter.next());
                    }
                    HirList lWriteOperands = (HirList)lSeq.getChild(3);
                    ListIterator lIter2 = lWriteOperands.iterator();
                    while (lIter2.hasNext()) {
                        HIR lWriteNode = (HIR)lIter2.next();
                        if (!lSetNodeList.contains(lWriteNode)) {
                            lSetNodeList.add(lWriteNode);
                        }
                        lDeferedNodes.add(lWriteNode);
                    }
                    continue;
                }
                if (lDeferedNodes.contains(lNode)) {
                    if (this.fDbgFlow <= 3) continue;
                    this.flow.dbg(5, " skip defered top node " + lNode.toStringShort());
                    continue;
                }
                HIR TopNode = lUseNode = lNode;
                lFlowAnalSym = null;
                while ((parentUseNode = (HIR)TopNode.getParent()) != null && (op = parentUseNode.getOperator()) == 19) {
                    TopNode = parentUseNode;
                }
                if (TopNode != lUseNode && lUseNode != (c = FlowUtil.getQualVarNode(TopNode))) continue;
                if (!lCallNodeStack.isEmpty() && !FlowUtil.isUnder(lCallNode = (IR)lCallNodeStack.get(lCallNodeStack.size() - 1), lUseNode)) {
                    this.handleCall(lCallNode, this.fSubpFlow, lDefSyms, lSymToDefNode);
                    lCallNodeStack.remove(lCallNodeStack.size() - 1);
                }
                if (FlowUtil.flowAnalSym(lUseNode) != null && !FlowUtil.isDefSymNode(lUseNode) && !FlowUtil.notDereferenced(lUseNode)) {
                    lFlowAnalSym = (FlowAnalSym)lUseNode.getSym();
                } else {
                    if (this.fDbgFlow > 3) {
                        this.flow.dbg(6, " may be use node " + lUseNode.toStringShort() + " " + IoRoot.toStringObjectShort(lUseNode.getSymOrExpId()));
                    }
                    if (lUseNode.getSymOrExpId() instanceof FlowAnalSym) {
                        lFlowAnalSym = lUseNode.getSymOrExpId();
                    }
                    if (FlowUtil.isCall(lUseNode)) {
                        lCallNodeStack.add(lUseNode);
                        if (this.fDbgFlow <= 3) continue;
                        this.flow.dbg(6, " stack " + lUseNode.toStringShort());
                        continue;
                    }
                    if (lFlowAnalSym == null) continue;
                    if (lFlowAnalSym instanceof ExpId && !this.fSubpFlow.getMaximalCompoundVars().contains(lFlowAnalSym)) {
                        if (this.fDbgFlow <= 3) continue;
                        this.flow.dbg(6, " ignore non-maximalCompoundVar " + lFlowAnalSym.getName());
                        continue;
                    }
                }
                if (lFlowAnalSym == null) continue;
                if (this.fDbgFlow > 3) {
                    this.flow.dbg(6, " lUseNode " + lNode.toStringShort() + " " + lFlowAnalSym.getName());
                }
                if ((lType = lFlowAnalSym.getSymType()) != null && !(lType instanceof VectorType) && !(lType instanceof PointerType)) {
                    int CallCount = 0;
                    for (IR lDefNode : (List)lSymToDefNode.get(lFlowAnalSym)) {
                        if (lDefNode == null) continue;
                        if (this.fDbgFlow > 3) {
                            this.flow.dbg(6, " lDefNode " + lDefNode.toStringShort());
                        }
                        if (lDefNode.getOperator() == 33) {
                            if (++CallCount > 2) {
                                continue;
                            }
                        } else {
                            ((DefUseListImpl)lDefUseList).getOrAddDefUseChain(lDefNode).addUseNode(lUseNode);
                            if (this.fDbgFlow > 3) {
                                this.flow.dbg(6, " addUseNode " + lUseNode.toStringShort());
                            }
                        }
                        ((UseDefListImpl)lUseDefList).getOrAddUseDefChain(lUseNode).addDefNode(lDefNode);
                        if (this.fDbgFlow <= 3) continue;
                        this.flow.dbg(6, " addDefNode " + lDefNode.toStringShort());
                    }
                } else {
                    int lOperator = lUseNode.getOperator();
                    if (lOperator == 17 || lOperator == 19 || lOperator == 20) {
                        ExpId lCompoundExpId = lUseNode.getExpId();
                        if (((SubpFlowImpl)this.fSubpFlow).getMaximalCompoundVars().contains(lCompoundExpId)) {
                            int CallCount = 0;
                            for (IR lDefNode : (List)lSymToDefNode.get(lCompoundExpId)) {
                                if (lDefNode == null) continue;
                                if (this.fDbgFlow > 3) {
                                    this.flow.dbg(6, " lDefNode " + lDefNode.toStringShort());
                                }
                                if (lDefNode.getOperator() == 33) {
                                    if (++CallCount > 2) {
                                        continue;
                                    }
                                } else {
                                    ((DefUseListImpl)lDefUseList).getOrAddDefUseChain(lDefNode).addUseNode(lUseNode);
                                    if (this.fDbgFlow > 3) {
                                        this.flow.dbg(6, " addUseNode " + lUseNode.toStringShort());
                                    }
                                }
                                ((UseDefListImpl)lUseDefList).getOrAddUseDefChain(lUseNode).addDefNode(lDefNode);
                                if (this.fDbgFlow <= 3) continue;
                                this.flow.dbg(6, " addDefNode " + lDefNode.toStringShort());
                            }
                        }
                    }
                }
                if (lDefSyms.contains(lFlowAnalSym)) continue;
                if (this.fDbgFlow > 3) {
                    this.flow.dbg(5, "lDefSyms " + ((Object)lDefSyms).toString() + " does not contain " + lFlowAnalSym.getName());
                }
                if (lFlowAnalSym.getSymKind() == 9) {
                    ((DefUseListImpl)lDefUseList).getOrAddDefUseChain(this.fSubpFlow.getFlowAdapter().dummyUninitialization).addUseNode(lUseNode);
                    ((UseDefListImpl)lUseDefList).getOrAddUseDefChain(lUseNode).addDefNode(this.fSubpFlow.getFlowAdapter().dummySettingByParam);
                    continue;
                }
                if (lDefUseList == null) continue;
                ((DefUseListImpl)lDefUseList).getOrAddDefUseChain(this.fSubpFlow.getFlowAdapter().dummyUninitialization).addUseNode(lUseNode);
                ((UseDefListImpl)lUseDefList).getOrAddUseDefChain(lUseNode).addDefNode(this.fSubpFlow.getFlowAdapter().dummyUninitialization);
            }
            if (lSubtree instanceof AssignStmt || lSubtree instanceof AsmStmt) {
                for (HIR hIR : lSetNodeList) {
                    FlowAnalSym lSymAssigned = lSubtree instanceof AssignStmt ? lSetRefReprOfBBlock22.getDefSym() : hIR.getSymOrExpId();
                    if (this.fDbgFlow > 3) {
                        this.flow.dbg(5, "set operand", lSymAssigned.getName());
                    }
                    if (lSymAssigned instanceof ExpId && ((ExpId)lSymAssigned).getExpInf().getRValueExpId() != null) {
                        lSymAssigned = ((ExpId)lSymAssigned).getExpInf().getRValueExpId();
                        if (this.fDbgFlow > 3) {
                            this.flow.dbg(5, " defSym as r-value " + lSymAssigned.getName());
                        }
                    }
                    if (this.fDbgFlow > 3) {
                        this.flow.dbg(5, "AssignStmt clear previous def nodes of defSym ", lSymAssigned.getName());
                    }
                    lSymToDefNode.removeAllEntries(lSymAssigned);
                    if (this.fDbgFlow > 3) {
                        this.flow.dbg(5, " record as DefNode " + lSubtree.toStringShort());
                    }
                    lDefSyms.add(lSymAssigned);
                    ((List)lSymToDefNode.get(lSymAssigned)).add(lSubtree);
                }
            }
            if (lSetRefReprOfBBlock22 == null) continue;
            HIR lHirOfSetRefREprOfBBlock = (HIR)lSetRefReprOfBBlock22.getIR();
            while (!lCallNodeStack.isEmpty()) {
                lCallNode = (IR)lCallNodeStack.get(lCallNodeStack.size() - 1);
                this.handleCall(lCallNode, this.fSubpFlow, lDefSyms, lSymToDefNode);
                lCallNodeStack.remove(lCallNodeStack.size() - 1);
            }
            if (!lSetRefReprOfBBlock22.sets()) continue;
            FlowAnalSym lDefSym = lSetRefReprOfBBlock22.defSym();
            if (this.fDbgFlow > 3) {
                this.flow.dbg(6, "lSetRefRepr of " + lHirOfSetRefREprOfBBlock.toStringShort(), " set " + lDefSym);
            }
            if (lDefSym != null) {
                ((List)lSymToDefNode.get(lDefSym)).clear();
                lDefSyms.add(lDefSym);
                ((List)lSymToDefNode.get(lDefSym)).add(lHirOfSetRefREprOfBBlock);
                if (this.fDbgFlow > 3) {
                    this.flow.dbg(6, " add " + lHirOfSetRefREprOfBBlock.toStringShort() + " to " + lDefSym.getName());
                }
                if (((HIR)lSetRefReprOfBBlock22.getIR()).getOperator() != 33) {
                    ((DefUseListImpl)((SubpFlowImpl)this.fSubpFlow).getListOfDefUseList()).getOrAddDefUseChain(lHirOfSetRefREprOfBBlock);
                }
                this.fSubpFlow.getDefinedSyms().add(lDefSym);
                continue;
            }
            for (FlowAnalSym lFlowAnalSym : lSetRefReprOfBBlock22.modSyms()) {
                ((List)lSymToDefNode.get(lFlowAnalSym)).add(lHirOfSetRefREprOfBBlock);
                if (this.fDbgFlow > 3) {
                    this.flow.dbg(6, " add " + lHirOfSetRefREprOfBBlock.toStringShort() + " to " + lFlowAnalSym.getName());
                }
                if (((HIR)lSetRefReprOfBBlock22.getIR()).getOperator() != 33) {
                    ((DefUseListImpl)((SubpFlowImpl)this.fSubpFlow).getListOfDefUseList()).getOrAddDefUseChain(lHirOfSetRefREprOfBBlock);
                }
                this.fSubpFlow.getDefinedSyms().add(lFlowAnalSym);
            }
        }
    }

    protected void handleCall(IR pCallNode, SubpFlow pSubpFlow, Set pDDefSyms, ListValuedMap pSymToPDefNode) {
        if (this.fDbgFlow > 3) {
            this.flow.dbg(6, "handleCall " + pCallNode.toStringShort());
        }
        for (FlowAnalSym lFlowAnalSym : this.fSubpFlow.setOfGlobalVariables()) {
            pSymToPDefNode.addUnique(lFlowAnalSym, pCallNode);
        }
        if (this.fDbgFlow > 3) {
            this.flow.dbg(6, "SymToPDefNode", pSymToPDefNode.toString());
        }
    }

    protected Set callModSyms(IR pCallNode, SubpFlow pCurrentSubpFlow) {
        return pCurrentSubpFlow.getSetRefReprOfIR(pCallNode).modSyms00();
    }

    private static boolean postdominates(Set pPostdominatorBBlocks, BBlock pDominatedBBlock, BBlock pExitBBlock) {
        Object lVisitedFlag = new Object();
        return !DataFlowImpl.search(pDominatedBBlock, pExitBBlock, pPostdominatorBBlocks, lVisitedFlag);
    }

    private static boolean search(BBlock pCurrent, BBlock pGoal, Set pObstacles, Object pVisitedFlag) {
        if (pObstacles.contains(pCurrent)) {
            return false;
        }
        List lSuccList = pCurrent.getSuccList();
        for (BBlock lSuccBBlock : lSuccList) {
            if (lSuccBBlock == pGoal) {
                return true;
            }
            if (lSuccBBlock.getWork() == pVisitedFlag) continue;
            lSuccBBlock.setWork(pVisitedFlag);
            if (!DataFlowImpl.search(lSuccBBlock, pGoal, pObstacles, pVisitedFlag)) continue;
            return true;
        }
        return false;
    }

    public void findAll() {
        this.findAllBitVectors();
        this.findDefUse();
        this.findReach();
    }

    public void showDef() {
        this.fShowDataFlow.showDef();
    }

    public void showKill() {
        this.fShowDataFlow.showKill();
    }

    public void showReach() {
        this.fShowDataFlow.showReach();
    }

    public void showDefined() {
        this.fShowDataFlow.showDefined();
    }

    public void showExposed() {
        this.fShowDataFlow.showExposed();
    }

    public void showEGen() {
        this.fShowDataFlow.showEGen();
    }

    public void showEKill() {
        this.fShowDataFlow.showEKill();
    }

    public void showAvailIn() {
        this.fShowDataFlow.showAvailIn();
    }

    public void showAvailOut() {
        this.fShowDataFlow.showAvailOut();
    }

    public void showLiveIn() {
        this.fShowDataFlow.showLiveIn();
    }

    public void showLiveOut() {
        this.fShowDataFlow.showLiveOut();
    }

    public void showDefIn() {
        this.fShowDataFlow.showDefIn();
    }

    public void showDefOut() {
        this.fShowDataFlow.showDefOut();
    }

    public void showDefVectors() {
        this.fShowDataFlow.showDefVectors();
    }

    public void showExpVectors() {
        this.fShowDataFlow.showExpVectors();
    }

    public void showBasic() {
        this.fShowDataFlow.showBasic();
    }

    public void showSolved() {
        this.fShowDataFlow.showSolved();
    }

    public void showReachRelated() {
        this.fShowDataFlow.showReachRelated();
    }

    public void showAvailInAvailOutRelated() {
        this.fShowDataFlow.showAvailInAvailOutRelated();
    }

    public void showLiveInLiveOutRelated() {
        this.fShowDataFlow.showLiveInLiveOutRelated();
    }

    public void showDefInDefOutRelated() {
        this.fShowDataFlow.showDefInDefOutRelated();
    }

    public void showAllBitVectors() {
        this.fShowDataFlow.showAllBitVectors();
    }

    public void showDefUse() {
        this.fShowDataFlow.showDefUse();
    }

    public void showUseDef() {
        this.fShowDataFlow.showUseDef();
    }

    public void showAll() {
        this.ioRoot.printOut.print("\n*[START]******** DataFlowGraph *******\n");
        this.fShowDataFlow.showAll();
        this.ioRoot.printOut.print("\n*[END]********** DataFlowGraph *******\n");
    }

    public void showSummary() {
        this.ioRoot.printOut.print("\nData flow summary of " + this.flowRoot.subpUnderAnalysis.getName() + "\n");
        this.fShowDataFlow.showSummary();
    }

    void showVector(BitVector pBitVector) {
        this.fShowDataFlow.showVector(pBitVector);
    }

    void showVector(BitVector pBitVector, String pComment) {
        this.fShowDataFlow.showVector(pBitVector, pComment);
    }

    public Set getUndefinedUseNodeOfSym(FlowAnalSym lSym) {
        return this.fUndefinedUseNodesOfSym[lSym.getIndex()];
    }

    ExpVector toExpVector(Set pSymbolSet) {
        if (this.fDbgFlow > 3) {
            this.ioRoot.dbgFlow.printObject(8, " toExpVector", pSymbolSet);
        }
        if (pSymbolSet == null) {
            return null;
        }
        ExpVector lExpVector = this.fSubpFlow.expVector();
        for (Sym lSymbol : pSymbolSet) {
            if (this.fDbgFlow > 3) {
                this.ioRoot.dbgFlow.printObject(7, " sym ", lSymbol);
            }
            int lExpBitPosition = this.expLookup(((FlowAnalSym)lSymbol).getIndex());
            lExpVector.setBit(lExpBitPosition);
        }
        return lExpVector;
    }

    Set toSet(ExpVector pExpVector) {
        HashSet<FlowAnalSym> lSet = new HashSet<FlowAnalSym>();
        for (int i = 1; i <= this.getFlowAnalSymCount(); ++i) {
            if (pExpVector.getBit(i) != 1) continue;
            lSet.add(this.getFlowAnalSym(i));
        }
        return lSet;
    }
}

