/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.IoRoot;
import coins.flow.BBlock;
import coins.flow.BBlockVector;
import coins.flow.BBlockVectorImpl;
import coins.flow.ControlFlow;
import coins.flow.Flow;
import coins.flow.HirSubpFlow;
import coins.flow.ShowControlFlow;
import coins.flow.SubpFlow;
import coins.flow.SubpFlowImpl;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.IfStmt;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SwitchStmt;
import coins.sym.Label;
import coins.sym.Subp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ControlFlowImpl
implements ControlFlow {
    public final FlowRoot flowRoot;
    public final IoRoot ioRoot;
    public final Flow flow;
    private SubpFlow fSubpFlow;
    private ShowControlFlow fShowFlow;
    public BBlockVector[] fDom;
    public BBlockVector[] fsDom;
    public BBlockVector[] fPostDom;
    public BBlockVector[] fPostsDom;
    public final int fDbgLevel;

    public ControlFlowImpl(FlowRoot pFlowRoot, SubpFlow pFlow, SubpDefinition pSubDef) {
        this.flowRoot = pFlowRoot;
        this.ioRoot = pFlowRoot.ioRoot;
        this.flow = pFlowRoot.flow;
        this.fSubpFlow = pFlow;
        this.fDbgLevel = this.ioRoot.dbgFlow.getLevel();
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgFlow.print(1, "ControlFlowImpl", pSubDef.getSubpSym().getName());
        }
        this.fSubpFlow.initiateControlFlowAnal(pSubDef, pSubDef.getNodeIndexMin(), pSubDef.getNodeIndexMax());
        this.fShowFlow = new ShowControlFlow(pFlow, this);
        if (this.flowRoot.isHirAnalysis()) {
            boolean bl = ((SubpFlowImpl)this.fSubpFlow).failed = !((HirSubpFlow)this.fSubpFlow).divideHirIntoBasicBlocks();
            if (!((SubpFlowImpl)this.fSubpFlow).failed) {
                this.makeControlFlowGraph(pSubDef.getHirBody());
            } else {
                this.ioRoot.msgRecovered.put(5011, "Skip to make control flow graph of " + pSubDef.getSubpSym().getName());
            }
        }
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgFlow.print(2, " To show control flow, getShowControlFlow.showAll()\n");
        }
        Flow cfr_ignored_0 = this.flowRoot.flow;
        this.flowRoot.flow.setFlowAnalStateLevel(2);
    }

    public ShowControlFlow getShowControlFlow() {
        return this.fShowFlow;
    }

    private void makeControlFlowGraph(Stmt pTree) {
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(2, "makeControlFlowGraph", "of " + pTree.toString());
        }
        BBlock firstBBlock = null;
        BBlock lastBBlock = null;
        lastBBlock = this.makeEdge(pTree, firstBBlock);
        firstBBlock = this.fSubpFlow.getEntryBBlock();
        this.deleteEdge(firstBBlock);
        this.linkBBlockInDfoAndInverseDfo();
        this.fSubpFlow.setComputedFlag(4);
        this.findDominate();
        this.findStrictlyDominate();
        this.findImmediatelyDominate();
        this.findDominatedChildren();
        this.fSubpFlow.setComputedFlag(5);
        this.findPostDominate();
        this.findPostStrictlyDominate();
        this.findPostImmediatelyDominate();
        this.findPostDominatedChildren();
        this.fSubpFlow.setComputedFlag(6);
    }

    private void deleteEdge(BBlock pBBlock) {
        int maxBBlockNo = this.fSubpFlow.getNumberOfBBlocks();
        BBlockVectorImpl mark = new BBlockVectorImpl(this.fSubpFlow);
        this.markRootDom(pBBlock, mark);
        LinkedList delList = new LinkedList();
        for (int i = 1; i <= maxBBlockNo; ++i) {
            if (mark.getBit(this.domBitLookUp(i)) != 0) continue;
            BBlock Curr = this.fSubpFlow.getBBlock(i);
            List l = Curr.getSuccList();
            this.ListCopy(l, delList);
            ListIterator Ie = delList.listIterator();
            while (Ie.hasNext()) {
                BBlock Succ = (BBlock)Ie.next();
                Succ.deleteFromPredList(Curr);
                Curr.deleteFromSuccList(Succ);
            }
            l = Curr.getPredList();
            this.ListCopy(l, delList);
            Ie = delList.listIterator();
            while (Ie.hasNext()) {
                BBlock Pred = (BBlock)Ie.next();
                Pred.deleteFromPredList(Curr);
                Curr.deleteFromPredList(Pred);
            }
        }
    }

    private void markRootDom(BBlock pBBlock, BBlockVector pmark) {
        List l = pBBlock.getSuccList();
        pmark.setBit(this.domLookUp(pBBlock.getBlockNumber()));
        ListIterator Ie = l.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            if (pmark.getBit(this.domBitLookUp(b.getBlockNumber())) != 0) continue;
            this.markRootDom(b, pmark);
        }
    }

    private BBlock findEntryBlock() {
        Label lStartLabel = this.flowRoot.subpUnderAnalysis.getStartLabel();
        BBlock lEntryBBlock = this.flowRoot.fSubpFlow.getBBlock0(lStartLabel);
        if (lEntryBBlock != null) {
            lEntryBBlock.setFlag(7, true);
        }
        return lEntryBBlock;
    }

    private List findExitBBlock() {
        BBlock lExitBBlock = null;
        if (this.fDbgLevel > 0) {
            this.flow.dbg(3, "findExitBBlock", "BBlock with no successors: ");
        }
        LinkedList<BBlock> lBBlockWithNoSuccessors = new LinkedList<BBlock>();
        int maxBBlockNo = this.fSubpFlow.getNumberOfBBlocks();
        for (int i = 1; i <= maxBBlockNo; ++i) {
            BBlock lBBlock = this.fSubpFlow.getBBlock(i);
            List lSuccList = lBBlock.getSuccList();
            if (lSuccList.size() != 0) continue;
            lBBlockWithNoSuccessors.add(lBBlock);
            lExitBBlock = lBBlock;
            if (this.fDbgLevel <= 0) continue;
            this.flow.dbg(3, "B" + lBBlock.getBBlockNumber());
        }
        if (lExitBBlock != null) {
            lExitBBlock.setFlag(8, true);
        }
        return lBBlockWithNoSuccessors;
    }

    private void findDominate() {
        boolean lChanged;
        int j;
        BBlock lCurrBBlock;
        int i;
        int maxBBlockNo = this.fSubpFlow.getNumberOfBBlocks();
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, "flowDominate", "number of BBlocks " + maxBBlockNo);
        }
        this.fDom = new BBlockVectorImpl[maxBBlockNo + 1];
        this.fsDom = new BBlockVectorImpl[maxBBlockNo + 1];
        for (i = 1; i <= maxBBlockNo; ++i) {
            this.fDom[i] = new BBlockVectorImpl(this.fSubpFlow);
        }
        BBlockVectorImpl lPredDom = new BBlockVectorImpl(this.fSubpFlow);
        BBlockVectorImpl lPredDom1 = new BBlockVectorImpl(this.fSubpFlow);
        BBlockVectorImpl lnewDom = new BBlockVectorImpl(this.fSubpFlow);
        for (i = 1; i <= maxBBlockNo; ++i) {
            lCurrBBlock = this.fSubpFlow.getBBlock(i);
            if (lCurrBBlock.isEntryBlock()) {
                for (j = 1; j <= maxBBlockNo; ++j) {
                    this.fDom[this.domLookUp(i)].resetBit(j);
                }
                this.fDom[this.domLookUp(i)].setBit(this.domLookUp(i));
                continue;
            }
            for (j = 1; j <= maxBBlockNo; ++j) {
                this.fDom[this.domLookUp(i)].setBit(j);
            }
        }
        do {
            lChanged = false;
            for (i = 1; i <= maxBBlockNo; ++i) {
                int lookUp;
                lCurrBBlock = this.fSubpFlow.getBBlock(i);
                List lPredList = lCurrBBlock.getPredList();
                if (lPredList.size() != 0) {
                    for (j = 1; j <= maxBBlockNo; ++j) {
                        lPredDom.setBit(j);
                    }
                    ListIterator lPred = lPredList.listIterator();
                    while (lPred.hasNext()) {
                        BBlock lPredBBlock = (BBlock)lPred.next();
                        lookUp = this.domLookUp(lPredBBlock.getBlockNumber());
                        this.fDom[lookUp].vectorAnd(lPredDom, lPredDom);
                    }
                } else {
                    lPredDom.vectorReset();
                    if (this.fDbgLevel <= 3) continue;
                    this.ioRoot.dbgFlow.print(6, "no predecessor", "i " + i);
                    continue;
                }
                lPredDom.vectorCopy(lnewDom);
                lookUp = this.domLookUp(lCurrBBlock.getBlockNumber());
                lnewDom.setBit(lookUp);
                if (this.fDbgLevel > 3) {
                    this.ioRoot.dbgFlow.print(7, "i", i + " loopUp " + lookUp);
                }
                if (lnewDom.vectorEqual(this.fDom[lookUp])) continue;
                lnewDom.vectorCopy(this.fDom[lookUp]);
                lChanged = true;
                if (this.fDbgLevel <= 3) continue;
                this.ioRoot.dbgFlow.print(6, "changed", "i " + i + " loopUp " + lookUp);
            }
        } while (lChanged);
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(6, "end of ", "findDominate");
        }
    }

    private void findPostDominate() {
        boolean lChanged;
        int j;
        BBlock lCurrBBlock;
        int i;
        int maxBBlockNo = this.fSubpFlow.getNumberOfBBlocks();
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, "findPostDominate", "number of BBlocks " + maxBBlockNo);
        }
        this.fSubpFlow.setBBlockVectorBitCount(maxBBlockNo + 1);
        this.fPostDom = new BBlockVectorImpl[maxBBlockNo + 1];
        for (i = 1; i <= maxBBlockNo; ++i) {
            this.fPostDom[i] = new BBlockVectorImpl(this.fSubpFlow);
        }
        BBlockVectorImpl lSuccDom = new BBlockVectorImpl(this.fSubpFlow);
        BBlockVectorImpl lSuccDom1 = new BBlockVectorImpl(this.fSubpFlow);
        BBlockVectorImpl lnewDom = new BBlockVectorImpl(this.fSubpFlow);
        for (i = 1; i <= maxBBlockNo; ++i) {
            lCurrBBlock = this.fSubpFlow.getBBlock(i);
            if (lCurrBBlock.isExitBlock()) {
                for (j = 1; j <= maxBBlockNo; ++j) {
                    this.fPostDom[this.domLookUp(i)].resetBit(j);
                }
                this.fPostDom[this.domLookUp(i)].setBit(this.domLookUp(i));
                continue;
            }
            for (j = 1; j <= maxBBlockNo; ++j) {
                this.fPostDom[this.domLookUp(i)].setBit(j);
            }
        }
        do {
            lChanged = false;
            for (i = maxBBlockNo; 0 < i; --i) {
                int lookUp;
                lCurrBBlock = this.fSubpFlow.getBBlock(i);
                if (lCurrBBlock.getBBlockNumber() <= 0) continue;
                List lSuccList = lCurrBBlock.getSuccList();
                if (lSuccList.size() != 0) {
                    for (j = 1; j <= maxBBlockNo; ++j) {
                        lSuccDom.setBit(j);
                    }
                    ListIterator lSucc = lSuccList.listIterator();
                    while (lSucc.hasNext()) {
                        BBlock lSuccBBlock = (BBlock)lSucc.next();
                        lookUp = this.domLookUp(lSuccBBlock.getBlockNumber());
                        this.fPostDom[lookUp].vectorAnd(lSuccDom, lSuccDom);
                    }
                } else {
                    lSuccDom.vectorReset();
                    continue;
                }
                lSuccDom.vectorCopy(lnewDom);
                lookUp = this.domLookUp(lCurrBBlock.getBlockNumber());
                lnewDom.setBit(lookUp);
                if (lnewDom.vectorEqual(this.fPostDom[lookUp])) continue;
                if (this.fDbgLevel > 3) {
                    this.ioRoot.dbgFlow.print(5, "changed", "B" + i + " " + lCurrBBlock.getBBlockNumber() + " lookUp " + lookUp);
                }
                lnewDom.vectorCopy(this.fPostDom[lookUp]);
                lChanged = true;
            }
        } while (lChanged);
    }

    private void findStrictlyDominate() {
        int i;
        int maxBBlockNo = this.fSubpFlow.getNumberOfBBlocks();
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, "findStrictlyDominate", "number of BBlocks " + maxBBlockNo);
        }
        for (i = 1; i <= maxBBlockNo; ++i) {
            this.fsDom[i] = new BBlockVectorImpl(this.fSubpFlow);
            this.fDom[i].vectorCopy(this.fsDom[i]);
        }
        for (i = 1; i <= maxBBlockNo; ++i) {
            BBlock lCurrBBlock = this.fSubpFlow.getBBlock(i);
            this.fsDom[this.domLookUp(i)].resetBit(this.domLookUp(i));
        }
    }

    private void findPostStrictlyDominate() {
        int i;
        int maxBBlockNo = this.fSubpFlow.getNumberOfBBlocks();
        this.fPostsDom = new BBlockVectorImpl[maxBBlockNo + 1];
        for (i = 1; i <= maxBBlockNo; ++i) {
            this.fPostsDom[i] = new BBlockVectorImpl(this.fSubpFlow);
            this.fPostDom[i].vectorCopy(this.fPostsDom[i]);
        }
        for (i = 1; i <= maxBBlockNo; ++i) {
            BBlock lCurrBBlock = this.fSubpFlow.getBBlock(i);
            this.fPostsDom[this.domLookUp(i)].resetBit(this.domLookUp(i));
        }
    }

    private void findImmediatelyDominate() {
        int maxBBlockNo = this.fSubpFlow.getNumberOfBBlocks();
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, "findImmediatelyDominate", "number of BBlocks " + maxBBlockNo);
        }
        for (int i = 1; i <= maxBBlockNo; ++i) {
            int bj = -1;
            BBlockVectorImpl sdom = new BBlockVectorImpl(this.fSubpFlow);
            this.fsDom[i].vectorCopy(sdom);
            for (int j = 1; j <= maxBBlockNo; ++j) {
                if (sdom.getBit(this.domLookUp(j)) != 1) continue;
                bj = j;
                sdom.vectorSub(this.fDom[this.domLookUp(bj)], sdom);
            }
            BBlock CurBBlock = this.fSubpFlow.getBBlock(i);
            BBlock Idom = bj == -1 ? (BBlock)null : this.fSubpFlow.getBBlock(bj);
            CurBBlock.setImmediateDominator(Idom);
        }
    }

    private void findPostImmediatelyDominate() {
        int maxBBlockNo = this.fSubpFlow.getNumberOfBBlocks();
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, "findPostImmediatelyDominate", "number of BBlocks " + maxBBlockNo);
        }
        for (int i = 1; i <= maxBBlockNo; ++i) {
            int bj = -1;
            BBlockVectorImpl postsdom = new BBlockVectorImpl(this.fSubpFlow);
            this.fPostsDom[i].vectorCopy(postsdom);
            for (int j = 1; j <= maxBBlockNo; ++j) {
                if (postsdom.getBit(this.domLookUp(j)) != 1) continue;
                bj = j;
                postsdom.vectorSub(this.fPostDom[this.domLookUp(bj)], postsdom);
            }
            BBlock CurBBlock = this.fSubpFlow.getBBlock(i);
            BBlock Idom = bj == -1 ? (BBlock)null : this.fSubpFlow.getBBlock(bj);
            CurBBlock.setImmediatePostDominator(Idom);
        }
    }

    private void findDominatedChildren() {
        int i;
        int maxBBlockNo = this.fSubpFlow.getNumberOfBBlocks();
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, "findDominatedChildren", "number of BBlocks " + maxBBlockNo);
        }
        BBlock lChildBBlock = null;
        BBlock lIDomBBlock = null;
        for (i = 1; i <= maxBBlockNo; ++i) {
            lChildBBlock = this.fSubpFlow.getBBlock(i);
            lChildBBlock.setDominatedChildren(new LinkedList());
        }
        for (i = 1; i <= maxBBlockNo; ++i) {
            lChildBBlock = this.fSubpFlow.getBBlock(i);
            lIDomBBlock = lChildBBlock.getImmediateDominator();
            if (lIDomBBlock == null) continue;
            List lChild = lIDomBBlock.getDominatedChildren();
            lChild.add(lChildBBlock);
        }
    }

    private void findPostDominatedChildren() {
        int i;
        int maxBBlockNo = this.fSubpFlow.getNumberOfBBlocks();
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, "findPostDominatedChildren", "number of BBlocks " + maxBBlockNo);
        }
        BBlock lChildBBlock = null;
        BBlock lIDomBBlock = null;
        for (i = 1; i <= maxBBlockNo; ++i) {
            lChildBBlock = this.fSubpFlow.getBBlock(i);
            lChildBBlock.setPostDominatedChildren(new LinkedList());
        }
        for (i = 1; i <= maxBBlockNo; ++i) {
            lChildBBlock = this.fSubpFlow.getBBlock(i);
            lIDomBBlock = lChildBBlock.getImmediatePostDominator();
            if (lIDomBBlock == null) continue;
            List lChild = lIDomBBlock.getPostDominatedChildren();
            lChild.add(lChildBBlock);
        }
    }

    public int domLookUp(int ppNo) {
        int lBitPosition = ppNo;
        return lBitPosition;
    }

    public int domBitLookUp(int pBitPos) {
        int lBlockNo = pBitPos;
        return lBlockNo;
    }

    private BBlock makeEdge(Stmt pstmt, BBlock pblock) {
        boolean lAfterJumpReturn = false;
        Stmt nextStmt = pstmt;
        BBlock currBlock = pblock;
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(4, "makeEdge " + IoRoot.toStringObject(pblock), " from " + IoRoot.toStringObjectShort(pstmt) + " to ");
            if (nextStmt != null) {
                this.flowRoot.ioRoot.dbgFlow.print(4, IoRoot.toStringObjectShort(nextStmt.getNextStmt()));
            }
        }
        block10: while (nextStmt != null) {
            if (this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgFlow.print(5, "  nextStmt", nextStmt.toStringShort() + " nextToNext " + IoRoot.toStringObjectShort(nextStmt.getNextStmt()));
            }
            if (currBlock != null && this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgFlow.print(5, " BB" + currBlock.getBBlockNumber());
            }
            int lop = nextStmt.getOperator();
            switch (lop) {
                case 23: {
                    IfStmt stmtIF = (IfStmt)nextStmt;
                    BBlock thenBlock = this.makeEdge(stmtIF.getThenPart(), currBlock);
                    BBlock elseBlock = this.makeEdge(stmtIF.getElsePart(), currBlock);
                    BBlock lIfEndBlock = this.flowRoot.fSubpFlow.getBBlock0(stmtIF.getEndLabel());
                    if (this.fDbgLevel > 4) {
                        this.flow.dbg(6, "thenPart " + stmtIF.getThenPart() + " " + thenBlock + " elsePart " + stmtIF.getElsePart() + " " + elseBlock + " endif", lIfEndBlock.toStringShort() + " " + stmtIF.getEndLabel().getName());
                    }
                    if (thenBlock.controlTransfer() == null) {
                        this.addEdge(thenBlock, lIfEndBlock);
                    }
                    if (elseBlock.controlTransfer() == null) {
                        this.addEdge(elseBlock, lIfEndBlock);
                    }
                    LabeledStmt lIfEnd = (LabeledStmt)stmtIF.getChild(4);
                    if (this.fDbgLevel > 0) {
                        this.flow.dbg(6, " ", "if-end " + lIfEnd.toStringShort());
                    }
                    currBlock = lIfEnd.getStmt() != null ? this.makeEdge(lIfEnd.getStmt(), lIfEndBlock) : lIfEndBlock;
                    nextStmt = this.getNextStmtSeeingAncestor(stmtIF);
                    continue block10;
                }
                case 21: {
                    Stmt nextStmt1;
                    BBlock LabelBlock2 = this.flowRoot.fSubpFlow.getBBlock0(((LabeledStmt)nextStmt).getLabel());
                    if (!lAfterJumpReturn) {
                        this.addEdge(currBlock, LabelBlock2);
                    } else {
                        lAfterJumpReturn = false;
                    }
                    currBlock = LabelBlock2;
                    if (this.fDbgLevel > 0) {
                        this.flow.dbg(6, "labeledSt", "currBlock " + currBlock.toStringShort());
                    }
                    if ((nextStmt1 = ((LabeledStmt)nextStmt).getStmt()) == null) {
                        nextStmt = this.getNextStmtSeeingAncestor(nextStmt);
                        continue block10;
                    }
                    nextStmt = nextStmt1;
                    continue block10;
                }
                case 32: {
                    SwitchStmt stmtSWITCH = (SwitchStmt)nextStmt;
                    int CaseCount = stmtSWITCH.getCaseCount();
                    for (int i = 0; i < CaseCount; ++i) {
                        BBlock lCaseBlock = this.flowRoot.fSubpFlow.getBBlock0(stmtSWITCH.getCaseLabel(i));
                        this.addEdge(currBlock, lCaseBlock);
                    }
                    BBlock defaultBlock = this.flowRoot.fSubpFlow.getBBlock0(stmtSWITCH.getDefaultLabel());
                    BBlock lSwitchEndBlock = this.flowRoot.fSubpFlow.getBBlock0(stmtSWITCH.getEndLabel());
                    if (defaultBlock == null) {
                        this.addEdge(currBlock, lSwitchEndBlock);
                    } else {
                        this.addEdge(currBlock, defaultBlock);
                    }
                    BBlock bodyBlock = this.makeEdge(stmtSWITCH.getBodyStmt(), currBlock);
                    if (bodyBlock.controlTransfer() == null) {
                        this.addEdge(bodyBlock, lSwitchEndBlock);
                    }
                    LabeledStmt lSwitchEnd = (LabeledStmt)stmtSWITCH.getChild(4);
                    if (this.fDbgLevel > 0) {
                        this.flow.dbg(6, " ", "switch-end " + lSwitchEnd.toStringShort());
                    }
                    currBlock = lSwitchEnd.getStmt() != null ? this.makeEdge(lSwitchEnd.getStmt(), lSwitchEndBlock) : lSwitchEndBlock;
                    nextStmt = this.getNextStmtSeeingAncestor(stmtSWITCH);
                    continue block10;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    LoopStmt stmtLOOP = (LoopStmt)nextStmt;
                    Label lBackLabel = stmtLOOP.getLoopBackLabel();
                    BBlock loopbackBlock = this.flowRoot.fSubpFlow.getBBlock0(lBackLabel);
                    BBlock lLoopEndBlock = this.flowRoot.fSubpFlow.getBBlock0(stmtLOOP.getLoopEndLabel());
                    Stmt loopInitPart = stmtLOOP.getLoopInitPart();
                    if (this.fDbgLevel >= 4) {
                        this.flow.dbg(6, "loop", "back " + loopbackBlock.toStringShort() + " " + lBackLabel.getName() + " end " + lLoopEndBlock.toStringShort() + " body " + stmtLOOP.getLoopBodyPart().toStringShort() + " step " + stmtLOOP.getLoopStepLabel() + " end " + stmtLOOP.getChild(7).toStringShort());
                    }
                    BBlock loopInitBlock = this.makeEdge(loopInitPart, currBlock);
                    if (!this.isEndedWithJump(loopInitPart)) {
                        this.addEdge(currBlock, loopbackBlock);
                    }
                    BBlock bodyBlock = this.makeEdge(stmtLOOP.getLoopBodyPart(), loopbackBlock);
                    Label lStepLabel = stmtLOOP.getLoopStepLabel();
                    if (lStepLabel != null && lStepLabel.getHirPosition() != null) {
                        BBlock stepBlock = this.flowRoot.fSubpFlow.getBBlock0(lStepLabel);
                        if (this.fDbgLevel >= 4) {
                            this.flow.dbg(6, "stepBlock", stepBlock + " " + lStepLabel.getName());
                        }
                        if (stepBlock != null) {
                            this.addEdge(stepBlock, loopbackBlock);
                            stepBlock.getSuccEdge(loopbackBlock).flagBox().setFlag(11, true);
                            BBlock lStepBlock2 = this.makeEdge(stmtLOOP.getLoopStepPart(), stepBlock);
                        } else if (bodyBlock != null) {
                            if (bodyBlock.controlTransfer() == null) {
                                this.addEdge(bodyBlock, loopbackBlock);
                            }
                            bodyBlock.getSuccEdge(loopbackBlock).flagBox().setFlag(11, true);
                        }
                        if (stmtLOOP.getLoopEndCondition() == (Exp)null) {
                            this.addEdge(loopbackBlock, lLoopEndBlock);
                        } else if (stepBlock != null) {
                            this.addEdge(stepBlock, lLoopEndBlock);
                        } else if (bodyBlock.controlTransfer() == null) {
                            this.addEdge(bodyBlock, lLoopEndBlock);
                        }
                    } else {
                        if (bodyBlock.controlTransfer() == null) {
                            this.addEdge(bodyBlock, loopbackBlock);
                        }
                        if (loopbackBlock.controlTransfer() == null) {
                            this.addEdge(loopbackBlock, lLoopEndBlock);
                        }
                    }
                    LabeledStmt lLoopEnd = (LabeledStmt)stmtLOOP.getChild(7);
                    this.flow.dbg(6, " ", "loop-end " + lLoopEnd.toStringShort());
                    currBlock = lLoopEnd.getStmt() != null ? this.makeEdge(lLoopEnd.getStmt(), lLoopEndBlock) : lLoopEndBlock;
                    nextStmt = this.getNextStmtSeeingAncestor(stmtLOOP);
                    continue block10;
                }
                case 34: {
                    nextStmt = this.getNextStmtSeeingAncestor(nextStmt);
                    lAfterJumpReturn = true;
                    continue block10;
                }
                case 28: {
                    Label lJumpLabel = ((JumpStmt)nextStmt).getLabel();
                    BBlock LabelBlock4 = this.flowRoot.fSubpFlow.getBBlock0(lJumpLabel);
                    this.addEdge(currBlock, LabelBlock4);
                    nextStmt = this.getNextStmtSeeingAncestor(nextStmt);
                    lAfterJumpReturn = true;
                    continue block10;
                }
                case 35: {
                    BlockStmt lBlockStmt = (BlockStmt)nextStmt;
                    Stmt lStmtInBlock = lBlockStmt.getFirstStmt();
                    if (lStmtInBlock != null) {
                        nextStmt = lStmtInBlock;
                        continue block10;
                    }
                    nextStmt = this.getNextStmtSeeingAncestor(lBlockStmt);
                    continue block10;
                }
                case 14: {
                    nextStmt = this.getNextStmtSeeingAncestor(nextStmt);
                    continue block10;
                }
            }
            nextStmt = this.getNextStmtSeeingAncestor(nextStmt);
        }
        if (this.fDbgLevel > 0) {
            if (currBlock == null) {
                this.flow.dbg(6, "return", "BB0");
            } else {
                this.flow.dbg(6, "return", "BB" + currBlock.getBBlockNumber());
            }
        }
        return currBlock;
    }

    private void addEdge(BBlock ppred, BBlock psucc) {
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, "addEdge ");
        }
        if (psucc == null) {
            return;
        }
        if (ppred == null) {
            return;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(4, "from BB" + ppred.getBlockNumber() + " to BB" + psucc.getBlockNumber());
        }
        psucc.addToPredList(ppred);
        ppred.addToSuccList(psucc);
    }

    private void ListCopy(List from, List to) {
        to.clear();
        ListIterator Ie = from.listIterator();
        while (Ie.hasNext()) {
            to.add(Ie.next());
        }
    }

    public boolean linkBBlockInDfoAndInverseDfo() {
        BBlock lExitBBlock;
        boolean lNormal = true;
        Subp lSubp = this.fSubpFlow.getSubpSym();
        if (this.fDbgLevel > 0) {
            this.flow.dbg(2, "linkBBlockInDfoAndInverseDfo", lSubp.getName());
        }
        ArrayList lBBlockTable = this.fSubpFlow.getBBlockTable();
        BBlock lEntryBBlock = this.fSubpFlow.getEntryBBlock();
        List lBBlockWithNoSuccessors = this.findExitBBlock();
        int lSize = lBBlockWithNoSuccessors.size();
        if (lSize == 0) {
            lExitBBlock = null;
        } else {
            lExitBBlock = (BBlock)lBBlockWithNoSuccessors.get(lSize - 1);
            this.fSubpFlow.setExitBBlock(lExitBBlock);
            if (lSize > 1) {
                if (this.fDbgLevel > 0) {
                    this.flow.dbg(2, " There are multiple BBlocks with no successors", " " + lSize);
                }
                for (int lIndex = 0; lIndex < lSize - 1; ++lIndex) {
                    BBlock lElem = (BBlock)lBBlockWithNoSuccessors.get(lIndex);
                    lElem.addToSuccList(lExitBBlock);
                    if (this.fDbgLevel <= 0) continue;
                    this.flow.dbg(3, "  Make virtual edge from B" + lElem.getBBlockNumber(), " to B" + lExitBBlock.getBBlockNumber());
                }
                lNormal = false;
            }
        }
        this.flowRoot.fSubpFlow.setPrevBBlockInSearch(null);
        lEntryBBlock.linkInDepthFirstOrder(lSubp);
        if (lExitBBlock != null) {
            lExitBBlock.linkInInverseDepthFirstOrder(lSubp);
        }
        return lNormal;
    }

    private Stmt getNextStmtSeeingAncestor(Stmt pStmt) {
        if (pStmt == null) {
            return null;
        }
        if (this.fDbgLevel > 0) {
            this.flow.dbg(5, " getNextStmtSeeingAncestor " + pStmt.toStringShort());
        }
        if (pStmt.getNextStmt() != null) {
            return pStmt.getNextStmt();
        }
        HIR lAncestor = pStmt;
        do {
            if ((lAncestor = (HIR)lAncestor.getParent()) == null) {
                return null;
            }
            if (this.fDbgLevel > 0) {
                this.flow.dbg(5, " ancestor " + lAncestor.toStringShort());
            }
            if (lAncestor instanceof IfStmt || lAncestor instanceof LoopStmt || lAncestor instanceof SwitchStmt) {
                return null;
            }
            if (lAncestor instanceof BlockStmt) {
                return this.getNextStmtSeeingAncestor((Stmt)lAncestor);
            }
            if (lAncestor.getNextStmt() == null) continue;
            return lAncestor.getNextStmt();
        } while (lAncestor != null);
        return null;
    }

    protected boolean isEndedWithJump(Stmt pStmt) {
        if (pStmt == null) {
            return false;
        }
        switch (pStmt.getOperator()) {
            case 28: 
            case 34: {
                return true;
            }
            case 35: {
                return this.isEndedWithJump(((BlockStmt)pStmt).getLastStmt());
            }
            case 21: {
                return this.isEndedWithJump(((LabeledStmt)pStmt).getStmt());
            }
        }
        return false;
    }
}

