/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.IoRoot;
import coins.flow.BBlock;
import coins.flow.BBlockImpl;
import coins.flow.BBlockSubtreeIterator;
import coins.flow.HirSubpFlowImpl;
import coins.flow.SubpFlow;
import coins.flow.SubpFlowImpl;
import coins.ir.IR;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HIR_Impl;
import coins.ir.hir.IfStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SwitchStmt;
import java.util.HashSet;

public class BBlockSubtreeIteratorImpl
implements BBlockSubtreeIterator {
    public final FlowRoot flowRoot;
    public final IoRoot ioRoot;
    private BBlock fBBlock;
    protected SubpFlow fSubpFlow;
    protected int fNextStmtIndex;
    protected boolean fHeaderPassed = false;
    protected HIR fCurrSubtree = null;
    protected HIR fNextSubtree = null;
    protected final int fDbgLevel;

    public BBlockSubtreeIteratorImpl(FlowRoot pFlowRoot, BBlock pBBlock) {
        this.flowRoot = pFlowRoot;
        this.ioRoot = pFlowRoot.ioRoot;
        this.fSubpFlow = this.flowRoot.fSubpFlow;
        this.fDbgLevel = this.ioRoot.dbgFlow.getLevel();
        if (pBBlock != null && this.flowRoot.isHirAnalysis()) {
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgFlow.print(4, "BBlockSubtreeIteratorImpl", "B" + pBBlock.getBBlockNumber() + " fIrLink " + ((BBlockImpl)pBBlock).fIrLink + " fIteratorInitiated " + ((SubpFlowImpl)this.fSubpFlow).fIteratorInitiated + "\n");
            }
            if (((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeq == null) {
                if (this.fDbgLevel > 3) {
                    this.ioRoot.dbgFlow.print(4, "compute fStmtExpSeq for BBlockHirSubtreeIterator", this.fSubpFlow.getSubpSym().getName() + " IrIndexMin " + this.fSubpFlow.getIrIndexMin() + " IrIndexMax " + this.fSubpFlow.getIrIndexMax());
                }
                boolean lJumpReturnAppeared = false;
                ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeq = new HIR[(this.fSubpFlow.getIrIndexMax() - this.fSubpFlow.getIrIndexMin()) / 2 + 2];
                ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeqIndexForBBlock = new int[this.fSubpFlow.getNumberOfBBlocks() + 2];
                ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount = 0;
                HashSet<Exp> lConditionalAndSelectionExp = new HashSet<Exp>();
                int lIndex = this.fSubpFlow.getIrIndexMin();
                while (lIndex <= this.fSubpFlow.getIrIndexMax()) {
                    IR lNode = this.fSubpFlow.getIndexedNode(lIndex);
                    ++lIndex;
                    if (lNode == null) continue;
                    int lOperator = lNode.getOperator();
                    if (lNode instanceof Stmt) {
                        if (lJumpReturnAppeared) {
                            while (lIndex <= this.fSubpFlow.getIrIndexMax() && !(lNode instanceof LabeledStmt)) {
                                lNode = this.fSubpFlow.getIndexedNode(lIndex);
                                if (lNode != null) {
                                    lOperator = lNode.getOperator();
                                }
                                ++lIndex;
                            }
                            lJumpReturnAppeared = false;
                        }
                        switch (lOperator) {
                            case 21: {
                                BBlock lBBlock = this.fSubpFlow.getBBlock((HIR)lNode);
                                if (lBBlock == null || lBBlock.getBBlockNumber() == 0) break;
                                int lBBlockNum = lBBlock.getBBlockNumber();
                                ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeqIndexForBBlock[lBBlockNum] = ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount;
                                ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeq[((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount] = (HIR)lNode;
                                ++((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount;
                                break;
                            }
                            case 34: {
                                lJumpReturnAppeared = true;
                            }
                            case 22: 
                            case 36: 
                            case 37: {
                                ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeq[((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount] = (HIR)lNode;
                                ++((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount;
                                break;
                            }
                            case 23: {
                                lConditionalAndSelectionExp.add(((IfStmt)lNode).getIfCondition());
                                break;
                            }
                            case 32: {
                                lConditionalAndSelectionExp.add(((SwitchStmt)lNode).getSelectionExp());
                                break;
                            }
                            case 28: {
                                lJumpReturnAppeared = true;
                            }
                        }
                        continue;
                    }
                    if (lConditionalAndSelectionExp.contains(lNode)) {
                        ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeq[((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount] = (HIR)lNode;
                        ++((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount;
                        lConditionalAndSelectionExp.remove(lNode);
                        continue;
                    }
                    if (lOperator != 33 || lNode.getParent() instanceof ExpStmt) continue;
                    ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeq[((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount] = (HIR)lNode;
                    ++((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount;
                }
                if (this.fDbgLevel > 3) {
                    this.ioRoot.dbgFlow.print(4, "  fStmtCount " + ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount + "\n");
                    if (this.fDbgLevel >= 4) {
                        for (int lIndex2 = 0; lIndex2 < ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount; ++lIndex2) {
                            this.ioRoot.dbgFlow.print(4, ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeq[lIndex2].toStringShort());
                        }
                        for (int lIndex3 = 0; lIndex3 < this.fSubpFlow.getNumberOfBBlocks(); ++lIndex3) {
                            this.ioRoot.dbgFlow.print(4, " " + ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeqIndexForBBlock[lIndex3]);
                        }
                    }
                }
                ((SubpFlowImpl)this.fSubpFlow).fIteratorInitiated = true;
            }
            this.fNextStmtIndex = ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeqIndexForBBlock[pBBlock.getBBlockNumber()];
            this.fHeaderPassed = false;
            this.fNextSubtree = ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeq[this.fNextStmtIndex];
        }
    }

    public IR next() {
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgHir.print(7, " next of", IoRoot.toStringObjectShort(this.fCurrSubtree));
        }
        if (((SubpFlowImpl)this.fSubpFlow).fIteratorInitiated) {
            HIR lNextSubtree = null;
            if (this.fNextStmtIndex < ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount && (lNextSubtree = ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeq[this.fNextStmtIndex]) instanceof LabeledStmt) {
                if (this.fHeaderPassed) {
                    lNextSubtree = null;
                } else {
                    this.fHeaderPassed = true;
                }
            }
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgHir.print(5, " next is " + IoRoot.toStringObjectShort(lNextSubtree));
            }
            ++this.fNextStmtIndex;
            this.fCurrSubtree = lNextSubtree;
            return this.fCurrSubtree;
        }
        if (this.fNextSubtree instanceof LabeledStmt) {
            if (this.fHeaderPassed) {
                this.fCurrSubtree = null;
            } else {
                this.fHeaderPassed = true;
                if (this.fCurrSubtree == null) {
                    this.fCurrSubtree = this.fNextSubtree;
                    this.fNextSubtree = this.getNextSubtree(this.fCurrSubtree, false);
                } else {
                    this.fCurrSubtree = this.fNextSubtree;
                    this.fNextSubtree = null;
                }
            }
        } else if (this.fNextSubtree != null) {
            this.fCurrSubtree = this.fNextSubtree;
            this.fNextSubtree = null;
        } else if (this.fCurrSubtree != null) {
            this.fCurrSubtree = this.getNextSubtree(this.fCurrSubtree, true);
            this.fNextSubtree = null;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgHir.print(4, " fIteratorInitiated=false " + IoRoot.toStringObjectShort(this.fCurrSubtree));
        }
        return this.fCurrSubtree;
    }

    public boolean hasNext() {
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgHir.print(7, " hasNext " + IoRoot.toStringObjectShort(this.fCurrSubtree) + " " + IoRoot.toStringObjectShort(this.fCurrSubtree));
        }
        if (((SubpFlowImpl)this.fSubpFlow).fIteratorInitiated) {
            if (this.fNextStmtIndex < ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpCount) {
                HIR lNextSubtree = ((HirSubpFlowImpl)this.fSubpFlow).fStmtExpSeq[this.fNextStmtIndex];
                return !(lNextSubtree instanceof LabeledStmt) || !this.fHeaderPassed;
            }
            return false;
        }
        if (this.fNextSubtree != null) {
            return true;
        }
        if (this.fCurrSubtree == null) {
            return false;
        }
        this.fNextSubtree = this.getNextSubtree(this.fCurrSubtree, false);
        return this.fNextSubtree != null;
    }

    protected HIR getNextSubtree(HIR pHir, boolean pGet) {
        if (pHir == null) {
            return null;
        }
        HIR lHir = ((HIR_Impl)pHir).getNextNode();
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgHir.print(5, " getNextSubtree", pHir.toStringShort() + " next " + IoRoot.toStringObjectShort(lHir));
        }
        while (lHir != null) {
            int lOperator = lHir.getOperator();
            if (lHir instanceof Stmt) {
                switch (lOperator) {
                    case 21: {
                        if (this.fHeaderPassed) {
                            return null;
                        }
                        if (pGet) {
                            this.fHeaderPassed = true;
                        }
                    }
                    case 22: 
                    case 23: 
                    case 34: 
                    case 36: 
                    case 37: {
                        return lHir;
                    }
                    case 33: {
                        if (lHir.getParent() instanceof ExpStmt) break;
                        return lHir;
                    }
                }
            } else {
                HIR lParent = (HIR)lHir.getParent();
                if (lParent instanceof IfStmt ? lHir == ((IfStmt)lParent).getIfCondition() : lParent instanceof SwitchStmt && lHir == ((SwitchStmt)lParent).getSelectionExp()) {
                    return lHir;
                }
            }
            lHir = ((HIR_Impl)lHir).getNextNode();
        }
        return null;
    }
}

