/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.flow.BBlock;
import coins.flow.BBlockHir;
import coins.flow.BBlockHirNodeIteratorImpl;
import coins.flow.BBlockHirSubtreeIteratorImpl;
import coins.flow.BBlockImpl;
import coins.flow.BBlockNodeIterator;
import coins.flow.BBlockStmtIterator;
import coins.flow.BBlockSubtreeIterator;
import coins.ir.IR;
import coins.ir.hir.HIR;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Stmt;
import coins.sym.ExpId;
import coins.sym.Label;
import java.util.ArrayList;
import java.util.List;

public class BBlockHirImpl
extends BBlockImpl
implements BBlockHir {
    private HIR fFirstSubtree = null;
    private HIR fLastSubtree = null;

    public BBlockHirImpl(FlowRoot pFlowRoot, LabeledStmt pLabeledStmt, int pBBlockNumber) {
        super(pFlowRoot, pBBlockNumber);
        Label lLabel = null;
        this.fIrLink = pLabeledStmt;
        if (pLabeledStmt != null) {
            lLabel = pLabeledStmt.getLabel();
        }
        if (lLabel != null) {
            this.flowRoot.fSubpFlow.setBBlock(lLabel, (BBlock)this);
        }
    }

    public void setIrLink(LabeledStmt pLabeledStmt) {
        this.fIrLink = pLabeledStmt;
        Label lLabel = pLabeledStmt.getLabel();
        if (lLabel != null) {
            this.flowRoot.fSubpFlow.setBBlock(lLabel, (BBlock)this);
            this.fIrLink = pLabeledStmt;
        }
    }

    public BBlockSubtreeIterator bblockSubtreeIterator() {
        return new BBlockHirSubtreeIteratorImpl(this.flowRoot, this);
    }

    public BBlockNodeIterator bblockNodeIterator() {
        return new BBlockHirNodeIteratorImpl(this.flowRoot, this);
    }

    public IR getFirstSubtree() {
        HIR lSubtree = this.fFirstSubtree;
        if (this.getFlag(2)) {
            lSubtree = null;
        }
        if (lSubtree == null) {
            BBlockSubtreeIterator lIterator = this.bblockSubtreeIterator();
            while (lIterator.hasNext() && lSubtree == null) {
                lSubtree = (HIR)lIterator.next();
            }
        }
        this.fFirstSubtree = lSubtree;
        return lSubtree;
    }

    public IR getLastSubtree() {
        HIR lSubtree = this.fLastSubtree;
        if (this.getFlag(2)) {
            lSubtree = null;
        }
        HIR lPrevSubtree = lSubtree;
        if (lSubtree == null || this.getFlag(2)) {
            BBlockSubtreeIterator lIterator = this.bblockSubtreeIterator();
            while (lIterator.hasNext()) {
                if (lSubtree != null) {
                    lPrevSubtree = lSubtree;
                }
                lSubtree = (HIR)lIterator.next();
            }
        }
        if (lSubtree == null) {
            lSubtree = lPrevSubtree;
        }
        this.fLastSubtree = lSubtree;
        return lSubtree;
    }

    public void printSubtrees() {
        this.flowRoot.ioRoot.printOut.print("\nBBlock %d subtrees" + this.getBlockNumber());
        BBlockSubtreeIterator lIterator = this.bblockSubtreeIterator();
        while (lIterator.hasNext()) {
            HIR lSubtree = (HIR)lIterator.next();
            if (lSubtree == null) continue;
            lSubtree.print(2);
        }
    }

    public void addToExpNodeList(ExpId pExpId, HIR pExpNode) {
        List<HIR> lNodeList;
        if (!this.fExpNodeListMap.containsKey(pExpId)) {
            lNodeList = new ArrayList();
            this.fExpNodeListMap.put(pExpId, lNodeList);
        } else {
            lNodeList = (List)this.fExpNodeListMap.get(pExpId);
        }
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(5, " addToExpNodeList", pExpNode.toStringShort() + " " + pExpId + " " + this);
        }
        lNodeList.add(pExpNode);
    }

    public List getExpNodeList(ExpId pExpId) {
        if (this.fExpNodeListMap.containsKey(pExpId)) {
            return (List)this.fExpNodeListMap.get(pExpId);
        }
        return null;
    }

    public Stmt getFirstStmt() {
        return (Stmt)this.getIrLink();
    }

    public Stmt getLastStmt() {
        Stmt lStmt;
        Stmt lPreviousStmt = null;
        BBlockStmtIterator lIterator = new BBlockStmtIterator(this);
        while (lIterator.hasNext() && (lStmt = (Stmt)lIterator.next()) != null) {
            lPreviousStmt = lStmt;
        }
        return lPreviousStmt;
    }
}

