/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.ComplexConstNode;
import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.I77Utils;
import coins.ffront.Node;
import coins.ffront.Pair;
import coins.sym.Sym;

public class WriteStmt
extends FStmt {
    private FirList ciList;
    private FirList optIoList;

    public WriteStmt(FirList cList, FirList ioList, int line, FirToHir pfHir) {
        super(line, pfHir);
        this.ciList = cList;
        this.optIoList = ioList;
    }

    public void print(int level, String spaces) {
        super.print(level, spaces);
        this.fHir.debugPrint(level, spaces + "WriteStmt" + "\n");
        this.ciList.print(level, spaces + "cfg  ");
        if (this.optIoList != null) {
            this.optIoList.print(level, spaces + "out  ");
        }
    }

    public String toString() {
        return super.toString() + " WRITE statement";
    }

    public void process() {
        I77Utils i77utils = new I77Utils(this.fHir);
        Sym sym = this.fHir.getSym();
        i77utils.writeInit(this.ciList);
        this.addGeneratedStmt(i77utils.io_start());
        if (this.optIoList != null) {
            for (Node n : this.optIoList) {
                if (n instanceof Pair && !(n instanceof ComplexConstNode)) {
                    this.addGeneratedStmt(i77utils.dolist((Pair)n));
                    continue;
                }
                this.addGeneratedStmt(i77utils.io_do(n));
            }
        }
        this.addGeneratedStmt(i77utils.io_end());
        super.process();
    }
}

