/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.Node;
import coins.ffront.Quad;
import coins.ffront.UnaryNode;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.Stmt;

public class UnLabeledDoStmt
extends FStmt {
    private Quad doSpec;
    private Exp leftExp;
    private Node doTail;
    private boolean stepIsPositive = true;

    public UnLabeledDoStmt(Node pDoSpec, Node pDoTail, int line, FirToHir pfHir) {
        super(line, pfHir);
        this.doSpec = (Quad)pDoSpec;
        this.doTail = pDoTail;
    }

    public void print(int level, String spaces) {
        super.print(level, spaces);
        this.dp("UnLabeledDo");
        this.doSpec.print(level, spaces + "  ");
        this.doTail.print(level, spaces + "  ");
    }

    public String toString() {
        return super.toString() + " UnLabeledDoStmt statement";
    }

    public Stmt makeInitStmt() {
        this.leftExp = this.doSpec.left.makeExp();
        Exp initExp = this.doSpec.right.makeExp();
        initExp = this.fHirUtil.checkAssignExpType(this.leftExp, initExp);
        this.stmt = this.fHirUtil.makeAssignStmt(this.leftExp, initExp);
        return this.stmt;
    }

    public Exp makeCondExp() {
        int relOp = this.stepIsPositive ? 56 : 54;
        return this.hir.exp(relOp, this.leftExp, this.doSpec.extra.makeExp());
    }

    public Stmt makeStepStmt() {
        Exp stepExp;
        Node optStep = this.doSpec.last;
        if (optStep == null) {
            stepExp = this.fHirUtil.makeConstInt1Node();
        } else {
            stepExp = optStep.makeExp();
            if (optStep instanceof UnaryNode && ((UnaryNode)optStep).op == 63) {
                this.stepIsPositive = false;
            }
        }
        stepExp = this.fHirUtil.checkAssignExpType(this.leftExp, stepExp);
        Exp binaryExp = this.hir.exp(38, this.leftExp, stepExp);
        return this.fHirUtil.makeAssignStmt(this.leftExp, binaryExp);
    }

    Stmt makeLoopBodyStmt() {
        BlockStmt bodystmt = this.fHir.getExecStmtManager().processExecStmt((FirList)this.doTail);
        this.fESMgr.setCurrentStmt(this);
        return bodystmt;
    }

    public void process() {
        Stmt init = this.makeInitStmt();
        Stmt step = this.makeStepStmt();
        Exp cond = this.makeCondExp();
        Stmt body = this.makeLoopBodyStmt();
        this.stmt = (Stmt)this.hir.forStmt(init, cond, body, step).copyWithOperands();
        super.process();
    }
}

