/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.HirRoot;
import coins.SymRoot;
import coins.ffront.DeclManager;
import coins.ffront.EntryType;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.FortranCharacterExp;
import coins.ffront.HasConstValue;
import coins.ffront.HirUtility;
import coins.ffront.Node;
import coins.ffront.Pair;
import coins.ffront.Token;
import coins.ir.IrList;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.sym.Elem;
import coins.sym.PointerType;
import coins.sym.StructType;
import coins.sym.Sym;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.UnionType;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.ListIterator;

public class TypeUtility {
    FirToHir fHir;
    HirUtility fHirUtil;
    Sym sym;
    HIR hir;
    SymRoot symRoot;
    HirRoot hirRoot;
    private Type entryType;
    private StructType complexStructType;
    private StructType complexDoubleStructType;

    public TypeUtility(FirToHir fth) {
        this.fHir = fth;
        this.sym = fth.getSym();
        this.hir = fth.getHir();
        this.symRoot = this.fHir.getSymRoot();
        this.hirRoot = this.fHir.getHirRoot();
    }

    Exp getDimSizeParamExp(Node n, DeclManager declMgr) {
        String punit_name = declMgr.getProgramUnitName();
        String var_name = this.fHir.getExecStmtManager().getTempName(punit_name + "_dim_size_var");
        Var var = declMgr.searchOrAddVar(var_name, this.getIntType());
        Exp exp = n.makeExp();
        declMgr.setInitialValue(var, this.fHirUtil.castToInteger(exp));
        return this.hir.varNode(var);
    }

    Type getArrayType(Type array_type, FirList dims, DeclManager declMgr) {
        int[] dim_lows = new int[]{1, 1, 1, 1, 1, 1, 1};
        int[] dim_upps = new int[]{0, 0, 0, 0, 0, 0, 0};
        Exp[] dim_lp = new Exp[]{null, null, null, null, null, null, null};
        Exp[] dim_up = new Exp[]{null, null, null, null, null, null, null};
        Type type = null;
        this.dp(" array type: " + array_type);
        int dimnum = 0;
        for (Pair d : dims) {
            Node tl = d.getLeft();
            Node tr = d.getRight();
            if (tl != null) {
                if (tl instanceof HasConstValue && ((HasConstValue)((Object)tl)).getConstValue() != null) {
                    dim_lows[dimnum] = ((HasConstValue)((Object)tl)).getConstValue().intValue();
                } else if (tl != null) {
                    Exp e;
                    dim_lp[dimnum] = e = this.getDimSizeParamExp(tl, declMgr);
                } else {
                    this.fHir.printMsgFatal("unkown array lower index type");
                }
            }
            if (tr instanceof HasConstValue && ((HasConstValue)((Object)tr)).getConstValue() != null) {
                dim_upps[dimnum] = ((HasConstValue)((Object)tr)).getConstValue().intValue();
            } else if (tr != null) {
                dim_up[dimnum] = this.getDimSizeParamExp(tr, declMgr);
            } else {
                this.dp("[TYPE] assumed-size array");
                dim_up[dimnum] = null;
            }
            ++dimnum;
        }
        int i = 0;
        type = this.makeVectorType(array_type, i, dim_lp, dim_up, dim_lows, dim_upps);
        while (++i < dimnum) {
            type = this.makeVectorType(type, i, dim_lp, dim_up, dim_lows, dim_upps);
        }
        this.dp("[TYPE getArrayType]: " + type);
        return type;
    }

    Type makeVectorType(Type type, int dimnum, Exp[] dim_lp, Exp[] dim_up, int[] dim_lows, int[] dim_upps) {
        if (dim_lp[dimnum] != null || dim_up[dimnum] != null) {
            Exp el = dim_lp[dimnum];
            Exp eu = dim_up[dimnum];
            Exp ec = null;
            int il = -1;
            if (el == null) {
                il = dim_lows[dimnum] - 1;
                el = this.fHirUtil.makeIntConstNode(dim_lows[dimnum]);
            }
            if (eu == null && dim_upps[dimnum] != 0) {
                eu = this.fHirUtil.makeIntConstNode(dim_upps[dimnum]);
            }
            ec = il == 0 ? eu : (il != -1 ? this.hir.exp(39, eu, this.fHirUtil.makeIntConstNode(il)) : this.hir.exp(38, this.hir.exp(39, eu, el), this.fHirUtil.makeConstInt1Node()));
            type = this.sym.vectorType(null, type, ec, el);
        } else {
            type = this.sym.vectorType(null, type, dim_upps[dimnum] - dim_lows[dimnum] + 1, dim_lows[dimnum]);
        }
        return type;
    }

    Type getType(Pair pTypeName) {
        Token typeName = (Token)pTypeName.getLeft();
        int length = 0;
        Node optLength = pTypeName.getRight();
        if (optLength != null) {
            if (optLength instanceof HasConstValue) {
                length = ((HasConstValue)((Object)optLength)).getConstValue().intValue();
            }
        } else if (typeName.getKind() == 273) {
            length = 1;
        }
        return this.getType(typeName.getKind(), length);
    }

    Type getType(int typeKind, int length) {
        switch (typeKind) {
            case 268: {
                if (length == 8) {
                    return this.symRoot.typeLong;
                }
                return this.symRoot.typeInt;
            }
            case 269: {
                if (length == 8) {
                    return this.symRoot.typeDouble;
                }
                return this.symRoot.typeFloat;
            }
            case 271: {
                return this.symRoot.typeDouble;
            }
            case 273: {
                return this.charArray(length);
            }
            case 272: {
                return this.symRoot.typeBool;
            }
            case 270: {
                if (length == 16) {
                    return this.getComplexDoubleStructType();
                }
                return this.getComplexStructType();
            }
        }
        return null;
    }

    Type getType(int typeKind) {
        if (typeKind == 273) {
            return this.getType(typeKind, 1);
        }
        return this.getType(typeKind, 0);
    }

    Type charArray(int length) {
        return this.sym.vectorType(this.symRoot.typeChar, this.fHirUtil.makeIntConstNode(length));
    }

    public Type getEntryType() {
        if (this.entryType == null) {
            this.entryType = new EntryType(this.fHir);
        }
        return this.entryType;
    }

    boolean isComplexType(Type type) {
        return this.getComplexStructType() == type || this.getComplexDoubleStructType() == type;
    }

    boolean isDoubleComplexType(Type type) {
        return this.getComplexDoubleStructType() == type;
    }

    public StructType getComplexStructType() {
        if (this.complexStructType == null) {
            SymTable c_table = this.symRoot.symTableCurrent;
            this.symRoot.symTableCurrent = this.symRoot.symTableRoot;
            Type realType = this.getRealType();
            IrList elemList = this.hir.irList();
            this.pushSymTable(null);
            elemList.add(this.sym.defineElem("_real", realType));
            elemList.add(this.sym.defineElem("_imag", realType));
            this.popSymTable();
            Sym tag = this.symRoot.symTableCurrent.generateTag("_complex_struct");
            this.complexStructType = this.sym.structType(elemList, tag);
            tag.setSymType(this.complexStructType);
            tag.setFlag(14, true);
            this.symRoot.symTableCurrent = c_table;
        }
        return this.complexStructType;
    }

    public StructType getComplexDoubleStructType() {
        if (this.complexDoubleStructType == null) {
            SymTable c_table = this.symRoot.symTableCurrent;
            this.symRoot.symTableCurrent = this.symRoot.symTableRoot;
            Type doubleType = this.getDoubleType();
            IrList elemList = this.hir.irList();
            this.pushSymTable(null);
            elemList.add(this.sym.defineElem("_real", doubleType));
            elemList.add(this.sym.defineElem("_imag", doubleType));
            this.popSymTable();
            Sym tag = this.symRoot.symTableCurrent.generateTag("_complex_double_struct");
            this.complexDoubleStructType = this.sym.structType(elemList, tag);
            tag.setSymType(this.complexDoubleStructType);
            tag.setFlag(14, true);
            this.symRoot.symTableCurrent = c_table;
        }
        return this.complexDoubleStructType;
    }

    public Elem getRealPart() {
        return (Elem)this.complexStructType.getElemList().get(0);
    }

    public Elem getImagPart() {
        return (Elem)this.complexStructType.getElemList().get(1);
    }

    public Elem getDoubleRealPart() {
        return (Elem)this.complexDoubleStructType.getElemList().get(0);
    }

    public Elem getDoubleImagPart() {
        return (Elem)this.complexDoubleStructType.getElemList().get(1);
    }

    public Elem getRealPart(StructType type) {
        return (Elem)type.getElemList().get(0);
    }

    public Elem getImagPart(StructType type) {
        return (Elem)type.getElemList().get(1);
    }

    public Type getGlobalStructType(String type_name, String[] names, Type[] types) {
        Type type = (Type)this.symRoot.symTableRoot.searchLocal(type_name, 13);
        if (type == null) {
            SymTable c_table = this.symRoot.symTableCurrent;
            this.symRoot.symTableCurrent = this.symRoot.symTableRoot;
            IrList el = this.hir.irList();
            int sz = names.length;
            this.pushSymTable(null);
            for (int i = 0; i < sz; ++i) {
                el.add(this.sym.defineElem(names[i], types[i]));
            }
            this.popSymTable();
            Sym tag = this.symRoot.symTableCurrent.generateTag(type_name);
            type = this.sym.structType(el, tag);
            tag.setSymType(type);
            this.symRoot.symTableCurrent = c_table;
        }
        return type;
    }

    Elem searchElem(String ident, Type type) {
        IrList list;
        if (type instanceof StructType) {
            list = ((StructType)type).getElemList();
        } else if (type instanceof UnionType) {
            list = ((UnionType)type).getElemList();
        } else {
            return null;
        }
        ListIterator it = list.iterator();
        while (it.hasNext()) {
            Elem elem = (Elem)it.next();
            if (elem.getName() != ident) continue;
            return elem;
        }
        return null;
    }

    Type getVectorBaseType(VectorType vt) {
        while (vt.getElemType() instanceof VectorType) {
            vt = (VectorType)vt.getElemType();
        }
        Type etype = vt.getElemType();
        if (etype == this.getCharType()) {
            return vt;
        }
        return etype;
    }

    boolean isFortranCharacterType(Type type) {
        return type instanceof VectorType ? ((VectorType)type).getElemType() == this.getCharType() : type instanceof PointerType && ((PointerType)type).getPointedType() == this.getCharType();
    }

    boolean isFortranCharacterVectorType(VectorType type) {
        return this.isFortranCharacterType(this.getVectorBaseType(type));
    }

    FortranCharacterExp castFortranCharacterExp(Exp exp) {
        if (exp instanceof FortranCharacterExp) {
            return (FortranCharacterExp)exp;
        }
        this.fHir.printMsgFatal("Should be Character type");
        return null;
    }

    Exp getFortranCharacterLengthExp(Type type, Node hint) {
        return this.getFortranCharacterLengthExp(type, ((Token)hint).getLexem());
    }

    Exp getFortranCharacterLengthExp(Type type, String name) {
        if (!this.isFortranCharacterType(type)) {
            this.fHir.printMsgFatal("[BUG] TypeMgr#getCharacterLengthExp: " + type);
        }
        Exp e = ((VectorType)type).getElemCountExp();
        this.dp("e : " + e);
        if (((VectorType)type).getElemCount() == 0L) {
            DeclManager fDeclMgr = this.fHir.getDeclManager();
            String id = fDeclMgr.characterLengthVarName(name);
            this.dp("getFortranCharacterLengthExp - hint: " + name + ", " + id);
            this.dp("** : " + fDeclMgr.search(id));
            return this.hir.varNode((Var)fDeclMgr.search(id));
        }
        return e;
    }

    Exp getFortranCharacterVectorLengthExp(VectorType type, String name) {
        return this.getFortranCharacterLengthExp(this.getVectorBaseType(type), name);
    }

    public SymTable pushSymTable(Sym pSym) {
        return this.symRoot.symTableCurrent.pushSymTable(pSym);
    }

    public void popSymTable() {
        this.symRoot.symTableCurrent.popSymTable();
        this.symRoot.symTableCurrentSubp = this.fHir.getDeclManager().fSymTable;
    }

    public Type getRealType() {
        return this.symRoot.typeFloat;
    }

    public Type getDoubleType() {
        return this.symRoot.typeDouble;
    }

    public Type getIntType() {
        return this.symRoot.typeInt;
    }

    public Type getBoolType() {
        return this.symRoot.typeBool;
    }

    public Type getVoidType() {
        return this.symRoot.typeVoid;
    }

    public Type getCharType() {
        return this.symRoot.typeChar;
    }

    void dp(String msg) {
        this.fHir.dp(msg);
    }
}

