/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.ComplexExp;
import coins.ffront.DeclManager;
import coins.ffront.DoubleComplexExp;
import coins.ffront.ExecStmtManager;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.FortranCharacterExp;
import coins.ffront.HirUtility;
import coins.ffront.Node;
import coins.ffront.TypeUtility;
import coins.ir.IrList;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.Stmt;
import coins.ir.hir.VarNode;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.ListIterator;

public class IntrinsicUtility {
    static NameAndType[] intrinsicTable = null;
    FirToHir fHir;
    HIR hir;
    Sym sym;
    HirUtility fHirUtil;
    TypeUtility fTypeUtil;
    DeclManager fDeclMgr;
    ExecStmtManager fESMgr;
    static final int NOT_YET = 0;
    static final int MATH_LIB = 1;
    static final int MATH_LIB2 = 2;
    static final int CONV_TO_REAL = 4;
    static final int CONV_TO_INTEGER = 5;
    static final int CONV_TO_DOUBLE = 6;
    static final int CONV_TO_COMPLEX = 7;
    static final int CONV_TO_CHAR = 8;
    static final int ABS = 10;
    static final int POWER = 11;
    static final int TRUNCATE = 12;
    static final int NEAREST = 13;
    static final int NEAREST_INT = 14;
    static final int LENGTH = 15;
    static final int IMAGINARY_PART = 17;
    static final int CONJUGATE = 18;
    static final int DIMAGINARY_PART = 21;
    static final int DCONJUGATE = 22;
    static final int COMPLEX_LIB = 20;
    static final int SIGN = 26;
    static final int DIM = 27;
    static final int DPROD = 28;
    static final int MOD = 29;
    static final int MAX = 30;
    static final int MAX_R = 31;
    static final int MAX_I = 32;
    static final int MIN = 33;
    static final int MIN_R = 34;
    static final int MIN_I = 35;
    static final int INDEX = 40;
    static final int TYPE_NO = 0;
    static final int TYPE_REAL = 1;
    static final int TYPE_DOUBLE = 2;
    static final int TYPE_INT = 3;
    static final int TYPE_COMPLEX = 7;
    static final int TYPE_DCOMPLEX = 10;
    static final int TYPE_CHARACTER = 4;
    static final int TYPE_FLOAT = 5;
    static final int TYPE_NUMBER = 6;
    static final int TYPE_FC = 8;
    static final int TYPE_FI = 9;
    static final int TYPE_ONE_OR_TWO = 256;
    static final int TYPE_OVER_TWO = 512;

    public IntrinsicUtility(FirToHir fth) {
        this.fHir = fth;
        this.fTypeUtil = this.fHir.getTypeUtility();
        this.fHirUtil = this.fHir.getHirUtility();
        this.hir = this.fHir.getHir();
        this.sym = this.fHir.getSym();
        if (intrinsicTable == null) {
            this.init_intrinsicTable();
        }
    }

    int searchFuncName(String name) {
        for (int i = 0; i < intrinsicTable.length; ++i) {
            if (IntrinsicUtility.intrinsicTable[i].name != name) continue;
            return i;
        }
        return -1;
    }

    boolean isIntrinsicCall(String id) {
        return this.searchFuncName(id) >= 0;
    }

    Exp makeIntrinsicCall(String ident, FirList args) {
        this.fESMgr = this.fHir.getExecStmtManager();
        int index = this.searchFuncName(ident);
        Exp expArg = null;
        Exp expArg2 = null;
        IrList argExps = this.hir.irList();
        Node hint1 = null;
        Node hint2 = null;
        int i = 0;
        for (Node n : args) {
            Exp e = n.makeExp();
            argExps.add(e);
            if (i == 0) {
                expArg = e;
                hint1 = n;
            } else if (i == 1) {
                expArg2 = e;
                hint2 = n;
            }
            ++i;
        }
        this.argsTypeCheck(intrinsicTable[index], argExps);
        return this.makeIntrinsicCallCont(expArg, expArg2, argExps, index, hint1, hint2);
    }

    Exp makeIntrinsicCallCont(Exp expArg, Exp expArg2, IrList argExps, int index, Node hint, Node hint2) {
        NameAndType nat = intrinsicTable[index];
        String ident = nat.name;
        switch (nat.kind) {
            case 1: {
                if (this.fTypeUtil.isComplexType(expArg.getType())) {
                    int idx = this.searchFuncName(nat.complexFunc);
                    return this.makeIntrinsicCallCont(expArg, expArg2, argExps, idx, hint, hint2);
                }
                return this.makeLibCall(nat.libName, expArg, 271);
            }
            case 2: {
                return this.makeLibCall2(nat.libName, expArg, expArg2, 271);
            }
            case 20: {
                String name = this.fESMgr.getTempName() + "_intrinsic_dst_";
                Var dst = this.sym.defineVar(name.intern(), this.fTypeUtil.getComplexStructType());
                VarNode dstExp = this.hir.varNode(dst);
                this.makeComplexCall(nat.libName, hint.makeArgAddr(this.fESMgr.getCurrentStmt()), this.hir.exp(64, dstExp));
                return this.fHirUtil.makeComplexExp(dstExp);
            }
            case 5: {
                if (expArg instanceof ComplexExp) {
                    return this.hir.convExp(this.fTypeUtil.getIntType(), ((ComplexExp)expArg).getRealPart());
                }
                if (expArg instanceof FortranCharacterExp) {
                    FortranCharacterExp fcexp = (FortranCharacterExp)expArg;
                    if (fcexp.getBody().getType() instanceof VectorType) {
                        return this.hir.convExp(this.fTypeUtil.getIntType(), this.hir.contentsExp(this.hir.decayExp(fcexp.getBody())));
                    }
                    return this.hir.convExp(this.fTypeUtil.getIntType(), this.hir.contentsExp(fcexp.getBody()));
                }
                return this.hir.convExp(this.fTypeUtil.getIntType(), expArg);
            }
            case 4: {
                if (expArg instanceof ComplexExp) {
                    return ((ComplexExp)expArg).getRealPart();
                }
                return this.hir.convExp(this.fTypeUtil.getRealType(), expArg);
            }
            case 6: {
                if (expArg instanceof ComplexExp) {
                    return ((ComplexExp)expArg).getRealPart();
                }
                return this.hir.convExp(this.fTypeUtil.getDoubleType(), expArg);
            }
            case 8: {
                Exp tmp = this.tempVarNode("char", this.fTypeUtil.charArray(1));
                this.fESMgr.addStmt(this.makeAssignStmt(this.hir.subscriptedExp(tmp, this.fHirUtil.makeConstInt0Node()), expArg));
                return tmp;
            }
            case 7: {
                if (expArg instanceof ComplexExp) {
                    return expArg;
                }
                if (expArg2 == null) {
                    return new ComplexExp(this.fHirUtil.castIfNeeded(expArg, this.fTypeUtil.getRealType()), this.fHirUtil.makeConstReal0Node(), this.fHir);
                }
                return new ComplexExp(this.fHirUtil.castIfNeeded(expArg, this.fTypeUtil.getRealType()), this.fHirUtil.castIfNeeded(expArg2, this.fTypeUtil.getRealType()), this.fHir);
            }
            case 40: {
                Exp s_copy = this.fHirUtil.makeSubpNode("i_indx", 268, this.hir.irList(), 1);
                IrList args = this.hir.irList();
                FortranCharacterExp e1 = (FortranCharacterExp)expArg;
                FortranCharacterExp e2 = (FortranCharacterExp)expArg2;
                args.add(e1.getBody());
                args.add(e2.getBody());
                args.add(e1.getLength());
                args.add(e2.getLength());
                return this.hir.functionExp(s_copy, args);
            }
            case 12: {
                return this.hir.convExp(expArg.getType(), this.hir.convExp(this.fTypeUtil.getIntType(), expArg));
            }
            case 13: {
                return this.hir.convExp(expArg.getType(), this.funcNEAREST(expArg));
            }
            case 14: {
                return this.funcNEAREST(expArg);
            }
            case 15: {
                return ((FortranCharacterExp)expArg).getLength();
            }
            case 17: 
            case 21: {
                return ((ComplexExp)expArg).getImagPart();
            }
            case 18: {
                return new ComplexExp(((ComplexExp)expArg).getRealPart(), this.hir.exp(63, ((ComplexExp)expArg).getImagPart()), this.fHir);
            }
            case 22: {
                return new DoubleComplexExp(((DoubleComplexExp)expArg).getRealPart(), this.hir.exp(63, ((DoubleComplexExp)expArg).getImagPart()), this.fHir);
            }
            case 29: {
                if (expArg.getType() == this.fTypeUtil.getIntType() && expArg2.getType() == this.fTypeUtil.getIntType()) {
                    return this.hir.exp(43, expArg, expArg2);
                }
                expArg = this.fHirUtil.convToDouble(expArg);
                expArg2 = this.fHirUtil.convToDouble(expArg2);
                Exp e1 = this.hir.exp(42, expArg, expArg2);
                Exp e2 = this.hir.convExp(this.fTypeUtil.getIntType(), e1);
                Exp e3 = this.hir.exp(41, this.fHirUtil.convToDouble(e2), expArg2);
                return this.hir.exp(39, expArg, e3);
            }
            case 26: {
                Type type1 = expArg.getType();
                Type type2 = expArg2.getType();
                Exp tmp = this.tempVarNode("sign", type1);
                this.fESMgr.addStmt(this.makeAssignStmt(tmp, expArg));
                Stmt neg1 = this.makeAssignStmt(tmp, this.hir.exp(63, expArg));
                Stmt neg2 = this.makeAssignStmt(tmp, this.hir.exp(63, expArg));
                Exp zn1 = this.fHirUtil.makeTyped0Node(type1);
                Exp zn2 = this.fHirUtil.makeTyped0Node(type2);
                this.fESMgr.addStmt(this.hir.ifStmt(this.hir.exp(54, expArg2, zn2), this.hir.ifStmt(this.hir.exp(55, expArg, zn1), neg1, null), this.hir.ifStmt(this.hir.exp(53, expArg, zn1), neg2, null)));
                return tmp;
            }
            case 27: {
                Type type = this.fHirUtil.checkTwoExpType(expArg, expArg2);
                expArg = this.fHirUtil.castIfNeeded(expArg, type);
                expArg2 = this.fHirUtil.castIfNeeded(expArg2, type);
                Exp tmp = this.tempVarNode("dim", type);
                this.fESMgr.addStmt(this.makeAssignStmt(tmp, this.hir.exp(39, expArg, expArg2)));
                this.fESMgr.addStmt(this.hir.ifStmt(this.hir.exp(55, tmp, this.fHirUtil.makeTyped0Node(type)), this.makeAssignStmt(tmp, this.fHirUtil.makeTyped0Node(type)), null));
                return tmp;
            }
            case 28: {
                return this.hir.exp(41, this.hir.convExp(this.fTypeUtil.getDoubleType(), expArg), this.hir.convExp(this.fTypeUtil.getDoubleType(), expArg2));
            }
            case 10: {
                Type argType = expArg.getType();
                Exp constZero = null;
                Exp temp = null;
                if (argType.isFloating()) {
                    if (argType.getTypeKind() == 17) {
                        constZero = this.fHirUtil.makeConstDouble0Node();
                        temp = this.hir.varNode(this.fESMgr.makeDoubleTemp());
                    } else {
                        constZero = this.fHirUtil.makeConstReal0Node();
                        temp = this.hir.varNode(this.fESMgr.makeRealTemp());
                    }
                } else if (argType.isInteger()) {
                    constZero = this.fHirUtil.makeConstInt0Node();
                    temp = this.hir.varNode(this.fESMgr.makeIntTemp());
                } else {
                    if (expArg instanceof ComplexExp) {
                        Exp lExpReal = ((ComplexExp)expArg).getRealPart();
                        Exp lExpImag = ((ComplexExp)expArg).getImagPart();
                        temp = this.hir.exp(38, this.hir.exp(41, lExpReal, lExpReal), this.hir.exp(41, lExpImag, lExpImag));
                        return this.makeLibCall("sqrt", temp, 271);
                    }
                    this.fHir.printMsgFatal("unimplemented abs function " + ident);
                    return this.fHirUtil.makeConstInt1Node();
                }
                Stmt stmt = this.makeAssignStmt(temp, expArg);
                this.fESMgr.getCurrentStmt().addGeneratedStmt(stmt);
                Exp condition = this.hir.exp(55, temp, constZero);
                Exp negation = this.hir.exp(63, temp);
                stmt = this.hir.ifStmt(condition, this.makeAssignStmt(temp, negation), null);
                this.fESMgr.addStmt(stmt);
                return temp;
            }
            case 11: {
                Type type1 = expArg.getType();
                Type type2 = expArg2.getType();
                if (type1.isInteger() && type2.isInteger()) {
                    return this.intPowExp(expArg, expArg2);
                }
                if (type1 == this.fTypeUtil.getComplexStructType() || type2 == this.fTypeUtil.getComplexStructType()) {
                    return this.complexPowExp(expArg, expArg2);
                }
                return this.makeLibCall2("pow", expArg, expArg2, 271);
            }
            case 30: {
                return this.funcMAX(argExps);
            }
            case 31: {
                return this.hir.convExp(this.fTypeUtil.getRealType(), this.funcMAX(argExps));
            }
            case 32: {
                return this.hir.convExp(this.fTypeUtil.getIntType(), this.funcMAX(argExps));
            }
            case 33: {
                return this.funcMIN(argExps);
            }
            case 34: {
                return this.hir.convExp(this.fTypeUtil.getRealType(), this.funcMIN(argExps));
            }
            case 35: {
                return this.hir.convExp(this.fTypeUtil.getIntType(), this.funcMIN(argExps));
            }
            case 0: {
                this.fHir.printMsgFatal("BUG: NOT_YET");
                return null;
            }
        }
        this.fHir.printMsgFatal("unimplemented function " + ident + " with " + expArg.getType());
        return null;
    }

    Exp tempVarNode(String str, Type type) {
        return this.hir.varNode(this.sym.defineVar(this.fESMgr.getTempName(str), type));
    }

    Stmt makeAssignStmt(Exp e1, Exp e2) {
        return this.fHirUtil.makeAssignStmt(e1, e2);
    }

    Exp intPowExp(Exp e1, Exp e2) {
        HIR hir = this.fHir.getHir();
        IrList aParamList = hir.irList();
        IrList fParamList = hir.irList();
        aParamList.add(this.fHirUtil.makeArgAddr(this.fESMgr.getCurrentStmt(), e1));
        aParamList.add(this.fHirUtil.makeArgAddr(this.fESMgr.getCurrentStmt(), e2));
        Exp libSpec = this.fHirUtil.makeSubpNode("pow_ii", 268, fParamList, 1);
        return hir.functionExp(libSpec, aParamList);
    }

    Exp complexPowExp(Exp e1, Exp e2) {
        Exp libSpec;
        HIR hir = this.fHir.getHir();
        IrList aParamList = hir.irList();
        IrList fParamList = hir.irList();
        String name = this.fESMgr.getTempName() + "_intrinsic_dst_";
        Var dst = this.sym.defineVar(name.intern(), this.fTypeUtil.getComplexDoubleStructType());
        VarNode dstExp = hir.varNode(dst);
        aParamList.add(hir.exp(64, dstExp));
        if (e2.getType() == this.fTypeUtil.getIntType()) {
            aParamList.add(this.fHirUtil.makeArgAddr(this.fESMgr.getCurrentStmt(), new DoubleComplexExp((ComplexExp)e1, this.fHir)));
            aParamList.add(this.fHirUtil.makeArgAddr(this.fESMgr.getCurrentStmt(), e2));
            libSpec = this.fHirUtil.makeSubpNode("pow_zi", 268, fParamList, 1);
        } else {
            DoubleComplexExp e;
            if (e1 instanceof ComplexExp) {
                aParamList.add(this.fHirUtil.makeArgAddr(this.fESMgr.getCurrentStmt(), new DoubleComplexExp((ComplexExp)e1, this.fHir)));
            } else {
                e = new DoubleComplexExp(e1, null, this.fHir);
                aParamList.add(this.fHirUtil.makeArgAddr(this.fESMgr.getCurrentStmt(), e));
            }
            if (e2 instanceof ComplexExp) {
                aParamList.add(this.fHirUtil.makeArgAddr(this.fESMgr.getCurrentStmt(), new DoubleComplexExp((ComplexExp)e2, this.fHir)));
            } else {
                e = new DoubleComplexExp(e2, null, this.fHir);
                aParamList.add(this.fHirUtil.makeArgAddr(this.fESMgr.getCurrentStmt(), e));
            }
            libSpec = this.fHirUtil.makeSubpNode("pow_zz", 268, fParamList, 1);
        }
        this.fESMgr.addStmt(hir.callStmt(libSpec, aParamList));
        return this.fHirUtil.makeComplexExp(dstExp);
    }

    Exp funcNEAREST(Exp arg) {
        Type type = arg.getType();
        Exp tmp = this.tempVarNode("nearest", type);
        this.fESMgr.addStmt(this.makeAssignStmt(tmp, arg));
        this.fESMgr.addStmt(this.hir.ifStmt(this.hir.exp(54, tmp, this.fHirUtil.makeTyped0Node(type)), this.makeAssignStmt(tmp, this.hir.exp(38, tmp, this.fHirUtil.castIfNeeded(this.fHirUtil.makeFloatConstNode("0.5"), type))), this.makeAssignStmt(tmp, this.hir.exp(39, tmp, this.fHirUtil.castIfNeeded(this.fHirUtil.makeFloatConstNode("0.5"), type)))));
        return this.hir.convExp(this.fTypeUtil.getIntType(), tmp);
    }

    Exp funcMAX(IrList args) {
        ListIterator it = args.iterator();
        Exp e0 = (Exp)it.next();
        Type type = e0.getType();
        Exp tmp = this.tempVarNode("max", type);
        this.fESMgr.addStmt(this.makeAssignStmt(tmp, e0));
        while (it.hasNext()) {
            e0 = this.fHirUtil.castIfNeeded((Exp)it.next(), type);
            this.fESMgr.addStmt(this.hir.ifStmt(this.hir.exp(55, tmp, e0), this.makeAssignStmt(tmp, e0), null));
        }
        return tmp;
    }

    Exp funcMIN(IrList args) {
        ListIterator it = args.iterator();
        Exp e0 = (Exp)it.next();
        Type type = e0.getType();
        Exp tmp = this.tempVarNode("min", type);
        this.fESMgr.addStmt(this.makeAssignStmt(tmp, e0));
        while (it.hasNext()) {
            e0 = this.fHirUtil.castIfNeeded((Exp)it.next(), type);
            this.fESMgr.addStmt(this.hir.ifStmt(this.hir.exp(53, tmp, e0), this.makeAssignStmt(tmp, e0), null));
        }
        return tmp;
    }

    Exp makeLibCall(String name, Exp pExp, int type) {
        HIR hir = this.fHir.getHir();
        IrList aParamList = hir.irList();
        IrList fParamList = hir.irList();
        Type return_type = pExp.getType();
        if (type == 271) {
            pExp = this.fHirUtil.convToDouble(pExp);
        }
        aParamList.add(pExp);
        Exp libSpec = this.fHirUtil.makeSubpNode(name.intern(), type, fParamList, 1);
        return this.convertTo(hir.functionExp(libSpec, aParamList), return_type);
    }

    Exp makeLibCall2(String name, Exp pExp1, Exp pExp2, int type) {
        HIR hir = this.fHir.getHir();
        IrList aParamList = hir.irList();
        IrList fParamList = hir.irList();
        Type return_type = pExp1.getType();
        if (type == 271) {
            pExp1 = this.fHirUtil.convToDouble(pExp1);
            pExp2 = this.fHirUtil.convToDouble(pExp2);
        }
        aParamList.add(pExp1);
        aParamList.add(pExp2);
        Exp libSpec = this.fHirUtil.makeSubpNode(name.intern(), type, fParamList, 1);
        return this.convertTo(hir.functionExp(libSpec, aParamList), return_type);
    }

    Exp convertTo(Exp exp, Type type) {
        if (exp.getType() == type) {
            return exp;
        }
        return this.hir.convExp(type, exp);
    }

    void makeComplexCall(String name, Exp src, Exp dst) {
        HIR hir = this.fHir.getHir();
        IrList aParamList = hir.irList();
        IrList fParamList = hir.irList();
        aParamList.add(dst);
        aParamList.add(src);
        Exp libSpec = this.fHirUtil.makeSubpNode(name.intern(), 268, fParamList, 1);
        this.fESMgr.addStmt(hir.callStmt(libSpec, aParamList));
    }

    boolean typeCheck(Type type, int expected_type) {
        switch (expected_type) {
            case 1: {
                return type == this.fTypeUtil.getRealType();
            }
            case 2: {
                return type == this.fTypeUtil.getDoubleType();
            }
            case 3: {
                return type == this.fTypeUtil.getIntType();
            }
            case 7: {
                return this.fTypeUtil.isComplexType(type);
            }
            case 10: {
                return this.fTypeUtil.isDoubleComplexType(type);
            }
            case 4: {
                return this.fTypeUtil.isFortranCharacterType(type);
            }
            case 5: {
                return type == this.fTypeUtil.getRealType() || type == this.fTypeUtil.getDoubleType();
            }
            case 6: {
                return type == this.fTypeUtil.getRealType() || type == this.fTypeUtil.getDoubleType() || type == this.fTypeUtil.getIntType() || this.fTypeUtil.isComplexType(type);
            }
            case 8: {
                return type == this.fTypeUtil.getRealType() || type == this.fTypeUtil.getDoubleType() || this.fTypeUtil.isComplexType(type);
            }
            case 9: {
                return type == this.fTypeUtil.getRealType() || type == this.fTypeUtil.getDoubleType() || type == this.fTypeUtil.getIntType();
            }
        }
        this.fHir.printMsgFatal("BUG: argsTypeCheck");
        return false;
    }

    boolean argsTypeCheck(NameAndType nat, IrList argsExps) {
        ListIterator it = argsExps.iterator();
        int num = 0;
        while (it.hasNext()) {
            ++num;
            Exp e = (Exp)it.next();
            Type t = e instanceof FortranCharacterExp ? ((FortranCharacterExp)e).getBody().getType() : e.getType();
            if (this.typeCheck(t, nat.type1 & 0xFF)) continue;
            this.fHir.printMsgRecovered("[IntrinsicFunction] Argument type is incollect for " + nat.name + ": " + t);
            return false;
        }
        if (num != 1 && nat.type2 == 0 && (nat.type1 | 0x100) == 0 && (nat.type1 | 0x200) == 0) {
            this.fHir.printMsgRecovered("arguments error: too many args");
            return false;
        }
        if (num != 2 && nat.type2 != 0) {
            this.fHir.printMsgRecovered("arguments error: too many, or few args");
            return false;
        }
        return true;
    }

    void init_intrinsicTable() {
        NameAndType[] tempTable = new NameAndType[]{new NameAndType("_power", 11, 6), new NameAndType("int", 5, 6), new NameAndType("ifix", 5, 1), new NameAndType("idint", 5, 2), new NameAndType("real", 4, 6), new NameAndType("float", 4, 3), new NameAndType("sngl", 4, 2), new NameAndType("dble", 6, 6), new NameAndType("cmplx", 7, 262), new NameAndType("ichar", 5, 4), new NameAndType("char", 8, 3), new NameAndType("aint", 12, 5), new NameAndType("dint", 12, 2), new NameAndType("anint", 13, 5), new NameAndType("dnint", 13, 5), new NameAndType("nint", 14, 5), new NameAndType("idnint", 14, 2), new NameAndType("abs", 10, 6), new NameAndType("iabs", 10, 3), new NameAndType("dabs", 10, 2), new NameAndType("cabs", 10, 7), new NameAndType("len", 15, 4), new NameAndType("aimag", 17, 7), new NameAndType("conjg", 18, 7), new NameAndType("dimag", 21, 10), new NameAndType("dconjg", 22, 10), new NameAndType("sqrt", 1, "sqrt", 8, "csqrt"), new NameAndType("dsqrt", 1, "sqrt", 2), new NameAndType("csqrt", 20, "c_sqrt", 7), new NameAndType("exp", 1, "exp", 8, "cexp"), new NameAndType("dexp", 1, "exp", 2), new NameAndType("cexp", 20, "c_exp", 7), new NameAndType("log", 1, "log", 8, "clog"), new NameAndType("alog", 1, "log", 1), new NameAndType("dlog", 1, "log", 2), new NameAndType("clog", 20, "c_log", 7), new NameAndType("log10", 1, "log10", 5), new NameAndType("alog10", 1, "log10", 1), new NameAndType("dlog10", 1, "log10", 2), new NameAndType("sin", 1, "sin", 8, "csin"), new NameAndType("dsin", 1, "sin", 2), new NameAndType("csin", 20, "c_sin", 7), new NameAndType("cos", 1, "cos", 8, "ccos"), new NameAndType("dcos", 1, "cos", 2), new NameAndType("ccos", 20, "c_cos", 7), new NameAndType("tan", 1, "tan", 5), new NameAndType("dtan", 1, "tan", 2), new NameAndType("asin", 1, "asin", 5), new NameAndType("dasin", 1, "asin", 2), new NameAndType("acos", 1, "acos", 5), new NameAndType("dacos", 1, "acos", 2), new NameAndType("atan", 1, "atan", 5), new NameAndType("datan", 1, "atan", 2), new NameAndType("atan2", 2, "atan2", 5, 5), new NameAndType("datan2", 2, "atan2", 2, 2), new NameAndType("sinh", 1, "sinh", 5), new NameAndType("dsinh", 1, "sinh", 2), new NameAndType("cosh", 1, "cosh", 5), new NameAndType("dcosh", 1, "cosh", 2), new NameAndType("tanh", 1, "tanh", 5), new NameAndType("dtanh", 1, "tanh", 2), new NameAndType("mod", 29, 9, 9), new NameAndType("amod", 29, 1, 1), new NameAndType("dmod", 29, 2, 2), new NameAndType("sign", 26, 9, 9), new NameAndType("isign", 26, 3, 3), new NameAndType("dsign", 26, 2, 2), new NameAndType("dim", 27, 9, 9), new NameAndType("idim", 27, 3, 3), new NameAndType("ddim", 27, 2, 2), new NameAndType("dprod", 28, 1, 1), new NameAndType("max", 30, 521), new NameAndType("max0", 30, 515), new NameAndType("amax1", 30, 513), new NameAndType("dmax1", 30, 514), new NameAndType("amax0", 31, 515), new NameAndType("max1", 32, 513), new NameAndType("min", 33, 521), new NameAndType("min0", 33, 515), new NameAndType("amin1", 33, 513), new NameAndType("dmin1", 33, 514), new NameAndType("amin0", 34, 515), new NameAndType("min1", 35, 513), new NameAndType("index", 40, 4, 4)};
        intrinsicTable = tempTable;
    }

    void dp(String msg) {
        this.fHir.dp(msg);
    }

    class NameAndType {
        String name;
        String libName;
        int kind;
        int type1 = 0;
        int type2 = 0;
        String complexFunc;

        NameAndType(String name, int k, int t1) {
            this.name = name;
            this.kind = k;
            this.type1 = t1;
        }

        NameAndType(String name, int k, int t1, int t2) {
            this(name, k, t1);
            this.type2 = t2;
        }

        NameAndType(String name, int k, String pName, int t1) {
            this(name, k, t1);
            this.libName = pName;
        }

        NameAndType(String name, int k, String pName, int t1, String cf) {
            this(name, k, t1);
            this.libName = pName;
            this.complexFunc = cf;
        }

        NameAndType(String name, int k, String pName, int t1, int t2) {
            this(name, k, t1, t2);
            this.libName = pName;
        }
    }
}

