/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.HirRoot;
import coins.SymRoot;
import coins.ffront.ComplexExp;
import coins.ffront.DoubleComplexExp;
import coins.ffront.ExecStmtManager;
import coins.ffront.FStmt;
import coins.ffront.FirToHir;
import coins.ffront.FortranCharacterExp;
import coins.ffront.TypeUtility;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.ElemNode;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.PointedExp;
import coins.ir.hir.QualifiedExp;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubscriptedExp;
import coins.ir.hir.VarNode;
import coins.sym.Label;
import coins.sym.PointerType;
import coins.sym.StructType;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.Var;
import coins.sym.VectorType;

public class HirUtility {
    FirToHir fHir;
    TypeUtility fTypeUtil;
    Sym sym;
    HIR hir;
    SymRoot symRoot;
    HirRoot hirRoot;

    public HirUtility(FirToHir fth, HIR h) {
        this.fHir = fth;
        this.sym = fth.getSym();
        this.hir = fth.getHir();
        this.symRoot = this.fHir.getSymRoot();
        this.hirRoot = this.fHir.getHirRoot();
    }

    public Exp makeArgAddr(FStmt pCallStmt, Exp pExp) {
        VarNode dummyExp;
        Type expType = pExp.getType();
        this.dp("HirUtility#makeArgAddr: " + pExp + " as " + expType);
        if (pExp instanceof FortranCharacterExp) {
            return ((FortranCharacterExp)pExp).getBody();
        }
        if (expType instanceof VectorType) {
            return this.hir.exp(64, pExp);
        }
        if (expType instanceof PointerType) {
            return pExp;
        }
        if (pExp instanceof VarNode) {
            return this.hir.exp(64, pExp);
        }
        String dummyName = this.fHir.getExecStmtManager().getTempName();
        if (pExp instanceof DoubleComplexExp) {
            expType = this.fTypeUtil.getComplexDoubleStructType();
            dummyExp = this.hir.varNode(this.sym.defineVar(dummyName, expType));
            DoubleComplexExp ce = this.makeDoubleComplexExp(dummyExp);
            pCallStmt.addGeneratedStmt(this.makeAssignStmt(ce.getImagPart(), ((DoubleComplexExp)pExp).getImagPart()));
            pCallStmt.addGeneratedStmt(this.makeAssignStmt(ce.getRealPart(), ((DoubleComplexExp)pExp).getRealPart()));
        } else if (pExp instanceof ComplexExp) {
            expType = this.fTypeUtil.getComplexStructType();
            dummyExp = this.hir.varNode(this.sym.defineVar(dummyName, expType));
            ComplexExp ce = this.makeComplexExp(dummyExp);
            pCallStmt.addGeneratedStmt(this.makeAssignStmt(ce.getImagPart(), ((ComplexExp)pExp).getImagPart()));
            pCallStmt.addGeneratedStmt(this.makeAssignStmt(ce.getRealPart(), ((ComplexExp)pExp).getRealPart()));
        } else {
            dummyExp = this.hir.varNode(this.sym.defineVar(dummyName, expType));
            pCallStmt.addGeneratedStmt(this.makeAssignStmt(dummyExp, pExp));
        }
        return this.hir.exp(64, dummyExp);
    }

    DoubleComplexExp makeDoubleComplexExp(Exp pExp) {
        StructType type = (StructType)pExp.getType();
        ElemNode elemNode = this.hir.elemNode(this.fTypeUtil.getRealPart(type));
        QualifiedExp realExp = this.hir.qualifiedExp(pExp, elemNode);
        elemNode = this.hir.elemNode(this.fTypeUtil.getImagPart(type));
        QualifiedExp imagExp = this.hir.qualifiedExp(pExp, elemNode);
        return new DoubleComplexExp(realExp, imagExp, this.fHir);
    }

    ComplexExp makeComplexExp(Exp pExp) {
        StructType type = (StructType)pExp.getType();
        ElemNode elemNode = this.hir.elemNode(this.fTypeUtil.getRealPart(type));
        QualifiedExp realExp = this.hir.qualifiedExp(pExp, elemNode);
        elemNode = this.hir.elemNode(this.fTypeUtil.getImagPart(type));
        QualifiedExp imagExp = this.hir.qualifiedExp(pExp, elemNode);
        if (type == this.fTypeUtil.getComplexDoubleStructType()) {
            return new DoubleComplexExp(realExp, imagExp, this.fHir);
        }
        return new ComplexExp(realExp, imagExp, this.fHir);
    }

    ComplexExp makeComplexExpByType(Exp rexp, Exp iexp, Type type) {
        if (type == this.fTypeUtil.getDoubleType()) {
            return new DoubleComplexExp(rexp, iexp, this.fHir);
        }
        return new ComplexExp(rexp, iexp, this.fHir);
    }

    ComplexExp makeComplexExpFromVar(Var v) {
        Type t = v.getSymType();
        if (t == this.fTypeUtil.getComplexStructType()) {
            return this.makeComplexExp(this.hir.varNode(v));
        }
        if (t == this.fTypeUtil.getComplexDoubleStructType()) {
            return this.makeDoubleComplexExp(this.hir.varNode(v));
        }
        return null;
    }

    public Exp makeNullNode() {
        return this.hir.nullNode();
    }

    public Exp makeConstInt1Node() {
        return this.hir.constNode(this.symRoot.intConst1);
    }

    public Exp makeConstInt0Node() {
        return this.hir.constNode(this.symRoot.intConst0);
    }

    public Exp makeConstReal0Node() {
        return this.hir.constNode(this.symRoot.floatConst0);
    }

    public Exp makeConstDouble0Node() {
        return this.hir.constNode(this.symRoot.doubleConst0);
    }

    public Exp makeConstReal1Node() {
        return this.hir.constNode(this.sym.floatConst("1.0", this.symRoot.typeFloat));
    }

    public Exp makeIntConstNode(String lexem) {
        return this.hir.constNode(this.sym.intConst(lexem, this.symRoot.typeInt));
    }

    public Exp makeIntConstNode(int num) {
        return this.hir.constNode(this.sym.intConst(String.valueOf(num), this.symRoot.typeInt));
    }

    public Exp makeFloatConstNode(String lexem) {
        return this.hir.constNode(this.sym.floatConst(lexem, this.symRoot.typeFloat));
    }

    public Exp makeDoubleConstNode(String lexem) {
        return this.hir.constNode(this.sym.floatConst(lexem, this.symRoot.typeDouble));
    }

    public Exp makeTrueConstNode() {
        return this.hir.constNode(this.symRoot.boolConstTrue);
    }

    public Exp makeFalseConstNode() {
        return this.hir.constNode(this.symRoot.boolConstFalse);
    }

    public FortranCharacterExp makeCharsConstNode(String lexem) {
        return this.makeFortranCharacterExp(this.hir.decayExp(this.hir.constNode(this.sym.stringConst(lexem))), this.makeIntConstNode(lexem.length()));
    }

    public FortranCharacterExp makeFortranCharacterExp(Exp body, Exp len) {
        this.dp("FortranCharacterExp: " + body);
        this.dp("FortranCharacterExp: " + body.getType());
        if (!(body.getType() instanceof PointerType)) {
            body = this.hir.decayExp(body);
        }
        this.dp("FortranCharacterExp: " + body.getType());
        return new FortranCharacterExp(body, len, this.fHir);
    }

    public Exp checkAssignExpType(Exp pExp1, Exp pExp2) {
        Type exp1Type = pExp1.getType();
        Type exp2Type = pExp2.getType();
        if (exp1Type instanceof PointerType && pExp2 instanceof ConstNode && ((ConstNode)pExp2).getIntValue() == 0) {
            return pExp2;
        }
        if (exp1Type == exp2Type || pExp1 instanceof ComplexExp && pExp2 instanceof ComplexExp) {
            return pExp2;
        }
        if ((exp1Type.isFloating() || exp1Type.isInteger()) && (exp2Type.isFloating() || exp2Type.isInteger())) {
            return this.hir.convExp(exp1Type, pExp2);
        }
        if (pExp2 instanceof ComplexExp) {
            return this.checkAssignExpType(pExp1, ((ComplexExp)pExp2).getRealPart());
        }
        if (pExp1 instanceof ComplexExp) {
            return new ComplexExp(pExp2, this.makeConstReal0Node(), this.fHir);
        }
        this.dp("illegal assignment (pExp1): " + pExp1);
        this.dp("illegal assignment (pExp2): " + pExp2);
        this.fHir.printMsgError("illegal assignment: (left type: " + exp1Type + ", right type: " + exp2Type + ")");
        return pExp2;
    }

    public Stmt makeAssignStmt(Exp lExp1, Exp lExp2) {
        if (!(lExp1 instanceof VarNode || lExp1 instanceof SubscriptedExp || lExp1 instanceof ComplexExp || lExp1 instanceof QualifiedExp || lExp1 instanceof PointedExp || lExp1.getOperator() == 68)) {
            this.fHir.printMsgFatal("left value must be assinable : " + lExp1);
            return null;
        }
        lExp2 = this.checkAssignExpType(lExp1, lExp2);
        if (lExp1 instanceof ComplexExp) {
            BlockStmt bstmt = this.hir.blockStmt(null);
            bstmt.addLastStmt(this.makeAssignStmt(((ComplexExp)lExp1).getImagPart(), ((ComplexExp)lExp2).getImagPart()));
            bstmt.addLastStmt(this.makeAssignStmt(((ComplexExp)lExp1).getRealPart(), ((ComplexExp)lExp2).getRealPart()));
            return bstmt;
        }
        if (lExp2 instanceof ComplexExp) {
            return this.makeAssignStmt(lExp1, this.castIfNeeded(((ComplexExp)lExp2).getRealPart(), lExp1.getType()));
        }
        if (lExp2.getType() == this.fTypeUtil.getBoolType()) {
            return this.hir.assignStmt(lExp1, this.makeBooleanExp(lExp2));
        }
        return this.hir.assignStmt(lExp1, this.castIfNeeded(lExp2, lExp1.getType()));
    }

    public Exp makeBooleanExp(Exp e) {
        int op = e.getOperator();
        if (op == 51 || op == 54 || op == 53 || op == 56 || op == 55 || op == 52) {
            ExecStmtManager esmgr = this.fHir.getExecStmtManager();
            Var v = this.sym.defineVar(esmgr.getTempName("booleantemp"), this.fTypeUtil.getBoolType());
            esmgr.currentStmt.addGeneratedStmt(this.makeIfStmt(e, this.hir.assignStmt(this.hir.varNode(v), this.makeTrueConstNode()), this.hir.assignStmt(this.hir.varNode(v), this.makeFalseConstNode())));
            return this.hir.varNode(v);
        }
        return e;
    }

    public Stmt makeCharacterAssignStmt(Exp e1, Exp e2, Exp l1, Exp l2) {
        Exp s_copy = this.makeSubpNode("s_copy", 268, this.hir.irList(), 1);
        this.dp("CharacterAssign: " + e1 + " = " + e2);
        IrList args = this.hir.irList();
        args.add(e1);
        args.add(e2);
        args.add(l1);
        args.add(l2);
        return this.hir.callStmt(s_copy, args);
    }

    public Exp makeSubpNode(String pSubpName, int pType, IrList pParamList, int visibility) {
        Type returnType = this.fTypeUtil.getType(pType);
        Subp lSubp = this.sym.defineSubp(pSubpName.intern(), returnType);
        lSubp.setVisibility(2);
        lSubp.closeSubpHeader();
        return this.makeSubpExp(lSubp);
    }

    public Exp makeSubpExp(Subp subp) {
        return this.hir.exp(64, this.hir.subpNode(subp));
    }

    public Exp convToDouble(Exp pExp) {
        Type type = pExp.getType();
        if (type.getTypeKind() == 17) {
            return pExp;
        }
        return this.hir.convExp(this.symRoot.typeDouble, pExp);
    }

    Stmt qassign(Var var, String ident, Exp exp) {
        ElemNode elem = this.hir.elemNode(this.fTypeUtil.searchElem(ident, var.getSymType()));
        if (elem == null) {
            this.fHir.printMsgFatal("no elem: " + ident);
        }
        return this.makeAssignStmt(this.hir.qualifiedExp(this.hir.varNode(var), elem), exp);
    }

    Exp castToInteger(Exp exp) {
        this.dp("--" + exp);
        Type type = exp.getType();
        if (exp instanceof ComplexExp) {
            ComplexExp cexp = (ComplexExp)exp;
            return this.hir.convExp(this.fTypeUtil.getIntType(), cexp.getRealPart());
        }
        if (!type.isInteger()) {
            return this.hir.convExp(this.fTypeUtil.getIntType(), exp);
        }
        return exp;
    }

    Type checkTwoExpType(Exp arg1, Exp arg2) {
        Type t1 = arg1.getType();
        Type t2 = arg2.getType();
        Type check = this.fTypeUtil.getDoubleType();
        if (t1 == check || t2 == check) {
            return check;
        }
        check = this.fTypeUtil.getRealType();
        if (t1 == check || t2 == check) {
            return check;
        }
        check = this.fTypeUtil.getIntType();
        if (t1 == check && t2 == check) {
            return check;
        }
        this.dp("unreachable");
        return null;
    }

    Exp castIfNeeded(Exp exp, Type type) {
        if (type == exp.getType()) {
            return exp;
        }
        return this.hir.convExp(type, exp);
    }

    Exp makeTyped0Node(Type type) {
        Exp exp = this.makeConstInt0Node();
        if (type == this.fTypeUtil.getIntType()) {
            return exp;
        }
        return this.castIfNeeded(exp, type);
    }

    void dp(String msg) {
        this.fHir.dp(msg);
    }

    Stmt makeIfStmt(Exp cond, Stmt thenStmt, Stmt elseStmt) {
        int op = cond.getOperator();
        if (op == 46) {
            BlockStmt elseBlock = this.hir.blockStmt(null);
            Label label = this.fHir.getExecStmtManager().makeNewLabel("if_elseBlock_label_");
            elseBlock.addLastStmt(this.hir.labeledStmt(label, null));
            elseBlock.addLastStmt(elseStmt);
            return this.makeIfStmt(cond.getExp1(), this.makeIfStmt(cond.getExp2(), thenStmt, this.hir.jumpStmt(label)), elseBlock);
        }
        if (op == 47) {
            BlockStmt thenBlock = this.hir.blockStmt(null);
            BlockStmt elseBlock = this.hir.blockStmt(null);
            Label label = this.fHir.getExecStmtManager().makeNewLabel("if_thenBlock_label_");
            thenBlock.addLastStmt(this.hir.labeledStmt(label, null));
            thenBlock.addLastStmt(thenStmt);
            elseBlock.addLastStmt(this.makeIfStmt(cond.getExp2(), this.hir.jumpStmt(label), null));
            elseBlock.addLastStmt(elseStmt);
            return this.makeIfStmt(cond.getExp1(), thenBlock, elseBlock);
        }
        if (op == 52 || op == 51 || op == 53 || op == 54 || op == 55 || op == 56) {
            return this.hir.ifStmt(cond, thenStmt, elseStmt);
        }
        if (op == 48) {
            Exp e2 = cond.getExp2();
            if (e2 instanceof ConstNode) {
                ConstNode ce2 = (ConstNode)e2;
                if (ce2.getIntValue() == 1) {
                    return this.makeIfStmt(cond.getExp1(), elseStmt, thenStmt);
                }
                if (ce2.getIntValue() == 0) {
                    return this.makeIfStmt(cond.getExp1(), thenStmt, elseStmt);
                }
                return null;
            }
            return this.hir.ifStmt(this.hir.exp(52, cond, this.makeConstInt0Node()), thenStmt, elseStmt);
        }
        return this.hir.ifStmt(this.hir.exp(52, cond, this.makeConstInt0Node()), thenStmt, elseStmt);
    }
}

