/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.ComputedGoto;
import coins.ffront.EntryStmt;
import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.Pair;
import coins.ffront.Token;
import coins.sym.Var;

public class HeaderStmt
extends FStmt {
    private Token fIdent;
    private String originalIdString = null;
    private FirList fArgs;
    private boolean isFunction;
    private Pair fType;
    private int numberOfStar;
    private Var returnVar;
    private Token returnVarToken;
    private Token firstIntArg;

    public HeaderStmt(Token pIdent, FirList pArgs, boolean isF, Pair pType, int line, FirToHir pfHir) {
        super(line, pfHir);
        this.fIdent = pIdent;
        this.fArgs = pArgs;
        this.isFunction = isF;
        this.fType = pType;
        this.numberOfStar = 0;
        this.returnVar = null;
    }

    public void print(int level, String spaces) {
        super.print(level, spaces);
        this.fHir.debugPrint(level, spaces + "HeaderStmt" + this.fIdent + "\n");
    }

    public String toString() {
        return super.toString() + "Header statement" + this.fIdent;
    }

    public void addEntryStmt(FirList entryList) {
        EntryStmt headEntry = new EntryStmt(this.fIdent.copy(), this.fArgs, this.fLine, this.fHir);
        entryList.addFirst(headEntry);
        this.fHir.f7Hir.addFirstStmt(headEntry);
        this.fArgs = (FirList)this.fArgs.clone();
        this.firstIntArg = new Token(0, "i_".intern(), 261, this.fHir);
        this.fArgs.addFirst(this.firstIntArg);
    }

    public void change(FirList pArgs, FirList entryStmtList) {
        this.originalIdString = this.fIdent.getLexem();
        this.fIdent.changeLexem();
        this.fArgs = pArgs;
        FirList labelList = new FirList(this.fHir);
        for (EntryStmt entryStmt : entryStmtList) {
            labelList.addLast(entryStmt.getIdentToken());
        }
        ComputedGoto cGoto = new ComputedGoto(labelList, this.firstIntArg, this.fLine, this.fHir);
        this.fHir.f7Hir.addFirstStmt(cGoto);
    }

    public void changeToSubprogram() {
        this.isFunction = false;
        this.originalIdString = this.fIdent.getLexem();
        this.fIdent.changeLexem();
        Token newParam = new Token(0, this.originalIdString, 261, this.fHir);
        this.fArgs.addFirst(newParam);
        if (this.fType != null) {
            FirList typedDeclList = this.fHir.f7Sym.typedDeclList;
            typedDeclList.addLast(new Pair(this.fType, new FirList(new Pair(newParam, null, this.fHir), this.fHir), this.fHir));
        }
    }

    public String getReturnVarString() {
        if (this.returnVarToken == null) {
            this.getReturnVarToken();
        }
        return this.returnVarToken.getLexem();
    }

    public Token getReturnVarToken() {
        if (this.returnVarToken == null) {
            this.returnVarToken = new Token(0, ("_" + this.fIdent.getLexem()).intern(), 261, this.fHir);
        }
        return this.returnVarToken;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public Pair getTypePair() {
        return this.fType;
    }

    public String getLexem() {
        return this.fIdent.getLexem();
    }

    public Token getIdToken() {
        return this.fIdent;
    }

    public FirList getArgs() {
        return this.fArgs;
    }

    public void setStar(int pInt) {
        this.numberOfStar = pInt;
    }

    public int getStar() {
        return this.numberOfStar;
    }

    public void setReturnVar(Var pVar) {
        this.returnVar = pVar;
    }

    public Var getReturnVar() {
        return this.returnVar;
    }

    public String getOriginalIdString() {
        return this.originalIdString;
    }

    public void process() {
        this.stmt = null;
        super.process();
    }
}

