/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.BaseManager;
import coins.ffront.ComplexExp;
import coins.ffront.DeclManager;
import coins.ffront.DoubleComplexExp;
import coins.ffront.FNumber;
import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.HasConstValue;
import coins.ffront.Node;
import coins.ffront.Pair;
import coins.ffront.Token;
import coins.ffront.TypeUtility;
import coins.ir.hir.Exp;
import coins.sym.Type;
import java.util.HashMap;

public class ConstManager
extends BaseManager {
    HashMap CurrentParameterMap;
    DeclManager fDeclMgr;
    TypeUtility fTypeUtil;

    public ConstManager(FirToHir fth, DeclManager dmgr) {
        super(fth);
        this.fDeclMgr = dmgr;
        this.fTypeUtil = this.fHir.getTypeUtility();
        this.CurrentParameterMap = new HashMap();
    }

    void processParameterDeclStatement(FirList list) {
        for (Pair p : list) {
            Token ident = (Token)p.getLeft();
            Node value = p.getRight();
            String name = ident.getLexem();
            Type type = this.fDeclMgr.getSymbolType(name);
            if (this.isConstName(name)) {
                this.printMsgFatal("[Parameter] This symbol is already declared as parameter: " + name);
            }
            if (this.fDeclMgr.isDefinedSymbol(name)) {
                this.dp("- parameter: delete from symbol table: " + name);
                this.fDeclMgr.deleteFromSymbolTable(name);
            }
            this.dp("Parameter(" + name + " = " + value + " as " + type + ")");
            this.CurrentParameterMap.put(name, new ParameterObject(name, value, type, this.fHir));
        }
    }

    FNumber getConstValue(Token name) {
        return this.getConstValue(name.getLexem());
    }

    FNumber getConstValue(String name) {
        if (this.CurrentParameterMap == null) {
            return null;
        }
        ParameterObject po = (ParameterObject)this.CurrentParameterMap.get(name);
        if (po != null) {
            return po.getConstValue();
        }
        return null;
    }

    Exp getConstExp(String name) {
        if (this.CurrentParameterMap == null) {
            return null;
        }
        ParameterObject po = (ParameterObject)this.CurrentParameterMap.get(name);
        if (po != null) {
            return po.makeExp();
        }
        return null;
    }

    Exp getConstArgAddr(String name, FStmt stmt) {
        if (this.CurrentParameterMap == null) {
            return null;
        }
        ParameterObject po = (ParameterObject)this.CurrentParameterMap.get(name);
        if (po != null) {
            return po.makeArgAddr(stmt);
        }
        return null;
    }

    boolean setParameterType(String name, Type t) {
        ParameterObject po = (ParameterObject)this.CurrentParameterMap.get(name);
        if (po != null) {
            po.setType(t);
            return true;
        }
        return false;
    }

    boolean isConstName(String name) {
        return this.CurrentParameterMap.get(name) != null;
    }

    class ParameterObject {
        String name_;
        Node node_;
        Type type_;
        FirToHir fHir;

        public ParameterObject(String name, Node n, Type t, FirToHir fth) {
            this.name_ = name;
            this.node_ = n;
            this.type_ = t;
            this.fHir = fth;
        }

        FNumber getConstValue() {
            FNumber n = ((HasConstValue)((Object)this.node_)).getConstValue();
            if (this.type_.isInteger()) {
                return FNumber.make(n.intValue());
            }
            if (this.type_.isFloating()) {
                return FNumber.make(n.doubleValue());
            }
            if (ConstManager.this.fTypeUtil.isComplexType(this.type_)) {
                // empty if block
            }
            this.fHir.printMsgFatal("unkown parameter: ??");
            return null;
        }

        Exp makeExp() {
            Exp e = this.node_.makeExp();
            Type t = e.getType();
            if (!(t == this.type_ || ConstManager.this.fTypeUtil.isComplexType(t) && ConstManager.this.fTypeUtil.isComplexType(this.type_))) {
                if (ConstManager.this.fTypeUtil.isComplexType(this.type_)) {
                    return new ComplexExp(e, ConstManager.this.fHirUtil.makeConstReal0Node(), this.fHir);
                }
                if (ConstManager.this.fTypeUtil.isComplexType(t)) {
                    if (this.type_.isFloating()) {
                        return ((ComplexExp)e).getRealPart();
                    }
                    return ConstManager.this.hir.convExp(this.type_, e);
                }
                return ConstManager.this.hir.convExp(this.type_, e);
            }
            if (ConstManager.this.fTypeUtil.isDoubleComplexType(this.type_)) {
                ComplexExp ce = (ComplexExp)e;
                return new DoubleComplexExp(ce.getRealPart(), ce.getImagPart(), this.fHir);
            }
            return e;
        }

        Exp makeArgAddr(FStmt stmt) {
            Exp e = this.node_.makeExp();
            Type t = e.getType();
            if (t != this.type_) {
                return ConstManager.this.fHirUtil.makeArgAddr(stmt, this.makeExp());
            }
            return this.node_.makeArgAddr(stmt);
        }

        void setType(Type t) {
            this.type_ = t;
        }
    }
}

