/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.DeclManager;
import coins.ffront.ExecStmtManager;
import coins.ffront.FNumber;
import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.FortranCharacterExp;
import coins.ffront.HasConstValue;
import coins.ffront.HirUtility;
import coins.ffront.Node;
import coins.ffront.Pair;
import coins.ffront.SubstringNode;
import coins.ffront.TypeUtility;
import coins.ir.IrList;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.Stmt;
import coins.ir.hir.VarNode;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.Iterator;

public class ConcatNode
extends Pair
implements HasConstValue {
    HirUtility fHirUtil;
    TypeUtility fTypeMgr;
    DeclManager fDeclMgr;
    ExecStmtManager fESMgr;
    HIR hir;
    Sym sym;
    Exp func_;
    Exp evp;
    Exp evl;
    int length_;
    int size_;

    public ConcatNode(Node left, Node right, FirToHir pfHir) {
        super(left, right, pfHir);
    }

    public void print(int level, String spaces) {
        this.fHir.debugPrint(level, spaces + "<concat:" + " " + this.left + " // " + this.right + ">\n");
        super.print(level, spaces);
    }

    public String toString() {
        return "ConcatExp";
    }

    FirList get_concatenatee() {
        FirList concatenatee_list = new FirList(this.fHir);
        this.traverse_concatenatee(concatenatee_list, this.left);
        this.traverse_concatenatee(concatenatee_list, this.right);
        return concatenatee_list;
    }

    void traverse_concatenatee(FirList list, Node target) {
        if (target instanceof ConcatNode) {
            ConcatNode ce = (ConcatNode)target;
            this.traverse_concatenatee(list, ce.getLeft());
            this.traverse_concatenatee(list, ce.getRight());
        } else {
            list.add(target);
        }
    }

    void prepare() {
        this.hir = this.fHir.getHir();
        this.sym = this.fHir.getSym();
        this.fHirUtil = this.fHir.getHirUtility();
        this.fDeclMgr = this.fHir.getDeclManager();
        this.fESMgr = this.fHir.getExecStmtManager();
        this.fTypeMgr = this.fHir.getTypeUtility();
        this.fHir.dp("ConcatExp#makeExp: " + this.left + " // " + this.right);
        FirList concatenatee_list = this.get_concatenatee();
        int size = concatenatee_list.size();
        String name = this.fESMgr.getTempName() + "_vec_ptr_";
        VectorType type = this.sym.vectorType((Type)this.sym.pointerType(this.fTypeMgr.getCharType()), size);
        Var vec_ptr = this.sym.defineVar(name.intern(), type);
        name = this.fESMgr.getTempName() + "_vec_len_";
        type = this.sym.vectorType(this.fTypeMgr.getIntType(), size);
        Var vec_len = this.sym.defineVar(name.intern(), type);
        Iterator it = concatenatee_list.iterator();
        this.evp = this.hir.varNode(vec_ptr);
        this.evl = this.hir.varNode(vec_len);
        int length = 0;
        int i = 0;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            FortranCharacterExp e = (FortranCharacterExp)n.makeExp();
            this.fESMgr.addStmt(this.hir.assignStmt(this.hir.subscriptedExp(this.evp, this.fHirUtil.makeIntConstNode(i)), e.getBody()));
            Exp e_len = e.getLength();
            this.fESMgr.addStmt(this.hir.assignStmt(this.hir.subscriptedExp(this.evl, this.fHirUtil.makeIntConstNode(i)), e_len));
            length += e_len.evaluateAsInt();
            ++i;
        }
        this.func_ = this.fHirUtil.makeSubpNode("s_cat", 268, this.hir.irList(), 1);
        this.length_ = length;
        this.size_ = size;
    }

    public Exp makeExp() {
        this.prepare();
        String name = this.fESMgr.getTempName() + "_concat_dst_";
        Var vt = this.sym.defineVar(name.intern(), this.sym.vectorType(this.fTypeMgr.getCharType(), this.length_));
        VarNode et = this.hir.varNode(vt);
        IrList args = this.hir.irList();
        args.add(et);
        args.add(this.evp);
        args.add(this.evl);
        args.add(this.fHirUtil.makeArgAddr(this.fESMgr.getCurrentStmt(), this.fHirUtil.makeIntConstNode(this.size_)));
        args.add(this.fHirUtil.makeIntConstNode(this.length_));
        this.fESMgr.addStmt(this.hir.callStmt(this.func_, args));
        return et;
    }

    public Exp makeArgAddr(FStmt pCallStmt) {
        return this.makeExp();
    }

    public Stmt assignWithConcatString(Node dstnode) {
        Exp dstsize;
        Exp dstarg;
        this.prepare();
        IrList args = this.hir.irList();
        if (dstnode instanceof SubstringNode) {
            FortranCharacterExp dst = (FortranCharacterExp)dstnode.makeExp();
            dstarg = this.hir.exp(64, dst.getBody());
            dstsize = dst.getLength();
        } else {
            FortranCharacterExp dst = (FortranCharacterExp)dstnode.makeExp();
            dstarg = dstnode.makeArgAddr(this.fESMgr.getCurrentStmt());
            dstsize = dst.getLength();
        }
        args.add(dstarg);
        args.add(this.evp);
        args.add(this.evl);
        args.add(this.fHirUtil.makeArgAddr(this.fESMgr.getCurrentStmt(), this.fHirUtil.makeIntConstNode(this.size_)));
        args.add(dstsize);
        return this.hir.callStmt(this.func_, args);
    }

    public FNumber getConstValue() {
        return null;
    }

    void dp(String msg) {
        this.fHir.dp(msg);
    }
}

