/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.Node;
import coins.ffront.Token;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.HirSeq;
import coins.ir.hir.Stmt;
import coins.sym.Label;

public class ComputedGoto
extends FStmt {
    private FirList fLabels;
    private Node fExp;

    public ComputedGoto(FirList pLabels, Node pExp, int line, FirToHir pfHir) {
        super(line, pfHir);
        this.fLabels = pLabels;
        this.fExp = pExp;
    }

    public ComputedGoto(int line, FirToHir pfHir) {
        super(line, pfHir);
        this.fLabels = null;
        this.fExp = null;
    }

    public void print(int level, String spaces) {
        super.print(level, spaces);
        this.fHir.debugPrint(level, spaces + " ComputedGoto " + this.fExp + "\n");
    }

    public String toString() {
        return super.toString() + " ComputedGoto statement ";
    }

    public void process() {
        this.stmt = this.makeSwitchStmt(this.fExp.makeExp(), this.fLabels);
        super.process();
    }

    public Stmt makeSwitchStmt(Exp pExp, FirList pLabels) {
        this.fESMgr = this.fHir.getExecStmtManager();
        IrList jumpList = this.hir.irList();
        BlockStmt switchBlock = this.hir.blockStmt(null);
        if (pLabels == null) {
            this.fHir.printMsgRecovered("Computed Goto without labels");
            return null;
        }
        int counter = 1;
        for (Token labelToken : pLabels) {
            Label gotoLabel = this.fESMgr.makeLabel(labelToken.getLexem());
            Label switchLabel = this.fESMgr.makeNewLabel();
            HirSeq pair = this.hir.hirSeq(this.fHirUtil.makeIntConstNode(counter++), this.hir.labelNode(switchLabel));
            jumpList.add(pair);
            switchBlock.addLastStmt(this.hir.labeledStmt(switchLabel, null));
            switchBlock.addLastStmt(this.hir.jumpStmt(gotoLabel));
        }
        return this.hir.switchStmt(pExp, jumpList, null, switchBlock, this.fESMgr.makeNewLabel());
    }
}

