/*
 * Decompiled with CFR 0.152.
 */
package coins.drivergen.process;

import coins.PassException;
import coins.drivergen.InputIr;
import coins.drivergen.Options;
import coins.drivergen.ProcessException;
import coins.drivergen.process.GenerateCode;
import coins.drivergen.process.MakeHirFromSource;
import coins.drivergen.process.MakeNewLirFromHir;
import coins.drivergen.process.Navigator;
import java.io.IOException;
import java.util.HashMap;

public class ProcessManager {
    private HashMap processMap = new HashMap();
    private InputIr ir;
    private Options op;

    public ProcessManager() {
        this.registProcess(MakeHirFromSource.navi);
        this.registProcess(MakeNewLirFromHir.navi);
        this.registProcess(GenerateCode.navi);
    }

    private void registProcess(Navigator p) {
        if (p != null) {
            this.setProcess(p.name(), p);
        }
    }

    public void setProcess(String name, Navigator p) {
        this.processMap.put(name, p);
    }

    public Navigator getProcess(String name) {
        return (Navigator)this.processMap.get(name);
    }

    public void init(InputIr ir, Options op) {
        this.ir = ir;
        this.op = op;
    }

    public void go(String[] procName) throws ProcessException, PassException, IOException {
        for (int i = 0; i < procName.length; ++i) {
            Navigator navi = null;
            navi = this.getProcess(procName[i]);
            if (navi == null) {
                throw new PassException(procName[i], "can't find the process");
            }
            navi.go(this.ir, this.op);
        }
    }
}

