/*
 * Decompiled with CFR 0.152.
 */
package coins.driver;

import coins.IoRoot;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class Warning {
    private static final String ALL = "all";
    private static final String NEGATIVE = "no-";
    private static final String fMessageHeader = "Warning";
    private final Map fWarningTable;
    private boolean fWarningAll = false;
    private IoRoot fIoRoot;

    private Map parseArgument(List pArguments) {
        Hashtable<String, Boolean> lTable = new Hashtable<String, Boolean>();
        for (String lArg : pArguments) {
            if (lArg.equals(ALL)) {
                this.fWarningAll = true;
                continue;
            }
            if (lArg.startsWith(NEGATIVE)) {
                lTable.put(lArg.substring(NEGATIVE.length()), new Boolean(false));
                continue;
            }
            lTable.put(lArg, new Boolean(true));
        }
        return lTable;
    }

    public Warning() {
        this(new ArrayList());
    }

    public Warning(IoRoot pIo) {
        this(new ArrayList(), pIo);
    }

    public Warning(List warningArguments) {
        this.fWarningTable = this.parseArgument(warningArguments);
    }

    public Warning(List warningArguments, IoRoot pIo) {
        this.fIoRoot = pIo;
        this.fWarningTable = this.parseArgument(warningArguments);
    }

    public synchronized boolean getGenericWarningFlag() {
        return this.fWarningAll;
    }

    public synchronized boolean setGenericWarningFlag(boolean newValue) {
        boolean oldValue = this.fWarningAll;
        this.fWarningAll = newValue;
        return oldValue;
    }

    public synchronized Boolean getWarningFlag(String category) {
        return (Boolean)this.fWarningTable.get(category);
    }

    public synchronized Boolean setWarningFlag(String category, boolean newFlag) {
        return this.fWarningTable.put(category, new Boolean(newFlag));
    }

    public synchronized boolean shouldWarn() {
        return this.fWarningAll;
    }

    public synchronized boolean shouldWarn(String category) {
        if (this.fWarningTable.containsKey(category)) {
            return (Boolean)this.fWarningTable.get(category);
        }
        return this.shouldWarn();
    }

    private void putMessage(String message) {
        if (this.fIoRoot == null) {
            System.out.println("Warning: " + message);
        } else {
            this.fIoRoot.msgWarning.put(message);
        }
    }

    private void putMessage(int warningNumber, String message) {
        if (this.fIoRoot == null) {
            System.out.println("Warning: " + message);
        } else {
            this.fIoRoot.msgWarning.put(warningNumber, message);
        }
    }

    public synchronized void setIoRoot(IoRoot pIo) {
        this.fIoRoot = pIo;
    }

    public synchronized void warning(String message) {
        if (this.shouldWarn()) {
            this.putMessage(message);
        }
    }

    public synchronized void warning(int warningNumber, String message) {
        if (this.shouldWarn()) {
            this.putMessage(warningNumber, message);
        }
    }

    public synchronized void warning(String category, String message) {
        if (this.shouldWarn(category)) {
            this.putMessage(message);
        }
    }

    public synchronized void warning(int warningNumber, String category, String message) {
        if (this.shouldWarn(category)) {
            this.putMessage(warningNumber, message);
        }
    }
}

