/*
 * Decompiled with CFR 0.152.
 */
package coins.driver;

import coins.IoRoot;
import coins.PassException;
import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.CompileStatus;
import coins.driver.CompilerImplementation;
import coins.driver.PassStopException;
import coins.driver.StopWatch;
import coins.driver.StreamCopier;
import coins.driver.Suffix;
import coins.driver.SuffixFactory;
import coins.driver.TemporaryFileManager;
import coins.driver.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class CompileThread
extends Thread {
    private static final File DEFAULT_OUTPUT_FILE = new File("a.out");
    private static final int IO_BUFFER_SIZE = 4096;
    private String myName = "Driver";
    String fSourceFileName;
    boolean fIsLinkerThread;
    TemporaryFileManager fTemporaryFileManager;
    CompilerImplementation fImplementation;
    CompileSpecification fSpec;
    IoRoot fIoRoot;
    CompileStatus fStatus;
    Map fThreadLocalVariables;
    StopWatch fClock;

    CompileThread(String pSourceFileName, CompileSpecification pSpec, TemporaryFileManager pTemporaryFileManager, CompilerImplementation pImplementation, CompileStatus pStatus, boolean pIsLinkerThread) {
        this.fSourceFileName = pSourceFileName;
        this.fIsLinkerThread = pIsLinkerThread;
        this.fSpec = pSpec;
        this.fTemporaryFileManager = pTemporaryFileManager;
        this.fImplementation = pImplementation;
        this.fStatus = pStatus;
        this.fThreadLocalVariables = new HashMap();
        this.fClock = new StopWatch();
    }

    public IoRoot getIoRoot() {
        return this.fIoRoot;
    }

    public int getExitStatus() {
        return this.fStatus.getExitStatus();
    }

    public void setABEND() {
        this.fStatus.setABEND();
    }

    public void setExitStatus(int s) {
        this.fStatus.setExitStatus(s);
    }

    public synchronized boolean isDefinedThreadLocalVariable(String varName) {
        return this.fThreadLocalVariables.containsKey(varName);
    }

    public synchronized Object getThreadLocalVariableValue(String varName) {
        return this.fThreadLocalVariables.get(varName);
    }

    public synchronized Object setThreadLocalVariableValue(String varName, Object value) {
        return this.fThreadLocalVariables.put(varName, value);
    }

    public synchronized Object removeThreadLocalVariable(String varName) {
        return this.fThreadLocalVariables.remove(varName);
    }

    public long elapsedTime() {
        return this.fClock.read();
    }

    public File createTemporaryFile() throws IOException {
        return this.fTemporaryFileManager.createTemporaryFile();
    }

    private void doPreprocess(File pSourceFile, Suffix pSuffix, InputStream pIn, OutputStream pOut, CompilerImplementation pImplementation, IoRoot pIo) throws IOException, PassException {
        pImplementation.preprocess(pSourceFile, pSuffix, pOut, pIo);
    }

    private void doCompile(File pSourceFile, Suffix pSuffix, InputStream pIn, OutputStream pOut, CompilerImplementation pImplementation, IoRoot pIo) throws IOException, PassException {
        pImplementation.compile(pSourceFile, pSuffix, pIn, pOut, pIo);
    }

    private void doAssemble(File pSourceFile, Suffix pSuffix, InputStream pIn, File pOut, CompilerImplementation pImplementation, IoRoot pIo) throws IOException, PassException {
        this.fSpec.getTrace().trace("Driver", 5000, "doAssemble");
        pImplementation.assemble(pSourceFile, pSuffix, pIn, pOut, pIo);
    }

    private void doLink(File pOut, CompilerImplementation pImplementation, IoRoot pIo) throws IOException, PassException {
        pImplementation.link(pOut, pIo);
    }

    private void errorCheck(IoRoot io, String passName, CompileStatus status) throws PassException {
        io.msgWarning.resetMessageCountOfThisClass();
        if (io.msgRecovered.getMessageCountOfThisClass() > 0) {
            io.msgRecovered.resetMessageCountOfThisClass();
            status.setABEND();
        }
        if (io.msgError.getMessageCountOfThisClass() > 0) {
            io.msgError.resetMessageCountOfThisClass();
            status.setABEND();
            throw new PassException(io.getSourceFile(), passName, "compilation stopped due to compile error(s)");
        }
    }

    public void storeToFile(InputStream in, File dest) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        FileOutputStream lOut = new FileOutputStream(dest);
        while ((len = in.read(buffer)) > 0) {
            ((OutputStream)lOut).write(buffer, 0, len);
        }
        ((OutputStream)lOut).close();
    }

    private InputStream callPassGroup(PassGroup pPassGroup, File pSourceFile, InputStream pIn) throws PassException {
        if (!pPassGroup.isSkipped()) {
            try {
                if (pPassGroup.isRequired()) {
                    if (pIn == null && pSourceFile != null) {
                        pIn = new FileInputStream(pSourceFile);
                    }
                    if (pPassGroup.isStopHere()) {
                        File lDest = pPassGroup.outputFile();
                        this.fSpec.getTrace().trace("Driver", 5000, "output file = " + lDest.getName());
                        pPassGroup.go(this, pIn, lDest, this.fIoRoot);
                        pIn = null;
                    } else if (this.fSpec.isSet("-pipe")) {
                        ByteArrayOutputStream lOut = new ByteArrayOutputStream();
                        pPassGroup.go(this, pIn, lOut, this.fIoRoot);
                        byte[] buffer = lOut.toByteArray();
                        lOut.close();
                        pIn = new ByteArrayInputStream(buffer);
                    } else {
                        File lTemp = this.createTemporaryFile();
                        this.fSpec.getTrace().trace("Driver", 5000, "temporary file = " + lTemp.getPath());
                        pPassGroup.go(this, pIn, lTemp, this.fIoRoot);
                        pIn = new FileInputStream(lTemp);
                    }
                    this.errorCheck(this.fIoRoot, pPassGroup.getName(), this.fStatus);
                } else if (pPassGroup.isStopHere()) {
                    if (pIn == null) {
                        pPassGroup.setOutputFile(pSourceFile);
                    } else {
                        File lDest = pPassGroup.outputFile();
                        this.storeToFile(pIn, lDest);
                        pIn = null;
                    }
                }
            }
            catch (IOException lIOException) {
                String lMessage = lIOException.getMessage();
                this.fIoRoot.msgError.put(lMessage);
                if (pSourceFile == null) {
                    throw new PassException(this.myName, lMessage);
                }
                throw new PassException(pSourceFile, this.myName, lMessage);
            }
        }
        return pIn;
    }

    public void run() {
        this.fClock.start();
        Trace lTrace = this.fSpec.getTrace();
        CoinsOptions lCoinsOptions = this.fSpec.getCoinsOptions();
        String lArch = lCoinsOptions.getArg("target");
        try {
            if (this.fIsLinkerThread) {
                String lLanguageName = SuffixFactory.getSuffix("o", null).getLanguageName();
                this.fIoRoot = new IoRoot(new File(""), System.out, System.out, System.err, this.fSpec, lArch, lLanguageName);
                lTrace.trace("Driver", 5000, "new IoRoot for linker thread, target=" + lArch + ", language=" + lLanguageName);
                this.fSpec.getWarning().setIoRoot(this.fIoRoot);
                this.callPassGroup(new Linker(), null, null);
            } else {
                lTrace.trace("Driver", 5000, "run(3)");
                File lSourceFile = new File(this.fSourceFileName);
                String lSufOption = lCoinsOptions.getArg("suffixoption");
                Suffix lSuffix = SuffixFactory.getSuffix(lSourceFile, lSufOption);
                String lLanguageName = lSuffix.getLanguageName();
                this.fIoRoot = new IoRoot(lSourceFile, System.out, System.out, System.err, this.fSpec, lArch, lLanguageName);
                lTrace.trace("Driver", 5000, "new IoRoot, target=" + lArch + ", language=" + lLanguageName);
                this.fSpec.getWarning().setIoRoot(this.fIoRoot);
                lTrace.trace("Driver", 5000, "run(4)");
                InputStream lIn = null;
                lIn = this.callPassGroup(new Preprocessor(lSourceFile), lSourceFile, lIn);
                lTrace.trace("Driver", 5000, "run(5)");
                lIn = this.callPassGroup(new Compiler(lSourceFile), lSourceFile, lIn);
                lTrace.trace("Driver", 5000, "run(6)");
                Assembler lAssembler = new Assembler(lSourceFile);
                this.callPassGroup(lAssembler, lSourceFile, lIn);
                lTrace.trace("Driver", 5000, "run(7)");
                this.fSpec.setObjectFile(this.fSourceFileName, lAssembler.outputFile().getPath());
            }
        }
        catch (PassStopException lPassStopException) {
            lTrace.trace("Driver", 5000, "PassStopException: " + lPassStopException.getMessage());
            this.fStatus.cancelLinking();
        }
        catch (PassException lPassException) {
            lTrace.trace("Driver", 5000, "PassException: " + lPassException.getMessage());
            this.fStatus.setABEND();
        }
        catch (RuntimeException lRuntimeException) {
            lTrace.trace("Driver", 5000, "RuntimeException: " + lRuntimeException.getMessage());
            this.fStatus.setABEND();
            throw lRuntimeException;
        }
        catch (Error lError) {
            lTrace.trace("Driver", 5000, "Error: " + lError.getMessage());
            this.fStatus.setABEND();
            throw lError;
        }
    }

    class Linker
    extends PassGroup {
        Linker() {
            super(new File("."));
            this.fName = "linker";
        }

        boolean isRequired() {
            return true;
        }

        Suffix outputSuffix() {
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isSkipped() {
            CompileSpecification cfr_ignored_0 = CompileThread.this.fSpec;
            if (CompileThread.this.fSpec.isSet("-E")) return true;
            CompileSpecification cfr_ignored_1 = CompileThread.this.fSpec;
            if (CompileThread.this.fSpec.isSet("-S")) return true;
            CompileSpecification cfr_ignored_2 = CompileThread.this.fSpec;
            if (!CompileThread.this.fSpec.isSet("-c")) return false;
            return true;
        }

        void go(CompileThread pThread, InputStream pIn, OutputStream pOut, IoRoot io) throws IOException, PassException {
            File lTempFile = CompileThread.this.createTemporaryFile();
            pThread.doLink(lTempFile, CompileThread.this.fImplementation, io);
            FileInputStream lIn = new FileInputStream(lTempFile);
            new StreamCopier(lIn, pOut).go();
            pOut.close();
        }

        void go(CompileThread pThread, InputStream pIn, File pOut, IoRoot io) throws IOException, PassException {
            pThread.doLink(pOut, CompileThread.this.fImplementation, io);
        }

        boolean isStopHere() {
            return true;
        }

        File outputFile() throws PassException {
            CompileSpecification cfr_ignored_0 = CompileThread.this.fSpec;
            if (CompileThread.this.fSpec.isSet("-o")) {
                CompileSpecification cfr_ignored_1 = CompileThread.this.fSpec;
                return new File((String)CompileThread.this.fSpec.getArg("-o"));
            }
            return DEFAULT_OUTPUT_FILE;
        }
    }

    class Assembler
    extends PassGroup {
        Assembler(File pSourceFile) {
            super(pSourceFile);
            this.fName = "assembler";
        }

        boolean isRequired() {
            return this.fSuffix.isAssembleRequired();
        }

        Suffix outputSuffix() {
            return this.fSuffix.afterAssemble();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isSkipped() {
            CompileSpecification cfr_ignored_0 = CompileThread.this.fSpec;
            if (CompileThread.this.fSpec.isSet("-E")) return true;
            CompileSpecification cfr_ignored_1 = CompileThread.this.fSpec;
            if (!CompileThread.this.fSpec.isSet("-S")) return false;
            return true;
        }

        void go(CompileThread pThread, InputStream pIn, OutputStream pOut, IoRoot io) throws IOException, PassException {
            File lTempFile = CompileThread.this.createTemporaryFile();
            pThread.doAssemble(this.fSourceFile, this.fSuffix, pIn, lTempFile, CompileThread.this.fImplementation, io);
            FileInputStream lIn = new FileInputStream(lTempFile);
            new StreamCopier(lIn, pOut).go();
            pOut.close();
        }

        void go(CompileThread pThread, InputStream pIn, File pOut, IoRoot io) throws IOException, PassException {
            pThread.doAssemble(this.fSourceFile, this.fSuffix, pIn, pOut, CompileThread.this.fImplementation, io);
        }

        boolean isStopHere() {
            return true;
        }

        File outputFile() throws PassException {
            if (this.fOutputFile == null) {
                CompileSpecification cfr_ignored_0 = CompileThread.this.fSpec;
                if (CompileThread.this.fSpec.isSet("-c")) {
                    CompileSpecification cfr_ignored_1 = CompileThread.this.fSpec;
                    if (CompileThread.this.fSpec.isSet("-o")) {
                        CompileSpecification cfr_ignored_2 = CompileThread.this.fSpec;
                        this.fOutputFile = new File((String)CompileThread.this.fSpec.getArg("-o"));
                    } else {
                        this.fOutputFile = this.changeSuffix(this.outputSuffix());
                    }
                } else {
                    try {
                        this.fOutputFile = CompileThread.this.createTemporaryFile();
                    }
                    catch (IOException lIOException) {
                        String lMessage = lIOException.getMessage();
                        throw new PassException(this.fSourceFile, "assembler", lMessage);
                    }
                }
            }
            return this.fOutputFile;
        }
    }

    class Compiler
    extends PassGroup {
        Compiler(File pSourceFile) {
            super(pSourceFile);
            this.fName = "compiler";
        }

        boolean isRequired() {
            return this.fSuffix.isCompileRequired();
        }

        Suffix outputSuffix() {
            return this.fSuffix.afterCompile();
        }

        boolean isSkipped() {
            CompileSpecification cfr_ignored_0 = CompileThread.this.fSpec;
            return CompileThread.this.fSpec.isSet("-E");
        }

        void go(CompileThread pThread, InputStream pIn, OutputStream pOut, IoRoot io) throws IOException, PassException {
            pThread.doCompile(this.fSourceFile, this.fSuffix, pIn, pOut, CompileThread.this.fImplementation, io);
        }

        boolean isStopHere() {
            CompileSpecification cfr_ignored_0 = CompileThread.this.fSpec;
            return CompileThread.this.fSpec.isSet("-S");
        }
    }

    class Preprocessor
    extends PassGroup {
        Preprocessor(File pSourceFile) {
            super(pSourceFile);
            this.fName = "preprocessor";
        }

        boolean isRequired() {
            return this.fSuffix.isPreprocessRequired();
        }

        Suffix outputSuffix() {
            return this.fSuffix.afterPreprocess();
        }

        boolean isSkipped() {
            return false;
        }

        void go(CompileThread pThread, InputStream pIn, OutputStream pOut, IoRoot io) throws IOException, PassException {
            pThread.doPreprocess(this.fSourceFile, this.fSuffix, pIn, pOut, CompileThread.this.fImplementation, io);
        }

        boolean isStopHere() {
            CompileSpecification cfr_ignored_0 = CompileThread.this.fSpec;
            return CompileThread.this.fSpec.isSet("-E");
        }
    }

    abstract class PassGroup {
        String fName;
        File fSourceFile;
        Suffix fSuffix;
        File fOutputFile = null;

        PassGroup(File pSourceFile) {
            this.fSourceFile = pSourceFile;
            CoinsOptions lCoinsOptions = CompileThread.this.fSpec.getCoinsOptions();
            String lSuffixOption = lCoinsOptions.getArg("suffixoption");
            this.fSuffix = SuffixFactory.getSuffix(pSourceFile, lSuffixOption);
        }

        String getName() {
            return this.fName;
        }

        abstract boolean isSkipped();

        abstract boolean isRequired();

        abstract boolean isStopHere();

        abstract Suffix outputSuffix();

        abstract void go(CompileThread var1, InputStream var2, OutputStream var3, IoRoot var4) throws IOException, PassException;

        void go(CompileThread pThread, InputStream pIn, File pOut, IoRoot io) throws IOException, PassException {
            FileOutputStream lOut = new FileOutputStream(pOut);
            try {
                this.go(pThread, pIn, lOut, io);
            }
            catch (IOException lIOException) {
                ((OutputStream)lOut).close();
                pOut.delete();
                throw lIOException;
            }
            catch (PassException lPassException) {
                ((OutputStream)lOut).close();
                pOut.delete();
                throw lPassException;
            }
            ((OutputStream)lOut).close();
        }

        File changeSuffix(Suffix pNewSuffix) {
            File parentFile = this.fSourceFile.getParentFile();
            String name = this.fSourceFile.getName();
            int index = name.lastIndexOf(46);
            String root = index == -1 ? name : name.substring(0, index);
            return new File(parentFile, root + '.' + pNewSuffix.toString());
        }

        File outputFile() throws PassException {
            if (this.fOutputFile == null) {
                CompileSpecification cfr_ignored_0 = CompileThread.this.fSpec;
                if (CompileThread.this.fSpec.isSet("-o")) {
                    CompileSpecification cfr_ignored_1 = CompileThread.this.fSpec;
                    return new File((String)CompileThread.this.fSpec.getArg("-o"));
                }
                return this.changeSuffix(this.outputSuffix());
            }
            return this.fOutputFile;
        }

        void setOutputFile(File pFile) {
            this.fOutputFile = pFile;
        }
    }
}

