/*
 * Decompiled with CFR 0.152.
 */
package coins.cfront;

import coins.cfront.Lex;

public class ParseError
extends Exception {
    private String fileName;
    private int lineNumber;
    private String reason;

    public ParseError(Lex l, String s) {
        super(l.getFileName() + ':' + l.getLineNumber());
        this.fileName = l.getFileName();
        this.lineNumber = l.getLineNumber();
        this.reason = s;
        l.ioRoot.addToTotalErrorCount(1);
    }

    public ParseError(Lex l, char c) {
        this(l, c + " is missing.");
        this.printMessage(l, c + " is missing.");
    }

    public ParseError(Lex l) {
        this(l, "syntax error");
        this.printMessage(l, "syntax error");
    }

    public ParseError(Lex l, String fname, int line, String s) {
        super(fname + ':' + line + ' ' + s);
        this.fileName = fname;
        this.lineNumber = line;
        this.reason = s;
        l.ioRoot.addToTotalErrorCount(1);
        this.printMessage(l, fname, line, s);
    }

    public ParseError badLvalue(String op) {
        this.reason = "invalid lvalue in " + op;
        return this;
    }

    public String getMessage() {
        return super.getMessage() + ' ' + this.reason;
    }

    private void printMessage(Lex pLex, String pString) {
        if (pLex.ioRoot.dbgControl.getLevel() > 0 || pLex.ioRoot.dbgParse.getLevel() > 0) {
            System.out.print("\n" + pLex.getFileName() + ":" + pLex.getLineNumber() + " " + pString);
        }
    }

    private void printMessage(Lex pLex, String pFile, int pLine, String pMessage) {
        if (pLex.ioRoot.dbgControl.getLevel() > 0 || pLex.ioRoot.dbgParse.getLevel() > 0) {
            System.out.print("\n" + pFile + ":" + pLine + " " + pMessage);
        }
    }
}

