/*
 * Decompiled with CFR 0.152.
 */
package coins.cfront;

import coins.Debug;
import coins.IoRoot;
import coins.Message;
import coins.ast.TokenId;
import coins.ast.TypeId;
import coins.cfront.KeywordTable;
import coins.cfront.Parser;
import coins.cfront.Token;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class Lex
implements TokenId,
TypeId {
    final IoRoot ioRoot;
    final Debug debug;
    final Message warning;
    final Message error;
    Parser parser;
    private int lastChar;
    private int lastTokenId;
    private InputStream input;
    private int lineNumber;
    private String fileName;
    private Token currentToken;
    private Token lookAheadTokens;
    private StringBuffer textBuffer;
    private static final KeywordTable ktable = new KeywordTable(40);
    public final int fDbgLevel;
    private static final int[] equalOps;

    public Lex(IoRoot ioroot, InputStream s) {
        this.ioRoot = ioroot;
        this.debug = ioroot.dbgParse;
        this.warning = ioroot.msgWarning;
        this.error = ioroot.msgError;
        this.lastChar = -1;
        this.lastTokenId = 10;
        this.input = s;
        this.lineNumber = 1;
        this.fileName = "unknown";
        this.currentToken = new Token();
        this.lookAheadTokens = null;
        this.textBuffer = new StringBuffer();
        this.fDbgLevel = ioroot.dbgParse.getLevel();
    }

    public int get() throws IOException {
        Token t;
        if (this.lookAheadTokens == null) {
            return this.get(this.currentToken);
        }
        this.currentToken = t = this.lookAheadTokens;
        this.lookAheadTokens = this.lookAheadTokens.next;
        if (this.fDbgLevel > 3) {
            this.debug.print(6, "lex.get", (char)t.tokenId + " " + t.tokenId + " " + this.getString() + " ");
        }
        return t.tokenId;
    }

    public int lookAhead() throws IOException {
        return this.lookAhead(0);
    }

    public int lookAhead(int i) throws IOException {
        Token tk = this.lookAheadTokens;
        if (tk == null) {
            this.lookAheadTokens = tk = this.currentToken;
            tk.next = null;
            this.get(tk);
        }
        while (i-- > 0) {
            if (tk.next == null) {
                Token tk2;
                tk.next = tk2 = new Token();
                this.get(tk2);
            }
            tk = tk.next;
        }
        this.currentToken = tk;
        if (this.parser.fDbgLevel > 3) {
            this.debug.print(6, "lookAhead", (char)tk.tokenId + " " + tk.tokenId + " " + this.getString() + " ");
        }
        return tk.tokenId;
    }

    public int getLineNumber() {
        return this.currentToken.lineNumber;
    }

    public String getFileName() {
        return this.currentToken.fileName;
    }

    public String getString() {
        return this.currentToken.textValue;
    }

    public long getLong() {
        return this.currentToken.longValue;
    }

    public double getDouble() {
        return this.currentToken.doubleValue;
    }

    public boolean isType(int pTokenId) {
        switch (pTokenId) {
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 409: {
                return true;
            }
        }
        return false;
    }

    public StringBuffer getTextBuffer() {
        return this.textBuffer;
    }

    private int get(Token token) throws IOException {
        int t;
        do {
            this.lastTokenId = t = this.readLine(token);
            if (t == 499) {
                t = 501;
                this.skipAsm();
                continue;
            }
            if (t != 300) continue;
            token.textValue = "asm";
        } while (t == 10 || t == 501);
        token.tokenId = t;
        token.lineNumber = this.lineNumber;
        token.fileName = this.fileName;
        if (this.parser.fDbgLevel > 3) {
            this.debug.print(6, "lex.get", (char)t + " " + t + " curr:" + this.currentToken.tokenId + " " + this.getString() + " ");
        }
        return t;
    }

    private void skipAsm() throws IOException {
        int c;
        while ((c = this.getc()) != -1 && c != 40) {
        }
        int i = 1;
        do {
            if ((c = this.getc()) == 40) {
                ++i;
                continue;
            }
            if (c == 41) {
                --i;
                continue;
            }
            if (c == -1) break;
        } while (i > 0);
    }

    private int readLine(Token token) throws IOException {
        int c = this.getNextNonWhiteChar();
        if (c < 0) {
            return c;
        }
        if (c == 10) {
            ++this.lineNumber;
            return 10;
        }
        if (c == 35 && this.lastTokenId == 10) {
            int lDirectiveValue = this.readLineDirective(token);
            if (lDirectiveValue == 413) {
                return 413;
            }
            return 10;
        }
        if (c == 39) {
            return this.readCharConst(token);
        }
        if (c == 34) {
            return this.readStringL(token);
        }
        if (48 <= c && c <= 57) {
            return this.readNumber(c, token);
        }
        if (c == 46) {
            c = this.getc();
            if (48 <= c && c <= 57) {
                StringBuffer tbuf = this.textBuffer;
                tbuf.setLength(0);
                tbuf.append('.');
                return this.readDouble(tbuf, c, token);
            }
            this.ungetc(c);
            return this.readSeparator(46);
        }
        if (c == 76) {
            int c2 = this.getc();
            if (c2 == 34) {
                return this.readStringWL(token);
            }
            this.ungetc(c2);
            return this.readIdentifier(c, token);
        }
        if (65 <= c && c <= 90 || 97 <= c && c <= 122 || c == 95 || c == 36) {
            return this.readIdentifier(c, token);
        }
        return this.readSeparator(c);
    }

    private int getNextNonWhiteChar() throws IOException {
        int c;
        block2: {
            while (true) {
                if (Lex.isBlank(c = this.getc())) {
                    continue;
                }
                if (c != 92) break block2;
                c = this.getc();
                if (c != 10 && c != 13) break;
            }
            this.ungetc(c);
        }
        return c;
    }

    private int readLineDirective(Token token) throws IOException {
        int c;
        int lReturnValue = 0;
        while (Lex.isBlank(c = this.getc())) {
        }
        if (Lex.isDigit(c)) {
            int num = c - 48;
            while (Lex.isDigit(c = this.getc())) {
                num = num * 10 + c - 48;
            }
            this.lineNumber = num - 1;
            while (Lex.isBlank(c)) {
                c = this.getc();
            }
            if (c == 34) {
                StringBuffer tbuf = this.textBuffer;
                tbuf.setLength(0);
                while ((c = this.getc()) != 34) {
                    tbuf.append((char)c);
                }
                this.fileName = tbuf.toString();
            }
        } else {
            StringBuffer tbuf = this.textBuffer;
            tbuf.setLength(0);
            tbuf.append((char)c);
            while ((c = this.getc()) != 10) {
                tbuf.append((char)c);
            }
            if (tbuf.indexOf("pragma") == 0) {
                String tokens = tbuf.substring(6).trim();
                token.textValue = tokens.intern();
                lReturnValue = 413;
                this.ungetc(c);
            }
        }
        while (c != 10) {
            c = this.getc();
        }
        ++this.lineNumber;
        return lReturnValue;
    }

    private int readCharConst(Token token) throws IOException {
        int c;
        int value = 0;
        while ((c = this.getc()) != 39) {
            if (c == 92) {
                value = this.readEscapeChar();
                continue;
            }
            if (c < 32) {
                if (c == 10) {
                    ++this.lineNumber;
                }
                return 500;
            }
            value = c;
        }
        token.longValue = value;
        return 401;
    }

    private int readEscapeChar() throws IOException {
        int c = this.getc();
        if (c == 110) {
            c = 10;
        } else if (c == 116) {
            c = 9;
        } else if (c == 114) {
            c = 13;
        } else if (c == 102) {
            c = 12;
        } else if (c == 10) {
            ++this.lineNumber;
        } else if (c == 98) {
            c = 8;
        } else if (c == 118) {
            c = 11;
        } else if (c == 97) {
            c = 7;
        } else if (c == 92) {
            c = 92;
        } else if (c == 39) {
            c = 39;
        } else if (c == 34) {
            c = 34;
        } else if (Character.isDigit((char)c) && c <= 55) {
            c = Character.digit((char)c, 8);
            int c1 = this.getc();
            if (Character.isDigit((char)c1) && c1 <= 55) {
                int c2 = this.getc();
                if (Character.isDigit((char)c2) && c2 <= 55) {
                    c = c * 64 + Character.digit((char)c1, 8) * 8 + Character.digit((char)c2, 8);
                } else {
                    this.ungetc(c2);
                    c = c * 8 + Character.digit((char)c1, 8);
                }
            } else {
                this.ungetc(c1);
            }
        } else if (c == 120) {
            int c1;
            int digit;
            c = 0;
            while (0 <= (digit = Character.digit((char)(c1 = this.getc()), 16))) {
                c = c * 16 + digit;
            }
            this.ungetc(c1);
        }
        return c;
    }

    private int readStringWL(Token token) throws IOException {
        int t = this.readStringL(token);
        if (t == 408) {
            return 410;
        }
        return t;
    }

    private int readStringL(Token token) throws IOException {
        int c;
        StringBuffer tbuf = this.textBuffer;
        tbuf.setLength(0);
        while (true) {
            if ((c = this.getc()) != 34) {
                if (c == 92) {
                    c = this.readEscapeChar();
                } else if (c == 10 || c < 0) {
                    ++this.lineNumber;
                    return 500;
                }
                tbuf.append((char)c);
                continue;
            }
            while (true) {
                if ((c = this.getc()) == 10) {
                    ++this.lineNumber;
                    continue;
                }
                if (!Lex.isBlank(c)) break;
            }
            if (c != 34) break;
        }
        this.ungetc(c);
        token.textValue = tbuf.toString().intern();
        return 408;
    }

    private int readNumber(int c, Token token) throws IOException {
        StringBuffer tbuf = this.textBuffer;
        tbuf.setLength(0);
        if (c == 48) {
            c = this.getc();
            if (c == 88 || c == 120) {
                c = this.readDigits(tbuf, 16);
                return this.readInteger(c, token, 16);
            }
            if (0 <= Character.digit((char)c, 8)) {
                c = this.readDigits(tbuf.append((char)c), 8);
                return this.readInteger(c, token, 8);
            }
            this.ungetc(c);
            c = 48;
        }
        if ((c = this.readDigits(tbuf.append((char)c), 10)) == 69 || c == 101 || c == 46) {
            return this.readDouble(tbuf, c, token);
        }
        return this.readInteger(c, token, 10);
    }

    private int readDigits(StringBuffer tbuf, int radix) throws IOException {
        int c;
        while (0 <= Character.digit((char)(c = this.getc()), radix)) {
            tbuf.append((char)c);
        }
        return c;
    }

    private int readInteger(int c, Token token, int radix) throws IOException {
        boolean signed = true;
        boolean unsigned = true;
        int nlong = 0;
        if (c == 85 || c == 117) {
            c = this.getc();
            signed = false;
            unsigned = true;
            if (c == 76 || c == 108) {
                c = this.getc();
                ++nlong;
                if (c == 76 || c == 108) {
                    c = this.getc();
                    ++nlong;
                }
            }
        } else if (c == 76 || c == 108) {
            c = this.getc();
            ++nlong;
            unsigned = true;
            if (c == 76 || c == 108) {
                c = this.getc();
                ++nlong;
                if (c == 85 || c == 117) {
                    c = this.getc();
                    signed = false;
                }
            } else if (c == 85 || c == 117) {
                c = this.getc();
                signed = false;
                if (c == 76 || c == 108) {
                    c = this.getc();
                    ++nlong;
                }
            }
        }
        this.ungetc(c);
        BigInteger big = new BigInteger(this.textBuffer.toString(), radix);
        int len = big.bitLength();
        token.longValue = big.longValue();
        if (signed && nlong <= 0 && len < 8 * this.parser.evaluator.toSize[105]) {
            return 402;
        }
        if (unsigned && nlong <= 0 && len <= 8 * this.parser.evaluator.toSize[105]) {
            return 403;
        }
        if (signed && nlong <= 1 && len < 8 * this.parser.evaluator.toSize[108]) {
            return 404;
        }
        if (nlong <= 1 && len <= 8 * this.parser.evaluator.toSize[108]) {
            return 405;
        }
        if (signed && nlong <= 2 && len < 8 * this.parser.evaluator.toSize[106]) {
            return 411;
        }
        return 412;
    }

    private int readDouble(StringBuffer sbuf, int c, Token token) throws IOException {
        int type;
        if (c != 69 && c != 101) {
            sbuf.append((char)c);
            while (48 <= (c = this.getc()) && c <= 57) {
                sbuf.append((char)c);
            }
        }
        if (c == 69 || c == 101) {
            sbuf.append((char)c);
            c = this.getc();
            if (c == 43 || c == 45) {
                sbuf.append((char)c);
                c = this.getc();
            }
            while (48 <= c && c <= 57) {
                sbuf.append((char)c);
                c = this.getc();
            }
        }
        if (c == 76 || c == 108) {
            type = 407;
        } else if (c == 70 || c == 102) {
            type = 406;
        } else {
            this.ungetc(c);
            type = 407;
        }
        try {
            token.doubleValue = Double.parseDouble(sbuf.toString());
            return type;
        }
        catch (NumberFormatException e) {
            return 500;
        }
    }

    private int readSeparator(int c) throws IOException {
        int c2;
        if (33 <= c && c <= 63) {
            int t = equalOps[c - 33];
            if (t == 0) {
                return c;
            }
            c2 = this.getc();
            if (c == 46) {
                if (c2 == 46) {
                    int c3 = this.getc();
                    if (c3 == 46) {
                        return 370;
                    }
                    this.ungetc(c3);
                    return 500;
                }
            } else if (c == c2) {
                switch (c) {
                    case 61: {
                        return 363;
                    }
                    case 43: {
                        return 364;
                    }
                    case 45: {
                        return 365;
                    }
                    case 38: {
                        return 369;
                    }
                    case 60: {
                        int c3 = this.getc();
                        if (c3 == 61) {
                            return 356;
                        }
                        this.ungetc(c3);
                        return 366;
                    }
                    case 62: {
                        int c3 = this.getc();
                        if (c3 == 61) {
                            return 359;
                        }
                        this.ungetc(c3);
                        return 367;
                    }
                }
            } else {
                if (c2 == 61) {
                    return t;
                }
                if (c == 45 && c2 == 62) {
                    return 371;
                }
            }
        } else if (c == 94) {
            c2 = this.getc();
            if (c2 == 61) {
                return 357;
            }
        } else if (c == 124) {
            c2 = this.getc();
            if (c2 == 61) {
                return 358;
            }
            if (c2 == 124) {
                return 368;
            }
        } else {
            return c;
        }
        this.ungetc(c2);
        return c;
    }

    private int readIdentifier(int c, Token token) throws IOException {
        String text;
        StringBuffer tbuf = this.textBuffer;
        tbuf.setLength(0);
        do {
            tbuf.append((char)c);
        } while (65 <= (c = this.getc()) && c <= 90 || 97 <= c && c <= 122 || c == 95 || c == 36 || 48 <= c && c <= 57);
        this.ungetc(c);
        int t = ktable.lookup(tbuf);
        if (t >= 0) {
            return t;
        }
        t = this.checkExtendedKeywords(tbuf);
        if (t >= 0) {
            return t;
        }
        token.textValue = text = tbuf.toString().intern();
        return this.parser.isTypedefedType(text) ? 409 : 400;
    }

    protected int checkExtendedKeywords(StringBuffer sbuf) {
        return -1;
    }

    private static boolean isBlank(int c) {
        return c == 32 || c == 9 || c == 12 || c == 13;
    }

    private static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    private void ungetc(int c) {
        this.lastChar = c;
    }

    private int getc() throws IOException {
        if (this.lastChar < 0) {
            return this.input.read();
        }
        int c = this.lastChar;
        this.lastChar = -1;
        return c;
    }

    static {
        ktable.append("__builtin_va_list", 308);
        ktable.append("asm", 300);
        ktable.append("auto", 301);
        ktable.append("break", 321);
        ktable.append("case", 322);
        ktable.append("char", 302);
        ktable.append("const", 303);
        ktable.append("continue", 323);
        ktable.append("default", 324);
        ktable.append("do", 325);
        ktable.append("double", 304);
        ktable.append("else", 326);
        ktable.append("enum", 305);
        ktable.append("extern", 306);
        ktable.append("float", 307);
        ktable.append("for", 327);
        ktable.append("goto", 328);
        ktable.append("if", 329);
        ktable.append("inline", 334);
        ktable.append("int", 308);
        ktable.append("long", 309);
        ktable.append("pragma", 413);
        ktable.append("register", 310);
        ktable.append("return", 330);
        ktable.append("short", 311);
        ktable.append("signed", 312);
        ktable.append("sizeof", 331);
        ktable.append("static", 313);
        ktable.append("struct", 314);
        ktable.append("switch", 332);
        ktable.append("typedef", 315);
        ktable.append("union", 316);
        ktable.append("unsigned", 317);
        ktable.append("void", 318);
        ktable.append("volatile", 319);
        ktable.append("while", 333);
        equalOps = new int[]{360, 0, 0, 0, 350, 351, 0, 0, 0, 352, 353, 0, 354, 370, 355, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 361, 363, 362, 0};
    }
}

