/*
 * Decompiled with CFR 0.152.
 */
package coins.cfront;

import coins.HirRoot;
import coins.IoRoot;
import coins.PassException;
import coins.SymRoot;
import coins.casttohir.ToHir;
import coins.casttohir.ToHirBase;
import coins.casttohir.ToHirBaseOpt;
import coins.casttohir.ToHirC;
import coins.casttohir.ToHirC2;
import coins.casttohir.ToHirCOpt;
import coins.casttohir.ToHirCOpt2;
import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.Driver;
import coins.driver.Suffix;
import coins.driver.Trace;
import coins.ir.hir.HIR;
import coins.ir.hir.Program;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class Cfront
extends Driver {
    protected File sourceFile;
    protected Suffix suffix;
    protected InputStream in;
    protected IoRoot ioRoot;
    public SymRoot symRoot;
    public HirRoot hirRoot;
    protected int fDbgLevel;
    protected CompileSpecification spec;

    public Cfront(File pSourceFile, Suffix pSuffix, InputStream pIn, IoRoot pIo, HirRoot pHirRoot) {
        this.sourceFile = pSourceFile;
        this.suffix = pSuffix;
        this.in = pIn;
        this.ioRoot = pIo;
        this.hirRoot = pHirRoot;
        this.symRoot = pHirRoot.symRoot;
        this.fDbgLevel = this.ioRoot.dbgToHir.getLevel();
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgToHir.print(1, "Cfront\n");
        }
    }

    public Cfront() {
    }

    public void makeHirFromCSource() throws IOException, PassException {
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgToHir.print(1, "makeHirFromCSource\n");
        }
        this.hirRoot.programRoot = this.makeHirCFromCSource(this.hirRoot, this.in, this.ioRoot);
        this.hirRoot.programRoot = this.makeHirBaseFromC(this.hirRoot, (HIR)this.hirRoot.programRoot, this.ioRoot);
    }

    protected HIR makeHirCFromCSource(HirRoot hirRoot, InputStream in, IoRoot io) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgToHir.print(1, "makeHirCFromCSource\n");
        }
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        boolean fromcSpecified = false;
        if (coinsOptions.isSet("hirOpt")) {
            fromcSpecified = this.includedInDelimitedList("fromc", '/', coinsOptions.getArg("hirOpt"));
        }
        ToHir tohir = new ToHir(hirRoot, coinsOptions.isSet("oldlir"), fromcSpecified);
        new ToHirC(tohir).astToHirC(in);
        ToHirCOpt toHirCOpt = new ToHirCOpt(tohir);
        new ToHirC2(tohir).visitProgram();
        if (fromcSpecified) {
            new ToHirCOpt2(tohir).visitProgram();
        } else {
            toHirCOpt.visitProgram();
        }
        Program hir = (Program)hirRoot.programRoot;
        hir.finishHir();
        if (this.fDbgLevel >= 4) {
            this.ioRoot.dbgToHir.print(1, "\nHIR-C");
            hir.print(0);
        }
        if (io.addToTotalErrorCount(0) > 0) {
            throw new PassException(io.getSourceFile(), "Ast to HIR-C", "Error(s) in parsing source.");
        }
        return hir;
    }

    protected HIR makeHirBaseFromC(HirRoot hirRoot, HIR hir, IoRoot io) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        Trace trace = spec.getTrace();
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgToHir.print(1, "makeHirBaseFromC\n");
        }
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        boolean fromcSpecified = false;
        if (coinsOptions.isSet("hirOpt")) {
            fromcSpecified = this.includedInDelimitedList("fromc", '/', coinsOptions.getArg("hirOpt"));
        }
        ToHir tohir = new ToHir(hirRoot, coinsOptions.isSet("oldlir"), fromcSpecified);
        new ToHirBase(tohir).visitProgram();
        if (fromcSpecified) {
            new ToHirBaseOpt(tohir).visitProgram();
        }
        hir.setIndexNumberToAllNodes(1);
        if (this.fDbgLevel >= 3) {
            this.ioRoot.dbgToHir.print(1, "\nHIR-base");
            hir.print(0);
        }
        if (this.ioRoot.dbgSym.getLevel() >= 3) {
            this.ioRoot.dbgSym.print(3, "\nSym after HIR generation ");
            SymRoot symroot = hirRoot.symRoot;
            symroot.symTable.printSymTableAllDetail(symroot.symTableRoot);
        }
        if (io.addToTotalErrorCount(0) > 0) {
            throw new PassException(io.getSourceFile(), "HIR-C to HIR-Base", "Error(s) in making HIR-Base.");
        }
        if (hir.isTree()) {
            trace.trace("HIR", 2, "\nHIR-base does not violate tree structure.");
        }
        return hir;
    }
}

