/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.ast.ASTree;
import coins.ast.Expr;
import coins.ast.expr.ArrayInitializer;
import coins.ast.expr.StringLiteral;
import coins.casttohir.ToHir;
import coins.casttohir.ToHirC;
import coins.ir.IrList;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpListExpImpl;
import coins.ir.hir.ForStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.VarNode;
import coins.sym.Elem;
import coins.sym.StructType;
import coins.sym.Sym;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.UnionType;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.LinkedList;
import java.util.Stack;

final class ToHirInit {
    private ArrayInitializer init;
    private Stack stack;
    private SymTable initSymTable;
    private final ToHir toHir;
    private final HIR hir;
    private final Sym sym;
    private final ToHirC toC;
    protected int fDbgLevel;

    ToHirInit(ToHir tohir, ToHirC toc) {
        this.toHir = tohir;
        this.hir = tohir.hirRoot.hir;
        this.sym = tohir.hirRoot.sym;
        this.toC = toc;
        this.message(1, "ToHirInit\n");
        this.stack = new Stack();
        this.fDbgLevel = tohir.ioRoot.dbgToHir.getLevel();
    }

    private void message(int level, String mes) {
        this.toHir.debug.print(level, "In", mes);
    }

    Exp createSetData(Var lval, Expr expr) {
        if (this.fDbgLevel > 3) {
            this.message(6, "createSetData  NAME=" + lval.getName() + "  TYPE=" + lval.getSymType());
        }
        this.stack.clear();
        this.initSymTable = lval.getRecordedIn();
        this.init = expr != null ? new ArrayInitializer(expr, null) : null;
        return this.parse(lval.getSymType());
    }

    private Exp parse(Type type) {
        if (this.fDbgLevel > 0) {
            this.message(8, "INIT " + type);
        }
        if (type.getTypeRank() != 0) {
            Exp val = this.getScalar(type);
            if (this.fDbgLevel > 0) {
                this.message(8, "SCALAR=" + val);
            }
            return val;
        }
        HIR ret = null;
        this.in();
        switch (type.getTypeKind()) {
            case 23: {
                long size = ((VectorType)type).getElemCount();
                Type elemtype = ((VectorType)type).getElemType();
                if ((elemtype.getTypeKind() == 7 || elemtype.getTypeKind() == 8) && (ret = this.getString(type)) != null) {
                    if (this.fDbgLevel <= 0) break;
                    this.message(8, "STRING=" + ret);
                    break;
                }
                LinkedList<Exp> list = new LinkedList<Exp>();
                int i = 0;
                while ((long)i < size) {
                    if (this.init == null && (long)i < size - 1L) {
                        if (this.fDbgLevel > 0) {
                            this.message(8, "REPEAT=" + i + "..." + size);
                        }
                        list.add(this.hir.exp(97, this.parse(elemtype), this.hir.intConstNode((int)size - i)));
                        break;
                    }
                    if (this.fDbgLevel > 0) {
                        this.message(8, "INDEX=" + i);
                    }
                    list.add(this.parse(elemtype));
                    ++i;
                }
                ret = new ExpListExpImpl(this.toHir.hirRoot, list);
                break;
            }
            case 24: {
                IrList il = ((StructType)type).getElemList();
                int size = il.size();
                if (this.fDbgLevel > 0) {
                    this.message(8, "elemList=" + il + " size " + size);
                }
                LinkedList<Exp> list = new LinkedList<Exp>();
                for (int i = 0; i < size; ++i) {
                    Elem elem = (Elem)il.get(i);
                    if (this.fDbgLevel > 0) {
                        this.message(8, "ELEM=" + elem.getName());
                    }
                    list.add(this.parse(elem.getSymType()));
                }
                ret = new ExpListExpImpl(this.toHir.hirRoot, list);
                break;
            }
            case 25: {
                IrList il = ((UnionType)type).getElemList();
                LinkedList<Exp> list = new LinkedList<Exp>();
                if (il.size() > 0) {
                    Elem elem = (Elem)il.get(0);
                    if (this.fDbgLevel > 0) {
                        this.message(8, "ELEM=" + elem.getName());
                    }
                    list.add(this.parse(elem.getSymType()));
                }
                ret = new ExpListExpImpl(this.toHir.hirRoot, list);
                break;
            }
            default: {
                this.toHir.fatal("ToHirInit.parse  TYPE=" + type);
            }
        }
        this.out();
        ret.setType(type);
        return ret;
    }

    void createAssignStmts(Stmt stmt, Var var, Expr expr) {
        if (this.fDbgLevel > 3) {
            this.message(6, "createAssignStmts  NAME=" + var.getName() + "  TYPE=" + var.getSymType());
        }
        this.initSymTable = var.getRecordedIn();
        VarNode lval = this.hir.varNode(var);
        if (expr != null && !(expr instanceof ArrayInitializer)) {
            Exp val = (Exp)this.toC.visit((ASTree)((Object)expr));
            if (lval.getType().getTypeKind() != 23) {
                val = this.toC.pPromotion(val);
            }
            this.addInitializer(stmt, this.toHir.newExpStmt(this.hir.exp(22, lval, val)));
            return;
        }
        this.init = new ArrayInitializer(expr, null);
        this.stack.clear();
        this.parse(stmt, lval);
    }

    private void parse(Stmt stmt, Exp lval) {
        Type type = lval.getType();
        if (this.fDbgLevel > 0) {
            this.message(8, "parse INIT " + type);
        }
        if (type.getTypeRank() != 0) {
            Exp val = this.getScalar(type);
            if (this.fDbgLevel > 0) {
                this.message(8, "SCALAR=" + val);
            }
            this.addInitializer(stmt, this.toHir.newExpStmt(this.hir.exp(22, lval, val)));
            return;
        }
        this.in();
        block0 : switch (type.getTypeKind()) {
            case 23: {
                Exp val;
                long size = ((VectorType)type).getElemCount();
                Type elemtype = ((VectorType)type).getElemType();
                if ((elemtype.getTypeKind() == 7 || elemtype.getTypeKind() == 8) && (val = this.getString(type)) != null) {
                    if (this.fDbgLevel > 0) {
                        this.message(8, "STRING=" + val);
                    }
                    this.addInitializer(stmt, this.toHir.newExpStmt(this.hir.exp(22, lval, val)));
                    break;
                }
                int i = 0;
                while ((long)i < size && this.isInitialized()) {
                    if (this.init == null && (long)i < size - 1L) {
                        if (this.fDbgLevel > 0) {
                            this.message(8, "REPEAT=" + i + "..." + size);
                        }
                        this.addInitializerLoop(stmt, lval, i, size);
                        break block0;
                    }
                    if (this.fDbgLevel > 0) {
                        this.message(8, "INDEX=" + i);
                    }
                    this.parse(stmt, this.toHir.subsExp(lval, this.hir.intConstNode(i)));
                    ++i;
                    lval = (Exp)lval.copyWithOperands();
                }
                break;
            }
            case 24: {
                IrList il = ((StructType)type).getElemList();
                int size = il.size();
                int i = 0;
                while (i < size && this.isInitialized()) {
                    Elem elem = (Elem)il.get(i);
                    if (this.fDbgLevel > 0) {
                        this.message(8, "ELEM=" + elem.getName());
                    }
                    this.parse(stmt, this.hir.qualifiedExp(lval, this.hir.elemNode(elem)));
                    ++i;
                    lval = (Exp)lval.copyWithOperands();
                }
                break;
            }
            case 25: {
                IrList il = ((UnionType)type).getElemList();
                if (il.size() <= 0 || !this.isInitialized()) break;
                Elem elem = (Elem)il.get(0);
                if (this.fDbgLevel > 0) {
                    this.message(8, "ELEM=" + elem.getName());
                }
                this.parse(stmt, this.hir.qualifiedExp(lval, this.hir.elemNode(elem)));
                break;
            }
            default: {
                this.toHir.fatal("ToHirInit.parse  TYPE: " + type);
            }
        }
        this.out();
    }

    private boolean isInitialized() {
        return this.toHir.machineParam.initGlobalExplicitly() || this.init != null || this.initSymTable != this.toHir.symRoot.symTableRoot;
    }

    private void addInitializerLoop(Stmt stmt, Exp lval, long from, long to) {
        Type elemtype = ((VectorType)lval.getType()).getElemType();
        Var tempvar = this.initSymTable.generateVar(this.toHir.symRoot.typeInt, this.initSymTable.getOwner());
        AssignStmt loopInit = this.hir.assignStmt(this.hir.varNode(tempvar), this.hir.intConstNode(from));
        AssignStmt loopStep = this.hir.assignStmt(this.hir.varNode(tempvar), this.hir.exp(38, this.hir.varNode(tempvar), this.hir.intConstNode(1)));
        Exp loopCond = this.hir.exp(55, this.hir.varNode(tempvar), this.hir.intConstNode(to));
        ForStmt forstmt = this.hir.forStmt(loopInit, this.initSymTable.generateLabel(), loopCond, null, this.initSymTable.generateLabel(), loopStep, this.initSymTable.generateLabel());
        this.addInitializer(stmt, forstmt);
        this.parse(forstmt.getLoopBodyPart(), this.toHir.subsExp(lval, this.hir.varNode(tempvar)));
    }

    private void addInitializer(Stmt stmt, Stmt insertion) {
        switch (stmt.getOperator()) {
            case 35: {
                ((BlockStmt)stmt).addLastStmt(insertion);
                break;
            }
            case 21: {
                Stmt s = ((LabeledStmt)stmt).getStmt();
                if (s == null) {
                    ((LabeledStmt)stmt).setStmt(insertion);
                    break;
                }
                if (s.getOperator() == 35) {
                    ((BlockStmt)s).addLastStmt(insertion);
                    break;
                }
                ((LabeledStmt)stmt).setStmt(null);
                BlockStmt block = this.hir.blockStmt(s);
                block.setFlag(4, true);
                block.addLastStmt(insertion);
                block.setSymTable(this.initSymTable);
                ((LabeledStmt)stmt).setStmt(block);
                break;
            }
            default: {
                this.toHir.fatal("ToHirInit.addInitializerToStmt OP:" + stmt.getOperator());
            }
        }
    }

    private void in() {
        if (this.init != null) {
            if (this.init.head() == null) {
                this.stack.push(this.init.tail());
                this.init = null;
            } else if (this.init.head() instanceof ArrayInitializer) {
                this.stack.push(this.init.tail());
                this.init = (ArrayInitializer)this.init.head();
            } else {
                this.stack.push(null);
            }
        } else {
            this.stack.push(null);
        }
    }

    private void out() {
        ArrayInitializer next = (ArrayInitializer)this.stack.pop();
        if (this.fDbgLevel > 0) {
            this.message(8, "out INIT=" + next + " LEVEL=" + this.stack.size());
        }
        if (next != null) {
            if (this.init != null) {
                this.toHir.warning("excess initializer(s) '" + this.init + "'");
            }
            this.init = next;
            return;
        }
        if (this.stack.empty() && this.init != null) {
            this.toHir.warning("excess initializer(s) '" + this.init + "'");
        }
    }

    private Exp getScalar(Type t) {
        if (this.init != null) {
            Expr e;
            Expr bak = e = (Expr)((Object)this.init.head());
            this.init = (ArrayInitializer)this.init.tail();
            while (e instanceof ArrayInitializer) {
                e = (Expr)((Object)((ArrayInitializer)e).head());
            }
            if (e != bak) {
                this.toHir.warning("Excess initializer brace(s)");
            }
            if (e != null) {
                return this.toC.pPromotion((Exp)this.toC.visit((ASTree)((Object)e)));
            }
        }
        return this.getConst0(t);
    }

    private Exp getConst0(Type t) {
        Object c = null;
        switch (t.getTypeKind()) {
            case 3: 
            case 4: {
                return this.hir.constNode(this.toHir.symRoot.intConst0);
            }
            case 5: 
            case 6: {
                return this.hir.constNode(this.toHir.symRoot.longConst0);
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.hir.constNode(this.toHir.symRoot.intConst0);
            }
            case 11: 
            case 12: {
                return this.hir.constNode(this.toHir.symRoot.longConst0);
            }
            case 16: {
                return this.hir.constNode(this.toHir.symRoot.floatConst0);
            }
            case 17: 
            case 18: {
                return this.hir.constNode(this.toHir.symRoot.doubleConst0);
            }
            case 21: {
                return this.hir.constNode(this.toHir.symRoot.intConst0);
            }
            case 22: {
                return this.hir.convExp(this.toHir.typeVoidPtr, this.hir.constNode(this.toHir.symRoot.intConst0));
            }
        }
        this.toHir.fatal("const0Node TYPE: " + t);
        return null;
    }

    private Exp getString(Type t) {
        if (this.init != null) {
            Expr e;
            Expr bak = e = (Expr)((Object)this.init.head());
            while (e instanceof ArrayInitializer) {
                e = (Expr)((Object)((ArrayInitializer)e).head());
            }
            if (e instanceof StringLiteral) {
                if (e != bak) {
                    this.toHir.warning("Excess initializer brace(s)");
                }
                this.init = (ArrayInitializer)this.init.tail();
                return this.getConstString(t, ((StringLiteral)e).get());
            }
            if (e != null) {
                return null;
            }
        }
        return this.getConstString(t, "");
    }

    private Exp getConstString(Type t, String s) {
        ConstNode val = this.hir.constNode(this.sym.stringConst(s.intern()));
        return val;
    }

    private boolean canBeStaticInit(Exp e) {
        switch (e.getOperator()) {
            case 5: {
                return true;
            }
            case 6: 
            case 8: 
            case 12: {
                return false;
            }
            case 7: {
                Var v = (Var)((VarNode)e).getSymNodeSym();
                Type t = v.getSymType();
                return v.getStorageClass() == 6 || t.isConst() && !t.isVolatile();
            }
            case 9: {
                return true;
            }
            case 17: {
                return this.canBeStaticInit(e.getExp1()) && this.canBeStaticInit(e.getExp2());
            }
            case 19: 
            case 20: {
                return this.canBeStaticInit(e.getExp1());
            }
            case 22: 
            case 33: {
                return false;
            }
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: {
                return this.canBeStaticInit(e.getExp1()) && this.canBeStaticInit(e.getExp2());
            }
            case 62: 
            case 63: 
            case 81: {
                return this.canBeStaticInit(e.getExp1());
            }
            case 64: {
                Exp e1 = e.getExp1();
                switch (e1.getOperator()) {
                    case 7: {
                        return ((Var)((VarNode)e1).getSymNodeSym()).getStorageClass() == 6;
                    }
                    case 9: {
                        return true;
                    }
                }
                return false;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                return this.canBeStaticInit(e.getExp1());
            }
            case 70: {
                return true;
            }
            case 73: {
                return false;
            }
            case 76: {
                return this.canBeStaticInit(e.getExp1()) && this.canBeStaticInit(e.getExp2());
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                return false;
            }
        }
        this.toHir.fatal("visitExp: " + e);
        return false;
    }
}

