/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.casttohir.ConditionInverter;
import coins.casttohir.SideEffectBuffer;
import coins.casttohir.ToC;
import coins.casttohir.ToHir;
import coins.casttohir.ToHirCast;
import coins.casttohir.ToHirVisit;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirList;
import coins.ir.hir.IfStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.VarNode;
import coins.sym.PointerType;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.Var;
import java.util.ListIterator;

public class ToHirCOpt
extends ToHirVisit {
    protected final ToHir toHir;
    protected final HIR hir;
    protected final Sym sym;
    protected final ToHirCast toCast;
    protected final SideEffectBuffer buffer;
    protected final ConditionInverter inverter;

    public ToHirCOpt(ToHir tohir) {
        super(tohir);
        this.toHir = tohir;
        this.hir = tohir.hirRoot.hir;
        this.sym = tohir.hirRoot.sym;
        this.message(1, "ToHirCOpt\n");
        this.toCast = new ToHirCast(tohir);
        this.buffer = new SideEffectBuffer(tohir);
        this.inverter = new ConditionInverter(tohir);
    }

    protected void message(int level, String mes) {
        this.toHir.debug.print(level, "CO", mes);
    }

    protected void atIf(IfStmt s) {
        super.atIf(s);
        s.setIfCondition(this.buffer.toExp(s.getIfCondition()));
    }

    protected void atWhile(LoopStmt s) {
        super.atWhile(s);
        s.setLoopStartCondition(this.buffer.toExp(s.getLoopStartCondition()));
    }

    protected void atFor(LoopStmt s) {
        super.atFor(s);
        s.setLoopStartCondition(this.buffer.toExp(s.getLoopStartCondition()));
    }

    protected void atUntil(LoopStmt s) {
        super.atUntil(s);
        s.setLoopEndCondition(this.buffer.toExp(s.getLoopEndCondition()));
    }

    protected void atSwitch(SwitchStmt s) {
        super.atSwitch(s);
        s.setSelectionExp(this.buffer.toExp(s.getSelectionExp()));
    }

    protected void atReturn(ReturnStmt s) {
        s.setReturnValue(this.buffer.toExp(this.visitExp(s.getReturnValue())));
    }

    protected void atExpStmt(ExpStmt s) {
        s.setExp(this.buffer.toExp(this.visitExp(s.getExp())));
    }

    protected Exp atVar(VarNode e) {
        Exp init;
        Type t = ((Var)e.getSymNodeSym()).getSymType();
        if (!this.inInitBlock() && e.getParent().getOperator() != 64 && !t.isVolatile() && t.isConst() && (init = ((Var)e.getSym()).getInitialValue()) != null && init.getOperator() == 5) {
            if (this.fDbgLevel > 3) {
                this.message(4, "const " + ((Var)e.getSym()).getName() + " --> " + init);
            }
            return this.toCast.cast(t, (Exp)init.copyWithOperands());
        }
        return e;
    }

    protected Exp atCall(FunctionExp e) {
        e.setFunctionSpec(this.buffer.toExp(this.visitExp(e.getFunctionSpec())));
        HirList actuallist = (HirList)e.getParamList();
        ListIterator i = actuallist.iterator();
        while (i.hasNext()) {
            Exp re = this.buffer.toExp(this.visitExp((Exp)i.next()));
            i.set(re);
            re.setParent(actuallist);
        }
        return e;
    }

    protected Exp atNot(Exp e) {
        Exp e1 = e.getExp1();
        if (e1.getOperator() == 62) {
            if (this.fDbgLevel > 3) {
                this.message(4, "~~v --> v: " + ToC.tos(e));
            }
            return this.visitExp(e1.getExp1());
        }
        return super.atNot(e);
    }

    protected Exp atNeg(Exp e) {
        Exp e1 = e.getExp1();
        if (e1.getOperator() == 63) {
            if (this.fDbgLevel > 3) {
                this.message(4, "--v --> v: " + ToC.tos(e));
            }
            return this.visitExp(e1.getExp1());
        }
        return super.atNeg(e);
    }

    protected Exp atAddr(Exp e) {
        Exp e1 = e.getExp1();
        if (e1.getOperator() == 68) {
            if (this.fDbgLevel > 3) {
                this.message(4, "&*v --> v: " + ToC.tos(e));
            }
            return this.visitExp(e1.getExp1());
        }
        return super.atAddr(e);
    }

    protected Exp atDecay(Exp e) {
        Exp e1 = e.getExp1();
        if (e1.getOperator() == 67) {
            if (this.fDbgLevel > 3) {
                this.message(4, "decay(undecay(v)) --> v: " + ToC.tos(e));
            }
            return this.visitExp(e1.getExp1());
        }
        return super.atDecay(e);
    }

    protected Exp atUndecay(Exp e) {
        Exp e1 = e.getExp1();
        if (e1.getOperator() == 66) {
            if (this.fDbgLevel > 3) {
                this.message(4, "undecay(decay(v)) --> v: " + ToC.tos(e));
            }
            return this.visitExp(e1.getExp1());
        }
        return super.atUndecay(e);
    }

    protected Exp atContents(Exp e) {
        Exp e1 = e.getExp1();
        if (e1.getOperator() == 64) {
            if (this.fDbgLevel > 3) {
                this.message(4, "*&v --> v: " + ToC.tos(e));
            }
            return this.visitExp(e1.getExp1());
        }
        super.atContents(e);
        Exp ptrnode = this.findUndecayablePointerNode(e.getExp1());
        if (ptrnode != null) {
            if (ptrnode.getOperator() == 66) {
                if (this.fDbgLevel > 3) {
                    this.message(4, "*(decay(a)+i) --> a[i]: " + ToC.tos(e));
                }
                return this.toHir.subsExp(ptrnode.getExp1(), this.toCast.iPromotion(e.getExp1()));
            }
            if (this.fDbgLevel > 3) {
                this.message(4, "*(ptr+i) --> undecay(ptr)[i]: " + ToC.tos(e));
            }
            long elemcount = ((PointerType)ptrnode.getType()).getElemCount();
            return this.toHir.subsExp(this.hir.undecayExp(ptrnode, elemcount), this.toCast.iPromotion(e.getExp1()));
        }
        return e;
    }

    protected Exp atEqZero(Exp e) {
        e = this.inverter.visitExp(e.getExp1());
        return this.visitExp(e);
    }

    private Exp findUndecayablePointerNode(Exp e) {
        switch (e.getOperator()) {
            case 66: {
                if (this.isObject(e.getExp1())) {
                    ((HIR)e.getParent()).setChild1(this.toHir.new0Node());
                    return e;
                }
                return null;
            }
            case 7: {
                Sym s = ((VarNode)e).getSymNodeSym();
                if (!s.getFlag(6) && !s.getFlag(9) && ((PointerType)s.getSymType()).getElemCount() != 0L) {
                    ((HIR)e.getParent()).setChild1(this.toHir.new0Node());
                    return e;
                }
                return null;
            }
            case 38: {
                Exp ret = this.findUndecayablePointerNode(e.getExp1());
                if (ret != null) {
                    if (e.getExp1().getOperator() == 5 && ((ConstNode)e.getExp1()).isIntConst0()) {
                        ((HIR)e.getParent()).setChild1(this.toCast.iPromotion(e.getExp2()));
                    } else {
                        e.setType(this.toHir.symRoot.typeInt);
                    }
                }
                return ret;
            }
            case 39: {
                Exp ret = this.findUndecayablePointerNode(e.getExp1());
                if (ret != null) {
                    if (e.getExp1().getOperator() == 5 && ((ConstNode)e.getExp1()).isIntConst0()) {
                        ((HIR)e.getParent()).setChild1(this.hir.exp(63, this.toCast.iPromotion(e.getExp2())));
                    } else {
                        e.setType(this.toHir.symRoot.typeInt);
                    }
                }
                return ret;
            }
        }
        return null;
    }

    private boolean isObject(Exp e) {
        switch (e.getOperator()) {
            case 5: 
            case 7: {
                return true;
            }
            case 17: 
            case 19: {
                return this.isObject(e.getExp1());
            }
        }
        return false;
    }
}

