/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.casttohir.SideEffectBuffer;
import coins.casttohir.SideEffectCutter;
import coins.casttohir.ToHir;
import coins.casttohir.ToHirCast;
import coins.casttohir.ToHirVisit;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.IfStmt;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SwitchStmt;
import coins.sym.Const;
import coins.sym.Label;
import coins.sym.Sym;

public class ToHirBaseOpt
extends ToHirVisit {
    private final ToHir toHir;
    private final ToHirCast toCast;
    private final HIR hir;
    private final Sym sym;
    private final SideEffectBuffer buffer;
    private final SideEffectCutter cutter;
    private boolean reachable;

    public ToHirBaseOpt(ToHir tohir) {
        super(tohir);
        this.message(1, "ToHirBaseOpt\n");
        this.toHir = tohir;
        this.toCast = new ToHirCast(tohir);
        this.hir = tohir.hirRoot.hir;
        this.sym = tohir.hirRoot.sym;
        this.buffer = new SideEffectBuffer(tohir);
        this.cutter = new SideEffectCutter(tohir, this.buffer);
    }

    protected void message(int level, String mes) {
        this.toHir.debug.print(level, "BO", mes);
    }

    protected void atBlock(BlockStmt s) {
        if (s.getSubpBodyFlag()) {
            this.reachable = true;
        }
        super.atBlock(s);
        if (s.getFirstStmt() == null) {
            s.deleteThisStmt();
        }
    }

    protected void atLabeledStmt(LabeledStmt s) {
        this.visitStmt(s.getStmt());
        Label label = s.getLabel();
        if (label.getHirRefCount() == 0 && (label.getLabelKind() == 16 || label.getLabelKind() == 8)) {
            if (this.fDbgLevel > 3) {
                this.message(6, "not referenced --> delete " + s);
            }
            s.deleteThisStmt();
            return;
        }
        this.reachable = true;
        Stmt prev = s.getPreviousStmt();
        while (prev != null) {
            if (prev.getOperator() == 21) {
                if (this.fDbgLevel > 3) {
                    this.message(6, "consecutive label --> merge " + s);
                }
                ((LabeledStmt)prev).merge(s);
                s.deleteThisStmt();
                s = (LabeledStmt)prev;
                prev = s.getPreviousStmt();
                continue;
            }
            if (prev.getOperator() != 28 || ((JumpStmt)prev).getLabel().getHirPosition() != s) break;
            Stmt pp = prev.getPreviousStmt();
            if (this.fDbgLevel > 3) {
                this.message(6, "zero jump --> delete " + prev);
            }
            prev.deleteThisStmt();
            prev = pp;
        }
    }

    protected void atAssignStmt(AssignStmt s) {
        if (!this.reachable) {
            if (this.fDbgLevel > 3) {
                this.message(6, "unreachable --> delete " + s);
            }
            s.deleteThisStmt();
        }
    }

    protected void atIf(IfStmt s) {
        Exp cond = s.getIfCondition();
        boolean reachableif = this.reachable;
        this.reachable = reachableif && cond.getSym() != this.toHir.symRoot.boolConstFalse;
        this.visitStmt(s.getThenPart().getStmt());
        boolean reachablethen = this.reachable;
        this.reachable = reachableif && cond.getSym() != this.toHir.symRoot.boolConstTrue;
        this.visitStmt(s.getElsePart().getStmt());
        this.reachable |= reachablethen;
        Stmt then0 = s.getThenPart().getStmt();
        Stmt else0 = s.getElsePart().getStmt();
        if (reachableif) {
            if (cond.getSym() == this.toHir.symRoot.boolConstTrue) {
                if (else0 != null) {
                    if (this.fDbgLevel > 3) {
                        this.message(6, "if(true) THEN; else ELSE; " + s);
                    }
                    Label endlabel = s.getEndLabel();
                    endlabel.setLabelKind(16);
                    BlockStmt block = this.buffer.getBlockStmt(else0);
                    block.addLastStmt(this.hir.labeledStmt(endlabel, null));
                    block.addFirstStmt(this.hir.jumpStmt(endlabel));
                    block.addFirstStmt(then0);
                    s.replaceThisStmtWith(block);
                } else {
                    if (this.fDbgLevel > 3) {
                        this.message(6, "if(true) THEN; " + s);
                    }
                    s.replaceThisStmtWith(then0);
                }
            } else if (cond.getSym() == this.toHir.symRoot.boolConstFalse) {
                if (then0 != null) {
                    if (this.fDbgLevel > 3) {
                        this.message(6, "if(false) THEN; else ELSE; " + s);
                    }
                    Label endlabel = s.getEndLabel();
                    endlabel.setLabelKind(16);
                    BlockStmt block = this.buffer.getBlockStmt(then0);
                    block.addLastStmt(this.hir.labeledStmt(endlabel, null));
                    block.addFirstStmt(this.hir.jumpStmt(endlabel));
                    block.addFirstStmt(else0);
                    s.replaceThisStmtWith(block);
                } else {
                    if (this.fDbgLevel > 3) {
                        this.message(6, "if(false); else ELSE; " + s);
                    }
                    s.replaceThisStmtWith(else0);
                }
            } else if (then0 == null && else0 == null) {
                if (this.fDbgLevel > 3) {
                    this.message(6, "if(e); " + s);
                }
                this.cutter.visitExp(cond);
                this.buffer.addToStmtPrev(s, false);
                s.deleteThisStmt();
            }
        } else {
            Label endlabel = s.getEndLabel();
            endlabel.setLabelKind(16);
            if (then0 != null) {
                if (else0 != null) {
                    if (this.fDbgLevel > 3) {
                        this.message(6, "unreachable if(e) THEN; else ELSE; " + s);
                    }
                    BlockStmt block = this.buffer.getBlockStmt(else0);
                    block.addLastStmt(this.hir.labeledStmt(endlabel, null));
                    block.addFirstStmt(this.hir.jumpStmt(endlabel));
                    block.addFirstStmt(then0);
                    block.addFirstStmt(this.hir.jumpStmt(endlabel));
                    s.replaceThisStmtWith(block);
                } else {
                    if (this.fDbgLevel > 3) {
                        this.message(6, "unreachable if(e) THEN; " + s);
                    }
                    BlockStmt block = this.buffer.getBlockStmt(then0);
                    block.addLastStmt(this.hir.labeledStmt(endlabel, null));
                    block.addFirstStmt(this.hir.jumpStmt(endlabel));
                    s.replaceThisStmtWith(block);
                }
            } else if (else0 != null) {
                if (this.fDbgLevel > 3) {
                    this.message(6, "unreachable if(e); else ELSE; " + s);
                }
                BlockStmt block = this.buffer.getBlockStmt(else0);
                block.addLastStmt(this.hir.labeledStmt(endlabel, null));
                block.addFirstStmt(this.hir.jumpStmt(endlabel));
                s.replaceThisStmtWith(block);
            } else {
                if (this.fDbgLevel > 3) {
                    this.message(6, "unreachable if(e); " + s);
                }
                s.deleteThisStmt();
            }
        }
    }

    protected void atWhile(LoopStmt s) {
        Label continuelabel = s.getLoopStepLabel();
        if (continuelabel.getHirRefCount() == 0 && continuelabel.getHirPosition() != null) {
            continuelabel.getHirPosition().deleteThisStmt();
        }
        Exp cond = s.getLoopStartCondition();
        boolean reachablewhile = this.reachable;
        this.reachable = cond.getSym() != this.toHir.symRoot.boolConstFalse;
        this.visitStmt(((LabeledStmt)s.getLoopBodyPart()).getStmt());
        this.reachable |= reachablewhile;
        Stmt body = ((LabeledStmt)s.getLoopBodyPart()).getStmt();
        if (cond.getSym() == this.toHir.symRoot.boolConstFalse) {
            Label endlabel = s.getLoopEndLabel();
            endlabel.setLabelKind(16);
            if (body == null) {
                if (this.fDbgLevel > 3) {
                    this.message(6, "while(false); " + s);
                }
                s.deleteThisStmt();
            } else {
                if (this.fDbgLevel > 3) {
                    this.message(6, "while(false) BODY; " + s);
                }
                BlockStmt block = this.buffer.getBlockStmt(body);
                block.addLastStmt(this.hir.labeledStmt(endlabel, null));
                block.addFirstStmt(this.hir.jumpStmt(endlabel));
                s.replaceThisStmtWith(block);
            }
        }
    }

    protected void atFor(LoopStmt s) {
        Label continuelabel = s.getLoopStepLabel();
        if (continuelabel.getHirRefCount() == 0 && continuelabel.getHirPosition() != null) {
            continuelabel.getHirPosition().deleteThisStmt();
        }
        Exp cond = s.getLoopStartCondition();
        boolean reachablefor = this.reachable;
        this.visitStmt(s.getLoopInitPart());
        this.reachable = cond.getSym() != this.toHir.symRoot.boolConstFalse;
        this.visitStmt(((LabeledStmt)s.getLoopBodyPart()).getStmt());
        this.visitStmt(s.getLoopStepPart());
        this.reachable |= reachablefor;
        Stmt init = s.getLoopInitPart();
        Stmt body = ((LabeledStmt)s.getLoopBodyPart()).getStmt();
        Stmt step = s.getLoopStepPart();
        if (cond.getSym() == this.toHir.symRoot.boolConstFalse) {
            Label endlabel = s.getLoopEndLabel();
            endlabel.setLabelKind(16);
            if (body != null) {
                if (this.fDbgLevel > 3) {
                    this.message(6, "for(INIT;false;STEP) BODY; " + s);
                }
                BlockStmt block = this.buffer.getBlockStmt(body);
                block.addLastStmt(step);
                block.addLastStmt(this.hir.labeledStmt(endlabel, null));
                block.addFirstStmt(this.hir.jumpStmt(endlabel));
                block.addFirstStmt(init);
                s.replaceThisStmtWith(block);
            } else if (step != null) {
                if (this.fDbgLevel > 3) {
                    this.message(6, "for(INIT;false;STEP); " + s);
                }
                BlockStmt block = this.buffer.getBlockStmt(step);
                block.addLastStmt(this.hir.labeledStmt(endlabel, null));
                block.addFirstStmt(this.hir.jumpStmt(endlabel));
                block.addFirstStmt(init);
                s.replaceThisStmtWith(block);
            } else if (init != null) {
                if (this.fDbgLevel > 3) {
                    this.message(6, "for(INIT;false;); " + s);
                }
                s.replaceThisStmtWith(init);
            } else {
                if (this.fDbgLevel > 3) {
                    this.message(6, "for(;false;); " + s);
                }
                s.deleteThisStmt();
            }
        }
    }

    protected void atUntil(LoopStmt s) {
        Label continuelabel = s.getLoopStepLabel();
        if (continuelabel.getHirRefCount() == 0 && continuelabel.getHirPosition() != null) {
            continuelabel.getHirPosition().deleteThisStmt();
        }
        Exp cond = s.getLoopEndCondition();
        boolean reachableuntil = this.reachable;
        this.reachable |= cond.getSym() != this.toHir.symRoot.boolConstFalse;
        this.visitStmt(((LabeledStmt)s.getLoopBodyPart()).getStmt());
        this.reachable |= reachableuntil;
        Stmt body = ((LabeledStmt)s.getLoopBodyPart()).getStmt();
        if (cond.getSym() == this.toHir.symRoot.boolConstFalse) {
            if (reachableuntil) {
                if (body != null) {
                    if (this.fDbgLevel > 3) {
                        this.message(6, "do BODY; while(false); " + s);
                    }
                    BlockStmt block = this.buffer.getBlockStmt(body);
                    s.replaceThisStmtWith(block);
                } else {
                    if (this.fDbgLevel > 3) {
                        this.message(6, "do; while(false); " + s);
                    }
                    s.deleteThisStmt();
                }
            } else if (body != null) {
                if (this.fDbgLevel > 3) {
                    this.message(6, "unreachable do BODY; while(false); " + s);
                }
                Label endlabel = s.getLoopEndLabel();
                endlabel.setLabelKind(16);
                BlockStmt block = this.buffer.getBlockStmt(body);
                block.addLastStmt(this.hir.labeledStmt(endlabel, null));
                block.addFirstStmt(this.hir.jumpStmt(endlabel));
                s.replaceThisStmtWith(block);
            } else {
                if (this.fDbgLevel > 3) {
                    this.message(6, "unreachable do; while(false); " + s);
                }
                s.deleteThisStmt();
            }
        } else if (!reachableuntil && body == null) {
            if (this.fDbgLevel > 3) {
                this.message(6, "unreachable do; while(e); " + s);
            }
            s.deleteThisStmt();
        }
    }

    protected void atJump(JumpStmt s) {
        if (!this.reachable) {
            if (this.fDbgLevel > 3) {
                this.message(6, "unreachable --> delete " + s);
            }
            s.deleteThisStmt();
        }
        this.reachable = false;
    }

    protected void atSwitch(SwitchStmt s) {
        Exp cond = s.getSelectionExp();
        Stmt body = s.getBodyStmt();
        if (!this.reachable) {
            Label caselabel;
            if (this.fDbgLevel > 3) {
                this.message(6, "unreachable switch(...) " + s);
            }
            int i = 0;
            while ((caselabel = s.getCaseLabel(i)) != null) {
                if (caselabel.getHirPosition() != null) {
                    caselabel.getHirPosition().deleteThisStmt();
                }
                ++i;
            }
            if (s.getDefaultLabel().getHirPosition() != null) {
                s.getDefaultLabel().getHirPosition().deleteThisStmt();
            }
            Label endlabel = s.getEndLabel();
            endlabel.setLabelKind(16);
            BlockStmt block = this.buffer.getBlockStmt(body);
            block.addLastStmt(this.hir.labeledStmt(endlabel, null));
            block.addFirstStmt(this.hir.jumpStmt(endlabel));
            s.replaceThisStmtWith(block);
            this.visitStmt(block);
        } else if (cond.getOperator() == 5) {
            if (this.fDbgLevel > 3) {
                this.message(6, "switch(CONST) " + s);
            }
            long val = ((Const)cond.getSym()).longValue();
            Const caseconst = null;
            Label caselabel = null;
            Label endlabel = s.getEndLabel();
            endlabel.setLabelKind(16);
            int i = 0;
            while ((caseconst = s.getCaseConst(i)) != null) {
                if (caseconst.longValue() == val) {
                    caselabel = s.getCaseLabel(i);
                } else {
                    s.getCaseLabel(i).getHirPosition().deleteThisStmt();
                }
                ++i;
            }
            if (caselabel != null) {
                if (s.getDefaultLabel().getHirPosition() != null) {
                    s.getDefaultLabel().getHirPosition().deleteThisStmt();
                }
            } else {
                caselabel = s.getDefaultLabel().getHirPosition() != null ? s.getDefaultLabel() : endlabel;
            }
            BlockStmt block = this.buffer.getBlockStmt(body);
            caselabel.setLabelKind(16);
            block.addLastStmt(this.hir.labeledStmt(endlabel, null));
            block.addFirstStmt(this.hir.jumpStmt(caselabel));
            s.replaceThisStmtWith(block);
            this.reachable = false;
            this.visitStmt(block);
        } else {
            this.reachable = false;
            this.visitStmt(body);
            this.reachable |= s.getEndLabel().getHirRefCount() != 0;
        }
    }

    protected void atReturn(ReturnStmt s) {
        if (!this.reachable) {
            if (this.fDbgLevel > 3) {
                this.message(6, "unreachable --> delete " + s);
            }
            s.deleteThisStmt();
        }
    }

    protected void atExpStmt(ExpStmt s) {
        if (!this.reachable) {
            if (this.fDbgLevel > 3) {
                this.message(6, "unreachable --> delete " + s);
            }
        } else {
            this.cutter.visitExp(s.getExp());
            this.buffer.addToStmtPrev(s, false);
        }
        s.deleteThisStmt();
    }
}

