/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.util;

public class UnionFind {
    private int nelements;
    private int[] parent;
    private int[] count;

    public UnionFind(int nelements) {
        this.nelements = nelements;
        this.parent = new int[nelements];
        this.count = new int[nelements];
        for (int i = 0; i < nelements; ++i) {
            this.parent[i] = i;
        }
    }

    public int find(int x) {
        int w;
        int y = x;
        while (this.parent[y] != y) {
            y = this.parent[y];
        }
        while ((w = this.parent[x]) != x) {
            this.parent[x] = y;
            x = w;
        }
        return y;
    }

    public int union(int x, int y) {
        if ((x = this.find(x)) != (y = this.find(y))) {
            if (this.count[x] < this.count[y]) {
                int w = x;
                x = y;
                y = w;
            }
            this.parent[y] = x;
            if (this.count[x] == this.count[y]) {
                int n = x;
                this.count[n] = this.count[n] + 1;
            }
        }
        return x;
    }

    public boolean isEquiv(int x, int y) {
        return this.find(x) == this.find(y);
    }
}

